/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd;

import cacheperf.comparisons.gemfirexd.QueryPerfClient;
import cacheperf.comparisons.gemfirexd.QueryPerfException;
import cacheperf.comparisons.gemfirexd.QueryPerfPrms;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.gemfirexd.NetworkServerHelper;
import hydra.gemfirexd.ThinClientHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import objects.query.QueryPrms;

public class QueryUtil {
    public static Connection gfxdEmbeddedSetup(QueryPerfClient client) throws SQLException {
        Properties p = new Properties();
        return QueryUtil.gfxdEmbeddedSetup(client, p);
    }

    public static Connection gfxdEmbeddedSetup(QueryPerfClient client, Properties p) throws SQLException {
        p.setProperty("enable-stats", String.valueOf(QueryPerfPrms.enableStats()));
        p.setProperty("enable-timestats", String.valueOf(QueryPerfPrms.enableTimeStats()));
        return QueryUtil.getConnection(client, "jdbc:gemfirexd:", "com.pivotal.gemfirexd.jdbc.EmbeddedDriver", p);
    }

    public static Connection gfxdClientSetup(QueryPerfClient client) throws SQLException {
        if (QueryPerfPrms.useNetworkLocator()) {
            return QueryUtil.gfxdClientLocatorSetup(client, NetworkServerHelper.getNetworkLocatorEndpoints());
        }
        return QueryUtil.gfxdClientServerSetup(client, NetworkServerHelper.getNetworkServerEndpoints());
    }

    public static Connection gfxdClientSetup(QueryPerfClient client, Properties p) throws SQLException {
        if (QueryPerfPrms.useNetworkLocator()) {
            return QueryUtil.gfxdClientLocatorSetup(client, NetworkServerHelper.getNetworkLocatorEndpoints(), p);
        }
        return QueryUtil.gfxdClientServerSetup(client, NetworkServerHelper.getNetworkServerEndpoints(), p);
    }

    public static Connection gfxdWanClientSetup(QueryPerfClient client) throws SQLException {
        if (QueryPerfPrms.useNetworkLocator()) {
            return QueryUtil.gfxdClientLocatorSetup(client, NetworkServerHelper.getNetworkLocatorEndpointsInWanSite());
        }
        return QueryUtil.gfxdClientServerSetup(client, NetworkServerHelper.getNetworkServerEndpointsInWanSite());
    }

    public static Connection gfxdWanClientSetup(QueryPerfClient client, List endpoints) throws SQLException {
        if (QueryPerfPrms.useNetworkLocator()) {
            return QueryUtil.gfxdClientLocatorSetup(client, endpoints);
        }
        return QueryUtil.gfxdClientServerSetup(client, endpoints);
    }

    public static Connection gfxdClientLocatorSetup(QueryPerfClient client, List endpoints) throws SQLException {
        return QueryUtil.gfxdClientLocatorSetup(client, endpoints, null);
    }

    public static Connection gfxdClientLocatorSetup(QueryPerfClient client, List endpoints, Properties overrideProp) throws SQLException {
        if (endpoints.size() == 0) {
            String s = "No network locator endpoints found";
            throw new QueryPerfException(s);
        }
        Properties p = ThinClientHelper.getConnectionProperties();
        if (overrideProp != null) {
            p.putAll((Map<?, ?>)overrideProp);
        }
        String url = "jdbc:gemfirexd://" + endpoints.get(0);
        List secondaryLocators = endpoints.subList(1, endpoints.size());
        if (secondaryLocators.size() > 0) {
            String secondaries = "";
            for (int i = 0; i < secondaryLocators.size(); ++i) {
                if (i > 0) {
                    secondaries = secondaries + ",";
                }
                secondaries = secondaries + secondaryLocators.get(i).toString();
            }
            p.setProperty("secondary-locators", secondaries);
        }
        return QueryUtil.getConnection(client, url, "com.pivotal.gemfirexd.jdbc.ClientDriver", p);
    }

    public static Connection gfxdClientServerSetup(QueryPerfClient client, List endpoints) throws SQLException {
        return QueryUtil.gfxdClientServerSetup(client, endpoints, null);
    }

    public static Connection gfxdClientServerSetup(QueryPerfClient client, List endpoints, Properties overrideProp) throws SQLException {
        if (endpoints.size() == 0) {
            String s = "No network server endpoints found";
            throw new QueryPerfException(s);
        }
        Properties p = ThinClientHelper.getConnectionProperties();
        if (overrideProp != null) {
            p.putAll((Map<?, ?>)overrideProp);
        }
        String url = "jdbc:gemfirexd://" + endpoints.get(0);
        return QueryUtil.getConnection(client, url, "com.pivotal.gemfirexd.jdbc.ClientDriver", p);
    }

    private static Connection getConnection(QueryPerfClient client, String protocol, String driver, Properties p) throws SQLException {
        Log.getLogWriter().info("Creating connection using " + driver + " with " + protocol + " and " + p);
        QueryUtil.loadDriver(driver);
        Connection conn = DriverManager.getConnection(protocol, p);
        QueryUtil.configure(client, conn);
        return conn;
    }

    public static void closeGFXDConnection(Connection conn) {
        block2: {
            try {
                String protocol = "jdbc:gemfirexd:;shutdown=true";
                DriverManager.getConnection(protocol);
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) break block2;
                Log.getLogWriter().severe("Shutdown failed:" + se.getMessage());
            }
        }
    }

    public static Connection gpdbSetup(QueryPerfClient client) throws SQLException {
        QueryUtil.loadDriver(QueryUtil.gpdbDriver());
        String url = QueryUtil.gpdbURL();
        Log.getLogWriter().info("Connecting to " + url);
        Connection conn = DriverManager.getConnection(url);
        QueryUtil.configure(client, conn);
        return conn;
    }

    public static String gpdbDriver() {
        return "org.postgresql.Driver";
    }

    public static String gpdbURL() {
        String url = "jdbc:postgresql://" + QueryPerfPrms.getDatabaseServerHost() + ":" + QueryPerfPrms.getDatabaseServerPort() + "/" + QueryPerfPrms.getDatabaseName() + "?user=" + QueryPerfPrms.getUser();
        String password = QueryPerfPrms.getPassword();
        if (password != null) {
            url = url + "&password=" + password;
        }
        return url;
    }

    public static Connection mySQLSetup(QueryPerfClient client) throws SQLException {
        QueryUtil.loadDriver(QueryUtil.mySQLDriver());
        String url = QueryUtil.mySQLURL();
        Log.getLogWriter().info("Connecting to " + url);
        Connection conn = DriverManager.getConnection(url);
        QueryUtil.configure(client, conn);
        return conn;
    }

    public static String mySQLDriver() {
        return "com.mysql.jdbc.Driver";
    }

    public static String mySQLURL() {
        String url = "jdbc:mysql://" + QueryPerfPrms.getDatabaseServerHost() + ":" + QueryPerfPrms.getDatabaseServerPort() + "/" + QueryPerfPrms.getDatabaseName() + "?user=" + QueryPerfPrms.getUser();
        String password = QueryPerfPrms.getPassword();
        if (password != null) {
            url = url + "&password=" + password;
        }
        return url;
    }

    public static Connection oracleSetup(QueryPerfClient client) throws SQLException {
        System.setProperty("java.security.egd", "file:///dev/urandom");
        QueryUtil.loadDriver(QueryUtil.oracleDriver());
        String url = QueryUtil.oracleURL();
        Log.getLogWriter().info("Connecting to " + url);
        Connection conn = DriverManager.getConnection(url);
        QueryUtil.configure(client, conn);
        return conn;
    }

    public static String oracleDriver() {
        return "oracle.jdbc.OracleDriver";
    }

    public static String oracleURL() {
        String url = "jdbc:oracle:thin:" + QueryPerfPrms.getUser() + "/" + QueryPerfPrms.getPassword() + "@" + QueryPerfPrms.getDatabaseServerHost() + ":1521:" + QueryPerfPrms.getDatabaseName();
        return url;
    }

    public static Connection rteSetup(QueryPerfClient client) throws SQLException {
        QueryUtil.loadDriver("com.gemstone.gemfire.sql.jdbcDriver");
        Properties endpoints = new Properties();
        String host = System.getProperty("host", "hs20h.gemstone.com");
        String port = System.getProperty("port", "50005");
        endpoints.setProperty("endpoints", "endone=" + host + ":" + port);
        Connection conn = DriverManager.getConnection("jdbc:gfsql:", endpoints);
        return conn;
    }

    private static void configure(QueryPerfClient client, Connection conn) throws SQLException {
        conn.setAutoCommit(false);
        if (client.txIsolation == 0 && (client.queryAPI == 3 || client.queryAPI == 4 || client.queryAPI == 5 || client.queryAPI == 7)) {
            String s = QueryPrms.getAPIString((int)client.queryAPI) + " does not support transaction isolation level \"none\"";
            throw new HydraConfigException(s);
        }
        conn.setTransactionIsolation(client.txIsolation);
        Log.getLogWriter().info("Using transaction isolation level: " + QueryPerfPrms.getTxIsolation(conn.getTransactionIsolation()));
    }

    public static void loadDriver(String driver) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException e) {
            String s = "Problem loading JDBC driver: " + driver;
            throw new QueryPerfException(s, e);
        }
        catch (InstantiationException e) {
            String s = "Problem loading JDBC driver: " + driver;
            throw new QueryPerfException(s, e);
        }
        catch (IllegalAccessException e) {
            String s = "Problem loading JDBC driver: " + driver;
            throw new QueryPerfException(s, e);
        }
    }
}

