/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.misc;

import cacheperf.comparisons.gemfirexd.QueryPerfClient;
import cacheperf.comparisons.gemfirexd.misc.CarterPrms;
import cacheperf.comparisons.gemfirexd.misc.CarterStats;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import objects.query.QueryPrms;

public class CarterClient
extends QueryPerfClient {
    private static String PRODUCT_INSERT = "insert into product values (?, ?, ?, ?)";
    private static String STORE_INSERT = "insert into store values (?, ?, ?)";
    private static String SALE_INSERT = "insert into sale (timestamp, storeid, productid, units, price) values (?, ?, ?, ?, ?)";
    private static String PRODUCT_UPDATE = "update product set inventory = inventory - 1 where id = ?";
    private static final boolean logQueries = QueryPrms.logQueries();
    private static final boolean logQueryResults = QueryPrms.logQueryResults();
    private static final int numProducts = CarterPrms.getNumProducts();
    private static final int numStores = CarterPrms.getNumStores();
    private static final int numSalesRecords = CarterPrms.getNumSalesRecords();
    private static float[] Prices = new float[CarterPrms.getNumProducts()];
    private static final String CONFLICT_STATE = "X0Z02";
    private static HydraThreadLocal localcarterstats = new HydraThreadLocal();
    protected CarterStats carterstats;

    public static void openStatisticsTask() {
        CarterClient c = new CarterClient();
        c.openStatistics();
    }

    private void openStatistics() {
        this.carterstats = this.getCarterStats();
        if (this.carterstats == null) {
            this.carterstats = CarterStats.getInstance();
        }
        this.setCarterStats(this.carterstats);
    }

    public static void closeStatisticsTask() {
        CarterClient c = new CarterClient();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.carterstats != null) {
            this.carterstats.close();
        }
    }

    public static void dropTablesTask() throws SQLException {
        CarterClient c = new CarterClient();
        c.initialize();
        if (c.ttgid == 0) {
            c.dropTables();
        }
    }

    private void dropTables() throws SQLException {
        this.dropTable("sale");
        this.dropTable("store");
        this.dropTable("product");
    }

    private void dropTable(String table) throws SQLException {
        String ddl = "drop table if exists " + table;
        this.executeDDL(ddl);
    }

    public static void createTablesTask() throws FileNotFoundException, IOException, SQLException {
        CarterClient c = new CarterClient();
        c.initialize();
        if (c.ttgid == 0) {
            c.createTables();
        }
    }

    private void createTables() throws SQLException {
        this.createTable("sale (timestamp timestamp, storeid int, productid int, units int, price float) partition by column (productid)");
        this.createTable("store (id int, city varchar(80), state char(2))");
        this.createTable("product (id int, name varchar(80), msrp float, inventory int)");
    }

    private void createTable(String table) throws SQLException {
        String ddl = "create table " + table;
        this.executeDDL(ddl);
    }

    private void executeDDL(String ddl) throws SQLException {
        if (logQueries) {
            Log.getLogWriter().info("Executing DDL: " + ddl);
        }
        Statement stmt = this.connection.createStatement();
        stmt.executeUpdate(ddl);
        stmt.close();
        if (logQueries) {
            Log.getLogWriter().info("Executed DDL: " + ddl);
        }
    }

    public static void populateProductsTask() throws SQLException {
        CarterClient c = new CarterClient();
        c.initialize(-1);
        if (c.ttgid == 0) {
            c.populateProducts();
        }
    }

    private void populateProducts() throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(PRODUCT_INSERT);
        for (int i = 1; i <= numProducts; ++i) {
            float basePrice;
            stmt.setInt(1, i);
            stmt.setString(2, "frazzled");
            CarterClient.Prices[i - 1] = basePrice = this.rng.nextFloat();
            stmt.setFloat(3, basePrice);
            stmt.setInt(4, 100000);
            stmt.addBatch();
        }
        stmt.executeBatch();
        stmt.close();
        this.connection.commit();
    }

    public static void populateStoresTask() throws SQLException {
        CarterClient c = new CarterClient();
        c.initialize(-1);
        if (c.ttgid == 0) {
            c.populateStores();
        }
    }

    private void populateStores() throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(STORE_INSERT);
        for (int i = 1; i <= numStores; ++i) {
            stmt.setInt(1, i);
            stmt.setString(2, "lockhart");
            stmt.setString(3, "tx");
            stmt.addBatch();
        }
        stmt.executeBatch();
        stmt.close();
        this.connection.commit();
    }

    public static void populateSaleRecordsTask() throws SQLException {
        CarterClient c = new CarterClient();
        c.initialize(-1);
        c.populateSaleRecords();
    }

    private void populateSaleRecords() throws SQLException {
        PreparedStatement saleStmt = this.connection.prepareStatement(SALE_INSERT);
        PreparedStatement inventoryStmt = this.connection.prepareStatement(PRODUCT_UPDATE);
        for (int i = 1; i <= numSalesRecords; ++i) {
            int retries = 0;
            boolean committed = false;
            int productNumber = this.rng.nextInt(1, numProducts);
            int storeNumber = this.rng.nextInt(1, numStores);
            Timestamp currentDate = new Timestamp(System.currentTimeMillis());
            while (!committed && retries++ < 50) {
                long start = this.carterstats.startSale();
                saleStmt.setTimestamp(1, currentDate);
                saleStmt.setInt(2, storeNumber);
                saleStmt.setInt(3, productNumber);
                saleStmt.setInt(4, this.rng.nextInt(1, 10));
                saleStmt.setFloat(5, Prices[productNumber - 1]);
                inventoryStmt.setInt(1, productNumber);
                try {
                    saleStmt.execute();
                    inventoryStmt.execute();
                    this.connection.commit();
                    committed = true;
                }
                catch (SQLException e) {
                    this.checkConflict(e);
                }
                this.carterstats.endSale(start, committed);
            }
        }
    }

    private void checkConflict(SQLException e) throws SQLException {
        if (e instanceof BatchUpdateException) {
            for (SQLException ex = e; ex != null; ex = ex.getNextException()) {
                if (ex.getSQLState().equals(CONFLICT_STATE)) continue;
                throw e;
            }
        } else if (!e.getSQLState().equals(CONFLICT_STATE)) {
            throw e;
        }
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.carterstats = this.getCarterStats();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setCarterStats(this.carterstats);
    }

    protected CarterStats getCarterStats() {
        CarterStats cstats = (CarterStats)((Object)localcarterstats.get());
        return cstats;
    }

    protected void setCarterStats(CarterStats cstats) {
        localcarterstats.set((Object)cstats);
    }
}

