/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.misc;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class CarterStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    public static final String VM_COUNT = "vmCount";
    protected static final String SALES = "sales";
    protected static final String SALE_TIME = "saleTime";
    protected static final String SALE_ROLLBACKS = "saleRollbacks";
    protected static final String SALE_ROLLBACK_TIME = "saleRollbackTime";
    private static boolean VMCounted = false;

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{CarterStats.factory().createIntGauge(VM_COUNT, "When aggregated, the number of VMs using this statistics object.", "VMs"), CarterStats.factory().createIntCounter(SALES, "Number of sales recorded.", "operations", largerIsBetter), CarterStats.factory().createLongCounter(SALE_TIME, "Total time spent recording sales.", "nanoseconds", !largerIsBetter), CarterStats.factory().createIntCounter(SALE_ROLLBACKS, "Number of sales rolled back.", "operations", largerIsBetter), CarterStats.factory().createLongCounter(SALE_ROLLBACK_TIME, "Total time spent rolling back sales.", "nanoseconds", !largerIsBetter)};
    }

    public static CarterStats getInstance() {
        CarterStats cstats = (CarterStats)CarterStats.getInstance(CarterStats.class, (int)0);
        cstats.incVMCount();
        return cstats;
    }

    public static CarterStats getInstance(String name) {
        CarterStats cstats = (CarterStats)CarterStats.getInstance(CarterStats.class, (int)0, (String)name);
        cstats.incVMCount();
        return cstats;
    }

    public static CarterStats getInstance(String name, String trimspecName) {
        CarterStats cstats = (CarterStats)CarterStats.getInstance(CarterStats.class, (int)0, (String)name, (String)trimspecName);
        cstats.incVMCount();
        return cstats;
    }

    public CarterStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    private synchronized void incVMCount() {
        if (!VMCounted) {
            this.statistics().incInt(VM_COUNT, 1);
            VMCounted = true;
        }
    }

    public long startSale() {
        return NanoTimer.getTime();
    }

    public void endSale(long start, boolean committed) {
        long elapsed = NanoTimer.getTime() - start;
        if (committed) {
            this.statistics().incInt(SALES, 1);
            this.statistics().incLong(SALE_TIME, elapsed);
        } else {
            this.statistics().incInt(SALE_ROLLBACKS, 1);
            this.statistics().incLong(SALE_ROLLBACK_TIME, elapsed);
        }
    }
}

