/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.poc;

import hydra.BasePrms;
import hydra.HydraConfigException;

public class POCPrms
extends BasePrms {
    public static Long ddlFileName;
    public static Long pocType;
    public static Long numBatches;
    public static Long batchSize;
    public static Long updatePercentage;

    public static String getDDLFileName() {
        Long key = ddlFileName;
        String val = POCPrms.tasktab().stringAt(key, POCPrms.tab().stringAt(key, null));
        if (val == null) {
            String s = BasePrms.nameForKey((Long)ddlFileName) + " is required";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static POCType getPOCType() {
        Long key = pocType;
        String val = POCPrms.tasktab().stringAt(key, POCPrms.tab().stringAt(key, null));
        if (val.equalsIgnoreCase(POCType.UseCase3.toString())) {
            return POCType.UseCase3;
        }
        if (val.equalsIgnoreCase(POCType.TelcelLoyalty.toString())) {
            return POCType.TelcelLoyalty;
        }
        if (val.equalsIgnoreCase(POCType.UseCase2.toString())) {
            return POCType.UseCase2;
        }
        String s = "Unrecognized " + BasePrms.nameForKey((Long)pocType) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getNumBatches() {
        Long key = numBatches;
        int val = POCPrms.tasktab().intAt(key, POCPrms.tab().intAt(key, 0));
        if (val <= 0) {
            String s = BasePrms.nameForKey((Long)ddlFileName) + " is required and must be positive";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getBatchSize() {
        Long key = batchSize;
        int val = POCPrms.tasktab().intAt(key, POCPrms.tab().intAt(key, 0));
        if (val <= 0) {
            String s = BasePrms.nameForKey((Long)ddlFileName) + " is required and must be positive";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getUpdatePercentage() {
        Long key = updatePercentage;
        int val = POCPrms.tasktab().intAt(key, POCPrms.tab().intAt(key, 0));
        if (val < 0) {
            String s = BasePrms.nameForKey((Long)ddlFileName) + " is required and must be non-negative";
            throw new HydraConfigException(s);
        }
        return val;
    }

    static {
        POCPrms.setValues(POCPrms.class);
    }

    public static enum POCType {
        UseCase3,
        TelcelLoyalty,
        UseCase2;

    }
}

