/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase1;

import cacheperf.comparisons.gemfirexd.QueryPerfClient;
import cacheperf.comparisons.gemfirexd.QueryPerfException;
import cacheperf.comparisons.gemfirexd.QueryUtil;
import cacheperf.comparisons.gemfirexd.useCase1.BOMessage;
import cacheperf.comparisons.gemfirexd.useCase1.BORawData;
import cacheperf.comparisons.gemfirexd.useCase1.FsAckStatus;
import cacheperf.comparisons.gemfirexd.useCase1.FsChunkedMessage;
import cacheperf.comparisons.gemfirexd.useCase1.FsDataLifeStatus;
import cacheperf.comparisons.gemfirexd.useCase1.FsHitStatus;
import cacheperf.comparisons.gemfirexd.useCase1.FsMessageSendStatus;
import cacheperf.comparisons.gemfirexd.useCase1.FsOutStatus;
import cacheperf.comparisons.gemfirexd.useCase1.InsertStatementBuilder;
import cacheperf.comparisons.gemfirexd.useCase1.OFACMessage;
import cacheperf.comparisons.gemfirexd.useCase1.UseCase1Blackboard;
import cacheperf.comparisons.gemfirexd.useCase1.UseCase1Prms;
import cacheperf.comparisons.gemfirexd.useCase1.UseCase1Stats;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.model.MatchingInfo;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HydraInternalException;
import hydra.HydraSubthread;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.LonerHelper;
import hydra.gemfirexd.NetworkServerHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;
import java.util.Vector;
import objects.query.QueryPrms;
import sql.sqlutil.ResultSetHelper;
import util.TestHelper;

public class UseCase1Client
extends QueryPerfClient {
    private static final String MATCH_CALL = "{CALL SEC_OWNER.matchStoredProc(?, ?, ?)}";
    private static final String PURGE_CALL = "{CALL SEC_OWNER.boPurgeStoredProc()}";
    private static final String IPAY = "IPAY";
    private static final String CLIENT_ACCOUNT = "CLIENT_ACCOUNT";
    private static final String SECT_CHANNEL_DATA = "SECT_CHANNEL_DATA";
    private static final String SECL_BO_DATA_STATUS_HIST = "SECL_BO_DATA_STATUS_HIST";
    protected static final String CONFLICT_STATE = "X0Z02";
    protected static final String DEADLOCK_STATE = "ORA-00060";
    protected static final String DUPLICATE_STR = "The statement was aborted because it would have caused a duplicate key value";
    protected static final int numBuckets = UseCase1Prms.getNumBuckets();
    protected static final boolean timeStmts = UseCase1Prms.timeStmts();
    protected static final int LOAD = 16823492;
    protected static final int ETLGEN = 16823493;
    protected static final int DUMMY = 16823494;
    protected static final int MATCH = 16823495;
    protected static final int MATCHPURGE = 16823496;
    protected static final int INBOUND = 16823497;
    protected static final int OUTBOUND = 16823498;
    protected static final String LOAD_NAME = "load";
    protected static final String ETLGEN_NAME = "etlgen";
    protected static final String DUMMY_NAME = "dummy";
    protected static final String MATCH_NAME = "match";
    protected static final String MATCHPURGE_NAME = "matchpurge";
    protected static final String INBOUND_NAME = "inbound";
    protected static final String OUTBOUND_NAME = "outbound";
    public static HydraThreadLocal localuseCase1stats = new HydraThreadLocal();
    private static List<String> clientAccounts = null;
    private static final Object clientAccountsLock = new Object();
    private static List<MatchCriteria> matchCriterias = null;
    private static final Object matchCriteriasLock = new Object();
    public UseCase1Stats useCase1stats;
    private boolean frontloaded = false;
    protected boolean logQueries;
    protected boolean logQueryResults;
    private static final String SECT_CHANNEL_RAW_DATA = "<MSG filename=\"SamplePAYEXT.txt\" sourceFormat=\"PAYEXT\"> <MLD>UNB+UNOA:3</MLD> <ADR.SenderId>5025007000009</ADR.SenderId> <ADR>14</ADR> <DTE>006981815:1+120430:1159+80314</DTE> <MLD>PAYEXT1</MLD> <MLD>UNH+1+PAYEXT:D:96A:UN</MLD> <CRN>BGM+451+GHFRT0088733652</CRN> <TYP>BUSIN</TYP> <TYP>PAI::9</TYP> <TYP>:ZZZ</TYP> <ACI>FCA+14</ACI> <DTE>DTM+137:20120430:102</DTE> <MLD>RFF+CR</MLD> <CRN.ClientRef>7XWzXJPAaUR2D</CRN.ClientRef> <CRN>RFF+ABO:5025006768762</CRN> <VAL>MOA+9</VAL> <VAL.Amount>125.37</VAL.Amount> <VAL.Currency>GBP</VAL.Currency> <MLD>DTM+209</MLD> <DTE.ValueDate>20120302</DTE.ValueDate> <MLD>102</MLD> <MLD>RFF+PB</MLD> <ACN.CompanyId>6777734</ACN.CompanyId> <MLD>FII+OR</MLD> <ACN.OrigAccountNo>19882892</ACN.OrigAccountNo> <FII.OrigBankId>ouuAeSpCLP</FII.OrigBankId> <MLD>FII+BF</MLD> <ACN.BeneAccountNo>P988WgvLVJ</ACN.BeneAccountNo> <FII.BeneBankId>WU0D8ZPtAT</FII.BeneBankId> <ADR>:::</ADR> <ADR.BeneBankAddr>auqvTxVzXtmUHujYOEto</ADR.BeneBankAddr> <ADR.BeneBankCtry>ES</ADR.BeneBankCtry> <MLD>NAD+OY+5025006768762</MLD> <ADR.OrigName>Spanish American Caribbean</ADR.OrigName> <MLD>NAD+BE+1000021496</MLD> <ADR.BeneName>ASAM CLARKE AND CO (MADRID USD)C/GOYA 11</ADR.BeneName> <ADR.BeneAddr>MADRID28001+ES</ADR.BeneAddr> <TYP>PRC+8</TYP> <TYP>DOC+380+37902012</TYP> <VAL>MOA+12:1607.9</VAL> <VAL>MOA+39:1607.9</VAL> <VAL>MOA+52</VAL> <DTE>DTM+171:20120229:102</DTE> <MLD>GIS+37</MLD> <MLD>UNT+23+1</MLD> </MSG>";
    private static final String[] CHANNEL_NAMES = new String[]{"PYS", "CCP-ED", "ISO"};
    private static final String SECT_CHANNEL_DATA_SQL = "insert into SEC_OWNER.SECT_CHANNEL_DATA (channel_txn_id, value_date, company_id, client_account, amount, currency, client_ref_no, orig_bank_id, bene_accnt_no, bene_bank_id, bene_bank_addr, bene_name, bene_addr, backoffice_code, txn_type, data_life_status, match_status, match_categ_id, etl_time, channel_name, raw_data, file_type_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    PreparedStatement SECT_CHANNEL_DATA_PS = null;
    private SortedMap<Integer, Set<MatchingInfo>> inMatchingKeyMap = null;
    protected static final String GET_MQ_BO_MAP_SQL = "select MQ_NAME, BACKOFFICE_CODE from SEC_OWNER.SECM_MQ_BO_MAP map, SEC_OWNER.SECM_MQ mq where map.MQ_ID=mq.MQ_ID";
    protected PreparedStatement GET_MQ_BO_MAP_PS = null;
    protected static final String GET_BY_BO_TXN_ID_SQL = "select * from SEC_OWNER.SECL_BO_DATA_STATUS_HIST where BO_TXN_ID = ? ORDER BY LAST_UPDATE_TIME DESC FETCH FIRST ROW ONLY";
    protected PreparedStatement GET_BY_BO_TXN_ID_PS = null;
    protected static final String INSERT_RAW_DATA_SQL = "INSERT INTO SEC_OWNER.SECL_BO_RAW_DATA (BO_TXN_ID, BO_RAW_DATA, MESSAGE_ID, INCOMING_QUEUE) VALUES(?,?,?,?)";
    protected PreparedStatement INSERT_RAW_DATA_PS = null;
    protected static final String GET_BY_PK_SQL = "select * from SEC_OWNER.SECL_BO_RAW_DATA where BO_TXN_ID = ?";
    protected PreparedStatement GET_BY_PK_PS = null;
    protected static final String SELECT_BO_DATA_SQL = "SELECT BO_TXN_ID, CLIENT_ID, CLIENT_NAME, CLIENT_ACCOUNT, COMPANY_ID, CLIENT_REF_NO, VALUE_DATE, AMOUNT, CURRENCY, ORIG_BANK_ID, BACKOFFICE_CODE, BENE_ACCNT_NO, BENE_NAME, BENE_ADDR, BENE_BANK_ID, BENE_BANK_NAME, BENE_BANK_ADDR, INSTR_CREATED_TIME, INSTR_CREATED_BY, DATA_LIFE_STATUS, MATCH_STATUS, MATCH_DATE, MATCH_CATEG_ID, MATCHING_TIME, MANUAL_MATCH, MATCHING_REASON, SCREENING_TIME, IS_MANUAL, IS_RESENT, CHANNEL_NAME, TXN_TYPE, OFAC_MSG_ID, HIT_STATUS, ACTUAL_VALUE_DATE, LAST_UPDATE_TIME FROM SEC_OWNER.SECL_BO_DATA_STATUS_HIST WHERE BO_TXN_ID = ? ORDER BY LAST_UPDATE_TIME DESC FETCH FIRST ROW ONLY";
    protected PreparedStatement SELECT_BO_DATA_PS = null;
    protected static final String QUERY_TO_INSERT_BO_LOG_TABLE_SQL = "INSERT INTO SEC_OWNER.SECL_BO_DATA_STATUS_HIST (BO_TXN_ID, CLIENT_ID, CLIENT_NAME, CLIENT_ACCOUNT, COMPANY_ID, CLIENT_REF_NO, VALUE_DATE, AMOUNT, CURRENCY, ORIG_BANK_ID, BACKOFFICE_CODE, BENE_ACCNT_NO, BENE_NAME, BENE_ADDR, BENE_BANK_ID, BENE_BANK_NAME, BENE_BANK_ADDR, INSTR_CREATED_TIME, INSTR_CREATED_BY, DATA_LIFE_STATUS, MATCH_STATUS, MATCH_DATE, MATCH_CATEG_ID, MATCHING_TIME, MANUAL_MATCH, MATCHING_REASON, SCREENING_TIME, IS_MANUAL, IS_RESENT, CHANNEL_NAME, TXN_TYPE, OFAC_MSG_ID, HIT_STATUS, ACTUAL_VALUE_DATE, LAST_UPDATE_TIME) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP)";
    protected PreparedStatement QUERY_TO_INSERT_BO_LOG_TABLE_PS = null;
    private static final String INSERT_OFAC_LOG_SQL = "INSERT INTO SEC_OWNER.SECL_OFAC_MESSAGE (BO_TXN_ID, CHN_TXN_ID, HIT_STATUS, MESSAGE_GUID, LAST_UPDATE_TIME, NO_OF_CHUNKS, FS_MESSAGE_ID) VALUES(?, ?, ?, ?, CURRENT_TIMESTAMP, ?, ?)";
    private PreparedStatement INSERT_OFAC_LOG_PS = null;
    private static final String INSERT_LOG_OFAC_CHUNKED_SQL = "INSERT INTO SEC_OWNER.SECL_OFAC_CHUNKED_MESSAGE (CHUNK_ID, FS_MESSAGE_ID, BACKOFFICE_TXN_ID, CHANNEL_TXN_ID, CHUNK_SEQ, CHUNKED_MSG, SENT_DATE, RECEIVING_TIME, OFAC_COMMENTS) values (?,?,?,?,?,?,?,?,?)";
    private PreparedStatement INSERT_LOG_OFAC_CHUNKED_PS = null;
    private static final String SELECT_INITIAL_OFAC_MSG_SQL = "SELECT * FROM SEC_OWNER.SECL_OFAC_MESSAGE WHERE FS_MESSAGE_ID = ? FETCH FIRST ROW ONLY";
    private PreparedStatement SELECT_INITIAL_OFAC_MSG_PS = null;
    private static final String INSERT_LOG_OFAC_CHUNKED_2_SQL = "INSERT INTO SEC_OWNER.SECL_OFAC_CHUNKED_MESSAGE (CHUNK_ID, CHUNK_SEQ, SENT_LIFE_STATUS, BACKOFFICE_TXN_ID, OFAC_COMMENTS, CHECKSUM, CHANNEL_TXN_ID, CHUNKED_MSG, FIRC_OUT_RES_HEADER, SENT_DATE, RECEIVING_TIME, ACK_STATUS, OUT_STATUS, FS_MESSAGE_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private PreparedStatement INSERT_LOG_OFAC_CHUNKED_2_PS = null;
    private static final String CHN_HIST_SUBQUERY_SQL = "SELECT CHANNEL_TXN_ID, BACKOFFICE_CODE, CHN_TXN_CREATED_TIME, DATA_LIFE_STATUS, MATCH_STATUS, MATCH_CATEG_ID, TXN_TYPE, HIT_STATUS, ACTUAL_VALUE_DATE, LAST_UPDATE_TIME FROM SEC_OWNER.SECL_CHN_DATA_STATUS_HIST WHERE CHANNEL_TXN_ID = ? ORDER BY LAST_UPDATE_TIME DESC FETCH FIRST ROW ONLY";
    private PreparedStatement CHN_HIST_SUBQUERY_PS = null;
    private static final String CHN_HIST_SUBQUERY_FROM_SECT_SQL = "SELECT CHANNEL_TXN_ID, BACKOFFICE_CODE, CHN_TXN_CREATED_TIME, DATA_LIFE_STATUS, MATCH_STATUS, MATCH_CATEG_ID, TXN_TYPE, HIT_STATUS, ACTUAL_VALUE_DATE, LAST_UPDATE_TIME FROM SEC_OWNER.SECT_CHANNEL_DATA WHERE CHANNEL_TXN_ID = ? FETCH FIRST ROW ONLY";
    private PreparedStatement CHN_HIST_SUBQUERY_FROM_SECT_PS = null;
    private static final String INSERT_CHN_HIST_SQL = "INSERT INTO SEC_OWNER.SECL_CHN_DATA_STATUS_HIST (CHANNEL_TXN_ID, BACKOFFICE_CODE, CHN_TXN_CREATED_TIME, DATA_LIFE_STATUS, MATCH_STATUS, MATCH_CATEG_ID, TXN_TYPE, HIT_STATUS, ACTUAL_VALUE_DATE, LAST_UPDATE_TIME) VALUES (?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP)";
    private PreparedStatement INSERT_CHN_HIST_PS = null;
    private static final String SELECT_BASED_ON_CHUNKID_SQL = "SELECT * FROM SEC_OWNER.SECL_OFAC_CHUNKED_MESSAGE WHERE CHUNK_ID = ? ORDER BY LAST_UPDATE_TIME DESC FETCH FIRST ROW ONLY";
    private PreparedStatement SELECT_BASED_ON_CHUNKID_PS = null;
    private static final String SELECT_INITIAL_OFAC_MSG_ORDERED_SQL = "SELECT * FROM SEC_OWNER.SECL_OFAC_MESSAGE WHERE FS_MESSAGE_ID = ? ORDER BY LAST_UPDATE_TIME DESC FETCH FIRST ROW ONLY";
    private PreparedStatement SELECT_INITIAL_OFAC_MSG_ORDERED_PS = null;
    private static final String SELECT_BASED_FS_MSG_ID_SQL = "SELECT CHUNK_ID FROM SEC_OWNER.SECL_OFAC_CHUNKED_MESSAGE WHERE FS_MESSAGE_ID = ? AND CHUNK_SEQ = ? ORDER BY LAST_UPDATE_TIME DESC";
    private PreparedStatement SELECT_BASED_FS_MSG_ID_PS = null;
    private static final String COUNT_CHUNK_SQL = "SELECT COUNT(*) FROM SEC_OWNER.SECL_OFAC_CHUNKED_MESSAGE";
    private PreparedStatement COUNT_CHUNK_PS = null;
    private static final String GET_BY_FSCM_SQL = "SELECT * FROM SEC_OWNER.SECL_OFAC_CHUNKED_MESSAGE WHERE FS_MESSAGE_ID = ? AND CHUNK_SEQ = ? ORDER BY LAST_UPDATE_TIME DESC FETCH FIRST ROW ONLY";
    private PreparedStatement GET_BY_FSCM_PS = null;
    private static final String GET_BY_ACK_SQL = "SELECT * FROM SEC_OWNER.SECL_OFAC_CHUNKED_MESSAGE WHERE FS_MESSAGE_ID = ? AND ACK_STATUS IS NOT NULL";
    private PreparedStatement GET_BY_ACK_PS = null;
    private static final String GET_BY_OUT_SQL = "SELECT * FROM SEC_OWNER.SECL_OFAC_CHUNKED_MESSAGE WHERE FS_MESSAGE_ID = ? AND OUT_STATUS IS NOT NULL";
    private PreparedStatement GET_BY_OUT_PS = null;
    private static final String COUNT_UNPROCESSED_SQL = "SELECT COUNT(*) FROM SEC_OWNER.SECL_OFAC_CHUNKED_MESSAGE WHERE FS_MESSAGE_ID = ? AND SENT_LIFE_STATUS = 4 AND (ACK_STATUS IS NULL OR OUT_STATUS = 5)";
    private PreparedStatement COUNT_UNPROCESSED_PS = null;
    private static final String READABLE_STRING = "854ku45Q985a.lsdk;,.ifpq4z58Ao45u.sdflkjsdgkjqwJKL:EIUR[p4pnm,.zxc239*h1@0*Fn/~5.+3&gwNa(.3K-c/2bd(kb1.(=wvz!/56NIwk-4/(#mDhn%kd#9jas9_n!KC0-c>3*(fbn3Fl)Fhaw.2?nz~l;1q3=Fbak1>ah1Bci23fripB319v*bnFl2Ba-cH$lfb?A)_2bgFo2_+Vv$al+b124kasbFV[2G}b@9ASFbCk2.KIhb4K";
    private static final int READABLE_STRING_LEN = "854ku45Q985a.lsdk;,.ifpq4z58Ao45u.sdflkjsdgkjqwJKL:EIUR[p4pnm,.zxc239*h1@0*Fn/~5.+3&gwNa(.3K-c/2bd(kb1.(=wvz!/56NIwk-4/(#mDhn%kd#9jas9_n!KC0-c>3*(fbn3Fl)Fhaw.2?nz~l;1q3=Fbak1>ah1Bci23fripB319v*bnFl2Ba-cH$lfb?A)_2bgFo2_+Vv$al+b124kasbFV[2G}b@9ASFbCk2.KIhb4K".length();
    private static final char[] INTS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static void openStatisticsTask() {
        UseCase1Client c = new UseCase1Client();
        c.openStatistics();
    }

    private void openStatistics() {
        this.useCase1stats = this.getUseCase1Stats();
        if (this.useCase1stats == null) {
            this.useCase1stats = UseCase1Stats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
        this.setUseCase1Stats(this.useCase1stats);
    }

    public static void closeStatisticsTask() {
        UseCase1Client c = new UseCase1Client();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.useCase1stats != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.useCase1stats.close();
        }
    }

    public static void connectUseCase1ThinWanClientTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        c.connectUseCase1ThinWanClient();
        c.updateHydraThreadLocals();
    }

    private void connectUseCase1ThinWanClient() throws SQLException {
        switch (this.queryAPI) {
            case 1: {
                LonerHelper.connect();
                String clientName = RemoteTestModule.getMyClientName();
                String dsName = clientName.substring(clientName.indexOf("ds"), clientName.length());
                List endpoints = NetworkServerHelper.getNetworkLocatorEndpoints(dsName);
                this.connection = QueryUtil.gfxdWanClientSetup(this, endpoints);
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void executeDDLTask() throws FileNotFoundException, IOException, SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        if (c.ttgid == 0) {
            c.executeDDL();
        }
    }

    private void executeDDL() throws FileNotFoundException, IOException, SQLException {
        String fn = this.getDDLFile(UseCase1Prms.getDDLFile());
        List<String> stmts = this.getDDLStatements(fn);
        for (String stmt : stmts) {
            if (this.queryAPI == 1) {
                // empty if block
            }
            Log.getLogWriter().info("Executing DDL: " + stmt);
            try {
                this.execute(stmt, this.connection);
            }
            catch (SQLException e) {
                if (stmt.contains("DROP")) {
                    if (!e.getMessage().contains("does not exist") && !e.getMessage().contains("Unknown table ")) {
                        throw e;
                    }
                }
                throw e;
            }
            this.commitDDL();
        }
    }

    public static void setHeapPercentageTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        if (c.ttgid == 0) {
            c.setHeapPercentage(UseCase1Prms.getHeapPercentage());
        }
    }

    protected void setHeapPercentage(double percentage) throws SQLException {
        String sql = "call SYS.SET_EVICTION_HEAP_PERCENTAGE_SG(?,?)";
        CallableStatement cs = this.connection.prepareCall(sql);
        Log.getLogWriter().info("CALL SYS.SET_EVICTION_HEAP_PERCENTAGE_SG(" + percentage + ", null)");
        cs.setDouble(1, percentage);
        cs.setNull(2, 12);
        cs.executeUpdate();
    }

    public static void generateDataTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize(16823492);
        c.generateDataAndDrainQueues();
    }

    private void generateDataAndDrainQueues() throws SQLException {
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        if (tgname.contains("client")) {
            this.generateData();
            this.sendDrainSignal();
            this.waitForDrainedSignal();
        } else if (tgname.contains("server")) {
            if (this.jid == 0) {
                this.waitForDrainSignal();
                this.waitForQueuesToDrain();
                this.sendDrainedSignal();
            }
        } else {
            String s = "Unexpected thread group: " + tgname;
            throw new QueryPerfException(s);
        }
        this.cacheEndTrim(this.trimIntervals, this.trimInterval);
    }

    private void sendDrainSignal() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        counters.increment(UseCase1Blackboard.drainSignal);
        Log.getLogWriter().info("Sent drain signal");
    }

    private void waitForDrainSignal() throws SQLException {
        Log.getLogWriter().info("Waiting for drain signal...");
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        int numETLLoadClients = UseCase1Prms.getNumETLLoadClients();
        while (counters.read(UseCase1Blackboard.drainSignal) < (long)numETLLoadClients) {
            MasterController.sleepForMs((int)1000);
        }
        Log.getLogWriter().info("Got drain signal");
    }

    private void sendDrainedSignal() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        counters.increment(UseCase1Blackboard.drainedSignal);
        Log.getLogWriter().info("Sent drained signal");
    }

    private void waitForDrainedSignal() throws SQLException {
        Log.getLogWriter().info("Waiting for drained signal...");
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        int numETLGatewayServers = UseCase1Prms.getNumETLGatewayServers();
        while (counters.read(UseCase1Blackboard.drainedSignal) < (long)numETLGatewayServers) {
            MasterController.sleepForMs((int)1000);
        }
        Log.getLogWriter().info("Got drained signal");
    }

    private void generateData() throws SQLException {
        this.generate_SECT_CHANNEL_DATA(this.connection);
    }

    private void generate_SECT_CHANNEL_DATA(Connection conn) throws SQLException {
        if (this.SECT_CHANNEL_DATA_PS == null) {
            this.SECT_CHANNEL_DATA_PS = conn.prepareStatement(SECT_CHANNEL_DATA_SQL);
        }
        PreparedStatement stmt = this.SECT_CHANNEL_DATA_PS;
        int batchSize = UseCase1Prms.getBatchSize();
        int numSectChannelDataRows = UseCase1Prms.getNumSectChannelDataRows();
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        int tgthreads = TestConfig.getInstance().getThreadGroup(tgname).getTotalThreads();
        int totalBatches = numSectChannelDataRows / (batchSize * tgthreads);
        Log.getLogWriter().info("Generating " + totalBatches * batchSize + " rows of data using " + tgthreads + " threads");
        if (totalBatches <= 0) {
            String s = "Cannot generate data with only " + totalBatches * batchSize + " rows. Fix" + " UseCase1Prms.numSectChannelDataRows=" + numSectChannelDataRows + " UseCase1Prms.batchSize=" + batchSize + " this.numThreads=" + this.numThreads;
            throw new QueryPerfException(s);
        }
        for (int i = 0; i < totalBatches; ++i) {
            long start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertSectChannelData);
            for (int j = 0; j < batchSize; ++j) {
                this.fillSectChannelDataStmt(conn, stmt);
                stmt.addBatch();
            }
            stmt.executeBatch();
            conn.commit();
            stmt.clearBatch();
            this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertSectChannelData, start, batchSize, null);
        }
        stmt.close();
    }

    private void fillSectChannelDataStmt(Connection conn, PreparedStatement stmt) throws SQLException {
        UUID txid = UUID.randomUUID();
        stmt.setString(1, txid.toString());
        Timestamp valueDate = this.generateTimestamp();
        stmt.setTimestamp(2, valueDate);
        String companyId = this.generateNumericString(7);
        stmt.setString(3, companyId);
        String clientAccount = this.generateNumericString(8);
        stmt.setString(4, clientAccount);
        Double amount = this.generateDecimal(5, 2);
        stmt.setDouble(5, amount);
        String currency = "GBP";
        stmt.setString(6, currency);
        String clientRefNo = this.generateString(13);
        stmt.setString(7, clientRefNo);
        String origBankId = this.generateString(10, 15);
        stmt.setString(8, origBankId);
        String beneAccntNo = this.generateString(10);
        stmt.setString(9, beneAccntNo);
        String beneBankId = this.generateString(10);
        stmt.setString(10, beneBankId);
        String beneBankAddr = this.generateString(20);
        stmt.setString(11, beneBankAddr);
        String beneName = this.generateString(10);
        stmt.setString(12, beneName);
        String beneAddr = this.generateString(20);
        stmt.setString(13, beneAddr);
        String backofficeCode = IPAY;
        stmt.setString(14, backofficeCode);
        String txnType = "DDI";
        stmt.setString(15, txnType);
        stmt.setInt(16, 0);
        stmt.setInt(17, 1);
        stmt.setInt(18, -1);
        stmt.setLong(19, -1L);
        String channelName = CHANNEL_NAMES[this.rng.nextInt(CHANNEL_NAMES.length - 1)];
        stmt.setString(20, channelName);
        Clob clob = conn.createClob();
        clob.setString(1L, SECT_CHANNEL_RAW_DATA);
        stmt.setClob(21, clob);
        String fileTypeId = UUID.randomUUID().toString();
        stmt.setString(22, fileTypeId);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("INSERT into SECT_CHANNEL_DATA with CURRENCY=" + currency + " AMOUNT=" + amount + " CLIENT_REF_NO=" + clientRefNo + " VALUE_DATE=" + valueDate + " CLIENT_ACCOUNT=" + clientAccount + " COMPANY_ID=" + companyId);
        }
    }

    private void waitForQueuesToDrain() throws SQLException {
        Log.getLogWriter().info("Waiting for queues to drain...");
        DistributedSystem f = DistributedSystemHelper.getDistributedSystem();
        Statistics[] stats = f.findStatisticsByType(f.findType("GatewaySenderStatistics"));
        while (true) {
            long qsize = 0L;
            for (int i = 0; i < stats.length; ++i) {
                qsize += (long)stats[i].getInt(GatewaySenderStats.getEventQueueSizeId());
            }
            if (qsize == 0L) break;
            MasterController.sleepForMs((int)250);
        }
        Log.getLogWriter().info("Waited for queues to drain");
    }

    public static void exportTablesTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        if (c.ttgid == 0 && UseCase1Prms.exportTables()) {
            c.exportTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportTables() throws SQLException {
        Connection conn = this.openTmpConnection();
        try {
            List<String> tables = this.getTableNames(conn);
            for (String table : tables) {
                this.exportTable(conn, table);
            }
        }
        finally {
            this.closeTmpConnection(conn);
        }
    }

    protected void exportTable(Connection conn, String table) throws SQLException {
        String exportTable = "CALL SYSCS_UTIL.EXPORT_TABLE (?, ?, ?, null, null, null)";
        String dir = FabricServerHelper.getFabricServerDescription().getSysDir() + "/" + table.toUpperCase() + ".file";
        CallableStatement cs = conn.prepareCall(exportTable);
        cs.setString(1, "SEC_OWNER");
        cs.setString(2, table);
        cs.setString(3, dir);
        cs.execute();
        Log.getLogWriter().info("Exported table: SEC_OWNER." + table + " to " + dir);
    }

    private List<String> getTableNames(Connection conn) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        try {
            ResultSet rs = conn.createStatement().executeQuery("SELECT tablename FROM sys.systables WHERE tableschemaname= 'SEC_OWNER'");
            while (rs.next()) {
                String table = rs.getString(1);
                tables.add(table);
                Log.getLogWriter().info("Found table to export: " + table);
            }
            rs.close();
            rs = null;
        }
        catch (SQLException e) {
            throw new QueryPerfException(TestHelper.getStackTrace((Throwable)e));
        }
        return tables;
    }

    public static void importTablesTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        if (c.sttgid == 0) {
            c.importTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importTables() throws SQLException {
        String dir = UseCase1Prms.getImportTableDir();
        Connection conn = this.openTmpConnection();
        try {
            for (String table : UseCase1Prms.getImportTables()) {
                this.importTable(conn, dir, table);
            }
        }
        finally {
            this.closeTmpConnection(conn);
        }
    }

    protected void importTable(Connection conn, String dir, String table) throws SQLException {
        String importTable = "CALL SYSCS_UTIL.IMPORT_TABLE_EX (?, ?, ?, null, null, null, 0, 0, 32, 0, null, null)";
        Log.getLogWriter().info("Importing table: SEC_OWNER." + table + " from " + dir);
        CallableStatement cs = conn.prepareCall(importTable);
        cs.setString(1, "SEC_OWNER");
        cs.setString(2, table);
        cs.setString(3, dir + "/" + table + ".file");
        cs.execute();
        Log.getLogWriter().info("Imported table: SEC_OWNER." + table);
    }

    public static void trafficCopTask1() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        c.trafficCop1();
    }

    private void trafficCop1() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        this.pauseTrafficCop(30);
        this.pauseClients(counters);
        this.shutDownAll(counters, "ds_12");
        this.killServers("ds_12");
        this.restartServers("ds_12");
        this.resumeClients(counters);
        this.pauseTrafficCop(30);
        this.stopTest(counters);
    }

    public static void trafficCopNoBounceTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        c.trafficCopNoBounce();
    }

    private void trafficCopNoBounce() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        this.pauseTrafficCop(UseCase1Prms.getTrafficCopSleepSec());
        this.stopTest(counters);
    }

    public static void trafficCopMatchTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        c.trafficCopMatch();
    }

    private void trafficCopMatch() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        this.pauseTrafficCop(UseCase1Prms.getTrafficCopSleepSec());
        this.pauseClients(counters);
        this.shutDownAll(counters, "ds_12");
        this.killServers("ds_12");
        this.restartServers("ds_12");
        this.resumeClients(counters);
        this.pauseTrafficCop(UseCase1Prms.getTrafficCopSleepSec());
        this.stopTest(counters);
    }

    private void shutDownAll(SharedCounters counters, String ds) {
        Log.getLogWriter().info("Traffic cop issuing shut-down-all on " + ds);
        FabricServerHelper.shutDownAllFabricServers(ds, 300);
        Log.getLogWriter().info("Traffic cop issued shut-down-all on " + ds);
    }

    private void killServers(String ds) {
        Log.getLogWriter().info("Traffic cop killing servers in " + ds);
        Map infos = UseCase1Blackboard.getInstance().getSharedMap().getMap();
        ArrayList<ClientVmInfo> targets = new ArrayList<ClientVmInfo>();
        for (ClientVmInfo info : infos.values()) {
            if (!info.getClientName().contains("data") || !info.getClientName().contains(ds)) continue;
            targets.add(info);
        }
        this.killServers(targets);
        Log.getLogWriter().info("Traffic cop killed servers in " + ds);
    }

    private void killServers(List<ClientVmInfo> targets) {
        Log.getLogWriter().info("Killing " + targets);
        ArrayList<HydraSubthread> threads = new ArrayList<HydraSubthread>();
        for (final ClientVmInfo clientVmInfo : targets) {
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    Log.getLogWriter().info("Traffic cop killing server " + clientVmInfo);
                    try {
                        ClientVmMgr.stop((String)("Killing " + clientVmInfo), (ClientVmInfo)clientVmInfo);
                        Log.getLogWriter().info("Traffic cop killed server " + clientVmInfo);
                    }
                    catch (ClientVmNotFoundException e) {
                        throw new QueryPerfException(TestHelper.getStackTrace((Throwable)e));
                    }
                }
            };
            String name = "Traffic Cop Dynamic Client VM Stopper";
            HydraSubthread t = new HydraSubthread(action);
            t.start();
            threads.add(t);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new QueryPerfException(TestHelper.getStackTrace((Throwable)e));
            }
        }
        Log.getLogWriter().info("Killed " + targets);
    }

    private void restartServers(String ds) {
        Log.getLogWriter().info("Traffic cop restarting servers in " + ds);
        Map infos = UseCase1Blackboard.getInstance().getSharedMap().getMap();
        ArrayList<ClientVmInfo> targets = new ArrayList<ClientVmInfo>();
        for (ClientVmInfo info : infos.values()) {
            if (!info.getClientName().contains("data") || !info.getClientName().contains(ds)) continue;
            targets.add(info);
        }
        this.restartServers(targets);
        Log.getLogWriter().info("Traffic cop restarted servers in " + ds);
    }

    private void restartServers(List<ClientVmInfo> targets) {
        Log.getLogWriter().info("Starting " + targets);
        ArrayList<HydraSubthread> threads = new ArrayList<HydraSubthread>();
        for (final ClientVmInfo clientVmInfo : targets) {
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    Log.getLogWriter().info("Traffic cop starting server " + clientVmInfo);
                    try {
                        ClientVmMgr.start((String)("Starting " + clientVmInfo), (ClientVmInfo)clientVmInfo);
                        Log.getLogWriter().info("Traffic cop started server " + clientVmInfo);
                    }
                    catch (ClientVmNotFoundException e) {
                        throw new QueryPerfException(TestHelper.getStackTrace((Throwable)e));
                    }
                }
            };
            String name = "Traffic Cop Dynamic Client VM Starter";
            HydraSubthread t = new HydraSubthread(action);
            t.start();
            threads.add(t);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new QueryPerfException(TestHelper.getStackTrace((Throwable)e));
            }
        }
        Log.getLogWriter().info("Started " + targets);
    }

    private void pauseClients(SharedCounters counters) {
        Log.getLogWriter().info("Traffic cop setting pause signal");
        counters.setIfLarger(UseCase1Blackboard.pauseSignal, 1L);
        int numClients = UseCase1Prms.getNumClients();
        while (counters.read(UseCase1Blackboard.pauseCount) < (long)numClients) {
            MasterController.sleepForMs((int)2000);
        }
        Log.getLogWriter().info("Traffic cop sees all clients have paused");
    }

    private void resumeClients(SharedCounters counters) {
        Log.getLogWriter().info("Traffic cop resuming clients");
        counters.zero(UseCase1Blackboard.pauseSignal);
        while (counters.read(UseCase1Blackboard.pauseCount) > 0L) {
            MasterController.sleepForMs((int)2000);
        }
        Log.getLogWriter().info("Traffic cop sees all clients have resumed");
    }

    private void stopTest(SharedCounters counters) {
        Log.getLogWriter().info("Sending stop signal from traffic cop");
        counters.setIfLarger(UseCase1Blackboard.stopSignal, 1L);
        throw new StopSchedulingTaskOnClientOrder("Traffic cop terminating");
    }

    private void pauseTrafficCop(int seconds) {
        Log.getLogWriter().info("Traffic cop sleeping " + seconds + " seconds");
        MasterController.sleepForMs((int)(seconds * 1000));
    }

    public static void useCase1RunCommandFilesTask() throws FileNotFoundException, IOException, SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        if (c.ttgid == 0) {
            c.useCase1RunCommandFiles();
        }
    }

    private void useCase1RunCommandFiles() throws FileNotFoundException, IOException, SQLException {
        boolean useThinClient = UseCase1Prms.useThinClient();
        String dsName = UseCase1Prms.getDSName();
        String path = "$JTESTS/cacheperf.comparisons.gemfirexd.useCase1/sql/";
        List<String> fns = UseCase1Prms.getSQLCommandFiles();
        Log.getLogWriter().info("Running commands on " + dsName + " using " + fns);
        for (String fn : fns) {
            String newfn = EnvHelper.expandEnvVars((String)(path + fn));
            Log.getLogWriter().info("Running commands on " + dsName + " using " + newfn);
            if (useThinClient) {
                NetworkServerHelper.executeSQLCommands(dsName, newfn, 120);
            } else {
                FabricServerHelper.executeSQLCommands(dsName, newfn, 120);
            }
            Log.getLogWriter().info("Ran commands on " + dsName + " using " + newfn);
        }
        Log.getLogWriter().info("Ran commands on " + dsName);
    }

    public static void useCase1DummyWorkloadTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize(16823494);
        c.useCase1DummyWorkload();
    }

    private void useCase1DummyWorkload() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        while (true) {
            this.terminateIfNeeded(counters);
            this.pauseIfNeeded(counters);
            this.doDummyWorkload();
        }
    }

    private void doDummyWorkload() throws SQLException {
        int seconds = UseCase1Prms.getDummyWorkloadSleepSec();
        Log.getLogWriter().info("Working for " + seconds + " seconds");
        long start = this.useCase1stats.startDummy();
        MasterController.sleepForMs((int)(seconds * 1000));
        this.useCase1stats.endDummy(start);
        Log.getLogWriter().info("Completed a " + seconds + "-second work cycle");
    }

    public static void generateMoreDataTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize(16823493);
        c.generateMoreData();
    }

    private void generateMoreData() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        int throttleMs = UseCase1Prms.getWorkloadThrottleMs();
        while (true) {
            this.terminateIfNeeded(counters);
            this.pauseIfNeeded(counters);
            long batchEnd = System.currentTimeMillis() + (long)(this.batchSeconds * 1000);
            while (System.currentTimeMillis() < batchEnd) {
                if (throttleMs != 0) {
                    MasterController.sleepForMs((int)UseCase1Prms.getWorkloadThrottleMs());
                }
                this.generateMore_SECT_CHANNEL_DATA(this.connection);
            }
            Log.getLogWriter().info("Completed a workload batch");
        }
    }

    private void generateMore_SECT_CHANNEL_DATA(Connection conn) throws SQLException {
        if (this.SECT_CHANNEL_DATA_PS == null) {
            this.SECT_CHANNEL_DATA_PS = conn.prepareStatement(SECT_CHANNEL_DATA_SQL);
        }
        PreparedStatement stmt = this.SECT_CHANNEL_DATA_PS;
        long start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertSectChannelData);
        this.fillSectChannelDataStmt(conn, stmt);
        stmt.executeUpdate();
        conn.commit();
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertSectChannelData, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useCase1MatchWorkloadTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize(16823495);
        Object object = clientAccountsLock;
        synchronized (object) {
            c.getClientAccounts();
        }
        c.useCase1MatchWorkload();
    }

    private void getClientAccounts() throws SQLException {
        if (clientAccounts == null) {
            Log.getLogWriter().info("Looking up current client accounts");
            clientAccounts = new ArrayList<String>();
            PreparedStatement clientAccountPS = this.connection.prepareStatement("select client_account from SEC_OWNER.SECT_CHANNEL_DATA");
            ResultSet rs = clientAccountPS.executeQuery();
            while (rs.next()) {
                String clientAccount = rs.getString(1);
                clientAccounts.add(clientAccount);
            }
            rs.close();
            rs = null;
            Log.getLogWriter().info("Looked up " + clientAccounts.size() + " current client accounts");
        } else {
            Log.getLogWriter().info("Found " + clientAccounts.size() + " current client accounts");
        }
    }

    private void useCase1MatchWorkload() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        int throttleMs = UseCase1Prms.getWorkloadThrottleMs();
        while (true) {
            this.terminateIfNeeded(counters);
            this.pauseIfNeeded(counters);
            CallableStatement callableStmt = this.connection.prepareCall(MATCH_CALL);
            callableStmt.registerOutParameter(3, 4);
            long batchEnd = System.currentTimeMillis() + (long)(this.batchSeconds * 1000);
            while (System.currentTimeMillis() < batchEnd) {
                if (throttleMs != 0) {
                    MasterController.sleepForMs((int)UseCase1Prms.getWorkloadThrottleMs());
                }
                int index = this.rng.nextInt(0, clientAccounts.size() - 1);
                String clientAccount = clientAccounts.get(index);
                this.doSingleMatchWithOnePrimaryKey(callableStmt, clientAccount);
            }
            Log.getLogWriter().info("Completed a workload batch");
        }
    }

    private void doSingleMatchWithOnePrimaryKey(CallableStatement callableStmt, String clientAccount) throws SQLException {
        long start = this.useCase1stats.startMatch();
        HashMap<String, String> tableMap = new HashMap<String, String>();
        tableMap.put(CLIENT_ACCOUNT, clientAccount);
        HashMap<String, HashMap<String, String>> inBackOfficeMsg = new HashMap<String, HashMap<String, String>>();
        inBackOfficeMsg.put(SECL_BO_DATA_STATUS_HIST, tableMap);
        HashSet<MatchingInfo> singlePrimaryMatchingKeySet = new HashSet<MatchingInfo>();
        MatchingInfo mi = new MatchingInfo();
        mi.setBackOfficeCode(IPAY);
        mi.setKeyName(CLIENT_ACCOUNT);
        mi.setMatchingPriority(1);
        mi.setChnDataTable(SECT_CHANNEL_DATA);
        mi.setBoDataTable(SECL_BO_DATA_STATUS_HIST);
        mi.setBoOnBoardTimestamp(new Timestamp(new Date().getTime()));
        mi.setKeyOnBoardTimestamp(new Timestamp(new Date().getTime()));
        singlePrimaryMatchingKeySet.add(mi);
        TreeMap<Integer, HashSet<MatchingInfo>> inMatchingKeyMap = new TreeMap<Integer, HashSet<MatchingInfo>>();
        inMatchingKeyMap.put(1, singlePrimaryMatchingKeySet);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Match Task matching CLIENT_ACCOUNT=" + clientAccount);
        }
        callableStmt.setObject(1, inBackOfficeMsg);
        callableStmt.setObject(2, inMatchingKeyMap);
        callableStmt.execute();
        int errorStateValue = callableStmt.getInt(3);
        ResultSet rs = callableStmt.getResultSet();
        int countOfRows = 0;
        while (rs.next()) {
            ++countOfRows;
            if (!Log.getLogWriter().fineEnabled()) continue;
            Log.getLogWriter().fine("Match Task got rs.getString(1) " + rs.getString(1));
        }
        rs.close();
        rs = null;
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Match Task got countOfRows=" + countOfRows + " errorStateValue=" + errorStateValue);
        }
        this.useCase1stats.endMatch(start, countOfRows, errorStateValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useCase1MatchAndPurgeWorkloadTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize(16823496);
        if (c.ttgid == 0) {
            c.useCase1PurgeWorkload();
        } else {
            Object object = clientAccountsLock;
            synchronized (object) {
                c.getClientAccounts();
            }
            c.useCase1MatchWorkload();
        }
    }

    private void useCase1PurgeWorkload() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        int throttleMs = UseCase1Prms.getWorkloadThrottleMs();
        int throttleChunkMs = UseCase1Prms.getWorkloadThrottleChunkMs();
        while (true) {
            this.terminateIfNeeded(counters);
            this.pauseIfNeeded(counters);
            if (throttleMs != 0) {
                long throttleEnd = System.currentTimeMillis() + (long)UseCase1Prms.getWorkloadThrottleMs();
                while (System.currentTimeMillis() < throttleEnd) {
                    MasterController.sleepForMs((int)throttleChunkMs);
                    this.terminateIfNeeded(counters);
                    this.pauseIfNeeded(counters);
                }
            }
            Log.getLogWriter().info("Starting BO purge");
            long start = this.useCase1stats.startPurge();
            CallableStatement callableStmt = this.connection.prepareCall(PURGE_CALL);
            callableStmt.execute();
            this.useCase1stats.endPurge(start);
            Log.getLogWriter().info("Completed BO purge");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useCase1InboundWorkloadTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize(16823497);
        Object object = matchCriteriasLock;
        synchronized (object) {
            c.getMatchCriteria();
        }
        c.useCase1InboundWorkload();
    }

    private void useCase1InboundWorkload() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        int throttleMs = UseCase1Prms.getWorkloadThrottleMs();
        while (true) {
            this.terminateIfNeeded(counters);
            this.pauseIfNeeded(counters);
            CallableStatement callableStmt = this.connection.prepareCall(MATCH_CALL);
            callableStmt.registerOutParameter(3, 4);
            long batchEnd = System.currentTimeMillis() + (long)(this.batchSeconds * 1000);
            while (System.currentTimeMillis() < batchEnd) {
                if (throttleMs != 0) {
                    MasterController.sleepForMs((int)UseCase1Prms.getWorkloadThrottleMs());
                }
                int index = this.rng.nextInt(0, matchCriterias.size() - 1);
                this.doInbound(this.connection, callableStmt, matchCriterias.get(index), counters);
            }
            Log.getLogWriter().info("Completed a workload batch");
        }
    }

    private void doInbound(Connection conn, CallableStatement callableStmt, MatchCriteria matchCriteria, SharedCounters counters) throws SQLException {
        long inbound_start = this.useCase1stats.startInbound();
        long stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.getMQNameBOMap);
        Map<String, Set<String>> mqNameBOCodeSet = this.getMQNameBOMap(conn);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.getMQNameBOMap, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertBORawData);
        String boTxnId = UUID.randomUUID().toString();
        String boRawDataInit = this.createBORawData(matchCriteria);
        String incomingQueueName = "BO1.REQ.IN.QUEUE";
        String msgId = this.generateString(20);
        this.insertBORawData(conn, boTxnId, boRawDataInit, msgId, incomingQueueName);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertBORawData, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.getBORawDataByPrimaryKey);
        BORawData boRawData = this.getBORawDataByPrimaryKey(conn, boTxnId);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.getBORawDataByPrimaryKey, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertStatusHist);
        String beneBankName = "WXXXX BANK";
        String beneAccntNo = "DE12330500000001296854 FOZZI BEAR CA";
        String channelName = "ISO";
        BOMessage boMessage = new BOMessage();
        boMessage.setBoTxnId(boTxnId);
        boMessage.setBoCode(IPAY);
        boMessage.setOfacMsgId(msgId);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "VALUE_DATE", matchCriteria.valueDate);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "CURRENCY", matchCriteria.currency);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "INSTR_CREATED_TIME", matchCriteria.valueDate);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "ACTUAL_VALUE_DATE", matchCriteria.valueDate);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "COMPANY_ID", matchCriteria.companyId);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "BENE_BANK_NAME", beneBankName);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "BENE_ACCNT_NO", beneAccntNo);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, CLIENT_ACCOUNT, matchCriteria.clientAccount);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "AMOUNT", matchCriteria.amount);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "SCREENING_TIME", -1);
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "CLIENT_REF_NO", matchCriteria.clientRefNo);
        boMessage.setChannelName(channelName);
        int rowsInsertedStatusHist = this.insertStatusHist(conn, boMessage, stmt_start);
        long startm = this.useCase1stats.startMatch();
        HashMap<String, String> tableMap = new HashMap<String, String>();
        tableMap.put("VALUE_DATE", matchCriteria.valueDate.toString());
        tableMap.put("CURRENCY", matchCriteria.currency);
        tableMap.put("INSTR_CREATED_TIME", matchCriteria.valueDate.toString());
        tableMap.put("ACTUAL_VALUE_DATE", matchCriteria.valueDate.toString());
        tableMap.put("COMPANY_ID", matchCriteria.companyId);
        tableMap.put("BENE_BANK_NAME", beneBankName);
        tableMap.put("BENE_ACCNT_NO", beneAccntNo);
        tableMap.put(CLIENT_ACCOUNT, matchCriteria.clientAccount);
        tableMap.put("AMOUNT", String.valueOf(matchCriteria.amount));
        tableMap.put("SCREENING_TIME", "-1");
        tableMap.put("CLIENT_REF_NO", matchCriteria.clientRefNo);
        tableMap.put("CHANNEL_NAME", channelName);
        HashMap<String, HashMap<String, String>> inBackOfficeMsg = new HashMap<String, HashMap<String, String>>();
        inBackOfficeMsg.put(SECL_BO_DATA_STATUS_HIST, tableMap);
        if (this.inMatchingKeyMap == null) {
            this.inMatchingKeyMap = new TreeMap<Integer, Set<MatchingInfo>>();
            HashSet<MatchingInfo> rule1 = new HashSet<MatchingInfo>();
            rule1.add(this.createMatchingInfo("CURRENCY", "VARCHAR"));
            rule1.add(this.createMatchingInfo("AMOUNT", "DECIMAL"));
            rule1.add(this.createMatchingInfo("CLIENT_REF_NO", "VARCHAR"));
            rule1.add(this.createMatchingInfo("VALUE_DATE", "TIMESTAMP"));
            rule1.add(this.createMatchingInfo(CLIENT_ACCOUNT, "VARCHAR"));
            this.inMatchingKeyMap.put(1, rule1);
            HashSet<MatchingInfo> rule2 = new HashSet<MatchingInfo>();
            rule2.add(this.createMatchingInfo("CURRENCY", "VARCHAR"));
            rule2.add(this.createMatchingInfo("AMOUNT", "DECIMAL"));
            rule2.add(this.createMatchingInfo("CLIENT_REF_NO", "VARCHAR"));
            rule2.add(this.createMatchingInfo("VALUE_DATE", "TIMESTAMP"));
            rule2.add(this.createMatchingInfo("COMPANY_ID", "VARCHAR"));
            this.inMatchingKeyMap.put(2, rule2);
        }
        callableStmt.setObject(1, inBackOfficeMsg);
        callableStmt.setObject(2, this.inMatchingKeyMap);
        callableStmt.execute();
        int errorStateValue = callableStmt.getInt(3);
        ResultSet rs = callableStmt.getResultSet();
        int countOfRows = 0;
        ArrayList<String> channelTxnIds = new ArrayList<String>();
        while (rs.next()) {
            ++countOfRows;
            channelTxnIds.add(rs.getString("CHANNEL_TXN_ID"));
            if (!Log.getLogWriter().fineEnabled()) continue;
            Log.getLogWriter().fine("Match Task got rs.getString(1) " + rs.getString(1));
        }
        rs.close();
        rs = null;
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Match Task got countOfRows=" + countOfRows + " errorStateValue=" + errorStateValue);
        }
        this.useCase1stats.endMatch(startm, countOfRows, errorStateValue);
        HashMap<String, Object> logTableNewValues = new HashMap<String, Object>();
        int rowsAddedForStep13 = this.getByBackOfficeTxnId2(conn, boTxnId, logTableNewValues);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.persistFsMessage);
        OFACMessage ofacMessage = new OFACMessage();
        ofacMessage.setMessageGuId(UUID.randomUUID().toString());
        ofacMessage.setBoTranId(boTxnId);
        String channelTxnId = null;
        if (channelTxnIds.size() == 1) {
            channelTxnId = (String)channelTxnIds.get(0);
            ofacMessage.setChnTxnId(channelTxnId);
        }
        ofacMessage.setFsHitStatus(FsHitStatus.NOT_YET_KNOWN);
        int fsMessageIdNum = this.getNextKey();
        counters.increment(UseCase1Blackboard.maxFsMessageId);
        String fsMessageId = String.valueOf(fsMessageIdNum);
        ofacMessage.setFsMessageId(fsMessageId);
        ofacMessage.setNoOfChunks(1);
        int numRowsAddedForStep14 = this.persistFsMessage(conn, ofacMessage);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.persistFsMessage, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.persistChunkedMessages);
        FsChunkedMessage fsChunkedMessage = new FsChunkedMessage();
        fsChunkedMessage.setChunkId(fsMessageId);
        fsChunkedMessage.setFsMessageId(fsMessageId);
        fsChunkedMessage.setBoTranId(boTxnId);
        fsChunkedMessage.setChnTxnId(channelTxnId);
        fsChunkedMessage.setChunkSequence(1);
        fsChunkedMessage.setChunkedMessage(boRawDataInit.getBytes());
        fsChunkedMessage.setSentDate(new Timestamp(new Date().getTime()));
        fsChunkedMessage.setReceivedDate(null);
        fsChunkedMessage.setOfacComment(null);
        fsChunkedMessage.setFsMessageSendStatus(FsMessageSendStatus.FS_MSG_SENT);
        this.persistChunkedMessages(conn, fsChunkedMessage);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.persistChunkedMessages, stmt_start);
        this.useCase1stats.endInbound(inbound_start);
    }

    public Map<String, Set<String>> getMQNameBOMap(Connection conn) throws SQLException {
        if (this.GET_MQ_BO_MAP_PS == null) {
            this.GET_MQ_BO_MAP_PS = conn.prepareStatement(GET_MQ_BO_MAP_SQL);
        }
        ArrayList<MQNameBOCode> mqNameBOCodeList = new ArrayList<MQNameBOCode>();
        ResultSet rs = this.GET_MQ_BO_MAP_PS.executeQuery();
        while (rs.next()) {
            MQNameBOCode mqNameBoCode = new MQNameBOCode();
            mqNameBoCode.mqName = rs.getString("MQ_NAME");
            mqNameBoCode.boCode = rs.getString("BACKOFFICE_CODE");
            mqNameBOCodeList.add(mqNameBoCode);
        }
        rs.close();
        rs = null;
        HashMap<String, Set<String>> mqNameBOCodeSet = new HashMap<String, Set<String>>();
        for (MQNameBOCode mqNameBOCode : mqNameBOCodeList) {
            HashSet<String> boSet = (HashSet<String>)mqNameBOCodeSet.get(mqNameBOCode.mqName);
            if (boSet == null) {
                boSet = new HashSet<String>();
                mqNameBOCodeSet.put(mqNameBOCode.mqName, boSet);
            }
            if (boSet.contains(mqNameBOCode.boCode)) continue;
            boSet.add(mqNameBOCode.boCode);
        }
        return mqNameBOCodeSet;
    }

    private void getMatchCriteria() throws SQLException {
        if (matchCriterias == null) {
            Log.getLogWriter().info("Looking up current match criteria");
            matchCriterias = new ArrayList<MatchCriteria>();
            PreparedStatement matchCriteriaPS = this.connection.prepareStatement("select CURRENCY, AMOUNT, CLIENT_REF_NO, VALUE_DATE, CLIENT_ACCOUNT, COMPANY_ID from SEC_OWNER.SECT_CHANNEL_DATA");
            ResultSet rs = matchCriteriaPS.executeQuery();
            while (rs.next()) {
                matchCriterias.add(new MatchCriteria(rs));
            }
            rs.close();
            rs = null;
            Log.getLogWriter().info("Looked up " + matchCriterias.size() + " current match criteria");
        } else {
            Log.getLogWriter().info("Found " + matchCriterias.size() + " current match criteria");
        }
    }

    public BOMessage getByBackOfficeTxnId(Connection conn, String boTxnId) throws SQLException {
        if (this.GET_BY_BO_TXN_ID_PS == null) {
            this.GET_BY_BO_TXN_ID_PS = conn.prepareStatement(GET_BY_BO_TXN_ID_SQL);
        }
        this.GET_BY_BO_TXN_ID_PS.setString(1, boTxnId);
        ResultSet rs = this.GET_BY_BO_TXN_ID_PS.executeQuery();
        BOMessage boMessage = null;
        if (rs.next()) {
            boMessage = new BOMessage();
            boMessage.setBoTxnId(rs.getString("BO_TXN_ID"));
            boMessage.setBoCode(rs.getString("BACKOFFICE_CODE"));
            boMessage.setOfacMsgId(rs.getString("OFAC_MSG_ID"));
            boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "MATCH_STATUS", rs.getString("MATCH_STATUS"));
            boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "DATA_LIFE_STATUS", rs.getString("DATA_LIFE_STATUS"));
            boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "MATCH_DATE", rs.getString("MATCH_DATE"));
            boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "MATCHING_TIME", rs.getString("MATCHING_TIME"));
            boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "MATCH_CATEG_ID", rs.getString("MATCH_CATEG_ID"));
            boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "IS_RESENT", rs.getString("IS_RESENT"));
            boMessage.setChannelName(rs.getString("CHANNEL_NAME"));
            boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "TXN_TYPE", rs.getString("TXN_TYPE"));
        }
        rs.close();
        rs = null;
        return boMessage;
    }

    public int insertBORawData(Connection conn, String boTxnId, String rawData, String msgId, String incomingQueueName) throws SQLException {
        if (this.INSERT_RAW_DATA_PS == null) {
            this.INSERT_RAW_DATA_PS = conn.prepareStatement(INSERT_RAW_DATA_SQL);
        }
        this.INSERT_RAW_DATA_PS.setString(1, boTxnId);
        Clob clob = conn.createClob();
        clob.setString(1L, rawData);
        this.INSERT_RAW_DATA_PS.setClob(2, clob);
        this.INSERT_RAW_DATA_PS.setString(3, msgId);
        this.INSERT_RAW_DATA_PS.setString(4, incomingQueueName);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("INSERT into SECL_BO_RAW_DATA BO_TXN_ID=" + boTxnId + " BO_RAW_DATA=" + rawData + " MESSAGE_ID=" + msgId + " INCOMING_QUEUE=" + incomingQueueName);
        }
        return this.INSERT_RAW_DATA_PS.executeUpdate();
    }

    public BORawData getBORawDataByPrimaryKey(Connection conn, String boTxnId) throws SQLException {
        if (this.GET_BY_PK_PS == null) {
            this.GET_BY_PK_PS = conn.prepareStatement(GET_BY_PK_SQL);
        }
        this.GET_BY_PK_PS.setString(1, boTxnId);
        ResultSet rs = this.GET_BY_PK_PS.executeQuery();
        BORawData boRawData = null;
        while (rs.next()) {
            if (boRawData != null) {
                String s = "Got more than one result from a primary key lookup on SECL_BO_RAW_DATA using boTxnId=" + boTxnId;
                throw new SQLException(s);
            }
            boRawData = new BORawData();
            boRawData.setBoTxnId(rs.getString("BO_TXN_ID"));
            boRawData.setMsgId(rs.getString("MESSAGE_ID"));
            boRawData.setIncomingQueueName(rs.getString("INCOMING_QUEUE"));
            try {
                boRawData.setRawData(rs.getString("BO_RAW_DATA"));
            }
            catch (UnsupportedEncodingException e) {
                throw new QueryPerfException("Bad raw data", e);
            }
        }
        rs.close();
        rs = null;
        return boRawData;
    }

    public int insertStatusHist(Connection conn, BOMessage boMessage, long stmt_start) throws SQLException {
        boMessage.putBoTableData(SECL_BO_DATA_STATUS_HIST, "SCREENING_TIME", -1);
        InsertStatementBuilder isb = new InsertStatementBuilder();
        isb.insertInto(SECL_BO_DATA_STATUS_HIST).set("BO_TXN_ID", boMessage.getBoTxnId()).set("BACKOFFICE_CODE", boMessage.getBoCode()).set("OFAC_MSG_ID", boMessage.getOfacMsgId());
        Set<String> boDataCols = boMessage.getBoTableColumnNames(SECL_BO_DATA_STATUS_HIST);
        if (null != boDataCols) {
            for (String columnName : boDataCols) {
                isb.set(columnName, boMessage.getBoTableData(SECL_BO_DATA_STATUS_HIST, columnName));
            }
        }
        String sql = isb.getSql();
        PreparedStatement ps = conn.prepareStatement(sql);
        Object[] values = isb.getSqlValues();
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("insertStatusHist: sql=" + sql + " values=" + Arrays.asList(values));
        }
        for (int i = 1; i <= values.length; ++i) {
            ps.setObject(i, values[i - 1]);
        }
        int numRowsAffected = ps.executeUpdate();
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertStatusHist, stmt_start);
        Set<String> extraTableNames = boMessage.getBoTableNames();
        for (String tableName : extraTableNames) {
            Set<String> columnNames;
            if (SECL_BO_DATA_STATUS_HIST.equals(tableName) || null == (columnNames = boMessage.getBoTableColumnNames(tableName)) || columnNames.size() <= 0) continue;
            long start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertExtraBOTables);
            InsertStatementBuilder isb2 = new InsertStatementBuilder();
            isb2.insertInto(tableName).set("BO_TXN_ID", boMessage.getBoTxnId());
            for (String columnName : columnNames) {
                Object val = boMessage.getBoTableData(tableName, columnName);
                if (null == val) continue;
                isb2.set(columnName, val);
            }
            PreparedStatement ps2 = conn.prepareStatement(isb2.getSql());
            Object[] values2 = isb2.getSqlValues();
            for (int i = 1; i <= values2.length; ++i) {
                ps2.setObject(i, values2[i]);
            }
            numRowsAffected += ps2.executeUpdate();
            this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertExtraBOTables, start);
        }
        return numRowsAffected;
    }

    public int getByBackOfficeTxnId2(Connection conn, String boTxnId, Map<String, Object> logTableNewValues) throws SQLException {
        long stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.getByBackOfficeTxnId2);
        if (this.SELECT_BO_DATA_PS == null) {
            this.SELECT_BO_DATA_PS = conn.prepareStatement(SELECT_BO_DATA_SQL);
        }
        this.SELECT_BO_DATA_PS.setString(1, boTxnId);
        ResultSet rs = this.SELECT_BO_DATA_PS.executeQuery();
        HashMap<String, Object> backOfficeMap = null;
        if (rs.next()) {
            backOfficeMap = new HashMap<String, Object>();
            backOfficeMap.put("BO_TXN_ID", rs.getObject("BO_TXN_ID"));
            backOfficeMap.put("CLIENT_ID", rs.getObject("CLIENT_ID"));
            backOfficeMap.put("CLIENT_NAME", rs.getObject("CLIENT_NAME"));
            backOfficeMap.put(CLIENT_ACCOUNT, rs.getObject(CLIENT_ACCOUNT));
            backOfficeMap.put("COMPANY_ID", rs.getObject("COMPANY_ID"));
            backOfficeMap.put("CLIENT_REF_NO", rs.getObject("CLIENT_REF_NO"));
            backOfficeMap.put("VALUE_DATE", rs.getObject("VALUE_DATE"));
            backOfficeMap.put("AMOUNT", rs.getObject("AMOUNT"));
            backOfficeMap.put("CURRENCY", rs.getObject("CURRENCY"));
            backOfficeMap.put("ORIG_BANK_ID", rs.getObject("ORIG_BANK_ID"));
            backOfficeMap.put("BACKOFFICE_CODE", rs.getObject("BACKOFFICE_CODE"));
            backOfficeMap.put("BENE_ACCNT_NO", rs.getObject("BENE_ACCNT_NO"));
            backOfficeMap.put("BENE_NAME", rs.getObject("BENE_NAME"));
            backOfficeMap.put("BENE_ADDR", rs.getObject("BENE_ADDR"));
            backOfficeMap.put("BENE_BANK_ID", rs.getObject("BENE_BANK_ID"));
            backOfficeMap.put("BENE_BANK_NAME", rs.getObject("BENE_BANK_NAME"));
            backOfficeMap.put("BENE_BANK_ADDR", rs.getObject("BENE_BANK_ADDR"));
            backOfficeMap.put("INSTR_CREATED_TIME", rs.getObject("INSTR_CREATED_TIME"));
            backOfficeMap.put("INSTR_CREATED_BY", rs.getObject("INSTR_CREATED_BY"));
            backOfficeMap.put("DATA_LIFE_STATUS", rs.getObject("DATA_LIFE_STATUS"));
            backOfficeMap.put("MATCH_STATUS", rs.getObject("MATCH_STATUS"));
            backOfficeMap.put("MATCH_DATE", rs.getObject("MATCH_DATE"));
            backOfficeMap.put("MATCH_CATEG_ID", rs.getObject("MATCH_CATEG_ID"));
            backOfficeMap.put("MATCHING_TIME", rs.getObject("MATCHING_TIME"));
            backOfficeMap.put("MANUAL_MATCH", rs.getObject("MANUAL_MATCH"));
            backOfficeMap.put("MATCHING_REASON", rs.getObject("MATCHING_REASON"));
            backOfficeMap.put("SCREENING_TIME", rs.getObject("SCREENING_TIME"));
            backOfficeMap.put("IS_MANUAL", rs.getObject("IS_MANUAL"));
            backOfficeMap.put("IS_RESENT", rs.getObject("IS_RESENT"));
            backOfficeMap.put("CHANNEL_NAME", rs.getObject("CHANNEL_NAME"));
            backOfficeMap.put("TXN_TYPE", rs.getObject("TXN_TYPE"));
            backOfficeMap.put("OFAC_MSG_ID", rs.getObject("OFAC_MSG_ID"));
            backOfficeMap.put("HIT_STATUS", rs.getObject("HIT_STATUS"));
            backOfficeMap.put("ACTUAL_VALUE_DATE", rs.getObject("ACTUAL_VALUE_DATE"));
        }
        rs.close();
        rs = null;
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.getByBackOfficeTxnId2, stmt_start);
        if (backOfficeMap != null) {
            stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertToBOLogTable);
            if (this.QUERY_TO_INSERT_BO_LOG_TABLE_PS == null) {
                this.QUERY_TO_INSERT_BO_LOG_TABLE_PS = conn.prepareStatement(QUERY_TO_INSERT_BO_LOG_TABLE_SQL);
            }
            HashMap<String, Object> backOfficeDataMap = backOfficeMap;
            PreparedStatement ps = this.QUERY_TO_INSERT_BO_LOG_TABLE_PS;
            Object obj = logTableNewValues.get("BO_TXN_ID") == null ? backOfficeDataMap.get("BO_TXN_ID") : logTableNewValues.get("BO_TXN_ID");
            ps.setObject(1, obj);
            Object object = obj = logTableNewValues.get("CLIENT_ID") == null ? backOfficeDataMap.get("CLIENT_ID") : logTableNewValues.get("CLIENT_ID");
            if (obj == null) {
                ps.setObject(2, obj);
            }
            Object object2 = obj = logTableNewValues.get("CLIENT_NAME") == null ? backOfficeDataMap.get("CLIENT_NAME") : logTableNewValues.get("CLIENT_NAME");
            if (obj == null) {
                ps.setNull(3, 12);
            } else {
                ps.setObject(3, obj);
            }
            Object object3 = obj = logTableNewValues.get(CLIENT_ACCOUNT) == null ? backOfficeDataMap.get(CLIENT_ACCOUNT) : logTableNewValues.get(CLIENT_ACCOUNT);
            if (obj == null) {
                ps.setNull(4, 12);
            } else {
                ps.setObject(4, obj);
            }
            Object object4 = obj = logTableNewValues.get("COMPANY_ID") == null ? backOfficeDataMap.get("COMPANY_ID") : logTableNewValues.get("COMPANY_ID");
            if (obj == null) {
                ps.setNull(5, 12);
            } else {
                ps.setObject(5, obj);
            }
            Object object5 = obj = logTableNewValues.get("CLIENT_REF_NO") == null ? backOfficeDataMap.get("CLIENT_REF_NO") : logTableNewValues.get("CLIENT_REF_NO");
            if (obj == null) {
                ps.setNull(6, 12);
            } else {
                ps.setObject(6, obj);
            }
            Object object6 = obj = logTableNewValues.get("VALUE_DATE") == null ? backOfficeDataMap.get("VALUE_DATE") : logTableNewValues.get("VALUE_DATE");
            if (obj == null) {
                ps.setNull(7, 93);
            } else {
                ps.setObject(7, obj);
            }
            Object object7 = obj = logTableNewValues.get("AMOUNT") == null ? backOfficeDataMap.get("AMOUNT") : logTableNewValues.get("AMOUNT");
            if (obj == null) {
                ps.setNull(8, 3);
            } else {
                ps.setObject(8, obj);
            }
            Object object8 = obj = logTableNewValues.get("CURRENCY") == null ? backOfficeDataMap.get("CURRENCY") : logTableNewValues.get("CURRENCY");
            if (obj == null) {
                ps.setNull(9, 12);
            } else {
                ps.setObject(9, obj);
            }
            Object object9 = obj = logTableNewValues.get("ORIG_BANK_ID") == null ? backOfficeDataMap.get("ORIG_BANK_ID") : logTableNewValues.get("ORIG_BANK_ID");
            if (obj == null) {
                ps.setNull(10, 12);
            } else {
                ps.setObject(10, obj);
            }
            Object object10 = obj = logTableNewValues.get("BACKOFFICE_CODE") == null ? backOfficeDataMap.get("BACKOFFICE_CODE") : logTableNewValues.get("BACKOFFICE_CODE");
            if (obj == null) {
                ps.setNull(11, 12);
            } else {
                ps.setObject(11, obj);
            }
            Object object11 = obj = logTableNewValues.get("BENE_ACCNT_NO") == null ? backOfficeDataMap.get("BENE_ACCNT_NO") : logTableNewValues.get("BENE_ACCNT_NO");
            if (obj == null) {
                ps.setNull(12, 12);
            } else {
                ps.setObject(12, obj);
            }
            Object object12 = obj = logTableNewValues.get("BENE_NAME") == null ? backOfficeDataMap.get("BENE_NAME") : logTableNewValues.get("BENE_NAME");
            if (obj == null) {
                ps.setNull(13, 12);
            } else {
                ps.setObject(13, obj);
            }
            Object object13 = obj = logTableNewValues.get("BENE_ADDR") == null ? backOfficeDataMap.get("BENE_ADDR") : logTableNewValues.get("BENE_ADDR");
            if (obj == null) {
                ps.setNull(14, 12);
            } else {
                ps.setObject(14, obj);
            }
            Object object14 = obj = logTableNewValues.get("BENE_BANK_ID") == null ? backOfficeDataMap.get("BENE_BANK_ID") : logTableNewValues.get("BENE_BANK_ID");
            if (obj == null) {
                ps.setNull(15, 12);
            } else {
                ps.setObject(15, obj);
            }
            Object object15 = obj = logTableNewValues.get("BENE_BANK_NAME") == null ? backOfficeDataMap.get("BENE_BANK_NAME") : logTableNewValues.get("BENE_BANK_NAME");
            if (obj == null) {
                ps.setNull(16, 12);
            } else {
                ps.setObject(16, obj);
            }
            Object object16 = obj = logTableNewValues.get("BENE_BANK_ADDR") == null ? backOfficeDataMap.get("BENE_BANK_ADDR") : logTableNewValues.get("BENE_BANK_ADDR");
            if (obj == null) {
                ps.setNull(17, 12);
            } else {
                ps.setObject(17, obj);
            }
            Object object17 = obj = logTableNewValues.get("INSTR_CREATED_TIME") == null ? backOfficeDataMap.get("INSTR_CREATED_TIME") : logTableNewValues.get("INSTR_CREATED_TIME");
            if (obj == null) {
                ps.setNull(18, 93);
            } else {
                ps.setObject(18, obj);
            }
            Object object18 = obj = logTableNewValues.get("INSTR_CREATED_BY") == null ? backOfficeDataMap.get("INSTR_CREATED_BY") : logTableNewValues.get("INSTR_CREATED_BY");
            if (obj == null) {
                ps.setNull(19, 12);
            } else {
                ps.setObject(19, obj);
            }
            Object object19 = obj = logTableNewValues.get("DATA_LIFE_STATUS") == null ? backOfficeDataMap.get("DATA_LIFE_STATUS") : logTableNewValues.get("DATA_LIFE_STATUS");
            if (obj == null) {
                ps.setNull(20, 5);
            } else {
                ps.setObject(20, obj);
            }
            Object object20 = obj = logTableNewValues.get("MATCH_STATUS") == null ? backOfficeDataMap.get("MATCH_STATUS") : logTableNewValues.get("MATCH_STATUS");
            if (obj == null) {
                ps.setNull(21, 5);
            } else {
                ps.setObject(21, obj);
            }
            Object object21 = obj = logTableNewValues.get("MATCH_DATE") == null ? backOfficeDataMap.get("MATCH_DATE") : logTableNewValues.get("MATCH_DATE");
            if (obj == null) {
                ps.setNull(22, 93);
            } else {
                ps.setObject(22, obj);
            }
            Object object22 = obj = logTableNewValues.get("MATCH_CATEG_ID") == null ? backOfficeDataMap.get("MATCH_CATEG_ID") : logTableNewValues.get("MATCH_CATEG_ID");
            if (obj == null) {
                ps.setNull(23, 4);
            } else {
                ps.setObject(23, obj);
            }
            Object object23 = obj = logTableNewValues.get("MATCHING_TIME") == null ? backOfficeDataMap.get("MATCHING_TIME") : logTableNewValues.get("MATCHING_TIME");
            if (obj == null) {
                ps.setNull(24, 4);
            } else {
                ps.setObject(24, obj);
            }
            Object object24 = obj = logTableNewValues.get("MANUAL_MATCH") == null ? backOfficeDataMap.get("MANUAL_MATCH") : logTableNewValues.get("MANUAL_MATCH");
            if (obj == null) {
                ps.setNull(25, 1);
            } else {
                ps.setObject(25, obj);
            }
            Object object25 = obj = logTableNewValues.get("MATCHING_REASON") == null ? backOfficeDataMap.get("MATCHING_REASON") : logTableNewValues.get("MATCHING_REASON");
            if (obj == null) {
                ps.setNull(26, 12);
            } else {
                ps.setObject(26, obj);
            }
            Object object26 = obj = logTableNewValues.get("SCREENING_TIME") == null ? backOfficeDataMap.get("SCREENING_TIME") : logTableNewValues.get("SCREENING_TIME");
            if (obj == null) {
                obj = 42;
            }
            ps.setObject(27, obj);
            Object object27 = obj = logTableNewValues.get("IS_MANUAL") == null ? backOfficeDataMap.get("IS_MANUAL") : logTableNewValues.get("IS_MANUAL");
            if (obj == null) {
                ps.setNull(28, 1);
            } else {
                ps.setObject(28, obj);
            }
            Object object28 = obj = logTableNewValues.get("IS_RESENT") == null ? backOfficeDataMap.get("IS_RESENT") : logTableNewValues.get("IS_RESENT");
            if (obj == null) {
                ps.setNull(29, 1);
            } else {
                ps.setObject(29, obj);
            }
            Object object29 = obj = logTableNewValues.get("CHANNEL_NAME") == null ? backOfficeDataMap.get("CHANNEL_NAME") : logTableNewValues.get("CHANNEL_NAME");
            if (obj == null) {
                ps.setNull(30, 12);
            } else {
                ps.setObject(30, obj);
            }
            Object object30 = obj = logTableNewValues.get("TXN_TYPE") == null ? backOfficeDataMap.get("TXN_TYPE") : logTableNewValues.get("TXN_TYPE");
            if (obj == null) {
                ps.setNull(31, 12);
            } else {
                ps.setObject(31, obj);
            }
            Object object31 = obj = logTableNewValues.get("OFAC_MSG_ID") == null ? backOfficeDataMap.get("OFAC_MSG_ID") : logTableNewValues.get("OFAC_MSG_ID");
            if (obj == null) {
                ps.setNull(32, 12);
            } else {
                ps.setObject(32, obj);
            }
            Object object32 = obj = logTableNewValues.get("HIT_STATUS") == null ? backOfficeDataMap.get("HIT_STATUS") : logTableNewValues.get("HIT_STATUS");
            if (obj == null) {
                ps.setNull(33, 5);
            } else {
                ps.setObject(33, obj);
            }
            Object object33 = obj = logTableNewValues.get("ACTUAL_VALUE_DATE") == null ? backOfficeDataMap.get("ACTUAL_VALUE_DATE") : logTableNewValues.get("ACTUAL_VALUE_DATE");
            if (obj == null) {
                ps.setNull(34, 12);
            } else {
                ps.setObject(34, obj);
            }
            int rows = this.QUERY_TO_INSERT_BO_LOG_TABLE_PS.executeUpdate();
            this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertToBOLogTable, stmt_start);
            return rows;
        }
        String s = "This branch should never be executed in this test";
        throw new QueryPerfException(s);
    }

    private int persistFsMessage(Connection conn, OFACMessage ofacMessage) throws SQLException {
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Entering FsChunkedMessagePersisterDAOImpl.persistFsMessage");
        }
        if (this.INSERT_OFAC_LOG_PS == null) {
            this.INSERT_OFAC_LOG_PS = conn.prepareStatement(INSERT_OFAC_LOG_SQL);
        }
        this.INSERT_OFAC_LOG_PS.setString(1, ofacMessage.getBoTranId());
        this.INSERT_OFAC_LOG_PS.setString(2, ofacMessage.getChnTxnId());
        this.INSERT_OFAC_LOG_PS.setShort(3, (short)ofacMessage.getFsHitStatus().getValue());
        this.INSERT_OFAC_LOG_PS.setString(4, ofacMessage.getMessageGuId());
        this.INSERT_OFAC_LOG_PS.setInt(5, ofacMessage.getNoOfChunks());
        this.INSERT_OFAC_LOG_PS.setString(6, ofacMessage.getFsMessageId());
        int insertedRows = this.INSERT_OFAC_LOG_PS.executeUpdate();
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Exiting FsChunkedMessagePersisterDAOImpl.persistFsMessage : Rows inserted : " + insertedRows);
        }
        return insertedRows;
    }

    public int persistChunkedMessages(Connection conn, FsChunkedMessage fsChunkedMessage) throws SQLException {
        if (this.INSERT_LOG_OFAC_CHUNKED_PS == null) {
            this.INSERT_LOG_OFAC_CHUNKED_PS = conn.prepareStatement(INSERT_LOG_OFAC_CHUNKED_SQL);
        }
        PreparedStatement ps = this.INSERT_LOG_OFAC_CHUNKED_PS;
        ps.setString(1, fsChunkedMessage.getChunkId());
        ps.setString(2, fsChunkedMessage.getFsMessageId());
        ps.setString(3, fsChunkedMessage.getBoTranId());
        ps.setString(4, fsChunkedMessage.getChnTxnId());
        ps.setInt(5, fsChunkedMessage.getChunkSequence());
        if (fsChunkedMessage.getChunkedMessage() != null) {
            ps.setString(6, String.valueOf(fsChunkedMessage.getChunkedMessage()));
        } else {
            ps.setString(6, null);
        }
        ps.setTimestamp(7, fsChunkedMessage.getSentDate());
        ps.setTimestamp(8, fsChunkedMessage.getReceivedDate());
        ps.setString(9, fsChunkedMessage.getOfacComment());
        return this.INSERT_LOG_OFAC_CHUNKED_PS.executeUpdate();
    }

    private String createBORawData(MatchCriteria matchCriteria) {
        StringBuilder sb = new StringBuilder();
        sb.append("<MSG filename=\"SamplePAYEXT.txt\" sourceFormat=\"PAYEXT\">").append("\n").append("<MLD>UNB+UNOA:3</MLD>").append("\n").append("<ADR.SenderId>5025007000009</ADR.SenderId>").append("\n").append("<ADR>14</ADR>").append("\n").append("<DTE>006981815:1+120430:1159+80314</DTE>").append("\n").append("<MLD>PAYEXT1</MLD>").append("\n").append("<MLD>UNH+1+PAYEXT:D:96A:UN</MLD>").append("\n").append("<CRN>BGM+451+GHFRT0088733652</CRN>").append("\n").append("<TYP>BUSIN</TYP>").append("\n").append("<TYP>PAI::9</TYP>").append("\n").append("<TYP>:ZZZ</TYP>").append("\n").append("<ACI>FCA+14</ACI>").append("\n").append("<DTE>DTM+137:20120430:102</DTE>").append("\n").append("<MLD>RFF+CR</MLD>").append("\n").append("<CRN>RFF+ABO:5025006768762</CRN>").append("\n").append("<CRN.ClientRef>").append(matchCriteria.clientRefNo).append("</CRN.ClientRef>").append("\n").append("<CRN>RFF+ABO:5025006768762</CRN>").append("\n").append("<VAL>MOA+9</VAL>").append("\n").append("<VAL.Amount>").append(matchCriteria.amount).append("</VAL.Amount>").append("\n").append("<VAL.Currency>").append(matchCriteria.currency).append("</VAL.Currency>").append("\n").append("<MLD>DTM+209</MLD>").append("\n").append("<DTE.ValueDate>").append(matchCriteria.valueDate).append("</DTE.ValueDate>").append("\n").append("<MLD>102</MLD>").append("\n").append("<MLD>RFF+PB</MLD>").append("\n").append("<ACN.CompanyId>").append(matchCriteria.companyId).append("</ACN.CompanyId>").append("\n").append("<MLD>FII+OR</MLD>").append("\n").append("<ACN.OrigAccountNo>").append(matchCriteria.clientAccount).append("</ACN.OrigAccountNo>").append("\n").append("<FII.OrigBankId>GOYFEbSMpo</FII.OrigBankId>").append("\n").append("<MLD>FII+BF</MLD>").append("\n").append("<ACN.BeneAccountNo>tGA4TRr6jn</ACN.BeneAccountNo>").append("\n").append("<FII.BeneBankId>j7EYfLjkhh</FII.BeneBankId>").append("\n").append("<ADR>:::</ADR>").append("\n").append("<ADR.BeneBankAddr>MFdjiKakfqsHvfcgTsbq</ADR.BeneBankAddr>").append("\n").append("<ADR.BeneBankCtry>ES</ADR.BeneBankCtry>").append("\n").append("<MLD>NAD+OY+5025006768762</MLD>").append("\n").append("<ADR.OrigName>Spanish American Caribbean</ADR.OrigName>").append("\n").append("<MLD>NAD+BE+1000021496</MLD>").append("\n").append("<ADR.BeneName>ASAM CLARKE AND CO (MADRID USD)C/GOYA 11</ADR.BeneName>").append("\n").append("<ADR.BeneAddr>MADRID28001+ES</ADR.BeneAddr>").append("\n").append("<TYP>PRC+8</TYP>").append("\n").append("<TYP>DOC+380+37902012</TYP>").append("\n").append("<VAL>MOA+12:1607.9</VAL>").append("\n").append("<VAL>MOA+39:1607.9</VAL>").append("\n").append("<VAL>MOA+52</VAL>").append("\n").append("<DTE>DTM+171:20120229:102</DTE>").append("\n").append("<MLD>GIS+37</MLD>").append("\n").append("<MLD>UNT+23+1</MLD>").append("\n").append("</MSG>").append("\n");
        return sb.toString();
    }

    private MatchingInfo createMatchingInfo(String keyName, String dataType) {
        MatchingInfo mi = new MatchingInfo();
        mi.setBackOfficeCode(IPAY);
        mi.setKeyName(keyName);
        mi.setDataType(dataType);
        mi.setMatchingPriority(1);
        mi.setChnDataTable(SECT_CHANNEL_DATA);
        mi.setBoDataTable(SECL_BO_DATA_STATUS_HIST);
        mi.setBoOnBoardTimestamp(new Timestamp(new Date().getTime()));
        mi.setKeyOnBoardTimestamp(new Timestamp(new Date().getTime()));
        return mi;
    }

    public static void useCase1OutboundWorkloadTask() throws SQLException {
        UseCase1Client c = new UseCase1Client();
        c.initialize(16823498);
        c.useCase1OutboundWorkload();
    }

    private void useCase1OutboundWorkload() throws SQLException {
        SharedCounters counters = UseCase1Blackboard.getInstance().getSharedCounters();
        int throttleMs = UseCase1Prms.getWorkloadThrottleMs();
        while (true) {
            this.terminateIfNeeded(counters);
            this.pauseIfNeeded(counters);
            long batchEnd = System.currentTimeMillis() + (long)(this.batchSeconds * 1000);
            while (System.currentTimeMillis() < batchEnd) {
                if (throttleMs != 0) {
                    MasterController.sleepForMs((int)UseCase1Prms.getWorkloadThrottleMs());
                }
                this.enableQueryPlanGeneration();
                this.doOutbound(this.connection, counters);
                this.disableQueryPlanGeneration();
            }
            Log.getLogWriter().info("Completed a workload batch");
        }
    }

    private void doOutbound(Connection conn, SharedCounters counters) throws SQLException {
        long maxFsMessageId;
        long stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.getFsMessageId);
        int fsMessageIdNum = this.getNextKey();
        while (!this.frontloaded) {
            maxFsMessageId = counters.read(UseCase1Blackboard.maxFsMessageId);
            if (maxFsMessageId < (long)(100 * this.numThreads)) {
                Log.getLogWriter().info("Sleeping 10 seconds to allow inbound side to frontload messages");
                MasterController.sleepForMs((int)10000);
                continue;
            }
            this.frontloaded = true;
        }
        while ((long)fsMessageIdNum > (maxFsMessageId = counters.read(UseCase1Blackboard.maxFsMessageId)) + (long)(75 * this.numThreads)) {
            Log.getLogWriter().info("Sleeping 10 seconds to allow inbound side to get ahead");
            MasterController.sleepForMs((int)10000);
        }
        String fsMessageId = String.valueOf(fsMessageIdNum);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.getFsMessageId, stmt_start);
        long outbound_start = this.useCase1stats.startOutbound();
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.selectInitialOFACMsg);
        OFACMessage ofacMessage = this.selectInitialOFACMsg(conn, fsMessageId);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.selectInitialOFACMsg, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.persistFsMessage);
        int numRowsAddedForOutboundStep1 = this.persistFsMessage(conn, ofacMessage);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.persistFsMessage, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.persistChunkedMessages);
        FsChunkedMessage fsChunkedMessage = new FsChunkedMessage();
        fsChunkedMessage.setChunkId(fsMessageId);
        fsChunkedMessage.setFsMessageId(fsMessageId);
        fsChunkedMessage.setBoTranId(ofacMessage.getBoTranId());
        fsChunkedMessage.setChnTxnId(ofacMessage.getChnTxnId());
        fsChunkedMessage.setChunkSequence(1);
        fsChunkedMessage.setChunkedMessage(SECT_CHANNEL_RAW_DATA.getBytes());
        fsChunkedMessage.setSentDate(new Timestamp(new Date().getTime()));
        fsChunkedMessage.setReceivedDate(new Timestamp(new Date().getTime()));
        fsChunkedMessage.setOfacComment(null);
        fsChunkedMessage.setFsMessageSendStatus(FsMessageSendStatus.FS_MSG_SENT);
        this.persistChunkedMessages(conn, fsChunkedMessage);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.persistChunkedMessages, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.selectBasedOnChunkId);
        FsChunkedMessage fscm = this.selectBasedOnChunkId(conn, fsChunkedMessage);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.selectBasedOnChunkId, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.persistChunkedMessages2);
        this.persistChunkedMessages2(conn, fscm);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.persistChunkedMessages2, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.getByBackOfficeTxnId);
        BOMessage boMessage = this.getByBackOfficeTxnId(conn, ofacMessage.getBoTranId());
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.getByBackOfficeTxnId, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertStatusHist);
        int rowsInsertedStatusHist = this.insertStatusHist(conn, boMessage, stmt_start);
        this.insertChnHistFromMsg(conn, fscm);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.selectInitialOFACMsgOrdered);
        OFACMessage ofac = this.selectInitialOFACMsgOrdered(conn, fsMessageId);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.selectInitialOFACMsgOrdered, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.selectBasedOnFircMsgId);
        List<String> chunkIds = this.selectBasedOnFircMsgId(conn, fscm);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("selectBasedOnFircMsgId: chunkIds=" + chunkIds);
        }
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.selectBasedOnFircMsgId, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.selectBasedOnChunkId);
        fscm = this.selectBasedOnChunkId(conn, fscm);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.selectBasedOnChunkId, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.countChunkedMessages);
        int totalChunkRows = this.countChunkedMessages(conn);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.countChunkedMessages, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.getByFircosoftMessageId);
        FsChunkedMessage fscm2 = this.getByFircosoftMessageId(conn, fscm);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.getByFircosoftMessageId, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.selectBasedOnChunkId);
        fscm = this.selectBasedOnChunkId(conn, fscm);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.selectBasedOnChunkId, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.selectBasedOnAckStatus);
        fscm = this.selectBasedOnAckStatus(conn, fscm);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.selectBasedOnAckStatus, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.selectBasedOnOutStatus);
        fscm = this.selectBasedOnOutStatus(conn, fscm);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.selectBasedOnOutStatus, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.countUnprocessedChunksOnAckQueue);
        this.countUnprocessedChunksOnAckQueue(conn, fsMessageId);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.countUnprocessedChunksOnAckQueue, stmt_start);
        stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.selectBasedOnChunkId);
        fscm = this.selectBasedOnChunkId(conn, fscm);
        this.useCase1stats.endStmt(UseCase1Stats.Stmt.selectBasedOnChunkId, stmt_start);
        this.useCase1stats.endOutbound(outbound_start);
    }

    private OFACMessage selectInitialOFACMsg(Connection conn, String fsMessageId) throws SQLException {
        if (this.SELECT_INITIAL_OFAC_MSG_PS == null) {
            this.SELECT_INITIAL_OFAC_MSG_PS = conn.prepareStatement(SELECT_INITIAL_OFAC_MSG_SQL);
        }
        this.SELECT_INITIAL_OFAC_MSG_PS.setString(1, fsMessageId);
        ResultSet rs = this.SELECT_INITIAL_OFAC_MSG_PS.executeQuery();
        if (!rs.next()) {
            String s = "Did not find SECL_OFAC_MESSAGE with FS_MESSAGE_ID=" + fsMessageId;
            throw new QueryPerfException(s);
        }
        OFACMessage ofacMessage = new OFACMessage();
        ofacMessage.setMessageGuId(rs.getString("MESSAGE_GUID"));
        ofacMessage.setBoTranId(rs.getString("BO_TXN_ID"));
        ofacMessage.setChnTxnId(rs.getString("CHN_TXN_ID"));
        ofacMessage.setFsHitStatus(FsHitStatus.HIT);
        ofacMessage.setFsMessageId(fsMessageId);
        ofacMessage.setNoOfChunks(rs.getInt("NO_OF_CHUNKS"));
        rs.close();
        rs = null;
        return ofacMessage;
    }

    public int persistChunkedMessages2(Connection conn, FsChunkedMessage fsChunkedMessage) throws SQLException {
        if (this.INSERT_LOG_OFAC_CHUNKED_2_PS == null) {
            this.INSERT_LOG_OFAC_CHUNKED_2_PS = conn.prepareStatement(INSERT_LOG_OFAC_CHUNKED_2_SQL);
        }
        PreparedStatement ps = this.INSERT_LOG_OFAC_CHUNKED_2_PS;
        ps.setString(1, fsChunkedMessage.getChunkId());
        ps.setInt(2, fsChunkedMessage.getChunkSequence());
        FsDataLifeStatus fsdatalife = FsDataLifeStatus.SENT_SS;
        ps.setObject(3, FsDataLifeStatus.getFsDataLifeStatus(fsdatalife));
        ps.setString(4, fsChunkedMessage.getBoTranId());
        ps.setString(5, fsChunkedMessage.getOfacComment());
        ps.setString(6, "checksum_here");
        ps.setString(7, fsChunkedMessage.getChnTxnId());
        ps.setString(8, String.valueOf(fsChunkedMessage.getChunkedMessage()));
        Clob clob = conn.createClob();
        clob.setString(1L, "THIS IS THE FIRCOSOFT HEADER DATA");
        ps.setClob(9, clob);
        ps.setTimestamp(10, fsChunkedMessage.getSentDate());
        ps.setTimestamp(11, fsChunkedMessage.getReceivedDate());
        FsAckStatus fsack = FsAckStatus.ACK_HIT;
        ps.setObject(12, FsAckStatus.getFsAckStatusCode(fsack));
        FsOutStatus fsout = FsOutStatus.OUT_PASSED;
        ps.setObject(13, FsOutStatus.getFsOutStatusCode(fsout));
        ps.setString(14, fsChunkedMessage.getFsMessageId());
        return this.INSERT_LOG_OFAC_CHUNKED_2_PS.executeUpdate();
    }

    public int insertChnHistFromMsg(Connection conn, FsChunkedMessage fsChunkedMessage) throws SQLException {
        if (this.CHN_HIST_SUBQUERY_PS == null) {
            this.CHN_HIST_SUBQUERY_PS = conn.prepareStatement(CHN_HIST_SUBQUERY_SQL);
        }
        if (this.CHN_HIST_SUBQUERY_FROM_SECT_PS == null) {
            this.CHN_HIST_SUBQUERY_FROM_SECT_PS = conn.prepareStatement(CHN_HIST_SUBQUERY_FROM_SECT_SQL);
        }
        if (this.INSERT_CHN_HIST_PS == null) {
            this.INSERT_CHN_HIST_PS = conn.prepareStatement(INSERT_CHN_HIST_SQL);
        }
        int rows = 0;
        long stmt_start_1 = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertChnHistQuery1);
        this.CHN_HIST_SUBQUERY_PS.setString(1, fsChunkedMessage.getChnTxnId());
        ResultSet rs = this.CHN_HIST_SUBQUERY_PS.executeQuery();
        if (rs.next()) {
            this.fillInsertChnHistStmt(this.INSERT_CHN_HIST_PS, rs);
            this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertChnHistQuery1, stmt_start_1);
            rows = this.insertChnHistStmt(this.INSERT_CHN_HIST_PS);
        } else {
            this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertChnHistQuery1, stmt_start_1);
            long stmt_start_2 = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertChnHistQuery2);
            this.CHN_HIST_SUBQUERY_FROM_SECT_PS.setString(1, fsChunkedMessage.getChnTxnId());
            rs = this.CHN_HIST_SUBQUERY_FROM_SECT_PS.executeQuery();
            if (rs.next()) {
                this.fillInsertChnHistStmt(this.INSERT_CHN_HIST_PS, rs);
                this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertChnHistQuery2, stmt_start_2);
                rows = this.insertChnHistStmt(this.INSERT_CHN_HIST_PS);
            } else {
                this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertChnHistQuery2, stmt_start_2);
            }
        }
        rs.close();
        rs = null;
        return rows;
    }

    private void fillInsertChnHistStmt(PreparedStatement ps, ResultSet rs) throws SQLException {
        ps.setObject(1, rs.getObject("CHANNEL_TXN_ID"));
        ps.setObject(2, rs.getObject("BACKOFFICE_CODE"));
        ps.setObject(3, rs.getObject("CHN_TXN_CREATED_TIME"));
        ps.setObject(4, rs.getObject("DATA_LIFE_STATUS"));
        ps.setObject(5, rs.getObject("MATCH_STATUS"));
        ps.setObject(6, rs.getObject("MATCH_CATEG_ID"));
        ps.setObject(7, rs.getObject("TXN_TYPE"));
        Object obj = rs.getObject("HIT_STATUS");
        if (obj == null) {
            ps.setNull(8, 5);
        } else {
            ps.setObject(8, rs.getObject("HIT_STATUS"));
        }
        obj = rs.getObject("ACTUAL_VALUE_DATE");
        if (obj == null) {
            ps.setNull(9, 93);
        } else {
            ps.setObject(9, rs.getObject("ACTUAL_VALUE_DATE"));
        }
    }

    private int insertChnHistStmt(PreparedStatement ps) throws SQLException {
        long stmt_start = this.useCase1stats.startStmt(UseCase1Stats.Stmt.insertChnHist);
        int rows = 0;
        try {
            rows = this.INSERT_CHN_HIST_PS.executeUpdate();
            this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertChnHist, stmt_start);
        }
        catch (SQLIntegrityConstraintViolationException e) {
            this.useCase1stats.endStmt(UseCase1Stats.Stmt.insertChnHistConstraintViolation, stmt_start);
        }
        return rows;
    }

    public FsChunkedMessage selectBasedOnChunkId(Connection conn, FsChunkedMessage fsChunkedMessage) throws SQLException {
        if (this.SELECT_BASED_ON_CHUNKID_PS == null) {
            this.SELECT_BASED_ON_CHUNKID_PS = conn.prepareStatement(SELECT_BASED_ON_CHUNKID_SQL);
        }
        this.SELECT_BASED_ON_CHUNKID_PS.setString(1, fsChunkedMessage.getFsMessageId());
        ResultSet rs = this.SELECT_BASED_ON_CHUNKID_PS.executeQuery();
        FsChunkedMessage fscm = new FsChunkedMessage();
        if (rs.next()) {
            this.readFsChunkedMessageResult(fscm, fsChunkedMessage, rs);
        }
        rs.close();
        rs = null;
        return fscm;
    }

    private void readFsChunkedMessageResult(FsChunkedMessage fscm, FsChunkedMessage fsChunkedMessage, ResultSet rs) throws SQLException {
        Object resultObj = rs.getObject("CHUNK_ID");
        Object obj = resultObj == null ? fsChunkedMessage.getChunkId() : resultObj;
        fscm.setChunkId((String)obj);
        resultObj = rs.getObject("FS_MESSAGE_ID");
        obj = resultObj == null ? fsChunkedMessage.getFsMessageId() : resultObj;
        fscm.setFsMessageId((String)obj);
        resultObj = rs.getObject("BACKOFFICE_TXN_ID");
        obj = resultObj == null ? fsChunkedMessage.getBoTranId() : resultObj;
        fscm.setBoTranId((String)obj);
        resultObj = rs.getObject("CHANNEL_TXN_ID");
        obj = resultObj == null ? fsChunkedMessage.getChnTxnId() : resultObj;
        fscm.setChnTxnId((String)obj);
        resultObj = rs.getObject("CHUNK_SEQ");
        fscm.setChunkSequence(fsChunkedMessage.getChunkSequence());
        resultObj = rs.getObject("CHUNKED_MSG");
        fscm.setChunkedMessage(fsChunkedMessage.getChunkedMessage());
        resultObj = rs.getObject("SENT_DATE");
        obj = resultObj == null ? fsChunkedMessage.getSentDate() : resultObj;
        fscm.setSentDate((Timestamp)obj);
        resultObj = rs.getObject("RECEIVING_TIME");
        obj = resultObj == null ? fsChunkedMessage.getReceivedDate() : resultObj;
        fscm.setReceivedDate((Timestamp)obj);
        resultObj = rs.getObject("OFAC_COMMENTS");
        obj = resultObj == null ? fsChunkedMessage.getOfacComment() : resultObj;
        fscm.setOfacComment((String)obj);
        resultObj = rs.getObject("SENT_LIFE_STATUS");
        fscm.setFsMessageSendStatus(fsChunkedMessage.getFsMessageSendStatus());
    }

    private OFACMessage selectInitialOFACMsgOrdered(Connection conn, String fsMessageId) throws SQLException {
        if (this.SELECT_INITIAL_OFAC_MSG_ORDERED_PS == null) {
            this.SELECT_INITIAL_OFAC_MSG_ORDERED_PS = conn.prepareStatement(SELECT_INITIAL_OFAC_MSG_ORDERED_SQL);
        }
        this.SELECT_INITIAL_OFAC_MSG_ORDERED_PS.setString(1, fsMessageId);
        ResultSet rs = this.SELECT_INITIAL_OFAC_MSG_ORDERED_PS.executeQuery();
        if (!rs.next()) {
            String s = "Did not find SECL_OFAC_MESSAGE with FS_MESSAGE_ID=" + fsMessageId;
            throw new QueryPerfException(s);
        }
        OFACMessage ofacMessage = new OFACMessage();
        ofacMessage.setMessageGuId(rs.getString("MESSAGE_GUID"));
        ofacMessage.setBoTranId(rs.getString("BO_TXN_ID"));
        ofacMessage.setChnTxnId(rs.getString("CHN_TXN_ID"));
        ofacMessage.setFsHitStatus(FsHitStatus.HIT);
        ofacMessage.setFsMessageId(fsMessageId);
        ofacMessage.setNoOfChunks(rs.getInt("NO_OF_CHUNKS"));
        rs.close();
        rs = null;
        return ofacMessage;
    }

    public List<String> selectBasedOnFircMsgId(Connection conn, FsChunkedMessage fscm) throws SQLException {
        if (this.SELECT_BASED_FS_MSG_ID_PS == null) {
            this.SELECT_BASED_FS_MSG_ID_PS = conn.prepareStatement(SELECT_BASED_FS_MSG_ID_SQL);
        }
        PreparedStatement ps = this.SELECT_BASED_FS_MSG_ID_PS;
        ps.setObject(1, fscm.getFsMessageId());
        ps.setObject(2, fscm.getChunkSequence());
        ResultSet rs = ps.executeQuery();
        ArrayList<String> chunkIds = new ArrayList<String>();
        while (rs.next()) {
            chunkIds.add(rs.getString("CHUNK_ID"));
        }
        rs.close();
        rs = null;
        return chunkIds;
    }

    public int countChunkedMessages(Connection conn) throws SQLException {
        ResultSet rs;
        if (this.COUNT_CHUNK_PS == null) {
            this.COUNT_CHUNK_PS = conn.prepareStatement(COUNT_CHUNK_SQL);
        }
        if ((rs = this.COUNT_CHUNK_PS.executeQuery()).next()) {
            return rs.getInt(1);
        }
        String s = "SECL_OFAC_CHUNKED_MESSAGE table has no rows";
        throw new QueryPerfException(s);
    }

    public FsChunkedMessage getByFircosoftMessageId(Connection conn, FsChunkedMessage fsChunkedMessage) throws SQLException {
        if (this.GET_BY_FSCM_PS == null) {
            this.GET_BY_FSCM_PS = conn.prepareStatement(GET_BY_FSCM_SQL);
        }
        PreparedStatement ps = this.GET_BY_FSCM_PS;
        ps.setString(1, fsChunkedMessage.getFsMessageId());
        ps.setInt(2, fsChunkedMessage.getChunkSequence());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            FsChunkedMessage fscm = new FsChunkedMessage();
            this.readFsChunkedMessageResult(fscm, fsChunkedMessage, rs);
            return fscm;
        }
        String s = "No SECL_OFAC_CHUNKED_MESSAGE with FS_MESSAGE_ID=" + fsChunkedMessage.getFsMessageId() + " and CHUNK_SEQ=" + fsChunkedMessage.getChunkSequence();
        throw new QueryPerfException(s);
    }

    public FsChunkedMessage selectBasedOnAckStatus(Connection conn, FsChunkedMessage fsChunkedMessage) throws SQLException {
        if (this.GET_BY_ACK_PS == null) {
            this.GET_BY_ACK_PS = conn.prepareStatement(GET_BY_ACK_SQL);
        }
        PreparedStatement ps = this.GET_BY_ACK_PS;
        ps.setString(1, fsChunkedMessage.getFsMessageId());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            FsChunkedMessage fscm = new FsChunkedMessage();
            this.readFsChunkedMessageResult(fscm, fsChunkedMessage, rs);
            return fscm;
        }
        String s = "No SECL_OFAC_CHUNKED_MESSAGE with FS_MESSAGE_ID=" + fsChunkedMessage.getFsMessageId() + " and ACK_STATUS=NOT NULL";
        throw new QueryPerfException(s);
    }

    public FsChunkedMessage selectBasedOnOutStatus(Connection conn, FsChunkedMessage fsChunkedMessage) throws SQLException {
        if (this.GET_BY_OUT_PS == null) {
            this.GET_BY_OUT_PS = conn.prepareStatement(GET_BY_OUT_SQL);
        }
        PreparedStatement ps = this.GET_BY_OUT_PS;
        ps.setString(1, fsChunkedMessage.getFsMessageId());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            FsChunkedMessage fscm = new FsChunkedMessage();
            this.readFsChunkedMessageResult(fscm, fsChunkedMessage, rs);
            return fscm;
        }
        String s = "No SECL_OFAC_CHUNKED_MESSAGE with FS_MESSAGE_ID=" + fsChunkedMessage.getFsMessageId() + " and OUT_STATUS=NOT NULL";
        throw new QueryPerfException(s);
    }

    public void countUnprocessedChunksOnAckQueue(Connection conn, String fsMessageId) throws SQLException {
        if (this.COUNT_UNPROCESSED_PS == null) {
            this.COUNT_UNPROCESSED_PS = conn.prepareStatement(COUNT_UNPROCESSED_SQL);
        }
        PreparedStatement ps = this.COUNT_UNPROCESSED_PS;
        ps.setString(1, fsMessageId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            int n = rs.getInt(1);
        }
    }

    private void terminateIfNeeded(SharedCounters counters) {
        if (counters.read(UseCase1Blackboard.stopSignal) > 0L) {
            this.cacheEndTrim(this.trimIntervals, this.trimInterval);
            this.updateHydraThreadLocals();
            throw new StopSchedulingTaskOnClientOrder("Received stop signal from traffic cop");
        }
    }

    private void pauseIfNeeded(SharedCounters counters) {
        int cycles = 0;
        while (counters.read(UseCase1Blackboard.pauseSignal) > 0L) {
            if (cycles == 0) {
                Log.getLogWriter().info("Received pause signal from traffic cop");
                counters.increment(UseCase1Blackboard.pauseCount);
            }
            MasterController.sleepForMs((int)5000);
            ++cycles;
        }
        if (cycles > 0) {
            int seconds = 5 * cycles;
            Log.getLogWriter().info("Received resume signal from traffic cop after " + seconds + " seconds");
            counters.decrement(UseCase1Blackboard.pauseCount);
        }
    }

    protected Timestamp generateTimestamp() {
        Date baseDate = null;
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            baseDate = DATE_FORMAT.parse("2012-01-01 01:01:00");
        }
        catch (ParseException e) {
            throw new QueryPerfException("2012-01-01 01:01:00 did not parse into a Date", e);
        }
        double addOn = Math.random() * 8.64E7 * 100.0;
        long newTime = baseDate.getTime() + (long)addOn;
        return new Timestamp(newTime);
    }

    protected String generateString(int size) {
        if (size > READABLE_STRING_LEN) {
            String s = "Cannot create substring of size " + size + " from readable string of size " + READABLE_STRING_LEN;
            throw new QueryPerfException(s);
        }
        int offset = this.rng.nextInt(READABLE_STRING_LEN - size);
        return READABLE_STRING.substring(offset, offset + size);
    }

    protected String generateString(int minsize, int maxsize) {
        return this.generateString(this.rng.nextInt(maxsize - minsize) + minsize);
    }

    protected String generateNumericString(int size) {
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = INTS[this.rng.nextInt(9)];
        }
        return new String(chars);
    }

    protected Double generateDecimal(int size, int decimals) {
        char[] chars = new char[size + 1 + decimals];
        for (int i = 0; i < size; ++i) {
            chars[i] = INTS[this.rng.nextInt(9)];
        }
        while (chars[0] == '0') {
            chars[0] = INTS[this.rng.nextInt(9)];
        }
        chars[i++] = 46;
        for (int j = 0; j < decimals; ++j) {
            chars[i + j] = INTS[this.rng.nextInt(9)];
        }
        return new Double(new String(chars));
    }

    private ResultSet execute(String stmt, Connection conn) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt + " on: " + conn);
        }
        ResultSet rs = null;
        Statement s = conn.createStatement();
        boolean result = s.execute(stmt);
        if (result) {
            rs = s.getResultSet();
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt + " on: " + conn);
        }
        s.close();
        return rs;
    }

    private void execute(PreparedStatement stmt) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt);
        }
        stmt.execute();
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt);
        }
    }

    private String getDDLFile(String fname) {
        String fn = "$JTESTS/cacheperf.comparisons.gemfirexd.useCase1/ddl/" + fname;
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("DDL file: " + newfn);
        return newfn;
    }

    private List<String> getDDLStatements(String fn) throws FileNotFoundException, IOException {
        Log.getLogWriter().info("Reading statements from " + fn);
        String text = FileUtil.getText((String)fn).trim();
        StringTokenizer tokenizer = new StringTokenizer(text, ";", false);
        ArrayList<String> stmts = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String stmt = tokenizer.nextToken().trim();
            stmts.add(stmt);
        }
        Log.getLogWriter().info("Read statements: " + stmts);
        return stmts;
    }

    private void commitDDL() {
        if (this.queryAPI != 1) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new QueryPerfException("Commit failed: " + e);
            }
        }
    }

    public static void dumpBucketsHook() {
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName.contains("server") || clientName.contains("sender") || clientName.contains("receiver") || clientName.contains("dbsync") || clientName.contains("prdata")) {
            Log.getLogWriter().info("Dumping local buckets");
            ResultSetHelper.dumpLocalBucket();
            Log.getLogWriter().info("Dumped local buckets");
        }
    }

    public static void dumpBucketsTask() {
        UseCase1Client c = new UseCase1Client();
        c.initialize();
        if (c.jid == 0) {
            Log.getLogWriter().info("Dumping local buckets");
            ResultSetHelper.dumpLocalBucket();
            Log.getLogWriter().info("Dumped local buckets");
        }
    }

    public static void postClientVmInfoTask() {
        int myVmid = RemoteTestModule.getMyVmid();
        ClientVmInfo info = new ClientVmInfo(Integer.valueOf(myVmid), RemoteTestModule.getMyClientName(), null);
        UseCase1Blackboard.getInstance().getSharedMap().put((Object)myVmid, (Object)info);
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.useCase1stats = this.getUseCase1Stats();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setUseCase1Stats(this.useCase1stats);
    }

    protected UseCase1Stats getUseCase1Stats() {
        this.useCase1stats = (UseCase1Stats)((Object)localuseCase1stats.get());
        return this.useCase1stats;
    }

    protected void setUseCase1Stats(UseCase1Stats useCase1stats) {
        localuseCase1stats.set((Object)useCase1stats);
    }

    protected void initialize(int trimInterval) {
        super.initialize(trimInterval);
        this.cacheStartTrim(this.trimIntervals, this.trimInterval);
    }

    @Override
    protected void initLocalParameters() {
        super.initLocalParameters();
        this.logQueries = QueryPrms.logQueries();
        this.logQueryResults = QueryPrms.logQueryResults();
    }

    @Override
    protected String nameFor(int name) {
        switch (name) {
            case 16823492: {
                return LOAD_NAME;
            }
            case 16823493: {
                return ETLGEN_NAME;
            }
            case 16823494: {
                return DUMMY_NAME;
            }
            case 16823495: {
                return MATCH_NAME;
            }
            case 16823496: {
                return MATCHPURGE_NAME;
            }
            case 16823497: {
                return INBOUND_NAME;
            }
            case 16823498: {
                return OUTBOUND_NAME;
            }
        }
        return super.nameFor(name);
    }

    protected int sttgid() {
        String clientName = System.getProperty("clientName");
        if (!clientName.contains("ds")) {
            return this.ttgid();
        }
        String[] arr = clientName.split("_");
        String localsite = null;
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals("ds")) continue;
            localsite = arr[i + 1];
            break;
        }
        if (localsite == null) {
            String s = "Client name is not of the form *_ds_site_*, where site is the site number";
            throw new QueryPerfException(s);
        }
        String localthreadname = Thread.currentThread().getName();
        Vector threadgroups = RemoteTestModule.getCurrentThread().getCurrentTask().getThreadGroupNames();
        int count = 0;
        for (List mapping : RemoteTestModule.getClientMapping()) {
            String threadgroup = (String)mapping.get(0);
            String threadname = (String)mapping.get(1);
            if (!threadgroups.contains(threadgroup)) continue;
            String[] carr = threadname.split("_");
            for (int i = 0; i < carr.length; ++i) {
                if (!carr[i].equals("ds")) continue;
                if (localthreadname.startsWith(threadname)) {
                    return count;
                }
                String site = carr[i + 1];
                if (!site.equals(localsite)) continue;
                ++count;
            }
        }
        String s = "Should not happen";
        throw new HydraInternalException(s);
    }

    @Override
    protected boolean getLogQueries() {
        return this.logQueries;
    }

    @Override
    protected void setLogQueries(boolean b) {
        this.logQueries = b;
    }

    @Override
    protected boolean generateQueryPlan() {
        return this.queryPlanFrequency != 0L && this.ttgid < this.maxQueryPlanners && this.timeToGenerateQueryPlan();
    }

    static class MatchCriteria {
        public String currency;
        public Double amount;
        public String clientRefNo;
        public Timestamp valueDate;
        public String clientAccount;
        public String companyId;

        public MatchCriteria(ResultSet rs) throws SQLException {
            this.currency = rs.getString(1);
            this.amount = rs.getDouble(2);
            this.clientRefNo = rs.getString(3);
            this.valueDate = rs.getTimestamp(4);
            this.clientAccount = rs.getString(5);
            this.companyId = rs.getString(6);
        }
    }

    static class MQNameBOCode {
        public String mqName;
        public String boCode;

        MQNameBOCode() {
        }
    }
}

