/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase1.datagen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.UUID;

public class DataGenerator {
    protected String url = "jdbc:gemfirexd://localhost:1530/";
    protected String driver = "com.pivotal.gemfirexd.jdbc.ClientDriver";
    int[] rowCount = new int[]{100000};
    static final Stack<Repeater> repeaters = new Stack();
    static final char[] chooseChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final char[] chooseBytes = "0123456789abcdef".toCharArray();
    static final char[] chooseInts = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public DataGenerator(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage <script> <tablenames> [<host:port> <rowcount> <column mapping file>]");
            System.exit(1);
        }
        try {
            if (args.length > 1) {
                this.url = "jdbc:gemfirexd://" + args[1];
                System.out.println("url=" + this.url);
            }
            Connection conn = this.getConnection();
            HashMap<String, Object> columnNameMapping = null;
            HashSet<String> columnsMapped = null;
            HashMap<String, RelationalOperator> colMapRelation = null;
            HashMap<String, ArrayList<String>> columnValueMapping = null;
            if (args.length > 3) {
                String line;
                columnNameMapping = new HashMap<String, Object>();
                columnsMapped = new HashSet<String>();
                colMapRelation = new HashMap<String, RelationalOperator>();
                columnValueMapping = new HashMap<String, ArrayList<String>>();
                FileReader freader = new FileReader(args[3]);
                BufferedReader in = new BufferedReader(freader);
                boolean skipMode = false;
                while ((line = in.readLine()) != null) {
                    String mappedColumnS;
                    String col;
                    Object mappedColumn;
                    String columnName;
                    StringTokenizer tokens;
                    if (line.startsWith("*/")) {
                        skipMode = false;
                        continue;
                    }
                    if (line.startsWith("##")) {
                        System.out.println();
                        continue;
                    }
                    if (skipMode || line.startsWith("#")) continue;
                    if (line.startsWith("/*")) {
                        skipMode = true;
                        continue;
                    }
                    if (line.startsWith("::foreach")) {
                        tokens = new StringTokenizer(line, " ");
                        tokens.nextToken();
                        columnName = tokens.nextToken();
                        if (!tokens.nextToken().equalsIgnoreCase("repeat")) {
                            throw new Exception("Invalid specification in line: " + line);
                        }
                        int numTimes = Integer.parseInt(tokens.nextToken());
                        repeaters.push(new Repeater(columnName, numTimes));
                        continue;
                    }
                    if (line.startsWith("::hcaerof")) {
                        tokens = new StringTokenizer(line, " ");
                        tokens.nextToken();
                        columnName = tokens.nextToken();
                        Repeater existing = repeaters.pop();
                        if (existing.columnName.equalsIgnoreCase(columnName)) continue;
                        throw new Exception("foreach nesting mismatch for line: " + line);
                    }
                    RelationalOperator op = RelationalOperator.Equal;
                    if ((line = line.trim()).length() <= 0) continue;
                    String[] mapping = line.split("=");
                    if (mapping.length == 1) {
                        mapping = line.split("<");
                        assert (mapping.length != 0);
                        if (mapping.length > 1) {
                            op = RelationalOperator.LessThan;
                        }
                    }
                    if ((mappedColumn = ColumnRange.parse(col = mapping[0].trim(), mappedColumnS = mapping[1].trim(), conn)) == null) {
                        mappedColumn = mappedColumnS;
                        System.out.println("Registering mapping for column " + col + " to " + mappedColumnS + " with " + op.name() + " relation");
                    } else {
                        String parentCol = ((ColumnRange)mappedColumn).foreachColumn;
                        if (parentCol != null) {
                            Object parentColRange = columnNameMapping.get(parentCol);
                            if (parentColRange == null) {
                                parentColRange = new ColumnRange(col, null, null, -1, -1, null, false, null, null);
                                ((ColumnRange)parentColRange).hasDependentForeach = true;
                                columnNameMapping.put(parentCol, parentColRange);
                            } else if (parentColRange instanceof ColumnRange) {
                                ((ColumnRange)parentColRange).hasDependentForeach = true;
                            } else {
                                throw new IllegalArgumentException("no value specifier for parent '" + parentCol + "' found for child '" + col + "'");
                            }
                        }
                    }
                    if (columnNameMapping.put(col, mappedColumn) != null) {
                        System.err.println("Multiple mappings for column " + col);
                        System.exit(2);
                    }
                    if (mappedColumn != mappedColumnS) continue;
                    columnsMapped.add(mappedColumnS);
                    colMapRelation.put(mappedColumnS, op);
                }
                if (!repeaters.empty()) {
                    throw new Exception("Invalid ::foreach pairing ...");
                }
                in.close();
            }
            DatabaseMetaData meta = conn.getMetaData();
            String[] types = new String[]{"TABLE"};
            ArrayList<String> prevTables = new ArrayList<String>();
            int tableIndex = -1;
            for (String fullTableName : args[0].split(",")) {
                ResultSet rsColumns = null;
                fullTableName = fullTableName.trim();
                String schemaName = null;
                String tableName = fullTableName;
                int schemaIndex = fullTableName.indexOf(46);
                if (schemaIndex >= 0) {
                    schemaName = fullTableName.substring(0, schemaIndex);
                    tableName = fullTableName.substring(schemaIndex + 1);
                }
                if (args.length > 2) {
                    if (args[2].indexOf(44) > 0) {
                        String[] multipleRowCount = args[2].split(",");
                        this.rowCount = new int[multipleRowCount.length];
                        for (int i = 0; i < multipleRowCount.length; ++i) {
                            this.rowCount[i] = Integer.parseInt(multipleRowCount[i]);
                        }
                        ++tableIndex;
                    } else {
                        this.rowCount[0] = Integer.parseInt(args[2]);
                        tableIndex = 0;
                    }
                }
                ResultSet rs = meta.getTables(null, schemaName, tableName, types);
                while (rs.next()) {
                    long startTime = System.currentTimeMillis();
                    if (!tableName.equals(rs.getString("TABLE_NAME"))) {
                        throw new RuntimeException("unexpected table name " + rs.getString("TABLE_NAME") + ", expected: " + tableName);
                    }
                    ResultSet keyList = meta.getPrimaryKeys(null, schemaName, tableName);
                    HashSet<String> importedKeys = null;
                    HashSet<String> primaryKey = null;
                    while (keyList.next()) {
                        if (primaryKey == null) {
                            primaryKey = new HashSet<String>();
                        }
                        primaryKey.add(keyList.getString("COLUMN_NAME"));
                    }
                    ResultSet importList = meta.getImportedKeys(null, schemaName, tableName);
                    while (importList.next()) {
                        if (importedKeys == null) {
                            importedKeys = new HashSet<String>();
                        }
                        importedKeys.add(importList.getString("PKCOLUMN_NAME") + " FK " + importList.getString("FKTABLE_NAME") + " FK COL " + importList.getString("FKCOLUMN_NAME"));
                    }
                    System.out.println();
                    System.out.println("Processing Table:" + tableName + " with primary key: " + primaryKey + " for " + this.rowCount[tableIndex] + " rows");
                    if (importedKeys != null) {
                        System.out.println("Foreign Keys for Table:" + tableName + " " + importedKeys + " for " + this.rowCount[tableIndex] + " rows");
                    }
                    FileWriter fstream = new FileWriter(tableName + ".dat");
                    BufferedWriter out = new BufferedWriter(fstream);
                    rsColumns = meta.getColumns(null, schemaName, tableName, null);
                    ArrayList<Object[]> columnsMeta = new ArrayList<Object[]>();
                    while (rsColumns.next()) {
                        Object[] columnMeta = new Object[]{rsColumns.getString("COLUMN_NAME"), rsColumns.getInt("DATA_TYPE"), rsColumns.getInt("COLUMN_SIZE"), rsColumns.getInt("DECIMAL_DIGITS")};
                        columnsMeta.add(columnMeta);
                    }
                    char sep = this.getFieldSeparator();
                    Object prevVal = null;
                    StringBuilder columnList = new StringBuilder();
                    for (int i = 0; i < this.rowCount[tableIndex]; ++i) {
                        StringBuilder sb = new StringBuilder();
                        int j = 0;
                        for (Object[] columnMeta : columnsMeta) {
                            Object mappedColumn;
                            String colName = (String)columnMeta[0];
                            String qColName = fullTableName + '.' + colName;
                            String value = null;
                            if (columnNameMapping != null && (mappedColumn = columnNameMapping.get(qColName)) != null) {
                                Class<?> colClass = mappedColumn.getClass();
                                if (colClass == String.class) {
                                    ArrayList columnValues = (ArrayList)columnValueMapping.get(mappedColumn);
                                    value = (String)columnValues.get(i % columnValues.size());
                                    if (i == 0) {
                                        System.out.println("Mapping column " + qColName + " to " + mappedColumn);
                                    }
                                } else if (colClass == String[].class) {
                                    Object[] mappedValues = (String[])mappedColumn;
                                    value = mappedValues[i % mappedValues.length];
                                    if (i == 0) {
                                        System.out.println("Mapping column " + qColName + " to values: " + Arrays.toString(mappedValues));
                                    }
                                } else if (colClass == ColumnRandom.class) {
                                    value = ((ColumnRandom)mappedColumn).getNext(this, (Integer)columnMeta[1], (Integer)columnMeta[2], (Integer)columnMeta[3], primaryKey, tableIndex, colName, i);
                                    if (i == 0) {
                                        System.out.println("Mapping column " + qColName + " to: " + mappedColumn);
                                    }
                                } else {
                                    value = ((ColumnRange)mappedColumn).getNext(i, columnNameMapping, columnValueMapping);
                                    if (i == 0) {
                                        System.out.println("Mapping column " + qColName + " to: " + mappedColumn);
                                    }
                                }
                            }
                            if (value == null) {
                                value = this.generateValues((Integer)columnMeta[1], (Integer)columnMeta[2], (Integer)columnMeta[3], primaryKey, tableIndex, colName, i, false, null);
                            }
                            if (columnsMapped != null && columnsMapped.contains(qColName)) {
                                RelationalOperator op;
                                ArrayList columnValues;
                                if (i == 0) {
                                    columnValues = new ArrayList();
                                    System.out.println("Registering values for mapped column " + qColName);
                                    columnValueMapping.put(qColName, columnValues);
                                } else {
                                    columnValues = (ArrayList)columnValueMapping.get(qColName);
                                }
                                String storeValue = value;
                                RelationalOperator relationalOperator = op = colMapRelation != null ? (RelationalOperator)((Object)colMapRelation.get(qColName)) : null;
                                if (op != null && op != RelationalOperator.Equal && op == RelationalOperator.LessThan) {
                                    if (i == 0) {
                                        System.out.println("Reducing value for mapped column " + qColName);
                                    }
                                    int type = (Integer)columnMeta[1];
                                    switch (type) {
                                        case -5: 
                                        case 4: 
                                        case 5: {
                                            long lv = Long.parseLong(value);
                                            lv = (long)((double)lv - (double)lv * 0.05);
                                            storeValue = Long.toString(lv);
                                            break;
                                        }
                                        case 8: {
                                            double dv = Double.parseDouble(value);
                                            dv -= dv * 0.05;
                                            storeValue = Double.toString(dv);
                                            break;
                                        }
                                        case 6: {
                                            float fv = Float.parseFloat(value);
                                            fv = (float)((double)fv - (double)fv * 0.05);
                                            storeValue = Float.toString(fv);
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            BigDecimal bv = new BigDecimal(value.toCharArray());
                                            bv = bv.movePointLeft(1);
                                            storeValue = bv.toPlainString();
                                            break;
                                        }
                                        default: {
                                            throw new RuntimeException("cannot handle column of type " + type);
                                        }
                                    }
                                }
                                columnValues.add(storeValue);
                            }
                            if (value == "[null]") {
                                if (i == 0) {
                                    columnList.append(colName).append(sep);
                                }
                                sb.append(sep);
                            } else if (value == "[skip]") {
                                if (i == 0) {
                                    System.out.println("Skipping value entry for " + qColName);
                                }
                            } else {
                                if (i == 0) {
                                    columnList.append(colName).append(sep);
                                }
                                sb.append(value).append(sep);
                            }
                            ++j;
                        }
                        if (i == 0) {
                            columnList.setCharAt(columnList.length() - 1, '\n');
                            out.write(columnList.toString());
                            columnList = null;
                        }
                        sb.setCharAt(sb.length() - 1, '\n');
                        out.write(sb.toString());
                    }
                    out.close();
                    System.out.println("    generation time elapsed: " + (System.currentTimeMillis() - startTime));
                }
                prevTables.add(fullTableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    protected String generateValues(int type, int cLen, int prec, HashSet<String> primaryKey, int tableIndex, String colName, int i, boolean absoluteLength, String baseValue) {
        String value;
        switch (type) {
            case 1: 
            case 12: 
            case 2005: {
                value = this.generateString(cLen, absoluteLength);
                if (!absoluteLength || baseValue == null || value.length() <= baseValue.length()) break;
                value = baseValue + value.substring(0, value.length() - baseValue.length());
                break;
            }
            case -5: 
            case 4: 
            case 5: {
                if (primaryKey == null || !primaryKey.contains(colName)) {
                    value = String.valueOf((int)(Math.random() * (double)this.rowCount[tableIndex]));
                    break;
                }
                value = String.valueOf(i + 1);
                break;
            }
            case 8: {
                value = String.valueOf(Math.random() * (double)this.rowCount[tableIndex]);
                break;
            }
            case 6: {
                value = Float.toString((float)(Math.random() * (double)this.rowCount[tableIndex]));
                break;
            }
            case 91: {
                value = this.generateDate(null);
                break;
            }
            case 93: {
                value = this.generateTimestamp(null);
                break;
            }
            case 2: 
            case 3: {
                if (primaryKey == null || !primaryKey.contains(colName)) {
                    value = this.generateNumeric(cLen, prec, absoluteLength);
                    break;
                }
                value = String.valueOf(i + 1);
                break;
            }
            case 2004: {
                value = this.generateBytes(cLen, absoluteLength);
                break;
            }
            default: {
                throw new RuntimeException("cannot handle column of type " + type);
            }
        }
        return value;
    }

    protected char getFieldSeparator() {
        return ',';
    }

    protected String getFormatterTimestamp() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    protected String getFormatterDate() {
        return "yyyy-MM-dd";
    }

    protected String getBaseTime() {
        return "2012-01-01 01:01:00";
    }

    protected String generateString(int len, boolean absoluteLength) {
        if (len > 32000) {
            len = 32000;
        }
        if (!absoluteLength) {
            len = (int)(Math.random() * 9.0 * (double)len / 10.0) + 1 + len / 10;
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = chooseChars[(int)(Math.random() * (double)chooseChars.length)];
        }
        return new String(chars);
    }

    protected String generateBytes(int len, boolean absoluteLength) {
        if (len > 32000) {
            len = 32000;
        }
        if (!absoluteLength) {
            len = (int)(Math.random() * 9.0 * (double)len / 10.0) + 1 + len / 10;
        }
        char[] chars = new char[len <<= 1];
        for (int i = 0; i < len; ++i) {
            chars[i] = chooseBytes[(int)(Math.random() * (double)chooseBytes.length)];
        }
        return new String(chars);
    }

    protected String generateDate(Date baseDate) {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        try {
            baseDate = formatterTimestamp.parse(this.getBaseTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(2);
        }
        double addOn = Math.random() * 8.64E7 * 100.0;
        long newTime = baseDate.getTime() + (long)addOn;
        Date newDate = new Date(newTime);
        return formatterTimestamp.format(newDate);
    }

    protected String generateTimestamp(Date baseDate) {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        try {
            baseDate = formatterTimestamp.parse(this.getBaseTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(2);
        }
        double addOn = Math.random() * 8.64E7 * 100.0;
        long newTime = baseDate.getTime() + (long)addOn;
        Date newDate = new Date(newTime);
        return formatterTimestamp.format(newDate);
    }

    protected String generateNumeric(int len, int prec, boolean absoluteLength) {
        int i;
        int major = len - prec;
        if (major > 1) {
            if (major > 15) {
                major = 15;
            }
            if (!absoluteLength) {
                major = (int)(Math.random() * (double)major) + 1;
            }
        }
        if (prec > 1 && !absoluteLength) {
            prec = (int)(Math.random() * (double)prec) + 1;
        }
        len = major + prec;
        char[] chars = new char[len + 1];
        for (i = 0; i < major; ++i) {
            chars[i] = chooseInts[(int)(Math.random() * (double)chooseInts.length)];
        }
        if (i < len) {
            chars[i] = 46;
            while (++i <= len) {
                chars[i] = chooseInts[(int)(Math.random() * (double)chooseInts.length)];
            }
        }
        return new String(chars, 0, i);
    }

    public Connection getConnection() {
        Connection con = null;
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
            System.exit(3);
        }
        try {
            Properties p = new Properties();
            p.setProperty("user", "locatoradmin");
            p.setProperty("password", "locatorpassword");
            con = DriverManager.getConnection(this.url, p);
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            System.exit(3);
        }
        return con;
    }

    public static void main(String[] args) {
        new DataGenerator(args);
    }

    static class ColumnRandom
    extends ColumnRange {
        final int beginLen;
        final int endLen;
        final int prec;
        final ColumnRange.specialTokens fixedToken;

        public ColumnRandom(String col, int beginLen, int endLen, int prec) {
            super(col, null, null, 0, 0, null);
            this.beginLen = beginLen;
            this.endLen = endLen;
            this.prec = prec;
            this.fixedToken = null;
        }

        public ColumnRandom(String col, ColumnRange.specialTokens token) {
            super(col, null, null, 0, 0, null);
            this.beginLen = -1;
            this.endLen = -1;
            this.prec = -1;
            this.fixedToken = token;
        }

        public String getNext(DataGenerator generator, int type, int cLen, int cPrec, HashSet<String> primaryKey, int tableIndex, String colName, int i) {
            String retVal = this.goForRepeatValue();
            if (retVal != null) {
                return retVal;
            }
            if (this.fixedToken != null) {
                this.currentValue = this.fixedToken.getNext();
            } else {
                int precision;
                int n = precision = this.prec == -1 ? cPrec : this.prec;
                this.currentValue = this.endLen == -1 ? generator.generateValues(type, this.beginLen == -1 ? cLen : this.beginLen, precision, primaryKey, tableIndex, colName, i, this.beginLen != -1, this.qColName.substring(this.qColName.lastIndexOf(".") + 1) + "  ") : generator.generateValues(type, this.rand.nextInt(this.endLen - this.beginLen) + this.beginLen, precision, primaryKey, tableIndex, colName, i, true, this.qColName.substring(this.qColName.lastIndexOf(".") + 1) + "  ");
            }
            return this.currentValue.toString();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("colName=").append(this.qColName).append(" ");
            if (this.fixedToken != null) {
                sb.append("fixedToken=").append((Object)this.fixedToken);
            } else {
                sb.append("beginLength=").append(this.beginLen);
                sb.append(";endLength=").append(this.endLen);
                sb.append(";prec=").append(this.prec);
            }
            return sb.toString();
        }
    }

    static class ColumnRange {
        final String qColName;
        final Object start;
        final Object increment;
        final int minNumber;
        final int maxNumber;
        final String foreachColumn;
        final boolean isDecimal;
        final Repeater repeatRetVal;
        String[] valueList;
        String valuePattern;
        boolean hasDependentForeach;
        Object currentValue;
        int currentIndex;
        final String foreignKeyColumn;
        int fkValueListIndex = 0;
        int currentLimit;
        Object currentNValue;
        int currentRepeatCount;
        final Random rand = new Random();
        public static final String nullToken = "[null]";
        public static final String skipToken = "[skip]";

        private ColumnRange(String qColName, Object start, Object increment, int minNumber, int maxNumber, String foreachColumn, boolean isDecimal, String[] valueList, String valuePattern) {
            this.qColName = qColName;
            this.start = start;
            this.increment = increment;
            this.minNumber = minNumber;
            this.maxNumber = maxNumber;
            this.foreachColumn = foreachColumn;
            this.isDecimal = isDecimal;
            this.repeatRetVal = repeaters.empty() ? null : repeaters.peek();
            this.valueList = valueList;
            this.valuePattern = valuePattern;
            this.foreignKeyColumn = null;
            this.currentIndex = -1;
            this.currentLimit = -1;
            this.currentRepeatCount = 0;
        }

        private ColumnRange(String qColName, Object start, Object increment, int minNumber, int maxNumber, String foreignKeyColumn) {
            this.qColName = qColName;
            this.start = start;
            this.increment = increment;
            this.minNumber = minNumber;
            this.maxNumber = maxNumber;
            this.foreachColumn = null;
            this.isDecimal = false;
            this.repeatRetVal = repeaters.empty() ? null : repeaters.peek();
            this.valueList = null;
            this.foreignKeyColumn = foreignKeyColumn;
            this.currentIndex = -1;
            this.currentLimit = -1;
            this.currentRepeatCount = 0;
        }

        protected String goForRepeatValue() {
            if (this.repeatRetVal != null) {
                if (this.currentRepeatCount == 0) {
                    ++this.currentRepeatCount;
                    return null;
                }
                if (this.currentRepeatCount++ <= this.repeatRetVal.numTimes) {
                    return this.currentValue.toString();
                }
                this.currentRepeatCount = 0;
            }
            return null;
        }

        public String getNext(int row, HashMap<String, Object> columnNameMapping, HashMap<String, ArrayList<String>> columnValueMapping) {
            String retVal = this.goForRepeatValue();
            if (retVal != null) {
                return retVal;
            }
            if (this.foreignKeyColumn != null && this.valueList == null) {
                this.valueList = columnValueMapping.get(this.foreignKeyColumn).toArray(new String[0]);
                System.out.println("Initialized foreignKeyColumn " + this.foreignKeyColumn + " with " + (this.valueList != null ? this.valueList.length : 0) + " values");
            }
            if (!this.hasDependentForeach) {
                ColumnRange range = this;
                while (range.getNext() && range.foreachColumn != null) {
                    range = (ColumnRange)columnNameMapping.get(range.foreachColumn);
                }
            } else if (this.currentValue == null) {
                this.getNext();
            }
            return this.currentValue.toString();
        }

        private boolean getNext() {
            boolean lastReached = false;
            if (this.valueList != null && this.minNumber == -1 && this.maxNumber == -1) {
                ++this.currentIndex;
                this.currentValue = this.valueList[this.currentIndex];
                if (this.currentIndex >= this.valueList.length - 1) {
                    lastReached = true;
                    this.currentIndex = -1;
                }
            } else {
                ++this.currentIndex;
                if (this.currentValue == null || this.currentLimit > 0 && this.currentIndex > this.currentLimit) {
                    this.currentLimit = this.minNumber == this.maxNumber ? this.minNumber : this.rand.nextInt(this.maxNumber - this.minNumber) + this.minNumber;
                    if (this.valuePattern == null) {
                        this.currentValue = this.start;
                    } else {
                        this.currentNValue = this.start;
                        this.currentValue = String.format(this.valuePattern, this.start);
                    }
                    this.currentIndex = 0;
                    if (this.foreignKeyColumn != null) {
                        ++this.fkValueListIndex;
                        if (this.fkValueListIndex >= this.valueList.length) {
                            this.fkValueListIndex = 0;
                        }
                        this.currentValue = this.valueList[this.fkValueListIndex];
                    }
                    lastReached = true;
                } else if (this.valuePattern != null) {
                    this.currentNValue = this.isDecimal ? ((BigDecimal)this.currentNValue).add((BigDecimal)this.increment) : Integer.valueOf((Integer)this.currentNValue + (Integer)this.increment);
                    this.currentValue = String.format(this.valuePattern, this.currentNValue);
                } else {
                    this.currentValue = this.foreignKeyColumn != null && this.valueList != null ? this.valueList[this.fkValueListIndex] : (this.isDecimal ? ((BigDecimal)this.currentValue).add((BigDecimal)this.increment) : Integer.valueOf((Integer)this.currentValue + (Integer)this.increment));
                }
            }
            return lastReached;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("colName=").append(this.qColName).append(" ");
            if (this.valueList != null) {
                sb.append("value list: ").append(Arrays.toString(this.valueList));
            } else {
                sb.append("start=").append(this.start).append(";increment=").append(this.increment);
                if (this.minNumber != -1 || this.maxNumber != -1) {
                    sb.append(";number=").append(this.minNumber);
                    if (this.minNumber != this.maxNumber) {
                        sb.append('-').append(this.maxNumber);
                    }
                }
                if (this.valuePattern != null) {
                    sb.append(";pattern=").append(this.valuePattern);
                }
                if (this.foreachColumn != null) {
                    sb.append(";foreach=").append(this.foreachColumn);
                }
            }
            sb.append(";hasDependentForeach=").append(this.hasDependentForeach);
            if (this.repeatRetVal != null) {
                sb.append(";").append(this.repeatRetVal);
            }
            return sb.toString();
        }

        static Object parse(String col, String line, Connection conn) throws SQLException {
            if (line.indexOf(44) > 0 || line.indexOf(91) >= 0 || line.indexOf("::") >= 0) {
                if (line.startsWith("::")) {
                    if (specialTokens.valuelist.lineStartsWith(line = line.substring("::".length()))) {
                        return specialTokens.valuelist.parse(col, line, conn);
                    }
                    if (specialTokens.random.lineStartsWith(line)) {
                        return specialTokens.random.parse(col, line, conn);
                    }
                    if (specialTokens.format.lineStartsWith(line)) {
                        return specialTokens.format.parse(col, line, conn);
                    }
                    if (specialTokens.UUID.lineStartsWith(line)) {
                        return specialTokens.UUID.parse(col, line, conn);
                    }
                    if (specialTokens.LCTS.lineStartsWith(line)) {
                        return specialTokens.LCTS.parse(col, line, conn);
                    }
                    if (specialTokens.LMTS.lineStartsWith(line)) {
                        return specialTokens.LMTS.parse(col, line, conn);
                    }
                    System.out.println("Registering range for column " + col + ": " + line);
                    String[] elems = line.split(",");
                    String start = null;
                    String increment = null;
                    int minNumber = -1;
                    int maxNumber = -1;
                    String foreachColumn = null;
                    String valuePattern = null;
                    for (String elem : elems) {
                        int spaceIndex;
                        String name = (elem = elem.trim()).substring(0, spaceIndex = elem.indexOf(32)).trim();
                        if ("start".equalsIgnoreCase(name)) {
                            start = elem.substring(spaceIndex + 1).trim();
                            continue;
                        }
                        if ("increment".equalsIgnoreCase(name)) {
                            increment = elem.substring(spaceIndex + 1).trim();
                            continue;
                        }
                        if ("number".equalsIgnoreCase(name)) {
                            String number = elem.substring(spaceIndex + 1);
                            int rangeIndex = number.indexOf(45);
                            if (rangeIndex > 0) {
                                minNumber = Integer.parseInt(number.substring(0, rangeIndex).trim());
                                maxNumber = Integer.parseInt(number.substring(rangeIndex + 1).trim());
                                continue;
                            }
                            minNumber = maxNumber = Integer.parseInt(number.trim());
                            continue;
                        }
                        if ("value".equalsIgnoreCase(name)) {
                            valuePattern = elem.substring(spaceIndex + 1).trim();
                            continue;
                        }
                        if ("foreach".equalsIgnoreCase(name)) {
                            foreachColumn = elem.substring(spaceIndex + 1).trim();
                            continue;
                        }
                        throw new IllegalArgumentException("unknown token '" + name + "'");
                    }
                    if (start == null || increment == null) {
                        throw new IllegalArgumentException("either start or increment not specified in range");
                    }
                    if (start.indexOf(46) >= 0 || increment.indexOf(46) >= 0) {
                        return new ColumnRange(col, new BigDecimal(start), new BigDecimal(increment), minNumber, maxNumber, foreachColumn, true, null, valuePattern);
                    }
                    return new ColumnRange(col, Integer.parseInt(start), Integer.parseInt(increment), minNumber, maxNumber, foreachColumn, false, null, valuePattern);
                }
                if (specialTokens.nullvalue.lineStartsWith(line)) {
                    return specialTokens.nullvalue.parse(col, line, conn);
                }
                if (specialTokens.skipvalue.lineStartsWith(line)) {
                    return specialTokens.skipvalue.parse(col, line, conn);
                }
                System.out.println("Registering value map for column " + col + ": " + line);
                return new ColumnRange(col, null, null, -1, -1, null, false, line.split(","), null);
            }
            return null;
        }

        static enum specialTokens {
            valuelist{

                @Override
                public ColumnRange parse(String col, String line, Connection conn) throws SQLException {
                    String[] elems = line.substring(2).split(",");
                    if (elems.length > 1) {
                        int minNumber = -1;
                        int maxNumber = -1;
                        String foreignKeyColumn = null;
                        for (String elem : elems) {
                            int spaceIndex;
                            String name = (elem = elem.trim()).substring(0, spaceIndex = elem.indexOf(32)).trim();
                            if ("valuelist".equalsIgnoreCase(name)) {
                                foreignKeyColumn = elem.substring(spaceIndex + 1).trim();
                                continue;
                            }
                            if (!"number".equalsIgnoreCase(name)) continue;
                            String number = elem.substring(spaceIndex + 1);
                            int rangeIndex = number.indexOf(45);
                            if (rangeIndex > 0) {
                                minNumber = Integer.parseInt(number.substring(0, rangeIndex).trim());
                                maxNumber = Integer.parseInt(number.substring(rangeIndex + 1).trim());
                                continue;
                            }
                            minNumber = maxNumber = Integer.parseInt(number.trim());
                        }
                        if (foreignKeyColumn == null || minNumber == -1 || maxNumber == -1) {
                            throw new IllegalArgumentException("either foreignKey or cardinality (number) not mentioned.");
                        }
                        System.out.println("Registering foreign key valuelist for column " + col + " foreignKeyColumn=" + foreignKeyColumn + ": " + line);
                        return new ColumnRange(col, null, null, minNumber, maxNumber, foreignKeyColumn);
                    }
                    String valueListQuery = line.substring(line.indexOf(91) + 1, line.indexOf(93));
                    ResultSet r = conn.createStatement().executeQuery(valueListQuery);
                    ArrayList<String> values = new ArrayList<String>();
                    while (r.next()) {
                        values.add(r.getString(1));
                    }
                    System.out.println("Registering dynamic value map for column " + col + ": " + line + " with " + values.size() + " elements ");
                    return new ColumnRange(col, null, null, -1, -1, null, false, values.toArray(new String[0]), null);
                }
            }
            ,
            random{

                @Override
                public ColumnRange parse(String col, String line, Connection conn) {
                    int beginIndex = line.indexOf("[");
                    if (beginIndex == -1) {
                        throw new IllegalArgumentException("Incomplete randome specifier: " + line);
                    }
                    int endIndex = line.indexOf("]");
                    if (endIndex == -1) {
                        throw new IllegalArgumentException("Incomplete randome specifier: " + line);
                    }
                    String valueSpec = line.substring(beginIndex + 1, endIndex);
                    if (valueSpec.indexOf("-") <= 0) {
                        System.out.println("Registering dynamic value map for column " + col + ": " + line + " with " + valueSpec + " length");
                        return new ColumnRandom(col, Integer.parseInt(valueSpec), -1, -1);
                    }
                    String[] valueLengths = valueSpec.split("-");
                    int begin = Integer.parseInt(valueLengths[0]);
                    int end = Integer.parseInt(valueLengths[1]);
                    System.out.println("Registering dynamic value map for column " + col + ": " + line + " from " + begin + " to " + end + " length");
                    return new ColumnRandom(col, begin, end, -1);
                }
            }
            ,
            format{

                @Override
                public ColumnRange parse(String col, String line, Connection conn) throws SQLException {
                    int beginLength = -1;
                    int endLength = -1;
                    int prec = -1;
                    String fSpec = line.substring(this.name().length()).trim();
                    int optBegin = fSpec.indexOf("[");
                    int optEnd = fSpec.indexOf("]");
                    int dot = fSpec.indexOf(".");
                    if (optBegin != -1) {
                        if (optEnd == -1) {
                            throw new IllegalArgumentException("[ .. ] mismatch in the format specifier in line: " + line);
                        }
                        int optionalportion = optEnd - optBegin - 1;
                        beginLength = fSpec.length() - 2 - optionalportion;
                        endLength = beginLength + optionalportion;
                        if (dot != -1) {
                            --beginLength;
                            --endLength;
                            prec = fSpec.length() - dot - 1;
                        }
                    } else if (dot == -1) {
                        beginLength = fSpec.length();
                    } else {
                        beginLength = fSpec.length() - 1;
                        prec = fSpec.length() - dot;
                    }
                    System.out.println("Registering dynamic value map for column " + col + ": " + line + " from " + beginLength + (endLength != -1 ? " to " + endLength + " length " : "") + " with " + prec + " precision");
                    return new ColumnRandom(col, beginLength, endLength, prec);
                }
            }
            ,
            UUID{

                @Override
                public ColumnRange parse(String col, String line, Connection conn) {
                    return new ColumnRandom(col, this);
                }

                @Override
                public String getNext() {
                    return java.util.UUID.randomUUID().toString();
                }
            }
            ,
            LMTS{

                @Override
                public ColumnRange parse(String col, String line, Connection conn) {
                    return new ColumnRandom(col, -1, -1, -1);
                }
            }
            ,
            LCTS{

                @Override
                public ColumnRange parse(String col, String line, Connection conn) {
                    System.out.println("Registering LCTS value for column " + col + ": " + line);
                    return new ColumnRandom(col, -1, -1, -1);
                }
            }
            ,
            nullvalue{

                @Override
                public boolean lineStartsWith(String line) {
                    return line.startsWith(ColumnRange.nullToken);
                }

                @Override
                public ColumnRange parse(String col, String line, Connection conn) throws SQLException {
                    System.out.println("Registering NULL value for column " + col + ": " + line);
                    return new ColumnRandom(col, this);
                }

                @Override
                public String getNext() {
                    return ColumnRange.nullToken;
                }
            }
            ,
            skipvalue{

                @Override
                public boolean lineStartsWith(String line) {
                    return line.startsWith(ColumnRange.skipToken);
                }

                @Override
                public ColumnRange parse(String col, String line, Connection conn) throws SQLException {
                    System.out.println("NOT Registering, rather skipping value for column " + col + ": " + line);
                    return new ColumnRandom(col, this);
                }

                @Override
                public String getNext() {
                    return ColumnRange.skipToken;
                }
            };


            public boolean lineStartsWith(String line) {
                return line.startsWith(this.name());
            }

            public String getNext() {
                return null;
            }

            public abstract ColumnRange parse(String var1, String var2, Connection var3) throws SQLException;
        }
    }

    class Repeater {
        String columnName;
        int numTimes;

        public Repeater(String columnName, int numTimes) {
            this.columnName = columnName;
            this.numTimes = numTimes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            Repeater other = (Repeater)obj;
            return this.columnName.equals(other.columnName);
        }

        public int hashCode() {
            return this.columnName.hashCode();
        }

        public String toString() {
            return "repeat=" + this.numTimes;
        }
    }

    static enum RelationalOperator {
        Equal,
        GreaterThan,
        LessThan;

    }
}

