/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase1.datagen;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class GenerateMapper {
    protected String url = "jdbc:gemfirexd://localhost:1530/";
    protected String driver = "com.pivotal.gemfirexd.jdbc.ClientDriver";
    int[] rowCount = new int[]{100000};
    static final char[] chooseChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final char[] chooseBytes = "0123456789abcdef".toCharArray();
    static final char[] chooseInts = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public GenerateMapper(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage <script> <tablenames> [<host:port> <rowcount> <column mapping file>]");
            System.exit(1);
        }
        try {
            if (args.length > 1) {
                this.url = "jdbc:gemfirexd://" + args[1];
                System.out.println("url=" + this.url);
            }
            Connection conn = this.getConnection();
            DatabaseMetaData meta = conn.getMetaData();
            String[] types = new String[]{"TABLE"};
            String schemaName = "SEC_OWNER";
            String tableQuery = args[0];
            ResultSet rs = tableQuery == null ? meta.getTables(null, schemaName, tableQuery, types) : conn.createStatement().executeQuery(tableQuery);
            while (rs.next()) {
                long startTime = System.currentTimeMillis();
                String tableName = rs.getString("TABLE_NAME");
                int existingRowCount = -1;
                ResultSet tableHaveRows = conn.createStatement().executeQuery("select count(1) from " + schemaName + "." + tableName + " having count(1) > 0");
                if (tableHaveRows.next()) {
                    if (tableQuery == null) continue;
                    existingRowCount = tableHaveRows.getInt(1);
                }
                ResultSet keyList = meta.getPrimaryKeys(null, schemaName, tableName);
                HashSet<String> importedKeys = null;
                HashSet<String> primaryKey = null;
                while (keyList.next()) {
                    if (primaryKey == null) {
                        primaryKey = new HashSet<String>();
                    }
                    primaryKey.add(keyList.getString("COLUMN_NAME"));
                }
                ResultSet importList = meta.getImportedKeys(null, schemaName, tableName);
                while (importList.next()) {
                    if (importedKeys == null) {
                        importedKeys = new HashSet<String>();
                    }
                    importedKeys.add(importList.getString("PKCOLUMN_NAME") + " => " + importList.getString("FKTABLE_NAME") + "." + importList.getString("FKCOLUMN_NAME"));
                }
                ResultSet rsColumns = meta.getColumns(null, schemaName, tableName, null);
                ArrayList<Object[]> columnsMeta = new ArrayList<Object[]>();
                while (rsColumns.next()) {
                    Object[] columnMeta = new Object[]{rsColumns.getString("COLUMN_NAME"), rsColumns.getInt("DATA_TYPE"), rsColumns.getInt("COLUMN_SIZE"), rsColumns.getInt("DECIMAL_DIGITS")};
                    columnsMeta.add(columnMeta);
                }
                if (existingRowCount <= 0) continue;
                String fullTableName = schemaName + "." + tableName;
                System.out.println("Printing column mapping for out of " + existingRowCount + " sample rows");
                LinkedHashMap<String, ArrayList<String>> valueMapping = new LinkedHashMap<String, ArrayList<String>>();
                ResultSet sampleData = conn.createStatement().executeQuery("select * from " + fullTableName);
                while (sampleData.next()) {
                    for (Object[] objectArray : columnsMeta) {
                        String colName = (String)objectArray[0];
                        String qColName = fullTableName + '.' + colName;
                        ArrayList<String> valuelist = (ArrayList<String>)valueMapping.get(qColName);
                        if (valuelist == null) {
                            valuelist = new ArrayList<String>();
                        }
                        valuelist.add(sampleData.getString(colName));
                        valueMapping.put(qColName, valuelist);
                    }
                }
                for (Map.Entry entry : valueMapping.entrySet()) {
                    System.out.println((String)entry.getKey() + " = " + entry.getValue());
                }
            }
            char c = this.getFieldSeparator();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    protected char getFieldSeparator() {
        return ',';
    }

    protected String getFormatterTimestamp() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    protected String getFormatterDate() {
        return "yyyy-MM-dd";
    }

    protected String getBaseTime() {
        return "2012-01-01 01:01:00";
    }

    protected String generateString(int len) {
        if (len > 32000) {
            len = 32000;
        }
        len = (int)(Math.random() * 9.0 * (double)len / 10.0) + 1 + len / 10;
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = chooseChars[(int)(Math.random() * (double)chooseChars.length)];
        }
        return new String(chars);
    }

    protected String generateBytes(int len) {
        if (len > 32000) {
            len = 32000;
        }
        len = (int)(Math.random() * 9.0 * (double)len / 10.0) + 1 + len / 10;
        char[] chars = new char[len <<= 1];
        for (int i = 0; i < len; ++i) {
            chars[i] = chooseBytes[(int)(Math.random() * (double)chooseBytes.length)];
        }
        return new String(chars);
    }

    protected String generateDate(Date baseDate) {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        try {
            baseDate = formatterTimestamp.parse(this.getBaseTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(2);
        }
        double addOn = Math.random() * 8.64E7 * 100.0;
        long newTime = baseDate.getTime() + (long)addOn;
        Date newDate = new Date(newTime);
        return formatterTimestamp.format(newDate);
    }

    protected String generateTimestamp(Date baseDate) {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        try {
            baseDate = formatterTimestamp.parse(this.getBaseTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(2);
        }
        double addOn = Math.random() * 8.64E7 * 100.0;
        long newTime = baseDate.getTime() + (long)addOn;
        Date newDate = new Date(newTime);
        return formatterTimestamp.format(newDate);
    }

    protected String generateNumeric(int len, int prec) {
        int i;
        int major = len - prec;
        if (major > 1) {
            if (major > 15) {
                major = 15;
            }
            major = (int)(Math.random() * (double)major) + 1;
        }
        if (prec > 1) {
            prec = (int)(Math.random() * (double)prec) + 1;
        }
        len = major + prec;
        char[] chars = new char[len + 1];
        for (i = 0; i < major; ++i) {
            chars[i] = chooseInts[(int)(Math.random() * (double)chooseInts.length)];
        }
        if (i < len) {
            chars[i] = 46;
            while (++i <= len) {
                chars[i] = chooseInts[(int)(Math.random() * (double)chooseInts.length)];
            }
        }
        return new String(chars, 0, i);
    }

    public Connection getConnection() {
        Connection con = null;
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
            System.exit(3);
        }
        try {
            Properties p = new Properties();
            p.setProperty("user", "locatoradmin");
            p.setProperty("password", "locatorpassword");
            con = DriverManager.getConnection(this.url, p);
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            System.exit(3);
        }
        return con;
    }

    public static void main(String[] args) {
        new GenerateMapper(args);
    }

    static enum RelationalOperator {
        Equal,
        GreaterThan,
        LessThan;

    }
}

