/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase1.src.matcher;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class LogUtils {
    public static String getErrorStateValueArrayStr(int[] errorStateValue) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < errorStateValue.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(errorStateValue[i]);
        }
        return sb.toString();
    }

    public static String getResultSetArrayStr(ResultSet[] rs, int colWidths) throws SQLException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rs.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(LogUtils.getResultSetStr(rs[i], colWidths));
        }
        return sb.toString();
    }

    public static String getResultSetStr(ResultSet rs, int colWidths) throws SQLException {
        if (rs == null) {
            return "null";
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= colCount; ++i) {
            String label = String.format("%1$#" + colWidths + "s", rsmd.getColumnLabel(i));
            sb.append(label + "|");
        }
        sb.append("\n");
        while (rs.next()) {
            StringBuffer row = new StringBuffer();
            for (int i = 1; i <= colCount; ++i) {
                String value = rs.getString(i);
                if (value == null) {
                    value = "null";
                }
                value = value.substring(0, Math.min(20, value.length()));
                value = String.format("%1$#" + colWidths + "s", value.trim());
                row.append(value + "|");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

