/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase1.src.matcher.impl;

import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.MatchExecutor;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.model.MatchResultSet;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.model.MatchingInfo;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.model.Query;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.utils.StoredProcUtils;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import hydra.Log;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicMatchExecutorImpl
implements MatchExecutor {
    @Override
    public MatchResultSet match(List<Object> prevResultList, Map<String, Map<String, String>> backOfficeMsg, Set<MatchingInfo> matchingKeySet, ProcedureExecutionContext pCtx) {
        MatchResultSet matchResultSet;
        block7: {
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("BasicMatchExecutorImpl-match entering prevResultList=" + prevResultList + " backOfficeMsg=" + backOfficeMsg + " matchingKeySet=" + matchingKeySet);
            }
            matchResultSet = new MatchResultSet();
            String inClause = this.buildInClause(prevResultList);
            Query query = this.buildQuery(prevResultList, inClause, backOfficeMsg, matchingKeySet);
            if (query == null) {
                if (Log.getLogWriter().fineEnabled()) {
                    Log.getLogWriter().fine("BasicMatchExecutorImpl-match query=" + query + " returning MatchingResultSet with null JDBC resultset");
                }
                matchResultSet.setErrorState(false);
                matchResultSet.setResultSet(null);
                return matchResultSet;
            }
            String callableStmtString = this.buildCallableStatementString(inClause);
            try {
                CallableStatement callableStmt = this.prepareCall(callableStmtString, query, prevResultList, pCtx);
                if (Log.getLogWriter().fineEnabled()) {
                    Log.getLogWriter().fine("BasicMatchExecutorImpl-match executing storedproc=" + callableStmtString + " query=" + query);
                }
                callableStmt.execute();
                matchResultSet.setResultSet(callableStmt.getResultSet());
                matchResultSet.setErrorState(StoredProcUtils.toBoolean(callableStmt.getInt(3)));
            }
            catch (SQLException e) {
                matchResultSet.setErrorState(true);
                if (!Log.getLogWriter().fineEnabled()) break block7;
                Log.getLogWriter().fine("BasicMatchExecutorImpl-match error=" + e);
            }
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchExecutorImpl-match exiting matchResultSet=" + matchResultSet);
        }
        return matchResultSet;
    }

    public String buildInClause(List<Object> prevResultList) {
        if (prevResultList == null || prevResultList.size() == 0) {
            return "";
        }
        StringBuilder inClause = new StringBuilder("SEC_OWNER.");
        inClause.append("SECT_CHANNEL_DATA");
        inClause.append(".");
        inClause.append("CHANNEL_TXN_ID");
        inClause.append(" IN (");
        int numberOfRecords = 0;
        for (Object txnId : prevResultList) {
            if (numberOfRecords > 0) {
                inClause.append(",");
            }
            inClause.append("?");
            ++numberOfRecords;
        }
        inClause.append(") ");
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchExecutorImpl-buildInClause numberOfRecords=" + numberOfRecords + " sb=" + inClause);
        }
        return inClause.toString();
    }

    private Query buildQuery(List<Object> prevResultList, String inClause, Map<String, Map<String, String>> backOfficeMsg, Set<MatchingInfo> matchingKeySet) {
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchExecutorImpl-buildQuery backOfficeMsg=" + backOfficeMsg + " matchingKeySet=" + matchingKeySet);
        }
        StringBuilder queryString = new StringBuilder();
        ArrayList<Object> bindVariableValueList = new ArrayList<Object>();
        if (prevResultList != null && prevResultList.size() != 0) {
            bindVariableValueList.addAll(prevResultList);
        }
        queryString.append("<local> SELECT ");
        queryString.append("SEC_OWNER.").append("SECT_CHANNEL_DATA").append(".").append("CHANNEL_TXN_ID").append(" FROM ");
        HashSet<String> chnlTableNames = new HashSet<String>();
        for (MatchingInfo matchingInfo : matchingKeySet) {
            chnlTableNames.add(matchingInfo.getChnDataTable());
        }
        int tableCount = 0;
        for (String chnlTableName : chnlTableNames) {
            if (tableCount == 0) {
                queryString.append("SEC_OWNER.").append(chnlTableName);
            } else {
                queryString.append(", ").append("SEC_OWNER.").append(chnlTableName);
            }
            ++tableCount;
        }
        if (matchingKeySet.size() > 0) {
            queryString.append(" WHERE ");
        }
        queryString.append(inClause);
        int columnCount = 0;
        for (MatchingInfo matchingInfo : matchingKeySet) {
            Map<String, String> boTable = backOfficeMsg.get(matchingInfo.getBoDataTable());
            if (boTable == null) continue;
            String boCurrentColumnValue = boTable.get(matchingInfo.getKeyName());
            if (boCurrentColumnValue == null) {
                if (Log.getLogWriter().fineEnabled()) {
                    Log.getLogWriter().fine("BasicMatchExecutorImpl-buildQuery returning null due to  key=" + matchingInfo.getKeyName() + " value=" + boCurrentColumnValue);
                }
                return null;
            }
            if (columnCount > 0 || !"".equals(inClause)) {
                queryString.append(" and ");
            }
            queryString.append(this.buildFieldCriteria(matchingInfo));
            bindVariableValueList.add(boCurrentColumnValue);
            ++columnCount;
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchExecutorImpl-buildQuery sb=" + queryString);
        }
        return new Query(queryString.toString(), bindVariableValueList);
    }

    private String buildFieldCriteria(MatchingInfo matchingInfo) {
        StringBuilder fieldStringBuilder = new StringBuilder();
        String upperStringBegin = null;
        String upperStringEnd = null;
        String dataType = matchingInfo.getDataType();
        if ("VARCHAR".equalsIgnoreCase(dataType) || "CHAR".equalsIgnoreCase(dataType) || "LONG VARCHAR".equalsIgnoreCase(dataType)) {
            upperStringBegin = "";
            upperStringEnd = "";
        } else {
            upperStringBegin = "";
            upperStringEnd = "";
        }
        fieldStringBuilder.append(upperStringBegin).append("SEC_OWNER.").append(matchingInfo.getChnDataTable()).append(".").append(matchingInfo.getKeyName()).append(upperStringEnd).append("=").append(upperStringBegin).append("?").append(upperStringEnd);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchExecutorImpl-buildFieldCriteria fieldStringBuilder=" + fieldStringBuilder);
        }
        return fieldStringBuilder.toString();
    }

    public String buildCallableStatementString(String inClause) {
        String whereClause = "".equals(inClause) ? "" : "WHERE " + inClause;
        StringBuilder callableStmtFormat = new StringBuilder("{CALL ");
        callableStmtFormat.append("SEC_OWNER.").append("queryExecutorStoredProc").append("(?,?,?)");
        callableStmtFormat.append("  WITH RESULT PROCESSOR ").append("cacheperf.comparisons.gemfirexd.useCase1.src.matcher.storedproc.MatchResultProcessor").append(" ON TABLE ").append("SEC_OWNER.").append("SECT_CHANNEL_DATA").append(" ").append(whereClause).append("}");
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchExecutorImpl-buildCallableStatementString sb=" + callableStmtFormat);
        }
        return callableStmtFormat.toString();
    }

    public CallableStatement prepareCall(String callableStmtString, Query query, List prevResultList, ProcedureExecutionContext pCtx) throws SQLException {
        Connection conn = pCtx.getConnection();
        CallableStatement callableStmt = conn.prepareCall(callableStmtString);
        callableStmt.registerOutParameter(3, 4);
        callableStmt.setObject(1, (Object)query.getQueryString());
        callableStmt.setObject(2, query.getBindVariableValueList());
        if (prevResultList == null || prevResultList.size() == 0) {
            return callableStmt;
        }
        int bindVariablePosition = 4;
        for (Object txnId : prevResultList) {
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine(" prepareCall: txnId=" + txnId);
            }
            callableStmt.setObject(bindVariablePosition, txnId);
            ++bindVariablePosition;
        }
        return callableStmt;
    }
}

