/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase1.src.matcher.impl;

import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.ExecutionInfo;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.MatchProcessingDecisionMaker;
import hydra.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BasicMatchProcessingDecisionMakerImpl
implements MatchProcessingDecisionMaker {
    private List<Integer> priorityList;

    public List<Integer> getPriorityList() {
        return this.priorityList;
    }

    public BasicMatchProcessingDecisionMakerImpl(Set<Integer> prioritySet) {
        this.priorityList = prioritySet == null ? null : new ArrayList<Integer>(prioritySet);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchProcessingDecisionMakerImpl-constructor priorityList=" + this.priorityList);
        }
    }

    @Override
    public ExecutionInfo getNextExecutionInfo(List<Object> currMatchResultList, int currPriority) {
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchProcessingDecisionMakerImpl-getNextExecutionInfo entering currMatchResultList=" + currMatchResultList + " currPriority=" + currPriority);
        }
        ExecutionInfo execInfo = new ExecutionInfo();
        if (this.priorityList != null && Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchProcessingDecisionMakerImpl-getNextExecutionInfo currPriority=" + currPriority + " priorityList(currPriority)=" + this.priorityList.indexOf(currPriority) + " priorityList.size()=" + this.priorityList.size());
        }
        if (this.priorityList == null || this.priorityList.size() == this.priorityList.indexOf(currPriority) + 1 || currMatchResultList != null && currMatchResultList.size() != 0) {
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("BasicMatchProcessingDecisionMakerImpl-getNextExecutionInfo setting stop true");
            }
            execInfo.setStop(true);
            if (currMatchResultList != null && Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("BasicMatchProcessingDecisionMakerImpl-getNextExecutionInfo prevMatchResultList.size() " + currMatchResultList.size());
            }
            execInfo.setNextPriority(-1);
            execInfo.setMatchResultList(currMatchResultList);
        } else {
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("BasicMatchProcessingDecisionMakerImpl-getNextExecutionInfo setting stop false");
            }
            execInfo.setStop(false);
            int prevPriorityIndex = this.priorityList.indexOf(currPriority);
            execInfo.setNextPriority(this.priorityList.get(prevPriorityIndex + 1));
            execInfo.setMatchResultList(null);
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchProcessingDecisionMakerImpl-getNextExecutionInfo execInfo=" + execInfo);
        }
        return execInfo;
    }
}

