/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase1.src.matcher.impl;

import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.ExecutionInfo;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.MatchExecutor;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.MatchProcessor;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.impl.BasicMatchExecutorImpl;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.impl.BasicMatchProcessingDecisionMakerImpl;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.model.MatchResultSet;
import cacheperf.comparisons.gemfirexd.useCase1.src.matcher.model.MatchingInfo;
import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import hydra.Log;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class BasicMatchProcessorImpl
implements MatchProcessor {
    private static Map<Integer, MatchExecutor> matchExecutorMap = new HashMap<Integer, MatchExecutor>();

    @Override
    public MatchResultSet match(Map<String, Map<String, String>> backOfficeMsg, SortedMap<Integer, Set<MatchingInfo>> matchingKeyMap, ResultSet[] resultSet, ProcedureExecutionContext pCtx) throws SQLException {
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchProcessorImpl-match entering backOfficeMsg=" + backOfficeMsg + " matchingKeyMap=" + matchingKeyMap);
        }
        List<Object> currMatchResultList = new ArrayList<Object>();
        int currPriority = -1;
        MatchResultSet returnMatchResultSet = null;
        ExecutionInfo execInfo = null;
        Set<Integer> prioritySet = matchingKeyMap.keySet();
        BasicMatchProcessingDecisionMakerImpl matchDecisionMkr = new BasicMatchProcessingDecisionMakerImpl(prioritySet);
        while (true) {
            MatchExecutor matchExecutor;
            if ((execInfo = matchDecisionMkr.getNextExecutionInfo(currMatchResultList, currPriority)).isStop()) {
                if (Log.getLogWriter().fineEnabled()) {
                    Log.getLogWriter().fine("BasicMatchProcessorImpl-match Skipping further processing execInfo=" + execInfo);
                }
                currMatchResultList = execInfo.getMatchResultList();
                break;
            }
            currPriority = execInfo.getNextPriority();
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("BasicMatchProcessorImpl-match processing currPriority=" + currPriority);
            }
            if ((returnMatchResultSet = (matchExecutor = BasicMatchProcessorImpl.getMatchExecutor(currPriority)).match(execInfo.getMatchResultList(), backOfficeMsg, (Set)matchingKeyMap.get(currPriority), pCtx)).isErrorState()) {
                if (!Log.getLogWriter().fineEnabled()) break;
                Log.getLogWriter().fine("BasicMatchProcessorImpl-match ERROR, stopping further processing");
                break;
            }
            ResultSet rs = returnMatchResultSet.getResultSet();
            while (rs != null && rs.next()) {
                currMatchResultList.add(rs.getString(1));
            }
            if (!Log.getLogWriter().fineEnabled()) continue;
            Log.getLogWriter().fine("BasicMatchProcessorImpl-match currMatchResultList=" + currMatchResultList + " currMatchResultList.size()=" + currMatchResultList.size() + " returnMatchResultSet.isErrorState()=" + returnMatchResultSet.isErrorState());
        }
        this.buildOutgoingResultSet(currMatchResultList, pCtx);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchProcessorImpl-match returnMatchResultSet=" + returnMatchResultSet);
        }
        return returnMatchResultSet;
    }

    private static MatchExecutor getMatchExecutor(Integer priority) {
        return matchExecutorMap.get(priority);
    }

    private void buildOutgoingResultSet(List<Object> matchResultList, ProcedureExecutionContext pCtx) {
        OutgoingResultSet ors = pCtx.getOutgoingResultSet(1);
        ors.addColumn("CHANNEL_TXN_ID");
        for (Object txnId : matchResultList) {
            ArrayList<Object> row = new ArrayList<Object>();
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("BasicMatchProcessorImpl-match forLoop txnId=" + txnId);
            }
            row.add(txnId);
            ors.addRow(row);
        }
        ors.endResults();
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("BasicMatchProcessorImpl-buildOutgoingResultSet ors=" + ors);
        }
    }

    static {
        matchExecutorMap.put(1, new BasicMatchExecutorImpl());
        matchExecutorMap.put(2, new BasicMatchExecutorImpl());
        matchExecutorMap.put(3, new BasicMatchExecutorImpl());
        matchExecutorMap.put(4, new BasicMatchExecutorImpl());
        matchExecutorMap.put(5, new BasicMatchExecutorImpl());
    }
}

