/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase1.src.matcher.storedproc;

import com.pivotal.gemfirexd.procedure.IncomingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureProcessorContext;
import com.pivotal.gemfirexd.procedure.ProcedureResultProcessor;
import hydra.Log;
import java.util.List;

public class MatchResultProcessor
implements ProcedureResultProcessor {
    private ProcedureProcessorContext context;
    private IncomingResultSet[] resultSets;
    private int currentIndex = 0;
    private int totalResultSets;
    private int previousResultSetNumber = 0;

    public void init(ProcedureProcessorContext context) {
        this.context = context;
    }

    public List<Object> getNextResultRow(int resultSetNumber) throws InterruptedException {
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("MatchResultProcessor-getNextResultRow previousResultSetNumber=" + this.previousResultSetNumber + " resultSetNumber=" + resultSetNumber);
        }
        if (this.resultSets == null || this.previousResultSetNumber != resultSetNumber) {
            this.resultSets = this.context.getIncomingResultSets(resultSetNumber);
            this.totalResultSets = this.resultSets.length;
            this.currentIndex = 0;
            this.previousResultSetNumber = resultSetNumber;
        }
        while (this.currentIndex < this.totalResultSets) {
            List row;
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("MatchResultProcessor-getNextResultRow totalResultSets=" + this.totalResultSets + " currentIndex=" + this.currentIndex);
            }
            IncomingResultSet currResultSet = this.resultSets[this.currentIndex];
            List currentRow = currResultSet.peekRow();
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("MatchResultProcessor-getNextResultRow currentRow=" + currentRow);
            }
            if ((row = currResultSet.takeRow()) != IncomingResultSet.END_OF_RESULTS) {
                if (Log.getLogWriter().fineEnabled()) {
                    Log.getLogWriter().fine("MatchResultProcessor-getNextResultRow takeRow=" + currentRow);
                }
                return row;
            }
            ++this.currentIndex;
        }
        return null;
    }

    public Object[] getOutParameters() throws InterruptedException {
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("MatchResultProcessor-getOutParameters");
        }
        IncomingResultSet[] inSets = this.context.getIncomingOutParameters();
        Integer errorStateValueObj = 0;
        for (IncomingResultSet inSet : inSets) {
            List outputParams = inSet.takeRow();
            if (outputParams == IncomingResultSet.END_OF_RESULTS) continue;
            errorStateValueObj = (Integer)outputParams.get(0);
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("MatchResultProcessor-getOutParameters errorStateValueObj=" + errorStateValueObj);
            }
            if (errorStateValueObj == 1) break;
        }
        Object[] returnOutParams = new Object[]{errorStateValueObj};
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("MatchResultProcessor-getOutParameters before return errorStateValueObj=" + errorStateValueObj + " returnOutParams=" + returnOutParams);
        }
        return returnOutParams;
    }

    public void close() {
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("MatchResultProcessor-close resets context and resultSets to null");
        }
        this.context = null;
        this.resultSets = null;
    }
}

