/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase4;

import cacheperf.comparisons.gemfirexd.QueryPerfClient;
import cacheperf.comparisons.gemfirexd.QueryPerfException;
import cacheperf.comparisons.gemfirexd.useCase4.UseCase4Prms;
import cacheperf.comparisons.gemfirexd.useCase4.UseCase4Stats;
import com.gemstone.gnu.trove.TIntIntHashMap;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import objects.query.QueryPrms;

public class UseCase4Client
extends QueryPerfClient {
    private static HydraThreadLocal localuseCase4stats = new HydraThreadLocal();
    protected UseCase4Stats useCase4stats;
    protected boolean logQueries;
    protected boolean logQueryResults;
    protected int numAccountProfiles = UseCase4Prms.getRowsInAccountProfile();
    protected int numAccounts = UseCase4Prms.getRowsInAccount();
    protected int numHoldings = UseCase4Prms.getRowsInHolding();
    protected int numOrders = UseCase4Prms.getRowsInOrders();
    protected int numQuotes = UseCase4Prms.getRowsInQuote();
    private static int[] listOfAccounts = null;
    private static int[] listOfOrderIds = null;
    private static int[] listOfOrderAccAccId = null;
    protected PreparedStatement holdingAggPS = null;
    protected PreparedStatement portSummPS = null;
    protected PreparedStatement mktSummPS = null;
    protected PreparedStatement holdingCountPS = null;
    protected PreparedStatement uptClosedOrderSelfJoinPS = null;
    protected PreparedStatement uptClosedOrderPS = null;
    protected PreparedStatement findOrderByStatusPS = null;
    protected PreparedStatement findOrderByAccAccIdPS = null;
    protected PreparedStatement findOrderIdAndAccAccIdPS = null;
    protected PreparedStatement findOrderCntAccAccIdPS = null;
    protected PreparedStatement findOrderCntAccAccIdAndStatusPS = null;
    private static final String holdingAggStr = "SELECT h.quote_symbol, sum(q.price * h.quantity) - SUM(h.purchaseprice * h.quantity) as gain FROM app.Holding h, app.Quote q where h.account_accountid = ? and h.quote_symbol=q.symbol GROUP BY h.quote_symbol HAVING SUM(q.price * h.quantity) - SUM(h.purchaseprice * h.quantity) > 0 ORDER BY gain desc";
    private static final String portSummStr = "SELECT SUM(h.purchaseprice * h.quantity) as purchaseBasis, sum(q.price * h.quantity) as marketValue, count(*) FROM app.Holding h, app.Quote q where h.account_accountid =? and h.quote_symbol=q.symbol ORDER BY marketValue desc";
    private static final String mktSummStr = "SELECT SUM(q.price)/count(*) as tradeStockIndexAverage, SUM(q.open1)/count(*) as tradeStockIndexOpenAverage, SUM(q.volume) as tradeStockIndexVolume, COUNT(*) as cnt , SUM(q.change1) FROM app.Quote q";
    private static final String holdingCountStr = "SELECT count(*) FROM app.Holding h WHERE h.account_Accountid = ?";
    private static final String uptClosedOrderSelfJoinStr = "UPDATE app.Orders o SET o.orderstatus = 'completed' WHERE o.account_accountid = ? AND o.orderid IN (SELECT o2.orderid FROM app.Orders o2 WHERE o2.orderstatus = 'closed' AND o2.account_accountid = ?)";
    private static final String uptClosedOrderStr = "UPDATE app.Orders o SET o.orderstatus = 'completed' WHERE o.account_accountid = ? AND o.orderstatus = 'closed'";
    private static final String findOrderByStatusStr = "SELECT o.* FROM app.Orders o WHERE o.orderstatus = ? AND o.account_accountid = ? order by orderid DESC";
    private static final String findOrderByAccAccIdStr = "SELECT o.* FROM app.Orders o WHERE o.account_accountid = ? order by orderid DESC";
    private static final String findOrderIdAndAccAccIdStr = "SELECT o.* FROM app.Orders o WHERE o.orderid = ? AND o.account_accountid = ?";
    private static final String findOrderCntAccAccIdStr = "SELECT count(*) FROM app.Orders o WHERE o.account_accountid = ?";
    private static final String findOrderCntAccAccIdAndStatusStr = "SELECT count(*) FROM app.Orders o WHERE o.account_accountid  = ? and o.orderstatus = ?";

    public static void loadDataTask() throws SQLException {
        UseCase4Client c = new UseCase4Client();
        c.initialize();
        if (c.ttgid == 0) {
            c.loadData();
        }
    }

    private void loadData() throws SQLException {
        long start = this.useCase4stats.startQuote();
        int rows = this.loadRows("Quote", this.getDataFileNameForQuote(), 6);
        this.useCase4stats.endQuote(start, rows);
        start = this.useCase4stats.startHolding();
        rows = this.loadRows("Holding", this.getDataFileNameForHolding(), 6);
        this.useCase4stats.endHolding(start, rows);
        start = this.useCase4stats.startAccountProfile();
        rows = this.loadRows("AccountProfile", this.getDataFileNameForAccountProfile(), 6);
        this.useCase4stats.endAccountProfile(start, rows);
        start = this.useCase4stats.startAccount();
        rows = this.loadRows("Account", this.getDataFileNameForAccount(), 6);
        this.useCase4stats.endAccount(start, rows);
        start = this.useCase4stats.startOrder();
        rows = this.loadRows("Orders", this.getDataFileNameForOrders(), 6);
        this.useCase4stats.endOrder(start, rows);
    }

    private int loadRows(String table, String dataFileName, int threads) throws SQLException {
        int rows = 0;
        Log.getLogWriter().info("Loading data for " + table + "...");
        String stmt = "CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', '" + table + "', '" + dataFileName + "', ',', NULL, NULL, 0, 0, " + threads + ", 0, NULL, NULL)";
        this.connection.createStatement().execute(stmt);
        ResultSet rs = this.connection.createStatement().executeQuery("select count(*) from app." + table);
        if (!rs.next()) {
            String s = "Unable to count rows in " + table + ".";
            throw new QueryPerfException(s);
        }
        rows = rs.getInt(1);
        rs.close();
        Log.getLogWriter().info("Done with data load for " + table + " (" + rows + " rows).");
        return rows;
    }

    private String getDataFileNameForAccount() {
        String fn = UseCase4Prms.getDataFileNameForAccount();
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("Data file for Account: " + fn);
        return newfn;
    }

    private String getDataFileNameForAccountProfile() {
        String fn = UseCase4Prms.getDataFileNameForAccountProfile();
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("Data file for AccountProfile: " + fn);
        return newfn;
    }

    private String getDataFileNameForHolding() {
        String fn = UseCase4Prms.getDataFileNameForHolding();
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("Data file for Holding: " + fn);
        return newfn;
    }

    private String getDataFileNameForOrders() {
        String fn = UseCase4Prms.getDataFileNameForOrders();
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("Data file for Orders: " + fn);
        return newfn;
    }

    private String getDataFileNameForQuote() {
        String fn = UseCase4Prms.getDataFileNameForQuote();
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("Data file for Quote: " + fn);
        return newfn;
    }

    public static void initAccountsTask() throws SQLException {
        UseCase4Client c = new UseCase4Client();
        c.initialize();
        if (c.jid == 0) {
            c.initAccounts();
        }
    }

    private void initAccounts() throws SQLException {
        ResultSet r = this.connection.createStatement().executeQuery("select count(*) from app.account");
        r.next();
        int totalAccounts = r.getInt(1);
        r.close();
        if (totalAccounts == 0) {
            String s = "No accounts found";
            throw new QueryPerfException(s);
        }
        listOfAccounts = new int[totalAccounts];
        Log.getLogWriter().info("Caching " + totalAccounts + " APP.HOLDING.ACCOUNT_ACCOUNTID information.");
        r = this.connection.createStatement().executeQuery("select accountid from app.account");
        for (int i = 0; i < listOfAccounts.length; ++i) {
            r.next();
            UseCase4Client.listOfAccounts[i] = r.getInt(1);
        }
        r.close();
        TIntIntHashMap orderIdAccId = new TIntIntHashMap();
        r = this.connection.createStatement().executeQuery("select orderid, account_accountid from app.orders");
        while (r.next()) {
            orderIdAccId.put(r.getInt(1), r.getInt(2));
        }
        r.close();
        listOfOrderIds = orderIdAccId.keys();
        listOfOrderAccAccId = orderIdAccId.getValues();
    }

    public static void runQueriesTask() throws SQLException {
        UseCase4Client c = new UseCase4Client();
        c.initialize(6230814);
        c.runQueries();
    }

    private void runQueries() throws SQLException {
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            this.runQuery();
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void runQuery() throws SQLException {
        UseCase4Prms.QueryType queryType = UseCase4Prms.getQueryType();
        int results = 0;
        int acc = listOfAccounts[this.rng.nextInt(listOfAccounts.length - 1)];
        long start = this.useCase4stats.startQuery();
        switch (queryType) {
            case holdingAgg: {
                results = this.holdingAgg(acc);
                break;
            }
            case portSumm: {
                results = this.portSumm(acc);
                break;
            }
            case mktSumm: {
                results = this.mktSumm(acc);
                break;
            }
            case holdingCount: {
                results = this.holdingCount(acc);
                break;
            }
            case uptClosedOrderSelfJoin: {
                results = this.uptClosedOrderSelfJoin(acc);
                break;
            }
            case uptClosedOrder: {
                results = this.uptClosedOrder(acc);
                break;
            }
            case findOrderByStatus: {
                results = this.findOrderByStatus(acc);
                break;
            }
            case findOrderByAccAccId: {
                results = this.findOrderByAccAccId(acc);
                break;
            }
            case findOrderIdAndAccAccId: {
                results = this.findOrderIdAndAccAccId(acc);
                break;
            }
            case findOrderCntAccAccId: {
                results = this.findOrderCntAccAccId(acc);
                break;
            }
            case findOrderCntAccAccIdAndStatus: {
                results = this.findOrderCntAccAccIdAndStatus(acc);
                break;
            }
            case mixed: {
                results = this.mixed(acc);
                break;
            }
            default: {
                throw new QueryPerfException("Should not happen");
            }
        }
        this.useCase4stats.endQuery(queryType, start, results, this.histogram);
    }

    private int holdingAgg(int acc) throws SQLException {
        int results = 0;
        if (this.holdingAggPS == null) {
            this.holdingAggPS = this.connection.prepareStatement(holdingAggStr);
        }
        this.holdingAggPS.setInt(1, acc);
        ResultSet rs = this.holdingAggPS.executeQuery();
        while (rs.next()) {
            rs.getString(1);
            rs.getFloat(2);
            ++results;
        }
        return results;
    }

    private int portSumm(int acc) throws SQLException {
        int results = 0;
        if (this.portSummPS == null) {
            this.portSummPS = this.connection.prepareStatement(portSummStr);
        }
        this.portSummPS.setInt(1, acc);
        ResultSet rs = this.portSummPS.executeQuery();
        while (rs.next()) {
            rs.getFloat(1);
            rs.getFloat(2);
            rs.getInt(3);
            ++results;
        }
        return results;
    }

    private int mktSumm(int acc) throws SQLException {
        int results = 0;
        if (this.mktSummPS == null) {
            this.mktSummPS = this.connection.prepareStatement(mktSummStr);
        }
        ResultSet rs = this.mktSummPS.executeQuery();
        while (rs.next()) {
            rs.getFloat(1);
            rs.getFloat(2);
            rs.getFloat(3);
            rs.getInt(4);
            rs.getFloat(5);
            ++results;
        }
        return results;
    }

    private int holdingCount(int acc) throws SQLException {
        int results = 0;
        if (this.holdingCountPS == null) {
            this.holdingCountPS = this.connection.prepareStatement(holdingCountStr);
        }
        this.holdingCountPS.setInt(1, acc);
        ResultSet rs = this.holdingCountPS.executeQuery();
        while (rs.next()) {
            rs.getInt(1);
            ++results;
        }
        return results;
    }

    private int uptClosedOrderSelfJoin(int acc) throws SQLException {
        if (this.uptClosedOrderSelfJoinPS == null) {
            this.uptClosedOrderSelfJoinPS = this.connection.prepareStatement(uptClosedOrderSelfJoinStr);
        }
        this.uptClosedOrderSelfJoinPS.setInt(1, acc);
        this.uptClosedOrderSelfJoinPS.setInt(2, acc);
        this.uptClosedOrderSelfJoinPS.execute();
        return 1;
    }

    private int uptClosedOrder(int acc) throws SQLException {
        if (this.uptClosedOrderPS == null) {
            this.uptClosedOrderPS = this.connection.prepareStatement(uptClosedOrderStr);
        }
        this.uptClosedOrderPS.setInt(1, acc);
        this.uptClosedOrderPS.execute();
        return 1;
    }

    private int findOrderByStatus(int acc) throws SQLException {
        boolean results = false;
        if (this.findOrderByStatusPS == null) {
            this.findOrderByStatusPS = this.connection.prepareStatement(findOrderByStatusStr);
        }
        this.findOrderByStatusPS.setString(1, "open");
        this.findOrderByStatusPS.setInt(2, acc);
        this.findOrderByStatusPS.executeQuery();
        return 1;
    }

    private int findOrderByAccAccId(int acc) throws SQLException {
        if (this.findOrderByAccAccIdPS == null) {
            this.findOrderByAccAccIdPS = this.connection.prepareStatement(findOrderByAccAccIdStr);
        }
        this.findOrderByAccAccIdPS.setInt(1, acc);
        this.findOrderByAccAccIdPS.executeQuery();
        return 1;
    }

    private int findOrderIdAndAccAccId(int acc) throws SQLException {
        if (this.findOrderIdAndAccAccIdPS == null) {
            this.findOrderIdAndAccAccIdPS = this.connection.prepareStatement(findOrderIdAndAccAccIdStr);
        }
        int qOrderIdx = this.rng.nextInt(listOfOrderIds.length - 1);
        this.findOrderIdAndAccAccIdPS.setInt(1, listOfOrderIds[qOrderIdx]);
        this.findOrderIdAndAccAccIdPS.setInt(2, listOfOrderAccAccId[qOrderIdx]);
        this.findOrderIdAndAccAccIdPS.executeQuery();
        return 1;
    }

    private int findOrderCntAccAccId(int acc) throws SQLException {
        int results = 0;
        if (this.findOrderCntAccAccIdPS == null) {
            this.findOrderCntAccAccIdPS = this.connection.prepareStatement(findOrderCntAccAccIdStr);
        }
        this.findOrderCntAccAccIdPS.setInt(1, acc);
        ResultSet rs = this.findOrderCntAccAccIdPS.executeQuery();
        while (rs.next()) {
            rs.getInt(1);
            ++results;
        }
        return results;
    }

    private int findOrderCntAccAccIdAndStatus(int acc) throws SQLException {
        int results = 0;
        if (this.findOrderCntAccAccIdAndStatusPS == null) {
            this.findOrderCntAccAccIdAndStatusPS = this.connection.prepareStatement(findOrderCntAccAccIdAndStatusStr);
        }
        this.findOrderCntAccAccIdAndStatusPS.setInt(1, acc);
        this.findOrderCntAccAccIdAndStatusPS.setString(2, "open");
        ResultSet rs = this.findOrderCntAccAccIdAndStatusPS.executeQuery();
        while (rs.next()) {
            rs.getInt(1);
            ++results;
        }
        return results;
    }

    private int mixed(int acc) throws SQLException {
        throw new UnsupportedOperationException("TBD");
    }

    public static void openStatisticsTask() {
        UseCase4Client c = new UseCase4Client();
        c.openStatistics();
    }

    private void openStatistics() {
        this.useCase4stats = this.getUseCase4Stats();
        if (this.useCase4stats == null) {
            this.useCase4stats = UseCase4Stats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
        this.setUseCase4Stats(this.useCase4stats);
    }

    public static void closeStatisticsTask() {
        UseCase4Client c = new UseCase4Client();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.useCase4stats != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.useCase4stats.close();
        }
    }

    public static void executeDDLTask() throws FileNotFoundException, IOException, SQLException {
        UseCase4Client c = new UseCase4Client();
        c.initialize();
        if (c.sttgid == 0) {
            c.executeDDL();
        }
    }

    private void executeDDL() throws FileNotFoundException, IOException, SQLException {
        String fn = this.getDDLFileName();
        List<String> stmts = this.getDDLStatements(fn);
        for (String stmt : stmts) {
            Log.getLogWriter().info("Creating table: " + stmt);
            this.execute(stmt, this.connection);
            this.commitDDL();
        }
    }

    private String getDDLFileName() {
        String fn = UseCase4Prms.getDDLFileName();
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("DDL file: " + fn);
        return newfn;
    }

    private List<String> getDDLStatements(String fn) throws FileNotFoundException, IOException {
        Log.getLogWriter().info("Reading statements from " + fn);
        String text = FileUtil.getText((String)fn).trim();
        StringTokenizer tokenizer = new StringTokenizer(text, ";", false);
        ArrayList<String> stmts = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String stmt = tokenizer.nextToken().trim();
            stmts.add(stmt);
        }
        Log.getLogWriter().info("Read statements: " + stmts);
        return stmts;
    }

    public static void dropTablesTask() throws SQLException {
        UseCase4Client c = new UseCase4Client();
        c.initialize();
        if (c.queryAPI != 1 && c.sttgid == 0) {
            c.dropTables();
        }
    }

    private void dropTables() throws SQLException {
        this.dropTable("quotes");
        this.dropTable("holding");
        this.dropTable("orders");
        this.dropTable("account");
        this.dropTable("accountprofile");
    }

    private void dropTable(String table) throws SQLException {
        String stmt = "drop table if exists " + table;
        this.execute(stmt, this.connection);
        this.commitDDL();
    }

    private ResultSet execute(String stmt, Connection conn) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt + " on: " + conn);
        }
        ResultSet rs = null;
        Statement s = conn.createStatement();
        boolean result = s.execute(stmt);
        if (result) {
            rs = s.getResultSet();
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt + " on: " + conn);
        }
        s.close();
        return rs;
    }

    private void execute(PreparedStatement stmt) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt);
        }
        stmt.execute();
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt);
        }
    }

    private void commitDDL() {
        if (this.queryAPI != 1) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new QueryPerfException("Commit failed: " + e);
            }
        }
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.useCase4stats = this.getUseCase4Stats();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setUseCase4Stats(this.useCase4stats);
    }

    protected UseCase4Stats getUseCase4Stats() {
        UseCase4Stats useCase4stats = (UseCase4Stats)((Object)localuseCase4stats.get());
        return useCase4stats;
    }

    protected void setUseCase4Stats(UseCase4Stats useCase4stats) {
        localuseCase4stats.set((Object)useCase4stats);
    }

    @Override
    protected void initLocalParameters() {
        super.initLocalParameters();
        this.logQueries = QueryPrms.logQueries();
        this.logQueryResults = QueryPrms.logQueryResults();
    }

    @Override
    protected boolean getLogQueries() {
        return this.logQueries;
    }

    @Override
    protected void setLogQueries(boolean b) {
        this.logQueries = b;
    }
}

