/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase5;

import cacheperf.comparisons.gemfirexd.QueryPerfClient;
import cacheperf.comparisons.gemfirexd.QueryPerfException;
import cacheperf.comparisons.gemfirexd.useCase5.UseCase5Prms;
import cacheperf.comparisons.gemfirexd.useCase5.UseCase5Stats;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import objects.query.QueryPrms;
import sql.sqlutil.ResultSetHelper;

public class UseCase5Client
extends QueryPerfClient {
    protected static final String CONFLICT_STATE = "X0Z02";
    protected static final String DEADLOCK_STATE = "ORA-00060";
    protected static final String DUPLICATE_STR = "The statement was aborted because it would have caused a duplicate key value";
    protected static final int numBuckets = UseCase5Prms.getNumBuckets();
    protected static final boolean timeStmts = UseCase5Prms.timeStmts();
    protected static final int TRANSACTIONS = 1580007;
    protected static final String TRANSACTIONS_NAME = "transactions";
    protected static HydraThreadLocal localuseCase5stats = new HydraThreadLocal();
    private static final String selstm = "select msn from terminals where terminal_id = ?";
    private static final String inslog = "insert into err_logs (source_id, log_time, err_msg) values (?, current_timestamp, ?)";
    private static final String updbal = "update terminal_accounts set outstanding_amount = outstanding_amount + ?  where terminal_id = ? and account_type = ? ";
    private static final String insbal = "insert into terminal_accounts (terminal_id, account_type, outstanding_amount) values (?, ?, ?)";
    private static final String updterm = "update terminals set msn = ?, logger_seq =?, status_update_time=current_timestamp where terminal_id = ?";
    private static final String insterm = "insert into terminals (terminal_id, terminal_ref_id, status_current, status_update_time, physical_location_group_id, msn, logger_seq) values (?, ?, 0, current_timestamp, 0, 0, 0)";
    private static final String instkt = "insert into betting_tickets (tsn, source_id, ticket_json, status) values (?, ?, ?, 1)";
    private static final String instsn = "insert into ticket_pools ( pool_id, source_id, tsn) values (?, ?, ?)";
    private PreparedStatement selstmPS = null;
    private PreparedStatement inslogPS = null;
    private PreparedStatement updbalPS = null;
    private PreparedStatement insbalPS = null;
    private PreparedStatement updtermPS = null;
    private PreparedStatement instermPS = null;
    private PreparedStatement instktPS = null;
    private PreparedStatement instsnPS = null;
    public UseCase5Stats useCase5stats;
    protected boolean logQueries;
    protected boolean logQueryResults;
    protected ResultSet rs = null;
    protected int result = 0;

    public static void openStatisticsTask() {
        UseCase5Client c = new UseCase5Client();
        c.openStatistics();
    }

    private void openStatistics() {
        this.useCase5stats = this.getUseCase5Stats();
        if (this.useCase5stats == null) {
            this.useCase5stats = UseCase5Stats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
        this.setUseCase5Stats(this.useCase5stats);
    }

    public static void closeStatisticsTask() {
        UseCase5Client c = new UseCase5Client();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.useCase5stats != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.useCase5stats.close();
        }
    }

    public static void executeDDLTask() throws FileNotFoundException, IOException, SQLException {
        UseCase5Client c = new UseCase5Client();
        c.initialize();
        if (c.sttgid == 0) {
            c.executeDDL();
        }
    }

    private void executeDDL() throws FileNotFoundException, IOException, SQLException {
        String fn = this.getDDLFile(UseCase5Prms.getDDLFile());
        List<String> stmts = this.getDDLStatements(fn);
        for (String stmt : stmts) {
            block4: {
                if (this.queryAPI == 1 && stmt.contains("partition")) {
                    stmt = stmt + " buckets " + numBuckets;
                }
                Log.getLogWriter().info("Executing DDL: " + stmt);
                try {
                    this.execute(stmt, this.connection);
                }
                catch (SQLException e) {
                    if (!stmt.contains("DROP") || e.getMessage().indexOf("does not exist") != -1 || e.getMessage().indexOf("Unknown table ") != -1) break block4;
                    throw e;
                }
            }
            this.commitDDL();
        }
    }

    public static void useCase5InsertTask() throws SQLException {
        UseCase5Client c = new UseCase5Client();
        c.initialize(1580007);
        c.useCase5Insert();
    }

    private void useCase5Insert() throws SQLException {
        char[] chars = new char[1024];
        Arrays.fill(chars, 'A');
        String tkt = new String(chars);
        StringBuilder tsnbuf = new StringBuilder();
        tsnbuf.setLength(19);
        Random ran = new Random(this.tid);
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.insert(tkt, tsnbuf, ran);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void insert(String tkt, StringBuilder tsnbuf, Random ran) throws SQLException {
        long start = this.useCase5stats.startTransaction();
        for (int j = 0; j < 19; ++j) {
            tsnbuf.setCharAt(j, Character.toUpperCase(Character.forDigit(ran.nextInt(16), 16)));
        }
        this._insert(this.connection, this.tid, tsnbuf.toString(), "1", 0, 100, 1, 100, 123, 456, tkt);
        this.useCase5stats.endTransaction(start, 0L);
    }

    private void _insert(Connection conn, int source_id, String tsn, String pool_ids_comma_sep_string, int balance_type1, int balance_value1, int balance_type2, int balance_value2, int msn, int logger_seq, String ticket_json) throws SQLException {
        int balance_type = balance_type1;
        int balance_value = balance_value1;
        int rowcnt = 0;
        if (this.inslogPS == null) {
            this.inslogPS = conn.prepareStatement(inslog);
        }
        this.inslogPS.setInt(1, source_id);
        this.inslogPS.setString(2, ticket_json);
        this.inslogPS.executeUpdate();
        if (this.instsnPS == null) {
            this.instsnPS = conn.prepareStatement(instsn);
        }
        for (String _pool_id : pool_ids_comma_sep_string.split(",")) {
            this.instsnPS.setInt(1, Integer.parseInt(_pool_id));
            this.instsnPS.setInt(2, source_id);
            this.instsnPS.setString(3, tsn);
            this.instsnPS.executeUpdate();
        }
        if (this.instktPS == null) {
            this.instktPS = conn.prepareStatement(instkt);
        }
        this.instktPS.setString(1, tsn);
        this.instktPS.setInt(2, source_id);
        this.instktPS.setString(3, ticket_json);
        this.instktPS.executeUpdate();
        for (int i = 0; i < 2; ++i) {
            if (balance_type < 0) continue;
            if (this.updbalPS == null) {
                this.updbalPS = conn.prepareStatement(updbal);
            }
            this.updbalPS.setInt(1, balance_value);
            this.updbalPS.setInt(2, source_id);
            this.updbalPS.setInt(3, balance_type);
            rowcnt = this.updbalPS.executeUpdate();
            if (rowcnt == 0) {
                if (this.insbalPS == null) {
                    this.insbalPS = conn.prepareStatement(insbal);
                }
                this.insbalPS.setInt(1, source_id);
                this.insbalPS.setInt(2, balance_type);
                this.insbalPS.setInt(3, balance_value);
                this.insbalPS.executeUpdate();
            }
            balance_type = balance_type2;
            balance_value = balance_value2;
        }
        if (this.updtermPS == null) {
            this.updtermPS = conn.prepareStatement(updterm);
        }
        this.updtermPS.setInt(1, msn);
        this.updtermPS.setInt(2, logger_seq);
        this.updtermPS.setInt(3, source_id);
        rowcnt = this.updtermPS.executeUpdate();
        if (rowcnt == 0) {
            if (this.instermPS == null) {
                this.instermPS = conn.prepareStatement(insterm);
            }
            this.instermPS.setInt(1, source_id);
            this.instermPS.setString(2, Integer.toHexString(source_id).toUpperCase());
            this.instermPS.executeUpdate();
        }
        conn.commit();
    }

    public void query(Connection conn, int source_id) throws SQLException {
        ResultSet rs = null;
        char[] chars = new char[1024];
        Arrays.fill(chars, 'A');
        String tkt = new String(chars);
        StringBuilder tsnbuf = new StringBuilder();
        tsnbuf.setLength(19);
        Random ran = new Random();
        if (this.selstmPS == null) {
            this.selstmPS = conn.prepareStatement(selstm);
        }
        for (int donecount = 0; donecount < 1234567; ++donecount) {
            for (int j = 0; j < 19; ++j) {
                tsnbuf.setCharAt(j, Character.toUpperCase(Character.forDigit(ran.nextInt(16), 16)));
            }
            this.selstmPS.setInt(1, source_id);
            rs = this.selstmPS.executeQuery();
            rs.next();
            int msn = rs.getInt(1);
            assert (msn == 123);
            rs.close();
            rs = null;
        }
    }

    private ResultSet execute(String stmt, Connection conn) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt + " on: " + conn);
        }
        ResultSet rs = null;
        Statement s = conn.createStatement();
        boolean result = s.execute(stmt);
        if (result) {
            rs = s.getResultSet();
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt + " on: " + conn);
        }
        s.close();
        return rs;
    }

    private void execute(PreparedStatement stmt) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt);
        }
        stmt.execute();
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt);
        }
    }

    private String getDDLFile(String fname) {
        String fn = "$JTESTS/cacheperf/comparisons/gemfirexd/useCase5/ddl/" + fname;
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("DDL file: " + newfn);
        return newfn;
    }

    private List<String> getDDLStatements(String fn) throws FileNotFoundException, IOException {
        Log.getLogWriter().info("Reading statements from " + fn);
        String text = FileUtil.getText((String)fn).trim();
        StringTokenizer tokenizer = new StringTokenizer(text, ";", false);
        ArrayList<String> stmts = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String stmt = tokenizer.nextToken().trim();
            stmts.add(stmt);
        }
        Log.getLogWriter().info("Read statements: " + stmts);
        return stmts;
    }

    private void commitDDL() {
        if (this.queryAPI != 1) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new QueryPerfException("Commit failed: " + e);
            }
        }
    }

    public static void dumpBucketsHook() {
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName.contains("server") || clientName.contains("sender") || clientName.contains("receiver") || clientName.contains("dbsync") || clientName.contains("prdata")) {
            Log.getLogWriter().info("Dumping local buckets");
            ResultSetHelper.dumpLocalBucket();
            Log.getLogWriter().info("Dumped local buckets");
        }
    }

    public static void dumpBucketsTask() {
        UseCase5Client c = new UseCase5Client();
        c.initialize();
        if (c.jid == 0) {
            Log.getLogWriter().info("Dumping local buckets");
            ResultSetHelper.dumpLocalBucket();
            Log.getLogWriter().info("Dumped local buckets");
        }
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.useCase5stats = this.getUseCase5Stats();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setUseCase5Stats(this.useCase5stats);
    }

    protected UseCase5Stats getUseCase5Stats() {
        this.useCase5stats = (UseCase5Stats)((Object)localuseCase5stats.get());
        return this.useCase5stats;
    }

    protected void setUseCase5Stats(UseCase5Stats useCase5stats) {
        localuseCase5stats.set((Object)useCase5stats);
    }

    @Override
    protected void initLocalParameters() {
        super.initLocalParameters();
        this.logQueries = QueryPrms.logQueries();
        this.logQueryResults = QueryPrms.logQueryResults();
    }

    @Override
    protected String nameFor(int name) {
        switch (name) {
            case 1580007: {
                return TRANSACTIONS_NAME;
            }
        }
        return super.nameFor(name);
    }

    @Override
    protected boolean getLogQueries() {
        return this.logQueries;
    }

    @Override
    protected void setLogQueries(boolean b) {
        this.logQueries = b;
    }
}

