/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase5;

import cacheperf.comparisons.gemfirexd.QueryPerfException;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.HistogramStats;
import perffmwk.PerformanceStatistics;

public class UseCase5Stats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    public static final String VM_COUNT = "vmCount";
    protected static final String INSERT_TX_COMPLETED = "insertTxCompleted";
    protected static final String INSERT_TX_TIME = "insertTxTime";
    protected static final String selstm_stmt = "selstmStmtsExecuted";
    protected static final String selstm_stmt_time = "selstmStmtTime";
    protected static final String inslog_stmt = "inslogStmtsExecuted";
    protected static final String inslog_stmt_time = "inslogStmtTime";
    protected static final String updbal_stmt = "updbalStmtsExecuted";
    protected static final String updbal_stmt_time = "updbalStmtTime";
    protected static final String insbal_stmt = "insbalStmtsExecuted";
    protected static final String insbal_stmt_time = "insbalStmtTime";
    protected static final String updterm_stmt = "updtermStmtsExecuted";
    protected static final String updterm_stmt_time = "updtermStmtTime";
    protected static final String insterm_stmt = "instermStmtsExecuted";
    protected static final String insterm_stmt_time = "instermStmtTime";
    protected static final String instkt_stmt = "instktStmtsExecuted";
    protected static final String instkt_stmt_time = "instktStmtTime";
    protected static final String instsn_stmt = "instsnStmtsExecuted";
    protected static final String instsn_stmt_time = "instsnStmtTime";
    private static boolean VMCounted = false;

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{UseCase5Stats.factory().createIntGauge(VM_COUNT, "When aggregated, the number of VMs using this statistics object.", "VMs"), UseCase5Stats.factory().createIntCounter(INSERT_TX_COMPLETED, "Number of insert transactions completed (committed).", "operations", largerIsBetter), UseCase5Stats.factory().createLongCounter(INSERT_TX_TIME, "Total time spent on insert transactions that were completed (committed).", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(selstm_stmt, "Number of selstm statements executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(selstm_stmt_time, "Total time spent executing selstm statements.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(inslog_stmt, "Number of inslog statements executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(inslog_stmt_time, "Total time spent executing inslog statements.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(updbal_stmt, "Number of updbal statements executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(updbal_stmt_time, "Total time spent executing updbal statements.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insbal_stmt, "Number of insbal statements executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insbal_stmt_time, "Total time spent executing insbal statements.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(updterm_stmt, "Number of updterm statements executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(updterm_stmt_time, "Total time spent executing updterm statements.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insterm_stmt, "Number of insterm statements executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insterm_stmt_time, "Total time spent executing insterm statements.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(instkt_stmt, "Number of instkt statements executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(instkt_stmt_time, "Total time spent executing instkt statements.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(instsn_stmt, "Number of instsn statements executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(instsn_stmt_time, "Total time spent executing instsn statements.", "nanoseconds", !largerIsBetter)};
    }

    public static UseCase5Stats getInstance() {
        UseCase5Stats tps = (UseCase5Stats)UseCase5Stats.getInstance(UseCase5Stats.class, (int)0);
        tps.incVMCount();
        return tps;
    }

    public static UseCase5Stats getInstance(String name) {
        UseCase5Stats tps = (UseCase5Stats)UseCase5Stats.getInstance(UseCase5Stats.class, (int)0, (String)name);
        tps.incVMCount();
        return tps;
    }

    public static UseCase5Stats getInstance(String name, String trimspecName) {
        UseCase5Stats tps = (UseCase5Stats)UseCase5Stats.getInstance(UseCase5Stats.class, (int)0, (String)name, (String)trimspecName);
        tps.incVMCount();
        return tps;
    }

    public UseCase5Stats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    private synchronized void incVMCount() {
        if (!VMCounted) {
            this.statistics().incInt(VM_COUNT, 1);
            VMCounted = true;
        }
    }

    public void incHistogram(HistogramStats histogram, long amount) {
        if (histogram != null) {
            histogram.incBin(amount);
        }
    }

    public long startCommit() {
        return NanoTimer.getTime();
    }

    public long startTransaction() {
        return NanoTimer.getTime();
    }

    public void endTransaction(long start, long commitStart) {
        long end = NanoTimer.getTime();
        long elapsed = end - start;
        this.statistics().incInt(INSERT_TX_COMPLETED, 1);
        this.statistics().incLong(INSERT_TX_TIME, elapsed);
    }

    public long startStmt(Stmt stmt) {
        return NanoTimer.getTime();
    }

    public void endStmt(Stmt stmt, long start) {
        this.endStmt(stmt, start, 1, null);
    }

    public void endStmt(Stmt stmt, long start, HistogramStats histogram) {
        this.endStmt(stmt, start, 1, histogram);
    }

    public void endStmt(Stmt stmt, long start, int amount, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        switch (stmt) {
            case selstm: {
                this.statistics().incInt(selstm_stmt, amount);
                this.statistics().incLong(selstm_stmt_time, elapsed);
                break;
            }
            case inslog: {
                this.statistics().incInt(inslog_stmt, amount);
                this.statistics().incLong(inslog_stmt_time, elapsed);
                break;
            }
            case updbal: {
                this.statistics().incInt(updbal_stmt, amount);
                this.statistics().incLong(updbal_stmt_time, elapsed);
                break;
            }
            case insbal: {
                this.statistics().incInt(insbal_stmt, amount);
                this.statistics().incLong(insbal_stmt_time, elapsed);
                break;
            }
            case updterm: {
                this.statistics().incInt(updterm_stmt, amount);
                this.statistics().incLong(updterm_stmt_time, elapsed);
                break;
            }
            case insterm: {
                this.statistics().incInt(insterm_stmt, amount);
                this.statistics().incLong(insterm_stmt_time, elapsed);
                break;
            }
            case instkt: {
                this.statistics().incInt(instkt_stmt, amount);
                this.statistics().incLong(instkt_stmt_time, elapsed);
                break;
            }
            case instsn: {
                this.statistics().incInt(instsn_stmt, amount);
                this.statistics().incLong(instsn_stmt_time, elapsed);
                break;
            }
            default: {
                String s = "Should not happen";
                throw new QueryPerfException(s);
            }
        }
        this.incHistogram(histogram, elapsed);
    }

    public static enum Stmt {
        selstm,
        inslog,
        updbal,
        insbal,
        updterm,
        insterm,
        instkt,
        instsn;

    }
}

