/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase5.poc;

import cacheperf.comparisons.gemfirexd.QueryPerfClient;
import cacheperf.comparisons.gemfirexd.useCase5.poc.UseCase5Prms;
import cacheperf.comparisons.gemfirexd.useCase5.poc.UseCase5Stats;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.sql.rowset.serial.SerialBlob;
import objects.query.QueryPrms;
import sql.sqlutil.ResultSetHelper;

public class UseCase5Client
extends QueryPerfClient {
    protected static final int NUM_TERMINALS = UseCase5Prms.getNumTerminals();
    protected static final String CONFLICT_STATE = "X0Z02";
    protected static final String DEADLOCK_STATE = "ORA-00060";
    protected static final String DUPLICATE_STR = "The statement was aborted because it would have caused a duplicate key value";
    protected static final int numBuckets = UseCase5Prms.getNumBuckets();
    protected static final boolean timeStmts = UseCase5Prms.timeStmts();
    private static final String CB_SELL_PREFIX = "S_";
    private static final String CB_PAY_PREFIX = "P_";
    private static final int C_CB = 101;
    private static final short C_TicketType_CB = 1;
    private static final short C_TransactionType_Sell = 1;
    private static final short C_TransactionType_Pay = 2;
    private static final String C_CBEventInfo = "Cash betting";
    private static final String C_CBMessageResult = "TICKET_SOLD_MESSAGE";
    private static final String C_CashPaidMessageResult = "TICKET_PAID_MESSAGE";
    private static final String C_FTerminalID = "terminal_id";
    private static final String C_FTerminalStatus = "terminal_status";
    private static final int OLTP_SERVICE_ID = 99;
    protected static final int TERMINALS = 1980507;
    protected static final int SELL_TRANSACTIONS = 1980508;
    protected static final int PAY_TRANSACTIONS = 1980509;
    protected static final String TERMINALS_NAME = "terminals";
    protected static final String SELL_TRANSACTIONS_NAME = "sells";
    protected static final String PAY_TRANSACTIONS_NAME = "pays";
    protected static HydraThreadLocal localuseCase5stats = new HydraThreadLocal();
    protected PreparedStatement insTerminalStmt = null;
    protected PreparedStatement insSourceStmt = null;
    private PreparedStatement insSourceMessageLogStmt;
    private PreparedStatement insSingleTicketStmt;
    private PreparedStatement insTicketHistoryStmt;
    private PreparedStatement insSourceMessageResultStmt;
    private PreparedStatement insTicketsToPoolStmt;
    private PreparedStatement selTerminalStatusStmt;
    private PreparedStatement insTerminalBalanceTransactionLogStmt;
    private PreparedStatement selectTicketByTSNStmt;
    private PreparedStatement updTicketForPayStmt;
    public UseCase5Stats useCase5stats;
    protected boolean logQueries;
    protected boolean logQueryResults;
    private byte[] ticketContent = "RACEBET () HV SAT WIN 1*1 $10".getBytes(Charset.forName("UTF-8"));
    private float ticketCost = 10.0f;

    public static void openStatisticsTask() {
        UseCase5Client c = new UseCase5Client();
        c.openStatistics();
    }

    private void openStatistics() {
        this.useCase5stats = this.getUseCase5Stats();
        if (this.useCase5stats == null) {
            this.useCase5stats = UseCase5Stats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
        this.setUseCase5Stats(this.useCase5stats);
    }

    public static void closeStatisticsTask() {
        UseCase5Client c = new UseCase5Client();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.useCase5stats != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.useCase5stats.close();
        }
    }

    public static void executeDDLTask() throws FileNotFoundException, IOException, SQLException {
        UseCase5Client c = new UseCase5Client();
        c.initialize();
        if (c.sttgid == 0) {
            c.executeDDL();
        }
    }

    private void executeDDL() throws FileNotFoundException, IOException, SQLException {
        String fn = this.getDDLFile(UseCase5Prms.getDDLFile());
        List<String> stmts = this.getDDLStatements(fn);
        for (String stmt : stmts) {
            if (this.queryAPI == 1 && stmt.contains("partition")) {
                stmt = stmt + " buckets " + numBuckets;
            }
            Log.getLogWriter().info("Executing DDL: " + stmt);
            Statement s = this.connection.createStatement();
            s.execute(stmt);
            this.connection.commit();
        }
    }

    public static void setupTerminalsTask() throws SQLException {
        UseCase5Client c = new UseCase5Client();
        c.initialize(1980507);
        if (c.ttgid == 0) {
            c.setupTerminals();
        }
    }

    private void setupTerminals() throws SQLException {
        Log.getLogWriter().info("Creating " + NUM_TERMINALS + " terminals...");
        long stmt_start = 0L;
        for (int i = 0; i < NUM_TERMINALS; ++i) {
            ResultSet rs;
            if (this.insTerminalStmt == null) {
                String stmt = "INSERT INTO terminals (terminal_status_update_time, terminal_status) VALUES (?, ?)";
                this.insTerminalStmt = this.connection.prepareStatement(stmt, 1);
            }
            Timestamp t = new Timestamp(System.currentTimeMillis());
            this.insTerminalStmt.setTimestamp(1, t);
            this.insTerminalStmt.setShort(2, (short)1);
            if (this.logQueries) {
                Log.getLogWriter().info("EXECUTING insTerminalStmt: " + t);
            }
            if (timeStmts) {
                stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insTerminal);
            }
            if (this.insTerminalStmt.executeUpdate() != 1) {
                throw new SQLException("insTerminal failed for Terminal " + i);
            }
            if (timeStmts) {
                this.useCase5stats.endStmt(UseCase5Stats.Stmt.insTerminal, stmt_start);
            }
            if ((rs = this.insTerminalStmt.getGeneratedKeys()) == null) {
                throw new SQLException("insTerminal failed to get generated keys for Terminal " + i);
            }
            int terminalId = -1;
            if (!rs.next()) {
                throw new SQLException("insTerminal failed to get generated key for Terminal " + i);
            }
            terminalId = rs.getInt(1);
            if (this.logQueries) {
                Log.getLogWriter().info("GENERATED terminalId: " + terminalId);
            }
            rs.close();
            rs = null;
            if (this.insSourceStmt == null) {
                String stmt = "INSERT INTO source_types (source_id, ref_id, source_type_id) VALUES (?, ?, ?)";
                this.insSourceStmt = this.connection.prepareStatement(stmt, 1);
            }
            String hexTerminalId = Integer.toHexString(terminalId);
            this.insSourceStmt.setString(1, hexTerminalId);
            this.insSourceStmt.setInt(2, terminalId);
            this.insSourceStmt.setShort(3, (short)1);
            if (this.logQueries) {
                Log.getLogWriter().info("EXECUTING insSourceStmt: " + hexTerminalId + " " + terminalId);
            }
            if (timeStmts) {
                stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insSource);
            }
            this.insSourceStmt.executeUpdate();
            if (timeStmts) {
                this.useCase5stats.endStmt(UseCase5Stats.Stmt.insSource, stmt_start);
            }
            this.connection.commit();
            Log.getLogWriter().info("Created terminal " + terminalId);
        }
    }

    public static void sellCashBetsTask() throws SQLException, NumberFormatException {
        UseCase5Client c = new UseCase5Client();
        c.initialize(1980508);
        c.sellCashBets();
    }

    private void sellCashBets() throws SQLException, NumberFormatException {
        ArrayList<String> poolIds = new ArrayList<String>();
        poolIds.add("1001");
        poolIds.add("1002");
        poolIds.add("1003");
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            long start = this.useCase5stats.startCBSell();
            this.logToSourceMessageAndValidate(key, CB_SELL_PREFIX);
            this.sell(key, poolIds);
            this.useCase5stats.endCBSell(start);
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void sell(int key, List<String> poolIds) throws SQLException, NumberFormatException {
        String s;
        int terminalIdInternal = this.rng.nextInt(1, NUM_TERMINALS);
        String terminalId = Integer.toHexString(terminalIdInternal);
        String ticketTSN = String.valueOf(key);
        String ticketTransactionId = CB_SELL_PREFIX + key;
        ResultSet rs = null;
        long stmt_start = 0L;
        if (this.insSingleTicketStmt == null) {
            String s2 = "INSERT INTO tickets (tsn, ticket_type, base_investment, total_investment, current_responded_ap, current_responded_terminal, ticket_json) VALUES (?, ?, ?, ?, ?, ?, ?)";
            this.insSingleTicketStmt = this.connection.prepareStatement(s2, 1);
        }
        this.insSingleTicketStmt.setString(1, ticketTSN);
        this.insSingleTicketStmt.setShort(2, (short)1);
        this.insSingleTicketStmt.setLong(3, 500L);
        this.insSingleTicketStmt.setLong(4, (long)this.ticketCost * 100L);
        this.insSingleTicketStmt.setInt(5, 99);
        this.insSingleTicketStmt.setInt(6, terminalIdInternal);
        this.insSingleTicketStmt.setBlob(7, new SerialBlob(this.ticketContent));
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING insSingleTicketStmt: " + ticketTSN + " " + terminalIdInternal);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insSingleTicket);
        }
        if (this.insSingleTicketStmt.executeUpdate() != 1) {
            throw new SQLException("insSingleTicket failed for Ticket TSN " + key);
        }
        rs = this.insSingleTicketStmt.getGeneratedKeys();
        if (rs == null) {
            throw new SQLException("insSingleTicket failed to get generated keys for Ticket TSN " + key);
        }
        long ticketId = -1L;
        if (!rs.next()) {
            throw new SQLException("insSingleTicket failed to get generated key for Ticket TSN " + key);
        }
        ticketId = rs.getLong(1);
        rs.close();
        rs = null;
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.insSingleTicket, stmt_start);
        }
        if (this.insTicketHistoryStmt == null) {
            String s3 = "INSERT INTO ticket_transaction_log (transaction_id, ticket_id, responded_ap, responded_terminal, event_info, transaction_type) VALUES (?, ?, ?, ?, ?, ?)";
            this.insTicketHistoryStmt = this.connection.prepareStatement(s3, 1);
        }
        this.insTicketHistoryStmt.setString(1, ticketTransactionId);
        this.insTicketHistoryStmt.setLong(2, ticketId);
        this.insTicketHistoryStmt.setInt(3, 99);
        this.insTicketHistoryStmt.setInt(4, terminalIdInternal);
        this.insTicketHistoryStmt.setString(5, C_CBEventInfo);
        this.insTicketHistoryStmt.setShort(6, (short)1);
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insTicketHistory);
        }
        if (this.insTicketHistoryStmt.executeUpdate() != 1) {
            throw new SQLException("insTicketHistory failed for Ticket TSN " + key);
        }
        rs = this.insTicketHistoryStmt.getGeneratedKeys();
        if (rs == null) {
            throw new SQLException("insTicketHistory failed to get generated keys for Ticket TSN " + key);
        }
        long ticketTransactionSeqNo = -1L;
        if (!rs.next()) {
            throw new SQLException("insTicketHistory failed to get generated key for Ticket TSN " + key);
        }
        ticketTransactionSeqNo = rs.getLong(1);
        rs.close();
        rs = null;
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.insTicketHistory, stmt_start);
        }
        if (this.insSourceMessageResultStmt == null) {
            s = "INSERT INTO source_message_results (transaction_id, return_message, responded_ap) VALUES (?, ?, ?)";
            this.insSourceMessageResultStmt = this.connection.prepareStatement(s);
        }
        this.insSourceMessageResultStmt.setString(1, ticketTransactionId);
        this.insSourceMessageResultStmt.setString(2, C_CBMessageResult);
        this.insSourceMessageResultStmt.setInt(3, 99);
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insSourceMessageResult);
        }
        this.insSourceMessageResultStmt.executeUpdate();
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.insSourceMessageResult, stmt_start);
        }
        if (this.insTicketsToPoolStmt == null) {
            s = "INSERT INTO tickets_in_pool (pool_id, ticket_id) VALUES (?, ?)";
            this.insTicketsToPoolStmt = this.connection.prepareStatement(s);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insTicketsToPool);
        }
        for (String poolId : poolIds) {
            this.insTicketsToPoolStmt.setLong(2, ticketId);
            this.insTicketsToPoolStmt.setLong(1, Long.parseLong(poolId));
            this.insTicketsToPoolStmt.addBatch();
        }
        this.insTicketsToPoolStmt.executeBatch();
        this.insTicketsToPoolStmt.clearBatch();
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.insTicketsToPool, stmt_start);
        }
        if (this.insTerminalBalanceTransactionLogStmt == null) {
            String stmt = "INSERT INTO terminal_balance_transaction_log (terminal_id, ticket_transaction_log_seq_no, transaction_type, transaction_amount) VALUES (?, ?, ?, ?)";
            this.insTerminalBalanceTransactionLogStmt = this.connection.prepareStatement(stmt);
        }
        this.insTerminalBalanceTransactionLogStmt.setLong(1, terminalIdInternal);
        this.insTerminalBalanceTransactionLogStmt.setLong(2, ticketTransactionSeqNo);
        this.insTerminalBalanceTransactionLogStmt.setShort(3, (short)1);
        this.insTerminalBalanceTransactionLogStmt.setLong(4, (long)this.ticketCost * 100L);
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insTerminalBalanceTransactionLog);
        }
        this.insTerminalBalanceTransactionLogStmt.executeUpdate();
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.insTerminalBalanceTransactionLog, stmt_start);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startCommit();
        }
        this.connection.commit();
        if (timeStmts) {
            this.useCase5stats.endCommit(stmt_start);
        }
    }

    private void logToSourceMessageAndValidate(int key, String prefix) throws SQLException {
        String s;
        int terminalIdInternal = this.rng.nextInt(1, NUM_TERMINALS);
        String terminalId = Integer.toHexString(terminalIdInternal);
        String ticketTransactionId = prefix + key;
        ResultSet rs = null;
        long stmt_start = 0L;
        if (this.insSourceMessageLogStmt == null) {
            s = "INSERT INTO source_message_logs (transaction_id, message_content, arrival_time, source_id, event_id, responded_ap) VALUES (?, ?, ?, ?, ?, ?)";
            this.insSourceMessageLogStmt = this.connection.prepareStatement(s);
        }
        this.insSourceMessageLogStmt.setString(1, ticketTransactionId);
        this.insSourceMessageLogStmt.setBytes(2, this.ticketContent);
        this.insSourceMessageLogStmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
        this.insSourceMessageLogStmt.setString(4, terminalId);
        this.insSourceMessageLogStmt.setInt(5, 101);
        this.insSourceMessageLogStmt.setInt(6, 99);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING insSourceMessageLogStmt: " + ticketTransactionId + " " + terminalId);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insSourceMessageLog);
        }
        if (this.insSourceMessageLogStmt.executeUpdate() != 1) {
            throw new SQLException("insSourceMessageLog failed for Ticket TSN " + key);
        }
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.insSourceMessageLog, stmt_start);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startCommit();
        }
        this.connection.commit();
        if (timeStmts) {
            this.useCase5stats.endCommit(stmt_start);
        }
        if (this.selTerminalStatusStmt == null) {
            s = "SELECT terminal_status, terminal_id FROM mv_source_id_and_terminal WHERE source_id = ? AND source_type_id = 1";
            this.selTerminalStatusStmt = this.connection.prepareStatement(s);
        }
        this.selTerminalStatusStmt.setString(1, terminalId);
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.selTerminalStatus);
        }
        if (!(rs = this.selTerminalStatusStmt.executeQuery()).next()) {
            throw new SQLException("selTerminalStatus failed for Terminal " + terminalId);
        }
        int tmpTerminalId = rs.getInt(C_FTerminalID);
        short tmpTerminalStatus = rs.getShort(C_FTerminalStatus);
        rs.close();
        rs = null;
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.selTerminalStatus, stmt_start);
        }
    }

    public static void payCashBetsTask() throws SQLException, NumberFormatException {
        UseCase5Client c = new UseCase5Client();
        c.initialize(1980509);
        c.payCashBets();
    }

    private void payCashBets() throws SQLException, NumberFormatException {
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            long start = this.useCase5stats.startCBPay();
            this.logToSourceMessageAndValidate(key, CB_PAY_PREFIX);
            this.pay(key);
            this.useCase5stats.endCBPay(start);
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void pay(int key) throws SQLException {
        String s;
        String ticketTSN = String.valueOf(key);
        String ticketTransactionId = CB_PAY_PREFIX + key;
        int terminalIdInternal = this.rng.nextInt(1, NUM_TERMINALS);
        long ticketId = 0L;
        int ticketStatus = 0;
        long paidAmount = 0L;
        long dividend = 0L;
        ResultSet rs = null;
        long stmt_start = 0L;
        if (this.selectTicketByTSNStmt == null) {
            s = "SELECT ticket_json, ticket_id, current_ticket_status, base_investment, total_investment, paid_amount, total_investment, dividend_amount FROM tickets WHERE tsn=?";
            this.selectTicketByTSNStmt = this.connection.prepareStatement(s);
        }
        this.selectTicketByTSNStmt.setString(1, ticketTSN);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING selectTicketByTSNStmt: " + ticketTSN);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.selectTicketByTSN);
        }
        if (!(rs = this.selectTicketByTSNStmt.executeQuery()).next()) {
            throw new SQLException("selectTicketByTSN failed for Ticket TSN " + ticketTSN);
        }
        Blob content = rs.getBlob("ticket_json");
        byte[] contentBytes = content.getBytes(1L, (int)content.length());
        ticketId = rs.getLong("ticket_id");
        ticketStatus = rs.getInt("current_ticket_status");
        paidAmount = rs.getLong("paid_amount");
        dividend = rs.getLong("total_investment");
        rs.getLong("base_investment");
        rs.getLong("total_investment");
        rs.close();
        rs = null;
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.selectTicketByTSN, stmt_start);
        }
        if (this.updTicketForPayStmt == null) {
            s = "UPDATE tickets SET current_ticket_status =?, current_responded_ap = ?, current_responded_terminal =?, paid_amount=?, dividend_status=?, dividend_amount=?, locked_by=? where tsn=?";
            this.updTicketForPayStmt = this.connection.prepareStatement(s);
        }
        this.updTicketForPayStmt.setShort(1, (short)ticketStatus);
        this.updTicketForPayStmt.setInt(2, 99);
        this.updTicketForPayStmt.setInt(3, terminalIdInternal);
        this.updTicketForPayStmt.setLong(4, paidAmount);
        this.updTicketForPayStmt.setShort(5, (short)1);
        this.updTicketForPayStmt.setLong(6, dividend);
        this.updTicketForPayStmt.setInt(7, -1);
        this.updTicketForPayStmt.setString(8, ticketTSN);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING updTicketForPayStmt: " + ticketTSN);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.updTicketForPay);
        }
        if (this.updTicketForPayStmt.executeUpdate() == 0) {
            throw new SQLException("updTicketForPay failed for Ticket TSN " + ticketTSN);
        }
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.updTicketForPay, stmt_start);
        }
        if (this.insTicketHistoryStmt == null) {
            s = "INSERT INTO ticket_transaction_log (transaction_id, ticket_id, responded_ap, responded_terminal, event_info, transaction_type) VALUES (?, ?, ?, ?, ?, ?)";
            this.insTicketHistoryStmt = this.connection.prepareStatement(s, 1);
        }
        this.insTicketHistoryStmt.setString(1, ticketTransactionId);
        this.insTicketHistoryStmt.setLong(2, ticketId);
        this.insTicketHistoryStmt.setInt(3, 99);
        this.insTicketHistoryStmt.setInt(4, terminalIdInternal);
        this.insTicketHistoryStmt.setString(5, C_CashPaidMessageResult);
        this.insTicketHistoryStmt.setShort(6, (short)2);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING insTicketHistoryStmt: " + ticketTransactionId + " " + ticketId);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insTicketHistory);
        }
        if (this.insTicketHistoryStmt.executeUpdate() != 1) {
            throw new SQLException("insTicketHistory failed for Ticket TSN " + key);
        }
        rs = this.insTicketHistoryStmt.getGeneratedKeys();
        if (rs == null) {
            throw new SQLException("insTicketHistory failed to get generated keys for Ticket TSN " + key);
        }
        long ticketTransactionSeqNo = -1L;
        if (!rs.next()) {
            throw new SQLException("insTicketHistory failed to get generated key for Ticket TSN " + key);
        }
        ticketTransactionSeqNo = rs.getLong(1);
        rs.close();
        rs = null;
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.insTicketHistory, stmt_start);
        }
        if (this.insSourceMessageResultStmt == null) {
            String s2 = "INSERT INTO source_message_results (transaction_id, return_message, responded_ap) VALUES (?, ?, ?)";
            this.insSourceMessageResultStmt = this.connection.prepareStatement(s2);
        }
        this.insSourceMessageResultStmt.setString(1, ticketTransactionId);
        this.insSourceMessageResultStmt.setString(2, C_CashPaidMessageResult);
        this.insSourceMessageResultStmt.setInt(3, 99);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING insSourceMessageResultStmt: " + ticketTSN);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insSourceMessageResult);
        }
        if (this.insSourceMessageResultStmt.executeUpdate() == 0) {
            throw new SQLException("insSourceMessageResult failed for Ticket TSN " + ticketTSN);
        }
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.insSourceMessageResult, stmt_start);
        }
        if (this.insTerminalBalanceTransactionLogStmt == null) {
            String stmt = "INSERT INTO terminal_balance_transaction_log (terminal_id, ticket_transaction_log_seq_no, transaction_type, transaction_amount) VALUES (?, ?, ?, ?)";
            this.insTerminalBalanceTransactionLogStmt = this.connection.prepareStatement(stmt);
        }
        this.insTerminalBalanceTransactionLogStmt.setLong(1, terminalIdInternal);
        this.insTerminalBalanceTransactionLogStmt.setLong(2, ticketTransactionSeqNo);
        this.insTerminalBalanceTransactionLogStmt.setShort(3, (short)2);
        this.insTerminalBalanceTransactionLogStmt.setLong(4, -dividend);
        if (this.logQueries) {
            Log.getLogWriter().info("EXECUTING insTerminalBalanceTransactionLogStmt: " + ticketTSN);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startStmt(UseCase5Stats.Stmt.insTerminalBalanceTransactionLog);
        }
        if (this.insTerminalBalanceTransactionLogStmt.executeUpdate() != 1) {
            throw new SQLException("insTerminalBalanceTransactionLog failed for Ticket TSN " + ticketTSN);
        }
        if (timeStmts) {
            this.useCase5stats.endStmt(UseCase5Stats.Stmt.insTerminalBalanceTransactionLog, stmt_start);
        }
        if (timeStmts) {
            stmt_start = this.useCase5stats.startCommit();
        }
        this.connection.commit();
        if (timeStmts) {
            this.useCase5stats.endCommit(stmt_start);
        }
    }

    private String getDDLFile(String fname) {
        String fn = "$JTESTS/cacheperf/comparisons/gemfirexd/useCase5/poc/ddl/" + fname;
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("DDL file: " + newfn);
        return newfn;
    }

    private List<String> getDDLStatements(String fn) throws FileNotFoundException, IOException {
        Log.getLogWriter().info("Reading statements from " + fn);
        String text = FileUtil.getText((String)fn).trim();
        StringTokenizer tokenizer = new StringTokenizer(text, ";", false);
        ArrayList<String> stmts = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String stmt = tokenizer.nextToken().trim();
            stmts.add(stmt);
        }
        Log.getLogWriter().info("Read statements: " + stmts);
        return stmts;
    }

    public static void dumpBucketsHook() {
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName.contains("server") || clientName.contains("sender") || clientName.contains("receiver") || clientName.contains("dbsync") || clientName.contains("prdata")) {
            Log.getLogWriter().info("Dumping local buckets");
            ResultSetHelper.dumpLocalBucket();
            Log.getLogWriter().info("Dumped local buckets");
        }
    }

    public static void dumpBucketsTask() {
        UseCase5Client c = new UseCase5Client();
        c.initialize();
        if (c.jid == 0) {
            Log.getLogWriter().info("Dumping local buckets");
            ResultSetHelper.dumpLocalBucket();
            Log.getLogWriter().info("Dumped local buckets");
        }
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.useCase5stats = this.getUseCase5Stats();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setUseCase5Stats(this.useCase5stats);
    }

    protected UseCase5Stats getUseCase5Stats() {
        this.useCase5stats = (UseCase5Stats)((Object)localuseCase5stats.get());
        return this.useCase5stats;
    }

    protected void setUseCase5Stats(UseCase5Stats useCase5stats) {
        localuseCase5stats.set((Object)useCase5stats);
    }

    @Override
    protected void initLocalParameters() {
        super.initLocalParameters();
        this.logQueries = QueryPrms.logQueries();
        this.logQueryResults = QueryPrms.logQueryResults();
    }

    @Override
    protected String nameFor(int name) {
        switch (name) {
            case 1980507: {
                return TERMINALS_NAME;
            }
            case 1980508: {
                return SELL_TRANSACTIONS_NAME;
            }
            case 1980509: {
                return PAY_TRANSACTIONS_NAME;
            }
        }
        return super.nameFor(name);
    }

    @Override
    protected boolean getLogQueries() {
        return this.logQueries;
    }

    @Override
    protected void setLogQueries(boolean b) {
        this.logQueries = b;
    }

    public static enum STATUS {
        ON,
        OFF;

    }
}

