/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase5.poc;

import cacheperf.comparisons.gemfirexd.QueryPerfException;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.HistogramStats;
import perffmwk.PerformanceStatistics;

public class UseCase5Stats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    public static final String VM_COUNT = "vmCount";
    protected static final String COMMITS_COMPLETED = "commitsCompleted";
    protected static final String COMMIT_TIME = "commitTime";
    protected static final String CB_SELLS_COMPLETED = "cbSellsCompleted";
    protected static final String CB_SELL_TIME = "cbSellTime";
    protected static final String CB_PAYS_COMPLETED = "cbPaysCompleted";
    protected static final String CB_PAY_TIME = "cbPayTime";
    protected static final String insTerminalStmt = "insTerminalStmtsExecuted";
    protected static final String insSourceStmt = "insSourceStmtsExecuted";
    protected static final String insSourceMessageLogStmt = "insSourceMessageLogStmtsExecuted";
    protected static final String insSingleTicketStmt = "insSingleTicketStmtsExecuted";
    protected static final String insTicketHistoryStmt = "insTicketHistoryStmtsExecuted";
    protected static final String insSourceMessageResultStmt = "insSourceMessageResultStmtsExecuted";
    protected static final String insTicketsToPoolStmt = "insTicketsToPoolStmtsExecuted";
    protected static final String selTerminalStatusStmt = "selTerminalStatusStmtsExecuted";
    protected static final String insTerminalBalanceTransactionLogStmt = "insTerminalBalanceTransactionLogStmtsExecuted";
    protected static final String selectTicketByTSNStmt = "selectTicketByTSNStmtsExecuted";
    protected static final String updTicketForPayStmt = "updTicketForPayStmtsExecuted";
    protected static final String insTerminalStmtTime = "insTerminalStmtTime";
    protected static final String insSourceStmtTime = "insSourceStmtTime";
    protected static final String insSourceMessageLogStmtTime = "insSourceMessageLogStmtTime";
    protected static final String insSingleTicketStmtTime = "insSingleTicketStmtTime";
    protected static final String insTicketHistoryStmtTime = "insTicketHistoryStmtTime";
    protected static final String insSourceMessageResultStmtTime = "insSourceMessageResultStmtTime";
    protected static final String insTicketsToPoolStmtTime = "insTicketsToPoolStmtTime";
    protected static final String selTerminalStatusStmtTime = "selTerminalStatusStmtTime";
    protected static final String insTerminalBalanceTransactionLogStmtTime = "insTerminalBalanceTransactionLogStmtTime";
    protected static final String selectTicketByTSNStmtTime = "selectTicketByTSNStmtTime";
    protected static final String updTicketForPayStmtTime = "updTicketForPayStmtTime";
    private static boolean VMCounted = false;

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{UseCase5Stats.factory().createIntGauge(VM_COUNT, "When aggregated, the number of VMs using this statistics object.", "VMs"), UseCase5Stats.factory().createIntCounter(COMMITS_COMPLETED, "Number of commits completed.", "operations", largerIsBetter), UseCase5Stats.factory().createLongCounter(COMMIT_TIME, "Total time spent on commits (minus DML time).", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(CB_SELLS_COMPLETED, "Number of cash sells completed.", "operations", largerIsBetter), UseCase5Stats.factory().createLongCounter(CB_SELL_TIME, "Total time spent on cash sells that were completed (minus commit time).", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(CB_PAYS_COMPLETED, "Number of cash pays completed.", "operations", largerIsBetter), UseCase5Stats.factory().createLongCounter(CB_PAY_TIME, "Total time spent on cash pays that were completed (minus commit time).", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insTerminalStmt, "Number of insTerminalStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insTerminalStmtTime, "Total time spent executing insTerminalStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insSourceStmt, "Number of insSourceStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insSourceStmtTime, "Total time spent executing insSourceStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insSourceMessageLogStmt, "Number of insSourceMessageLogStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insSourceMessageLogStmtTime, "Total time spent executing insSourceMessageLogStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insSingleTicketStmt, "Number of insSingleTicketStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insSingleTicketStmtTime, "Total time spent executing insSingleTicketStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insTicketHistoryStmt, "Number of insTicketHistoryStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insTicketHistoryStmtTime, "Total time spent executing insTicketHistoryStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insSourceMessageResultStmt, "Number of insSourceMessageResultStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insSourceMessageResultStmtTime, "Total time spent executing insSourceMessageResultStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insTicketsToPoolStmt, "Number of insTicketsToPoolStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insTicketsToPoolStmtTime, "Total time spent executing insTicketsToPoolStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(selTerminalStatusStmt, "Number of selTerminalStatusStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(selTerminalStatusStmtTime, "Total time spent executing selTerminalStatusStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(insTerminalBalanceTransactionLogStmt, "Number of insTerminalBalanceTransactionLogStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(insTerminalBalanceTransactionLogStmtTime, "Total time spent executing insTerminalBalanceTransactionLogStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(selectTicketByTSNStmt, "Number of selectTicketByTSNStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(selectTicketByTSNStmtTime, "Total time spent executing selectTicketByTSNStmt.", "nanoseconds", !largerIsBetter), UseCase5Stats.factory().createIntCounter(updTicketForPayStmt, "Number of updTicketForPayStmt executed.", "executions", largerIsBetter), UseCase5Stats.factory().createLongCounter(updTicketForPayStmtTime, "Total time spent executing updTicketForPayStmt.", "nanoseconds", !largerIsBetter)};
    }

    public static UseCase5Stats getInstance() {
        UseCase5Stats tps = (UseCase5Stats)UseCase5Stats.getInstance(UseCase5Stats.class, (int)0);
        tps.incVMCount();
        return tps;
    }

    public static UseCase5Stats getInstance(String name) {
        UseCase5Stats tps = (UseCase5Stats)UseCase5Stats.getInstance(UseCase5Stats.class, (int)0, (String)name);
        tps.incVMCount();
        return tps;
    }

    public static UseCase5Stats getInstance(String name, String trimspecName) {
        UseCase5Stats tps = (UseCase5Stats)UseCase5Stats.getInstance(UseCase5Stats.class, (int)0, (String)name, (String)trimspecName);
        tps.incVMCount();
        return tps;
    }

    public UseCase5Stats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    private synchronized void incVMCount() {
        if (!VMCounted) {
            this.statistics().incInt(VM_COUNT, 1);
            VMCounted = true;
        }
    }

    public void incHistogram(HistogramStats histogram, long amount) {
        if (histogram != null) {
            histogram.incBin(amount);
        }
    }

    public long startCommit() {
        return NanoTimer.getTime();
    }

    public void endCommit(long start) {
        this.statistics().incInt(COMMITS_COMPLETED, 1);
        this.statistics().incLong(COMMIT_TIME, NanoTimer.getTime() - start);
    }

    public long startCBSell() {
        return NanoTimer.getTime();
    }

    public void endCBSell(long start) {
        this.statistics().incInt(CB_SELLS_COMPLETED, 1);
        this.statistics().incLong(CB_SELL_TIME, NanoTimer.getTime() - start);
    }

    public long startCBPay() {
        return NanoTimer.getTime();
    }

    public void endCBPay(long start) {
        this.statistics().incInt(CB_PAYS_COMPLETED, 1);
        this.statistics().incLong(CB_PAY_TIME, NanoTimer.getTime() - start);
    }

    public long startStmt(Stmt stmt) {
        return NanoTimer.getTime();
    }

    public void endStmt(Stmt stmt, long start) {
        this.endStmt(stmt, start, 1, null);
    }

    public void endStmt(Stmt stmt, long start, HistogramStats histogram) {
        this.endStmt(stmt, start, 1, histogram);
    }

    public void endStmt(Stmt stmt, long start, int amount, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        switch (stmt) {
            case insTerminal: {
                this.statistics().incInt(insTerminalStmt, amount);
                this.statistics().incLong(insTerminalStmtTime, elapsed);
                break;
            }
            case insSource: {
                this.statistics().incInt(insSourceStmt, amount);
                this.statistics().incLong(insSourceStmtTime, elapsed);
                break;
            }
            case insSourceMessageLog: {
                this.statistics().incInt(insSourceMessageLogStmt, amount);
                this.statistics().incLong(insSourceMessageLogStmtTime, elapsed);
                break;
            }
            case insSingleTicket: {
                this.statistics().incInt(insSingleTicketStmt, amount);
                this.statistics().incLong(insSingleTicketStmtTime, elapsed);
                break;
            }
            case insTicketHistory: {
                this.statistics().incInt(insTicketHistoryStmt, amount);
                this.statistics().incLong(insTicketHistoryStmtTime, elapsed);
                break;
            }
            case insSourceMessageResult: {
                this.statistics().incInt(insSourceMessageResultStmt, amount);
                this.statistics().incLong(insSourceMessageResultStmtTime, elapsed);
                break;
            }
            case insTicketsToPool: {
                this.statistics().incInt(insTicketsToPoolStmt, amount);
                this.statistics().incLong(insTicketsToPoolStmtTime, elapsed);
                break;
            }
            case selTerminalStatus: {
                this.statistics().incInt(selTerminalStatusStmt, amount);
                this.statistics().incLong(selTerminalStatusStmtTime, elapsed);
                break;
            }
            case insTerminalBalanceTransactionLog: {
                this.statistics().incInt(insTerminalBalanceTransactionLogStmt, amount);
                this.statistics().incLong(insTerminalBalanceTransactionLogStmtTime, elapsed);
                break;
            }
            case selectTicketByTSN: {
                this.statistics().incInt(selectTicketByTSNStmt, amount);
                this.statistics().incLong(selectTicketByTSNStmtTime, elapsed);
                break;
            }
            case updTicketForPay: {
                this.statistics().incInt(updTicketForPayStmt, amount);
                this.statistics().incLong(updTicketForPayStmtTime, elapsed);
                break;
            }
            default: {
                String s = "Should not happen";
                throw new QueryPerfException(s);
            }
        }
        if (histogram != null) {
            this.incHistogram(histogram, elapsed);
        }
    }

    public static enum Stmt {
        insTerminal,
        insSource,
        insSourceMessageLog,
        insSingleTicket,
        insTicketHistory,
        insSourceMessageResult,
        insTicketsToPool,
        selTerminalStatus,
        insTerminalBalanceTransactionLog,
        selectTicketByTSN,
        updTicketForPay;

    }
}

