/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase6;

import cacheperf.comparisons.gemfirexd.QueryPerfClient;
import cacheperf.comparisons.gemfirexd.QueryPerfException;
import cacheperf.comparisons.gemfirexd.useCase6.UseCase6Prms;
import cacheperf.comparisons.gemfirexd.useCase6.UseCase6Stats;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import objects.query.QueryPrms;
import sql.SQLHelper;
import sql.datagen.DataGeneratorBB;
import sql.datagen.DataGeneratorHelper;
import sql.generic.SqlUtilityHelper;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class UseCase6Client
extends QueryPerfClient {
    protected static final String CONFLICT_STATE = "X0Z02";
    protected static final String DEADLOCK_STATE = "ORA-00060";
    protected static final String DUPLICATE_STR = "The statement was aborted because it would have caused a duplicate key value";
    protected static final int numBuckets = UseCase6Prms.getNumBuckets();
    protected static final boolean timeStmts = UseCase6Prms.timeStmts();
    protected static final int TRANSACTIONS = 1580017;
    protected static final String TRANSACTIONS_NAME = "updatetransactions";
    protected static HydraThreadLocal localuseCase6stats = new HydraThreadLocal();
    private static final String selstm = "SELECT * FROM OLTP_PNP_Subscriptions WHERE msisdn = ? AND walletname = ? ORDER BY expirydate desc fetch first 1 rows only";
    private static final String updstm = "UPDATE OLTP_PNP_Subscriptions SET expirydate = ? WHERE id = ?";
    private PreparedStatement selstmPS = null;
    private PreparedStatement updstmPS = null;
    public UseCase6Stats useCase6stats;
    protected boolean logQueries;
    protected boolean logQueryResults;
    protected ResultSet rs = null;
    protected int result = 0;
    protected static final ArrayList<String>[] paramValues = new ArrayList[2];

    public static void openStatisticsTask() {
        UseCase6Client c = new UseCase6Client();
        c.openStatistics();
    }

    private void openStatistics() {
        this.useCase6stats = this.getUseCase6Stats();
        if (this.useCase6stats == null) {
            this.useCase6stats = UseCase6Stats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
        this.setUseCase6Stats(this.useCase6stats);
    }

    public static void closeStatisticsTask() {
        UseCase6Client c = new UseCase6Client();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.useCase6stats != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.useCase6stats.close();
        }
    }

    public static void executeDDLTask() throws FileNotFoundException, IOException, SQLException {
        UseCase6Client c = new UseCase6Client();
        c.initialize();
        if (c.sttgid == 0) {
            c.executeDDL();
        }
    }

    private void executeDDL() throws FileNotFoundException, IOException, SQLException {
        String fn = this.getDDLFile(UseCase6Prms.getDDLFile());
        List<String> stmts = this.getDDLStatements(fn);
        for (String stmt : stmts) {
            block4: {
                if (this.queryAPI == 1 && stmt.contains("partition")) {
                    stmt = stmt + " buckets " + numBuckets;
                }
                Log.getLogWriter().info("Executing DDL: " + stmt);
                try {
                    this.execute(stmt, this.connection);
                }
                catch (SQLException e) {
                    if (!stmt.contains("DROP") || e.getMessage().indexOf("does not exist") != -1 || e.getMessage().indexOf("Unknown table ") != -1) break block4;
                    throw e;
                }
            }
            this.commitDDL();
        }
    }

    private ResultSet execute(String stmt, Connection conn) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt + " on: " + conn);
        }
        ResultSet rs = null;
        Statement s = conn.createStatement();
        boolean result = s.execute(stmt);
        if (result) {
            rs = s.getResultSet();
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt + " on: " + conn);
        }
        s.close();
        return rs;
    }

    private ResultSet executequery(String stmt, Connection conn) throws SQLException {
        ResultSet sel = null;
        PreparedStatement select = null;
        select = conn.prepareStatement(stmt);
        sel = select.executeQuery();
        int[] rowCounts = UseCase6Prms.getInitialRowCountToPopulateTable();
        if (sel.next()) {
            int count = sel.getInt(1);
            if (count == rowCounts[0]) {
                Log.getLogWriter().info("Found result count for query ( " + stmt + ") " + count);
            } else {
                throw new TestException("Expected result count for (" + stmt + ") is " + rowCounts[0] + " but found " + count);
            }
        }
        sel.close();
        sel = null;
        return sel;
    }

    private String getDDLFile(String fname) {
        String fn = "$JTESTS/cacheperf/comparisons/gemfirexd/useCase6/ddl/" + fname;
        String newfn = EnvHelper.expandEnvVars((String)fn);
        Log.getLogWriter().info("DDL file: " + newfn);
        return newfn;
    }

    private List<String> getDDLStatements(String fn) throws FileNotFoundException, IOException {
        Log.getLogWriter().info("Reading statements from " + fn);
        String text = FileUtil.getText((String)fn).trim();
        StringTokenizer tokenizer = new StringTokenizer(text, ";", false);
        ArrayList<String> stmts = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String stmt = tokenizer.nextToken().trim();
            stmts.add(stmt);
        }
        Log.getLogWriter().info("Read statements: " + stmts);
        return stmts;
    }

    private void commitDDL() {
        if (this.queryAPI != 1) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new QueryPerfException("Commit failed: " + e);
            }
        }
    }

    public static void dumpBucketsHook() {
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName.contains("server") || clientName.contains("sender") || clientName.contains("receiver") || clientName.contains("dbsync") || clientName.contains("prdata")) {
            Log.getLogWriter().info("Dumping local buckets");
            ResultSetHelper.dumpLocalBucket();
            Log.getLogWriter().info("Dumped local buckets");
        }
    }

    public static void dumpBucketsTask() {
        UseCase6Client c = new UseCase6Client();
        c.initialize();
        if (c.jid == 0) {
            Log.getLogWriter().info("Dumping local buckets");
            ResultSetHelper.dumpLocalBucket();
            Log.getLogWriter().info("Dumped local buckets");
        }
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.useCase6stats = this.getUseCase6Stats();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setUseCase6Stats(this.useCase6stats);
    }

    protected UseCase6Stats getUseCase6Stats() {
        this.useCase6stats = (UseCase6Stats)((Object)localuseCase6stats.get());
        return this.useCase6stats;
    }

    protected void setUseCase6Stats(UseCase6Stats useCase6stats) {
        localuseCase6stats.set((Object)useCase6stats);
    }

    @Override
    protected void initLocalParameters() {
        super.initLocalParameters();
        this.logQueries = QueryPrms.logQueries();
        this.logQueryResults = QueryPrms.logQueryResults();
    }

    @Override
    protected String nameFor(int name) {
        switch (name) {
            case 1580017: {
                return TRANSACTIONS_NAME;
            }
        }
        return super.nameFor(name);
    }

    @Override
    protected boolean getLogQueries() {
        return this.logQueries;
    }

    @Override
    protected void setLogQueries(boolean b) {
        this.logQueries = b;
    }

    public static void generateAndLoadDataTask() throws SQLException {
        UseCase6Client c = new UseCase6Client();
        c.initialize();
        if (c.ttgid == 0) {
            c.generateAndLoadData();
        }
    }

    private String getMapperFileAbsolutePath() {
        String mPath = System.getProperty("JTESTS") + "/" + TestConfig.tab().stringAt(UseCase6Prms.mapperFile, null);
        return mPath;
    }

    public void generateAndLoadData() throws SQLException {
        String[] tableNames = UseCase6Prms.getTableNames();
        int[] rowCounts = UseCase6Prms.getInitialRowCountToPopulateTable();
        String mapper = this.getMapperFileAbsolutePath();
        DataGeneratorHelper.initDataGenerator(mapper, tableNames, rowCounts, this.connection);
        this.populateTables(this.connection);
    }

    public void populateTables(Connection gConn) {
        int totalThreads = SqlUtilityHelper.totalTaskThreads();
        int ttgid = SqlUtilityHelper.ttgid();
        String[] tableNames = UseCase6Prms.getTableNames();
        for (int i = 0; i < tableNames.length; ++i) {
            if (ttgid % totalThreads != totalThreads - 1 || SqlUtilityHelper.getRowsInTable(tableNames[i], gConn) > 0) continue;
            this.populateTables(tableNames[i], gConn);
        }
    }

    private void populateTables(String fullTableName, Connection gConn) {
        String[] names = fullTableName.trim().split("\\.");
        String schemaName = names[0];
        String tableName = names[1];
        String csvFilePath = DataGeneratorBB.getCSVFileName(fullTableName);
        this.importTablesToGfxd(gConn, schemaName, tableName, csvFilePath);
        this.commitDDL();
    }

    private void importTablesToGfxd(Connection conn, String schema, String table, String csvPath) {
        Log.getLogWriter().info("Gfxd - Data Population Started for " + schema + "." + table + " using " + csvPath);
        String delimitor = ",";
        String procedure = "sql.datagen.ImportOraDG";
        String importTable = "CALL SYSCS_UTIL.IMPORT_DATA_EX(?, ?, null,null, ?, ?, NULL, NULL, 0, 0, 10, 0, ?, null)";
        try {
            CallableStatement cs = conn.prepareCall(importTable);
            cs.setString(1, schema.toUpperCase());
            cs.setString(2, table.toUpperCase());
            cs.setString(3, csvPath);
            cs.setString(4, delimitor);
            cs.setString(5, procedure);
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        Log.getLogWriter().info("Gfxd - Data Population Completed for " + schema + "." + table);
    }

    public static void storeUniqueDataFromTableTask() throws SQLException {
        UseCase6Client c = new UseCase6Client();
        c.initialize();
        c.storeUniqueDataFromTable();
    }

    private void storeUniqueDataFromTable() throws SQLException {
        UseCase6Client.paramValues[0] = new ArrayList();
        UseCase6Client.paramValues[1] = new ArrayList();
        PreparedStatement ps = this.connection.prepareStatement("select distinct msisdn, walletname from OLTP_PNP_Subscriptions");
        ResultSet paramRS = ps.executeQuery();
        Log.getLogWriter().info("populating msisdn and walletnames");
        int counter = 0;
        while (paramRS.next()) {
            paramValues[0].add(paramRS.getString(1));
            paramValues[1].add(paramRS.getString(2));
            if (++counter % 50000 != 0) continue;
            Log.getLogWriter().info("done loading " + counter + " items");
        }
        paramRS.close();
        ps.close();
    }

    public static void selectAndUpdateTask() throws SQLException {
        UseCase6Client c = new UseCase6Client();
        c.initialize(1580017);
        c.useCase6SelectAndUpdate();
    }

    private void useCase6SelectAndUpdateTask() throws SQLException {
        Random rand = new Random();
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void useCase6SelectAndUpdate() throws SQLException {
        PreparedStatement update = null;
        PreparedStatement select = null;
        for (int iter = 0; iter < paramValues[0].size(); ++iter) {
            long start = this.useCase6stats.startTransaction();
            select = this.connection.prepareStatement(selstm);
            update = this.connection.prepareStatement(updstm);
            select.setString(1, paramValues[0].get(iter));
            select.setString(2, paramValues[1].get(iter));
            ResultSet sel = select.executeQuery();
            sel.next();
            String id = sel.getString(1);
            sel.close();
            update.clearParameters();
            long tpsBegin = System.currentTimeMillis();
            Timestamp ts = new Timestamp(tpsBegin);
            update.setTimestamp(1, ts);
            update.setString(2, id);
            update.executeUpdate();
            this.connection.commit();
            this.useCase6stats.endTransaction(start, 0L);
            if (select != null) {
                select.close();
                select = null;
            }
            if (update == null) continue;
            update.close();
            update = null;
        }
    }
}

