/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd.useCase6;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.HistogramStats;
import perffmwk.PerformanceStatistics;

public class UseCase6Stats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    public static final String VM_COUNT = "vmCount";
    protected static final String SELECTUPDATE_TX_COMPLETED = "selectUpdateTxCompleted";
    protected static final String SELECTUPDATE_TX_TIME = "selectUpdateTxTime";
    private static boolean VMCounted = false;

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{UseCase6Stats.factory().createIntGauge(VM_COUNT, "When aggregated, the number of VMs using this statistics object.", "VMs"), UseCase6Stats.factory().createIntCounter(SELECTUPDATE_TX_COMPLETED, "Number of select and update transactions completed (committed).", "operations", largerIsBetter), UseCase6Stats.factory().createLongCounter(SELECTUPDATE_TX_TIME, "Total time spent on select and update transactions that were completed (committed).", "nanoseconds", !largerIsBetter)};
    }

    public static UseCase6Stats getInstance() {
        UseCase6Stats tps = (UseCase6Stats)UseCase6Stats.getInstance(UseCase6Stats.class, (int)0);
        tps.incVMCount();
        return tps;
    }

    public static UseCase6Stats getInstance(String name) {
        UseCase6Stats tps = (UseCase6Stats)UseCase6Stats.getInstance(UseCase6Stats.class, (int)0, (String)name);
        tps.incVMCount();
        return tps;
    }

    public static UseCase6Stats getInstance(String name, String trimspecName) {
        UseCase6Stats tps = (UseCase6Stats)UseCase6Stats.getInstance(UseCase6Stats.class, (int)0, (String)name, (String)trimspecName);
        tps.incVMCount();
        return tps;
    }

    public UseCase6Stats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    private synchronized void incVMCount() {
        if (!VMCounted) {
            this.statistics().incInt(VM_COUNT, 1);
            VMCounted = true;
        }
    }

    public void incHistogram(HistogramStats histogram, long amount) {
        if (histogram != null) {
            histogram.incBin(amount);
        }
    }

    public long startCommit() {
        return NanoTimer.getTime();
    }

    public long startTransaction() {
        return NanoTimer.getTime();
    }

    public void endTransaction(long start, long commitStart) {
        long end = NanoTimer.getTime();
        long elapsed = end - start;
        this.statistics().incInt(SELECTUPDATE_TX_COMPLETED, 1);
        this.statistics().incLong(SELECTUPDATE_TX_TIME, elapsed);
    }

    public static enum Stmt {
        selstm,
        inslog,
        updbal,
        insbal,
        updterm,
        insterm,
        instkt,
        instsn;

    }
}

