/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.poc.useCase6;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdbcDaoBase {
    public Connection con = null;
    private SqlBuilder sql = null;
    protected PreparedStatement ps = null;
    private ResultSet rs = null;
    protected boolean fineEnabled = false;
    Map<String, PreparedStatement> psCache = new HashMap<String, PreparedStatement>();

    protected JdbcDaoBase() {
        this.con = null;
        this.fineEnabled = Log.getLogWriter().fineEnabled();
    }

    protected JdbcDaoBase(Connection connection) {
        this.con = connection;
    }

    protected Connection getConnection() {
        if (this.con == null) {
            // empty if block
        }
        return this.con;
    }

    protected SqlBuilder createSqlBuilder(int size) {
        this.sql = new SqlBuilder(size);
        return this.sql;
    }

    protected SqlBuilder getSqlBuilder() {
        return this.sql;
    }

    protected void setSqlBuilderql(SqlBuilder sql) {
        this.sql = sql;
    }

    protected void sqlTransrator(SQLException e1) {
        if (this.ps != null) {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException e2) {
                    throw new RuntimeException(e2);
                }
            }
            try {
                this.ps.close();
            }
            catch (SQLException e2) {
                throw new RuntimeException(e2);
            }
        }
        throw new RuntimeException(e1);
    }

    protected PreparedStatement createPrepareStatement(String sql) throws SQLException {
        this.ps = this.con.prepareStatement(sql);
        return this.ps;
    }

    protected PreparedStatement createPrepareStatement(SqlBuilder sql) throws SQLException {
        this.ps = this.con.prepareStatement(sql.getBuf().toString());
        return this.ps;
    }

    protected void close() throws SQLException {
    }

    protected void sqlTransrator(SQLException e, String msg) {
        block3: {
            if (this.fineEnabled) {
                Log.getLogWriter().fine((Throwable)e);
            }
            try {
                this.close();
            }
            catch (SQLException e2) {
                if (!this.fineEnabled) break block3;
                Log.getLogWriter().fine((Throwable)e);
            }
        }
        throw new RuntimeException(msg, e);
    }

    protected ResultSet executeQuery() {
        return this.prepareStatemet(this.sql);
    }

    protected ResultSet prepareStatemet(SqlBuilder sql) {
        StringBuilder buf = sql.getBuf();
        String sqlStr = buf.toString();
        if (this.fineEnabled) {
            Log.getLogWriter().fine(sqlStr);
        }
        List<Object> params = sql.getParams();
        try {
            this.ps = this.psCache.get(sqlStr);
            if (this.ps == null) {
                this.ps = this.con.prepareStatement(sqlStr);
                this.psCache.put(sqlStr, this.ps);
                Log.getLogWriter().info(" NOT in PS Cache ...");
            }
            if (params != null) {
                for (int i = 0; i < params.size(); ++i) {
                    Object obj = params.get(i);
                    if (obj instanceof String) {
                        this.ps.setString(i + 1, (String)obj);
                        if (!this.fineEnabled) continue;
                        Log.getLogWriter().fine("params(" + i + ")[String] " + (String)obj);
                        continue;
                    }
                    if (obj instanceof java.sql.Date) {
                        this.ps.setDate(i + 1, (java.sql.Date)obj);
                        if (!this.fineEnabled) continue;
                        Log.getLogWriter().fine("params(" + i + ")[Date] " + ((java.sql.Date)obj).toString());
                        continue;
                    }
                    if (!(obj instanceof Double)) continue;
                    this.ps.setDouble(i + 1, (Double)obj);
                    if (!this.fineEnabled) continue;
                    Log.getLogWriter().fine("params(" + i + ")[Double] " + (Double)obj);
                }
            }
        }
        catch (SQLException e) {
            this.sqlTransrator(e);
        }
        return this.rs;
    }

    protected class SqlBuilder {
        private StringBuilder buf;
        private List<Object> params;

        private SqlBuilder() {
        }

        private SqlBuilder(int size) {
            this.buf = new StringBuilder(size);
        }

        public void append(SqlBuilder sql) {
            if (sql == null) {
                throw new IllegalArgumentException();
            }
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.buf.append(sql.getBuf().toString());
            for (Object obj : sql.getParams()) {
                this.params.add(obj);
            }
        }

        public void append(String str) {
            if (str == null) {
                throw new IllegalArgumentException();
            }
            this.buf.append(str);
            this.buf.append(" ");
        }

        public void append(String str, String val) {
            if (val == null) {
                throw new IllegalArgumentException();
            }
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.add(val);
            this.buf.append(str);
            this.buf.append(" ");
        }

        public void append(String str, String val1, String val2) {
            if (val1 == null || val2 == null) {
                throw new IllegalArgumentException();
            }
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.add(val1);
            this.params.add(val2);
            this.buf.append(str);
            this.buf.append(" ");
        }

        public void appendIfNotNull(String str, String val) {
            if (val == null) {
                return;
            }
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.add(val);
            this.buf.append(str);
            this.buf.append(" ");
        }

        public void appendIfNotNull(String str, String val1, String val2) {
            if (val1 == null && val2 == null) {
                return;
            }
            if (val1 == null || val2 == null) {
                throw new IllegalArgumentException();
            }
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.add(val1);
            this.params.add(val2);
            this.buf.append(str);
            this.buf.append(" ");
        }

        public void append(String str, Date val) {
            if (val == null) {
                throw new IllegalArgumentException();
            }
            this.append(str, new java.sql.Date(val.getTime()));
        }

        public void append(String str, java.sql.Date val) {
            if (val == null) {
                throw new IllegalArgumentException();
            }
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.add(val);
            this.buf.append(str);
            this.buf.append(" ");
        }

        public void append(String str, double val) {
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.add(val);
            this.buf.append(str);
            this.buf.append(" ");
        }

        public void appendIfNotNull(String str, Date val) {
            if (val == null) {
                return;
            }
            this.appendIfNotNull(str, new java.sql.Date(val.getTime()));
        }

        public void appendIfNotNull(String str, java.sql.Date val) {
            if (val == null) {
                return;
            }
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.add(val);
            this.buf.append(str);
            this.buf.append(" ");
        }

        public StringBuilder getBuf() {
            return this.buf;
        }

        public void setBuf(StringBuilder buf) {
            this.buf = buf;
        }

        public List<Object> getParams() {
            return this.params;
        }

        public void setParams(List<Object> params) {
            this.params = params;
        }
    }
}

