/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.app.tpce.jpa.entity;

import com.pivotal.gemfirexd.app.tpce.jpa.entity.Company;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.DailyMarket;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.Exchange;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.Holding;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.HoldingSummary;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.LastTrade;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.StatusType;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.Trade;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.TradeRequest;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.WatchList;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="SECURITY")
@NamedNativeQueries(value={@NamedNativeQuery(name="FindSecurityByCompany", query="select s_ex_id, s_name, s_symb from security where s_co_id = ?1 and s_issue = ?2", resultSetMapping="FindSecurityByCompanyResults"), @NamedNativeQuery(name="FindSecurityBySymbol", query="select s_co_id, s_ex_id, s_name from security where s_symb = ?1", resultSetMapping="FindSecurityBySymbolResults")})
@SqlResultSetMappings(value={@SqlResultSetMapping(name="FindSecurityByCompanyResults", columns={@ColumnResult(name="s_ex_id"), @ColumnResult(name="s_name"), @ColumnResult(name="s_symb")}), @SqlResultSetMapping(name="FindSecurityBySymbolResults", columns={@ColumnResult(name="s_co_id"), @ColumnResult(name="s_ex_id"), @ColumnResult(name="s_name")})})
public class Security
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="S_SYMB", unique=true, nullable=false, length=15)
    private String sSymb;
    @Column(name="S_52WK_HIGH", nullable=false)
    private double s52wkHigh;
    @Temporal(value=TemporalType.DATE)
    @Column(name="S_52WK_HIGH_DATE", nullable=false)
    private Date s52wkHighDate;
    @Column(name="S_52WK_LOW", nullable=false)
    private double s52wkLow;
    @Temporal(value=TemporalType.DATE)
    @Column(name="S_52WK_LOW_DATE", nullable=false)
    private Date s52wkLowDate;
    @Column(name="S_DIVIDEND", nullable=false)
    private double sDividend;
    @Temporal(value=TemporalType.DATE)
    @Column(name="S_EXCH_DATE", nullable=false)
    private Date sExchDate;
    @Column(name="S_ISSUE", nullable=false, length=6)
    private String sIssue;
    @Column(name="S_NAME", nullable=false, length=70)
    private String sName;
    @Column(name="S_NUM_OUT", nullable=false)
    private long sNumOut;
    @Column(name="S_PE", nullable=false)
    private double sPe;
    @Temporal(value=TemporalType.DATE)
    @Column(name="S_START_DATE", nullable=false)
    private Date sStartDate;
    @Column(name="S_YIELD", nullable=false)
    private double sYield;
    @OneToMany(mappedBy="security")
    private Set<DailyMarket> dailyMarkets;
    @OneToMany(mappedBy="security")
    private Set<Holding> holdings;
    @OneToMany(mappedBy="security")
    private Set<HoldingSummary> holdingSummary;
    @OneToOne(mappedBy="security", fetch=FetchType.LAZY)
    private LastTrade lastTrade;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="S_CO_ID", nullable=false)
    private Company company;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="S_EX_ID", nullable=false)
    private Exchange exchange;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="S_ST_ID", nullable=false)
    private StatusType statusType;
    @OneToMany(mappedBy="security")
    private Set<Trade> trades;
    @OneToMany(mappedBy="security")
    private Set<TradeRequest> tradeRequests;
    @ManyToMany(mappedBy="securities")
    private Set<WatchList> watchLists;

    public String getSSymb() {
        return this.sSymb;
    }

    public void setSSymb(String sSymb) {
        this.sSymb = sSymb;
    }

    public double getS52wkHigh() {
        return this.s52wkHigh;
    }

    public void setS52wkHigh(double s52wkHigh) {
        this.s52wkHigh = s52wkHigh;
    }

    public Date getS52wkHighDate() {
        return this.s52wkHighDate;
    }

    public void setS52wkHighDate(Date s52wkHighDate) {
        this.s52wkHighDate = s52wkHighDate;
    }

    public double getS52wkLow() {
        return this.s52wkLow;
    }

    public void setS52wkLow(double s52wkLow) {
        this.s52wkLow = s52wkLow;
    }

    public Date getS52wkLowDate() {
        return this.s52wkLowDate;
    }

    public void setS52wkLowDate(Date s52wkLowDate) {
        this.s52wkLowDate = s52wkLowDate;
    }

    public double getSDividend() {
        return this.sDividend;
    }

    public void setSDividend(double sDividend) {
        this.sDividend = sDividend;
    }

    public Date getSExchDate() {
        return this.sExchDate;
    }

    public void setSExchDate(Date sExchDate) {
        this.sExchDate = sExchDate;
    }

    public String getSIssue() {
        return this.sIssue;
    }

    public void setSIssue(String sIssue) {
        this.sIssue = sIssue;
    }

    public String getSName() {
        return this.sName;
    }

    public void setSName(String sName) {
        this.sName = sName;
    }

    public long getSNumOut() {
        return this.sNumOut;
    }

    public void setSNumOut(long sNumOut) {
        this.sNumOut = sNumOut;
    }

    public double getSPe() {
        return this.sPe;
    }

    public void setSPe(double sPe) {
        this.sPe = sPe;
    }

    public Date getSStartDate() {
        return this.sStartDate;
    }

    public void setSStartDate(Date sStartDate) {
        this.sStartDate = sStartDate;
    }

    public double getSYield() {
        return this.sYield;
    }

    public void setSYield(double sYield) {
        this.sYield = sYield;
    }

    public Set<DailyMarket> getDailyMarkets() {
        return this.dailyMarkets;
    }

    public void setDailyMarkets(Set<DailyMarket> dailyMarkets) {
        this.dailyMarkets = dailyMarkets;
    }

    public Set<Holding> getHoldings() {
        return this.holdings;
    }

    public void setHoldings(Set<Holding> holdings) {
        this.holdings = holdings;
    }

    public Set<HoldingSummary> getHoldingSummary() {
        return this.holdingSummary;
    }

    public void setHoldingSummaryTbls(Set<HoldingSummary> holdingSummary) {
        this.holdingSummary = holdingSummary;
    }

    public LastTrade getLastTrade() {
        return this.lastTrade;
    }

    public void setLastTrade(LastTrade lastTrade) {
        this.lastTrade = lastTrade;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public StatusType getStatusType() {
        return this.statusType;
    }

    public void setStatusType(StatusType statusType) {
        this.statusType = statusType;
    }

    public Set<Trade> getTrades() {
        return this.trades;
    }

    public void setTrades(Set<Trade> trades) {
        this.trades = trades;
    }

    public Set<TradeRequest> getTradeRequests() {
        return this.tradeRequests;
    }

    public void setTradeRequests(Set<TradeRequest> tradeRequests) {
        this.tradeRequests = tradeRequests;
    }

    public Set<WatchList> getWatchLists() {
        return this.watchLists;
    }

    public void setWatchLists(Set<WatchList> watchLists) {
        this.watchLists = watchLists;
    }
}

