/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.app.tpce.jpa.txn;

import com.pivotal.gemfirexd.app.tpce.TPCETxnInput;
import com.pivotal.gemfirexd.app.tpce.TPCETxnOutput;
import com.pivotal.gemfirexd.app.tpce.input.BrokerVolumeTxnInput;
import com.pivotal.gemfirexd.app.tpce.jpa.txn.JpaTransaction;
import com.pivotal.gemfirexd.app.tpce.output.BrokerVolumeTxnOutput;
import java.util.List;

public class JpaBrokerVolume
extends JpaTransaction {
    private String brokerVolumeQueryTemplate = "select B_NAME, SUM(TR_QTY * TR_BID_PRICE) from TRADE_REQUEST, SECTOR, INDUSTRY, COMPANY, BROKER, SECURITY, CUSTOMER_ACCOUNT where TR_CA_ID = CA_ID and CA_B_ID = B_ID and TR_S_SYMB = S_SYMB and S_CO_ID = CO_ID and CO_IN_ID = IN_ID and SC_ID = IN_SC_ID and B_NAME in (%BROKER_LIST%) and SC_NAME = :scName group by B_NAME order by 2 DESC";
    protected BrokerVolumeTxnInput bvTxnInput = null;
    protected BrokerVolumeTxnOutput bvTxnOutput = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TPCETxnOutput runTxn(TPCETxnInput txnInput) {
        this.bvTxnOutput = new BrokerVolumeTxnOutput();
        this.bvTxnInput = (BrokerVolumeTxnInput)txnInput;
        try {
            this.invokeFrame1();
        }
        finally {
            this.jpaTxnManager.close();
        }
        if (this.bvTxnOutput.getListLen() < 0 || this.bvTxnOutput.getListLen() > 40) {
            int status = -111;
            this.bvTxnOutput.setStatus(status);
            throw new IllegalStateException("Volume length " + this.bvTxnOutput.getListLen() + " is not valid. Status: " + status);
        }
        return this.bvTxnOutput;
    }

    protected void invokeFrame1() {
        String query = this.buildBrokerVolumeQuery();
        this.jpaTxnManager.beginTransaction();
        List rs = null;
        try {
            rs = this.entityManager.createNativeQuery(query).setParameter("scName", (Object)this.bvTxnInput.getSectorName()).getResultList();
        }
        catch (RuntimeException re) {
            this.jpaTxnManager.rollback();
            throw re;
        }
        this.jpaTxnManager.commit();
        this.bvTxnOutput.setListLen(rs.size());
        this.addVolumeToOutput(rs);
    }

    private void addVolumeToOutput(List<Object[]> rs) {
        for (Object[] rsEntry : rs) {
            this.bvTxnOutput.getVolumeArray().add((Double)rsEntry[1]);
        }
    }

    private String buildBrokerVolumeQuery() {
        if (this.bvTxnInput == null) {
            throw new IllegalStateException("Inproperly called buildBrokerVolumeQuery");
        }
        StringBuffer queryInClause = new StringBuffer();
        List<String> brokerList = this.bvTxnInput.getBrokerList();
        int brokerTotal = brokerList.size();
        int brokerCount = 0;
        for (String broker : brokerList) {
            queryInClause.append("'").append(broker).append("'");
            if (++brokerCount >= brokerTotal) continue;
            queryInClause.append(", ");
        }
        return this.brokerVolumeQueryTemplate.replaceAll("%BROKER_LIST%", queryInClause.toString());
    }
}

