/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.app.tpce.jpa.txn;

import com.pivotal.gemfirexd.app.tpce.TPCETxnInput;
import com.pivotal.gemfirexd.app.tpce.TPCETxnOutput;
import com.pivotal.gemfirexd.app.tpce.input.CustomerPositionTxnInput;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.Customer;
import com.pivotal.gemfirexd.app.tpce.jpa.txn.JpaTransaction;
import com.pivotal.gemfirexd.app.tpce.output.CustomerPositionTxnOutput;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;

public class JpaCustomerPosition
extends JpaTransaction {
    private static final String CUSTOMER_TID_QUERY = "FROM Customer c where c.cTaxId = :taxId";
    private static final String CUSTOMER_CID_QUERY = "FROM Customer c where c.cId = :cId";
    private static final String ASSET_CID_QUERY = "SELECT ca.caId, ca.caBal, SUM(hs.hsQty*lt.ltPrice) FROM CustomerAccount ca LEFT OUTER JOIN ca.holdingSummary hs, LastTrade lt WHERE hs.id.hsSSymb = lt.ltSSymb AND ca.customer.cId = :cId GROUP BY ca.caId, ca.caBal ORDER BY 3 ASC";
    private static final String HISTORY_ACCTID_NATVIE_QUERY = "SELECT t.T_ID, t.T_S_SYMB, t.T_QTY, st.ST_NAME, th.TH_DTS FROM TRADE t, TRADE_HISTORY th, STATUS_TYPE st WHERE t.T_CA_ID = :tCaId AND th.TH_T_ID = t.T_ID AND st.ST_ID = th.TH_ST_ID ORDER BY th.TH_DTS DESC, t.T_DTS DESC";
    protected CustomerPositionTxnInput cpTxnInput = null;
    protected CustomerPositionTxnOutput cpTxnOutput = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TPCETxnOutput runTxn(TPCETxnInput txnInput) {
        this.cpTxnOutput = new CustomerPositionTxnOutput();
        this.cpTxnInput = (CustomerPositionTxnInput)txnInput;
        try {
            this.invokeFrame1();
            if (this.cpTxnInput.getHistory() == 1L) {
                long historyAcctId = this.cpTxnOutput.getAcctIdArray().get(this.cpTxnInput.getAcctIdIndex());
                this.invokeFrame2(historyAcctId);
            } else {
                this.invokeFrame3();
            }
        }
        finally {
            this.jpaTxnManager.close();
        }
        return this.cpTxnOutput;
    }

    protected void invokeFrame1() {
        this.jpaTxnManager.beginTransaction();
        Customer customer = null;
        try {
            customer = this.cpTxnInput.getCustId() == 0L ? (Customer)this.entityManager.createQuery(CUSTOMER_TID_QUERY).setParameter("taxId", (Object)this.cpTxnInput.getTaxId()).getSingleResult() : (Customer)this.entityManager.createQuery(CUSTOMER_CID_QUERY).setParameter("cId", (Object)this.cpTxnInput.getCustId()).getSingleResult();
        }
        catch (RuntimeException re) {
            this.jpaTxnManager.rollback();
            throw re;
        }
        this.addCustomerToOutput(customer);
        List rs = null;
        try {
            rs = this.entityManager.createQuery(ASSET_CID_QUERY).setParameter("cId", (Object)customer.getCId()).setMaxResults(10).getResultList();
        }
        catch (RuntimeException re) {
            this.jpaTxnManager.rollback();
            throw re;
        }
        this.cpTxnOutput.setAcctLen(rs.size());
        if (this.cpTxnOutput.getAcctLen() < 1 || this.cpTxnOutput.getAcctLen() > 10) {
            this.jpaTxnManager.rollback();
            int status = -121;
            throw new IllegalStateException("Account length " + this.cpTxnOutput.getAcctLen() + " is not valid. Status: " + status);
        }
        this.addAssetsToOutput(rs);
    }

    protected void invokeFrame2(long acctId) {
        List rs = null;
        try {
            rs = this.entityManager.createNativeQuery(HISTORY_ACCTID_NATVIE_QUERY).setParameter("tCaId", (Object)acctId).setMaxResults(30).getResultList();
        }
        catch (RuntimeException re) {
            this.jpaTxnManager.rollback();
            throw re;
        }
        this.addHistoryToOutput(rs);
        if (this.cpTxnOutput.getHistLen() < 10 || this.cpTxnOutput.getHistLen() > 30) {
            this.jpaTxnManager.rollback();
            int status = -121;
            throw new IllegalStateException("History length for customer account " + acctId + " is " + this.cpTxnOutput.getHistLen() + " ;Not valid! Status: " + status);
        }
        this.jpaTxnManager.commit();
    }

    protected void invokeFrame3() {
        this.jpaTxnManager.commit();
    }

    private void addCustomerToOutput(Customer customer) {
        this.cpTxnOutput.setCId(customer.getCId());
        this.cpTxnOutput.setCAdId(customer.getCAdId());
        this.cpTxnOutput.setCArea1(customer.getCArea1());
        this.cpTxnOutput.setCArea2(customer.getCArea2());
        this.cpTxnOutput.setCArea3(customer.getCArea3());
        this.cpTxnOutput.setCCtry1(customer.getCCtry1());
        this.cpTxnOutput.setCCtry2(customer.getCCtry2());
        this.cpTxnOutput.setCCtry3(customer.getCCtry3());
        this.cpTxnOutput.setCDob(customer.getCDob());
        this.cpTxnOutput.setCEmail1(customer.getCEmail1());
        this.cpTxnOutput.setCEmail2(customer.getCEmail2());
        this.cpTxnOutput.setCExt1(customer.getCExt1());
        this.cpTxnOutput.setCExt2(customer.getCExt2());
        this.cpTxnOutput.setCExt3(customer.getCExt3());
        this.cpTxnOutput.setCFName(customer.getCFName());
        this.cpTxnOutput.setCGndr(customer.getCGndr());
        this.cpTxnOutput.setCLName(customer.getCLName());
        this.cpTxnOutput.setCLocal1(customer.getCLocal1());
        this.cpTxnOutput.setCLocal2(customer.getCLocal2());
        this.cpTxnOutput.setCLocal3(customer.getCLocal3());
        this.cpTxnOutput.setCMName(customer.getCMName());
        this.cpTxnOutput.setCStId(customer.getCStId());
        this.cpTxnOutput.setCTier(customer.getCTier());
    }

    private void addAssetsToOutput(List<Object[]> assets) {
        for (Object[] asset : assets) {
            this.cpTxnOutput.getAcctIdArray().add((Long)asset[0]);
            this.cpTxnOutput.getCashBalArray().add((Double)asset[1]);
            this.cpTxnOutput.getAssetTotalArray().add(asset[2] == null ? 0.0 : (Double)asset[2]);
        }
    }

    private void addHistoryToOutput(List<Object[]> histories) {
        int distinctTradeIdSize = 0;
        for (Object[] history : histories) {
            Long tradeId = ((BigInteger)history[0]).longValue();
            if (!this.cpTxnOutput.getTradeIdArray().contains(tradeId)) {
                ++distinctTradeIdSize;
            }
            if (distinctTradeIdSize > 10) break;
            this.cpTxnOutput.getTradeIdArray().add(tradeId);
            this.cpTxnOutput.getSymbolArray().add((String)history[1]);
            this.cpTxnOutput.getQtyArray().add((Integer)history[2]);
            this.cpTxnOutput.getTradeStatusArray().add((String)history[3]);
            this.cpTxnOutput.getHistDtsArray().add((Timestamp)history[4]);
        }
        this.cpTxnOutput.setHistLen(this.cpTxnOutput.getTradeIdArray().size());
    }
}

