/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.app.tpce.jpa.txn;

import com.pivotal.gemfirexd.app.tpce.TPCETxnInput;
import com.pivotal.gemfirexd.app.tpce.TPCETxnOutput;
import com.pivotal.gemfirexd.app.tpce.input.TradeOrderTxnInput;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.Broker;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.Charge;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.ChargePK;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.Customer;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.CustomerAccount;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.Security;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.StatusType;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.Trade;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.TradeHistory;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.TradeHistoryPK;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.TradeRequest;
import com.pivotal.gemfirexd.app.tpce.jpa.entity.TradeType;
import com.pivotal.gemfirexd.app.tpce.jpa.txn.JpaTransaction;
import com.pivotal.gemfirexd.app.tpce.output.TradeOrderTxnOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;

public class JpaTradeOrder
extends JpaTransaction {
    protected TradeOrderTxnInput toTxnInput = null;
    protected TradeOrderTxnOutput toTxnOutput = null;
    protected Customer customer = null;
    protected CustomerAccount customerAccount = null;
    protected Broker broker = null;
    BigDecimal commissionRate = null;
    double chargeAmount = 0.0;
    String statusId = null;
    String securitySymbol = null;
    double requestedPrice = 0.0;
    short ttIsMrkt = (short)-1;
    private static final String CUSTOMER_ACCOUNT_QUERY = "from CustomerAccount ca where ca.caId = :caId";
    private static final String PERMISSION_QUERY = "select ap.apAcl from AccountPermission ap where ap.id.apCaId = :caId and ap.id.apTaxId = :taxId and ap.apLName = :lName and ap.apFName = :fName";
    private static final String LAST_TRADE_QUERY = "select lt_price from last_trade where lt_s_symb = ?1";
    private static final String HOLDING_SUMMARY_QUERY = "select hs_qty from holding_summary where hs_ca_id = ?1 and hs_s_symb =?2";
    private static final String CUSTOMER_TOTAL_TAX_QUERY = "select sum(tx_rate) from taxrate where tx_id in (select cx_tx_id from customer_taxrate where cx_c_id = ?)";
    private static final String HOLDING_ASSETS_QUERY = "select sum(hs_qty * lt_price) from holding_summary, last_trade where hs_ca_id = ? and lt_s_symb = hs_s_symb";

    @Override
    public TPCETxnOutput runTxn(TPCETxnInput txnInput) {
        this.toTxnInput = (TradeOrderTxnInput)txnInput;
        this.toTxnOutput = new TradeOrderTxnOutput();
        try {
            this.invokeFrame1();
            if (!(this.toTxnInput.getExecLastName().equalsIgnoreCase(this.customer.getCLName()) && this.toTxnInput.getExecLastName().equalsIgnoreCase(this.customer.getCFName()) && this.toTxnInput.getExecTaxId().equalsIgnoreCase(this.customer.getCTaxId()))) {
                this.invokeFrame2();
            }
            this.invokeFrame3();
            this.invokeFrame4();
            this.invokeFrame5();
            this.invokeFrame6();
        }
        catch (RuntimeException re) {
            this.jpaTxnManager.rollback();
            throw re;
        }
        finally {
            this.jpaTxnManager.close();
        }
        return this.toTxnOutput;
    }

    protected void invokeFrame1() {
        this.jpaTxnManager.beginTransaction();
        try {
            this.customerAccount = (CustomerAccount)this.entityManager.createQuery(CUSTOMER_ACCOUNT_QUERY).setParameter("caId", (Object)this.toTxnInput.getAcctId()).getSingleResult();
        }
        catch (NoResultException nre) {
            this.toTxnOutput.setStatus(-711);
            throw nre;
        }
        catch (NonUniqueResultException nure) {
            this.toTxnOutput.setStatus(-711);
            throw nure;
        }
        catch (RuntimeException re) {
            throw re;
        }
        this.customer = this.customerAccount.getCustomer();
        this.broker = this.customerAccount.getBroker();
    }

    protected void invokeFrame2() {
        List apAclList = this.entityManager.createQuery(PERMISSION_QUERY).setParameter("caId", (Object)this.toTxnInput.getAcctId()).setParameter("taxId", (Object)this.toTxnInput.getExecTaxId()).setParameter("lName", (Object)this.toTxnInput.getExecLastName()).setParameter("fName", (Object)this.toTxnInput.getExecFirstName()).getResultList();
        if (apAclList.get(0) == null) {
            this.toTxnOutput.setStatus(-721);
            throw new IllegalStateException("No account permission was found. Status: -721");
        }
    }

    protected void invokeFrame3() {
        int holdQty;
        Object[] holding;
        int i;
        Query holdingQuery;
        Object[] securityArray;
        long companyId = -1L;
        String companyName = this.toTxnInput.getCoName();
        this.securitySymbol = this.toTxnInput.getSymbol().trim();
        String exchangeId = null;
        String securityName = null;
        if (this.securitySymbol.isEmpty()) {
            companyId = ((BigInteger)this.entityManager.createNamedQuery("FindCompanyByName").setParameter(1, (Object)companyName).getSingleResult()).longValue();
            securityArray = (Object[])this.entityManager.createNamedQuery("FindSecurityByCompany").setParameter(1, (Object)companyId).setParameter(2, (Object)this.toTxnInput.getIssue()).getSingleResult();
            exchangeId = (String)securityArray[0];
            securityName = (String)securityArray[1];
            this.securitySymbol = (String)securityArray[2];
        } else {
            securityArray = (Object[])this.entityManager.createNamedQuery("FindSecurityBySymbol").setParameter(1, (Object)this.securitySymbol).getSingleResult();
            companyId = ((BigInteger)securityArray[0]).longValue();
            exchangeId = (String)securityArray[1];
            securityName = (String)securityArray[2];
            companyName = (String)this.entityManager.createNamedQuery("FindCompanyById").setParameter(1, (Object)companyId).getSingleResult();
        }
        double marketPrice = (Double)this.entityManager.createNativeQuery(LAST_TRADE_QUERY).setParameter(1, (Object)this.securitySymbol).getSingleResult();
        Object[] tt = (Object[])this.entityManager.createNamedQuery("FindTradeOrderTTQuery").setParameter(1, (Object)this.toTxnInput.getTradeTypeId()).getSingleResult();
        this.ttIsMrkt = (Short)tt[0];
        short ttIsSell = (Short)tt[1];
        this.requestedPrice = this.ttIsMrkt == 1 ? marketPrice : this.toTxnInput.getRequestedPrice();
        int hsQty = 0;
        List hsQtyList = this.entityManager.createNativeQuery(HOLDING_SUMMARY_QUERY).setParameter(1, (Object)this.toTxnInput.getAcctId()).setParameter(2, (Object)this.securitySymbol).getResultList();
        if (hsQtyList.size() > 0) {
            hsQty = (Integer)hsQtyList.get(0);
        }
        double buyValue = 0.0;
        double sellValue = 0.0;
        long neededQty = this.toTxnInput.getTradeQty();
        if (ttIsSell == 1) {
            if (hsQty > 0) {
                holdingQuery = null;
                holdingQuery = this.toTxnInput.getIsLifo() == 1L ? this.entityManager.createNamedQuery("FindHolidingByCaIdSymbDesc") : this.entityManager.createNamedQuery("FindHolidingByCaIdSymbAsc");
                List holdingList = holdingQuery.setParameter(1, (Object)this.toTxnInput.getAcctId()).setParameter(2, (Object)this.securitySymbol).getResultList();
                for (i = 0; i < holdingList.size() && neededQty != 0L; ++i) {
                    holding = (Object[])holdingList.get(i);
                    holdQty = (Integer)holding[0];
                    double holdPrice = (Double)holding[1];
                    if ((long)holdQty > neededQty) {
                        buyValue += (double)neededQty * holdPrice;
                        sellValue += (double)neededQty * this.requestedPrice;
                        neededQty = 0L;
                        continue;
                    }
                    buyValue += (double)holdQty * holdPrice;
                    sellValue += (double)holdQty * this.requestedPrice;
                    neededQty -= (long)holdQty;
                }
            }
        } else if (hsQty < 0) {
            holdingQuery = null;
            holdingQuery = this.toTxnInput.getIsLifo() == 1L ? this.entityManager.createNamedQuery("FindHolidingByCaIdSymbDesc") : this.entityManager.createNamedQuery("FindHolidingByCaIdSymbAsc");
            List holdingList = holdingQuery.setParameter(1, (Object)this.toTxnInput.getAcctId()).setParameter(2, (Object)this.securitySymbol).getResultList();
            for (i = 0; i < holdingList.size() && neededQty != 0L; ++i) {
                holding = (Object[])holdingList.get(i);
                holdQty = (Integer)holding[0];
                double holdPrice = (Double)holding[1];
                if ((long)holdQty + neededQty < 0L) {
                    sellValue += (double)neededQty * holdPrice;
                    buyValue += (double)neededQty * this.requestedPrice;
                    neededQty = 0L;
                    continue;
                }
                holdQty = -holdQty;
                sellValue += (double)holdQty * holdPrice;
                buyValue += (double)holdQty * this.requestedPrice;
                neededQty -= (long)holdQty;
            }
        }
        double taxAmount = 0.0;
        if (sellValue > buyValue && (this.customerAccount.getCaTaxSt() == 1 || this.customerAccount.getCaTaxSt() == 2)) {
            BigDecimal taxRates = (BigDecimal)this.entityManager.createNativeQuery(CUSTOMER_TOTAL_TAX_QUERY).setParameter(1, (Object)this.customer.getCId()).getSingleResult();
            taxAmount = taxRates.doubleValue() * (sellValue - buyValue);
        }
        this.commissionRate = (BigDecimal)this.entityManager.createNamedQuery("FindCommissionRate").setParameter(1, (Object)this.customer.getCTier()).setParameter(2, (Object)this.toTxnInput.getTradeTypeId()).setParameter(3, (Object)exchangeId).setParameter(4, (Object)((int)this.toTxnInput.getTradeQty())).setParameter(5, (Object)((int)this.toTxnInput.getTradeQty())).getSingleResult();
        ChargePK chargePK = new ChargePK();
        chargePK.setChCTier(this.customer.getCTier());
        chargePK.setChTtId(this.toTxnInput.getTradeTypeId());
        Charge charge = (Charge)this.entityManager.find(Charge.class, (Object)chargePK);
        this.chargeAmount = charge.getChChrg();
        if (this.toTxnInput.getTypeIsMargin() == 1L) {
            double customerAssets = this.customerAccount.getCaBal();
            List holdAssetList = this.entityManager.createNativeQuery(HOLDING_ASSETS_QUERY).setParameter(1, (Object)this.toTxnInput.getAcctId()).getResultList();
            if (holdAssetList.size() != 0) {
                customerAssets += ((Double)holdAssetList.get(0)).doubleValue();
            }
        }
        String string = this.statusId = this.ttIsMrkt == 1 ? this.toTxnInput.getStSubmittedId() : this.toTxnInput.getStPendingId();
        if (sellValue > buyValue && (this.customerAccount.getCaTaxSt() == 1 || this.customerAccount.getCaTaxSt() == 2) && Math.abs(taxAmount - 0.0) < 0.005) {
            this.toTxnOutput.setStatus(-731);
        } else if (Math.abs(this.commissionRate.doubleValue() - 0.0) < 5.0E-5) {
            this.toTxnOutput.setStatus(-732);
        } else if (Math.abs(this.chargeAmount - 0.0) < 0.005) {
            this.toTxnOutput.setStatus(-733);
        }
        if (this.toTxnInput.getRollItBack() == 0L) {
            this.toTxnOutput.setBuyValue(buyValue);
            this.toTxnOutput.setSellValue(sellValue);
            this.toTxnOutput.setTaxAmount(taxAmount);
        }
    }

    protected void invokeFrame4() {
        Trade trade = new Trade();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        trade.setTDts(ts);
        StatusType st = (StatusType)this.entityManager.getReference(StatusType.class, (Object)this.statusId);
        trade.setStatusType(st);
        TradeType tt = (TradeType)this.entityManager.getReference(TradeType.class, (Object)this.toTxnInput.getTradeTypeId());
        trade.setTradeType(tt);
        trade.setTIsCash(this.toTxnInput.getTypeIsMargin() == 1L ? (short)0 : 1);
        Security security = (Security)this.entityManager.getReference(Security.class, (Object)this.securitySymbol);
        trade.setSecurity(security);
        trade.setTQty((int)this.toTxnInput.getTradeQty());
        trade.setTBidPrice(this.requestedPrice);
        trade.setCustomerAccount(this.customerAccount);
        trade.setTExecName(this.toTxnInput.getExecFirstName() + " " + this.toTxnInput.getExecLastName());
        trade.setTChrg(this.chargeAmount);
        trade.setTComm(this.commissionRate.doubleValue() / 100.0 * (double)this.toTxnInput.getTradeQty() * this.requestedPrice);
        trade.setTLifo((short)this.toTxnInput.getIsLifo());
        this.entityManager.persist((Object)trade);
        this.entityManager.flush();
        long tradeId = trade.getTId();
        if (this.ttIsMrkt != 0) {
            TradeRequest tr = new TradeRequest();
            tr.setTrTId(tradeId);
            tr.setTradeType(tt);
            tr.setSecurity(security);
            tr.setTrQty((int)this.toTxnInput.getTradeQty());
            tr.setTrBidPrice(this.requestedPrice);
            tr.setCustomerAccount(this.customerAccount);
            tr.setBroker(this.broker);
            this.entityManager.persist((Object)tr);
        }
        TradeHistory th = new TradeHistory();
        TradeHistoryPK thPK = new TradeHistoryPK();
        thPK.setThStId(this.statusId);
        thPK.setThTId(tradeId);
        th.setId(thPK);
        th.setThDts(ts);
        this.entityManager.persist((Object)th);
        if (this.toTxnInput.getRollItBack() == 0L) {
            this.toTxnOutput.setTradeId(tradeId);
        }
    }

    protected void invokeFrame5() {
        if (this.toTxnInput.getRollItBack() == 1L) {
            this.jpaTxnManager.rollback();
        }
    }

    protected void invokeFrame6() {
        if (this.toTxnInput.getRollItBack() != 1L) {
            this.jpaTxnManager.commit();
        }
    }
}

