/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf;

import com.gemstone.gemfire.internal.Assert;
import gfxdperf.PerfPrms;
import gfxdperf.PerfStats;
import gfxdperf.ScrambledZipfianGenerator;
import gfxdperf.ZipfianGenerator;
import gfxdperf.terminators.AbstractTerminator;
import gfxdperf.terminators.TerminatorFactory;
import hydra.ClientDescription;
import hydra.GsRandom;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.TestTask;
import hydra.blackboard.AnyCyclicBarrier;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import perffmwk.HistogramStats;
import perffmwk.HistogramStatsPrms;

public class PerfClient {
    private static HydraThreadLocal localtask = new HydraThreadLocal();
    private static HydraThreadLocal localbarriers = new HydraThreadLocal();
    private static HydraThreadLocal localterminator = new HydraThreadLocal();
    private static HydraThreadLocal localstatistics = new HydraThreadLocal();
    private static HydraThreadLocal localhistogram = new HydraThreadLocal();
    private static HydraThreadLocal localcurrentkey = new HydraThreadLocal();
    private static HydraThreadLocal localrng = new HydraThreadLocal();
    private static HydraThreadLocal localkeygenerator = new HydraThreadLocal();
    public TestTask task;
    public Map<String, Integer> barriers;
    public AbstractTerminator terminator;
    public PerfStats statistics;
    public HistogramStats histogram;
    public int currentKey;
    public GsRandom rng;
    public Random keyGenerator;
    public PerfPrms.KeyAllocation keyAllocation;
    public int keyAllocationChunkSize;
    public int maxKeys;
    public boolean isMainWorkload;
    public int jid;
    public int tid;
    public int tgid;
    public int ttgid;
    public int sttgid;
    public int numWanSites;
    public int numThreads;

    public static void openStatisticsTask() {
        PerfClient c = new PerfClient();
        c.initHydraThreadLocals();
        c.openStatistics();
        c.updateHydraThreadLocals();
    }

    private void openStatistics() {
        if (this.statistics == null) {
            this.statistics = PerfStats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
    }

    public static void closeStatisticsTask() {
        PerfClient c = new PerfClient();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.statistics != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.statistics.close();
        }
    }

    protected int getNextKey() {
        int key;
        switch (this.keyAllocation) {
            case SameKey: {
                key = 0;
                break;
            }
            case SameKeys: {
                if (this.currentKey == -1) {
                    key = 0;
                    break;
                }
                key = this.currentKey + 1;
                break;
            }
            case SameKeysWrap: {
                if (this.currentKey == -1) {
                    key = 0;
                    break;
                }
                key = (this.currentKey + 1) % this.maxKeys;
                break;
            }
            case SameKeysRandomWrap: {
                key = this.rng.nextInt(0, this.maxKeys - 1);
                break;
            }
            case OwnKey: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                    break;
                }
                key = this.currentKey;
                break;
            }
            case OwnKeys: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                    break;
                }
                key = this.currentKey + this.numThreads;
                break;
            }
            case OwnKeysWrap: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                } else {
                    key = this.currentKey + this.numThreads;
                }
                if (key < this.maxKeys) break;
                key = this.ttgid;
                break;
            }
            case OwnKeysRandomWrap: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                }
                int numKeys = (int)Math.ceil(this.maxKeys / this.numThreads);
                if (this.ttgid >= this.maxKeys % this.numThreads) {
                    --numKeys;
                }
                key = this.ttgid + this.numThreads * this.rng.nextInt(0, numKeys);
                break;
            }
            case OwnKeysChunked: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid * this.keyAllocationChunkSize;
                    break;
                }
                if ((this.currentKey + 1) % this.keyAllocationChunkSize == 0) {
                    key = this.currentKey + 1 + (this.numThreads - 1) * this.keyAllocationChunkSize;
                    break;
                }
                key = this.currentKey + 1;
                break;
            }
            case OwnKeysChunkedRandomWrap: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    PerfPrms.checkOwnKeysChunkedRandomWrap(this.maxKeys, this.keyAllocationChunkSize);
                }
                if ((this.currentKey + 1) % this.keyAllocationChunkSize == 0) {
                    int numChunks = this.maxKeys / this.keyAllocationChunkSize;
                    int numChunksPerThread = (int)Math.ceil(numChunks / this.numThreads);
                    if (this.ttgid >= numChunks % this.numThreads) {
                        --numChunksPerThread;
                    }
                    int chunk = this.ttgid + this.numThreads * this.rng.nextInt(0, numChunksPerThread);
                    key = chunk * this.keyAllocationChunkSize;
                    break;
                }
                key = this.currentKey + 1;
                break;
            }
            case Zipfian: {
                key = this.keyGenerator.nextInt();
                break;
            }
            case ScrambledZipfian: {
                key = this.keyGenerator.nextInt();
                break;
            }
            default: {
                throw new HydraInternalException("Should not happen");
            }
        }
        this.currentKey = key;
        return key;
    }

    private void checkSufficientKeys() {
        if (this.numThreads > this.maxKeys / this.keyAllocationChunkSize) {
            throw new HydraConfigException(this.maxKeys + " keys are not enough for " + this.numThreads + " threads to have their own keys (or chunk of keys)");
        }
    }

    public void sync() {
        String taskId = this.task.getReceiver() + "_" + this.task.getSelector() + "_" + this.task.getTaskIndex();
        Integer barrierId = this.barriers.containsKey(taskId) ? this.barriers.get(taskId) + 1 : 1;
        String barrierName = taskId + "_" + barrierId;
        int parties = PerfClient.numThreads();
        Log.getLogWriter().info("syncing at barrier " + barrierName + " for " + parties + " parties");
        AnyCyclicBarrier barrier = AnyCyclicBarrier.lookup((int)parties, (String)barrierName);
        barrier.await();
        this.barriers.put(taskId, barrierId);
        int syncSleepMs = PerfPrms.getSyncSleepMs();
        if (syncSleepMs > 0) {
            Log.getLogWriter().info("sleeping " + syncSleepMs + " ms after sync");
            MasterController.sleepForMs((int)syncSleepMs);
        }
        Log.getLogWriter().info("done syncing");
    }

    public static void dumpHeapTask() {
        PerfClient c = new PerfClient();
        c.initLocalVariables();
        c.dumpHeap();
    }

    private void dumpHeap() {
        if (this.ttgid == 0) {
            Log.getLogWriter().severe(ProcessMgr.fgexec((String)"sh heapdumprun.sh", (int)600));
        }
    }

    protected void initialize() {
        this.initLocalVariables();
        this.initLocalParameters();
        this.initHydraThreadLocals();
    }

    protected void initLocalVariables() {
        this.jid = this.jid();
        this.tid = this.tid();
        this.tgid = this.tgid();
        this.ttgid = this.ttgid();
        this.sttgid = this.sttgid();
        this.numWanSites = this.numWanSites();
        this.numThreads = PerfClient.numThreads();
        Assert.assertTrue((this.numThreads > 0 ? 1 : 0) != 0, (Object)("Have " + this.numThreads + " threads"));
    }

    protected void initLocalParameters() {
        this.isMainWorkload = PerfPrms.isMainWorkload();
        this.keyAllocation = PerfPrms.getKeyAllocation();
        this.keyAllocationChunkSize = PerfPrms.getKeyAllocationChunkSize();
        this.maxKeys = PerfPrms.getMaxKeys();
    }

    public void initHydraThreadLocals() {
        this.task = this.getTask();
        this.terminator = this.getTerminator();
        this.rng = this.getRNG();
        this.keyGenerator = this.getKeyGenerator();
        this.barriers = this.getBarriers();
        this.statistics = this.getStatistics();
        this.histogram = this.getHistogram();
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        this.currentKey = this.getCurrentKey();
    }

    public void updateHydraThreadLocals() {
        this.setTerminator(this.terminator);
        this.setBarriers(this.barriers);
        this.setStatistics(this.statistics);
        this.setHistogram(this.histogram);
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        this.setCurrentKey(this.currentKey);
    }

    protected void resetHydraThreadLocals(boolean resetKeys) {
        HistogramStats h;
        localterminator.set(null);
        if (resetKeys) {
            localcurrentkey.set(null);
        }
        if ((h = (HistogramStats)localhistogram.get()) != null) {
            h.close();
            localhistogram.set(null);
        }
    }

    protected TestTask getTask() {
        TestTask oldTask = (TestTask)localtask.get();
        TestTask newTask = RemoteTestModule.getCurrentThread().getCurrentTask();
        if (oldTask == null) {
            localtask.set((Object)newTask);
        } else if (!oldTask.equals(newTask)) {
            localtask.set((Object)newTask);
            boolean resetKeysAfter = PerfPrms.resetKeysAfterTaskEnds(oldTask);
            boolean resetKeysBefore = PerfPrms.resetKeysBeforeTaskStarts(newTask);
            this.resetHydraThreadLocals(resetKeysAfter || resetKeysBefore);
        }
        return newTask;
    }

    protected Map<String, Integer> getBarriers() {
        HashMap m = (HashMap)localbarriers.get();
        if (m == null) {
            m = new HashMap();
            localbarriers.set(m);
        }
        return (Map)localbarriers.get();
    }

    protected void setBarriers(Map<String, Integer> m) {
        localbarriers.set(m);
    }

    protected PerfStats getStatistics() {
        return (PerfStats)((Object)localstatistics.get());
    }

    protected void setStatistics(PerfStats stats) {
        localstatistics.set((Object)stats);
    }

    protected HistogramStats getHistogram() {
        HistogramStats h = (HistogramStats)localhistogram.get();
        if (h == null && HistogramStatsPrms.enable()) {
            String instanceName = "junk";
            Log.getLogWriter().info("Opening histogram for " + instanceName);
            h = HistogramStats.getInstance((String)instanceName);
            Log.getLogWriter().info("Opened histogram for " + instanceName);
            localhistogram.set((Object)h);
        }
        return h;
    }

    protected void setHistogram(HistogramStats h) {
        localhistogram.set((Object)h);
    }

    protected AbstractTerminator getTerminator() {
        TerminatorFactory.TerminatorName terminatorName;
        AbstractTerminator t = (AbstractTerminator)localterminator.get();
        if (t == null && (terminatorName = PerfPrms.getTerminatorName()) != null) {
            t = TerminatorFactory.create(terminatorName);
            localterminator.set((Object)t);
        }
        return t;
    }

    protected void setTerminator(AbstractTerminator t) {
        localterminator.set((Object)t);
    }

    protected int getCurrentKey() {
        Integer n = (Integer)localcurrentkey.get();
        if (n == null) {
            n = -1;
            localcurrentkey.set((Object)n);
        }
        return n;
    }

    protected void setCurrentKey(int n) {
        localcurrentkey.set((Object)n);
    }

    protected GsRandom getRNG() {
        GsRandom r = (GsRandom)localrng.get();
        if (r == null) {
            r = TestConfig.getInstance().getParameters().getRandGen();
            localrng.set((Object)r);
        }
        return r;
    }

    protected Random getKeyGenerator() {
        Random keyGenerator = (Random)localkeygenerator.get();
        if (keyGenerator == null) {
            if (this.keyAllocation == PerfPrms.KeyAllocation.Zipfian) {
                keyGenerator = new ZipfianGenerator(this.maxKeys);
            } else if (this.keyAllocation == PerfPrms.KeyAllocation.ScrambledZipfian) {
                keyGenerator = new ScrambledZipfianGenerator(this.maxKeys);
            }
            localkeygenerator.set((Object)keyGenerator);
        }
        return keyGenerator;
    }

    protected int jid() {
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("jid=" + this.tid() % RemoteTestModule.getMyNumThreads());
        }
        return this.tid() % RemoteTestModule.getMyNumThreads();
    }

    protected int tid() {
        return RemoteTestModule.getCurrentThread().getThreadId();
    }

    protected int tgid() {
        return RemoteTestModule.getCurrentThread().getThreadGroupId();
    }

    protected int ttgid() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        return task.getTaskThreadGroupId(tgname, this.tgid());
    }

    protected int sttgid() {
        List mappings = RemoteTestModule.getClientMapping();
        if (mappings == null) {
            String s = "Client mapping not found";
            throw new HydraRuntimeException(s);
        }
        String clientName = System.getProperty("clientName");
        String[] arr = clientName.split("_");
        if (arr.length != 3) {
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("sttgid: single site, using ttgid=" + this.ttgid());
            }
            return this.ttgid();
        }
        String localsite = arr[1];
        String localthreadname = Thread.currentThread().getName();
        Vector threadgroups = RemoteTestModule.getCurrentThread().getCurrentTask().getThreadGroupNames();
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("sttgid: matching " + localthreadname + " for site=" + localsite + " from threadgroups=" + threadgroups);
        }
        int count = 0;
        for (List mapping : mappings) {
            String threadgroup = (String)mapping.get(0);
            String threadname = (String)mapping.get(1);
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("sttgid: candidate threadgroup=" + threadgroup + " threadname= " + threadname);
            }
            if (threadgroups.contains(threadgroup)) {
                String[] carr = threadname.split("_");
                if (carr.length == 8) {
                    if (localthreadname.startsWith(threadname)) {
                        if (Log.getLogWriter().fineEnabled()) {
                            Log.getLogWriter().fine("sttgid: returning match for " + localthreadname + " as " + count);
                        }
                        return count;
                    }
                    String site = carr[5];
                    if (site.equals(localsite)) {
                        ++count;
                        if (!Log.getLogWriter().fineEnabled()) continue;
                        Log.getLogWriter().fine("sttgid: counting match " + count + "=" + threadname);
                        continue;
                    }
                    if (!Log.getLogWriter().fineEnabled()) continue;
                    Log.getLogWriter().fine("sttgid: candidate rejected=" + mapping + " invalid site=" + site);
                    continue;
                }
                String s = "Unexpected array size from " + threadname;
                throw new HydraRuntimeException(s);
            }
            if (!Log.getLogWriter().fineEnabled()) continue;
            Log.getLogWriter().fine("sttgid: candidate rejected=" + mapping + " invalid threadgroup=" + threadgroup);
        }
        String s = "Should not happen";
        throw new HydraInternalException(s);
    }

    protected int numWanSites() {
        int maxSite = PerfPrms.getNumWanSites();
        if (maxSite != 0) {
            return maxSite;
        }
        Vector clientNames = TestConfig.getInstance().getClientNames();
        for (String clientName : clientNames) {
            int site;
            String[] arr = clientName.split("_");
            if (arr.length != 3) {
                return 1;
            }
            try {
                site = Integer.parseInt(arr[1]);
            }
            catch (NumberFormatException e) {
                String s = clientName + " is not in the form <name>_<wanSiteNumber>_<itemNumber>";
                throw new HydraRuntimeException(s, (Exception)e);
            }
            maxSite = Math.max(site, maxSite);
        }
        if (maxSite == 0) {
            String s = "Should not happen";
            throw new HydraInternalException(s);
        }
        return maxSite;
    }

    public static int numThreads() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        int t = task.getTotalThreads();
        return t;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static HostDescription getHostDescription() {
        String clientName = RemoteTestModule.getMyClientName();
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        return cd.getVmDescription().getHostDescription();
    }
}

