/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf;

import gfxdperf.terminators.TerminatorFactory;
import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.TestTask;

public class PerfPrms
extends BasePrms {
    private static final String DEFAULT_KEY_ALLOCATION = "SameKeysWrap";
    public static Long isMainWorkload;
    public static Long keyAllocation;
    public static Long keyAllocationChunkSize;
    public static Long maxKeys;
    public static Long numWanSites;
    public static Long resetKeysAfterTaskEnds;
    public static Long resetKeysBeforeTaskStarts;
    public static Long syncSleepMs;
    public static Long terminatorName;

    public static boolean isMainWorkload() {
        Long key = isMainWorkload;
        return PerfPrms.tasktab().booleanAt(key, PerfPrms.tab().booleanAt(key, false));
    }

    public static KeyAllocation getKeyAllocation() {
        Long key = keyAllocation;
        String val = PerfPrms.tasktab().stringAt(key, PerfPrms.tab().stringAt(key, DEFAULT_KEY_ALLOCATION));
        for (KeyAllocation k : KeyAllocation.values()) {
            if (!val.equalsIgnoreCase(k.toString())) continue;
            return k;
        }
        String s = "Illegal value for " + PerfPrms.nameForKey((Long)key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getKeyAllocationChunkSize() {
        Long key = keyAllocationChunkSize;
        return PerfPrms.tasktab().intAt(key, PerfPrms.tab().intAt(key, 1));
    }

    public static void checkOwnKeysChunkedRandomWrap(int max, int chunk) {
        if (max % chunk != 0) {
            String s = BasePrms.nameForKey((Long)keyAllocationChunkSize) + "=" + chunk + " does not evenly divide " + BasePrms.nameForKey((Long)maxKeys) + "=" + max;
            throw new HydraConfigException(s);
        }
    }

    public static int getMaxKeys() {
        Long key = maxKeys;
        return PerfPrms.tasktab().intAt(key, PerfPrms.tab().intAt(key, -1));
    }

    public static int getNumWanSites() {
        Long key = numWanSites;
        int val = PerfPrms.tasktab().intAt(key, PerfPrms.tab().intAt(key, 0));
        if (val < 0) {
            String s = "Illegal value for " + PerfPrms.nameForKey((Long)key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static boolean resetKeysAfterTaskEnds(TestTask task) {
        Long key = resetKeysAfterTaskEnds;
        return task.getTaskAttributes().booleanAt(key, PerfPrms.tab().booleanAt(key, true));
    }

    public static boolean resetKeysBeforeTaskStarts(TestTask task) {
        Long key = resetKeysBeforeTaskStarts;
        return task.getTaskAttributes().booleanAt(key, PerfPrms.tab().booleanAt(key, true));
    }

    public static int getSyncSleepMs() {
        return PerfPrms.tasktab().intAt(syncSleepMs, PerfPrms.tab().intAt(syncSleepMs, 0));
    }

    public static TerminatorFactory.TerminatorName getTerminatorName() {
        Long key = terminatorName;
        String val = PerfPrms.tasktab().stringAt(key, PerfPrms.tab().stringAt(key, null));
        if (val == null) {
            return null;
        }
        for (TerminatorFactory.TerminatorName t : TerminatorFactory.TerminatorName.values()) {
            if (!val.equalsIgnoreCase(t.toString())) continue;
            return t;
        }
        String s = "Illegal value for " + PerfPrms.nameForKey((Long)key) + ": " + val;
        throw new HydraConfigException(s);
    }

    static {
        PerfPrms.setValues(PerfPrms.class);
    }

    public static enum KeyAllocation {
        SameKey,
        SameKeys,
        SameKeysWrap,
        SameKeysRandomWrap,
        OwnKey,
        OwnKeys,
        OwnKeysWrap,
        OwnKeysRandomWrap,
        OwnKeysChunked,
        OwnKeysChunkedRandomWrap,
        Zipfian,
        ScrambledZipfian;

    }
}

