/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import perffmwk.HistogramStats;
import perffmwk.PerformanceStatistics;

public class PerfStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    public static final String VM_COUNT = "vmCount";
    public static final String OPS = "operations";
    public static final String OP_TIME = "operationTime";
    private static boolean VMCounted = false;

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{PerfStats.factory().createIntGauge(VM_COUNT, "When aggregated, the number of VMs using this statistics object.", "VMs"), PerfStats.factory().createIntCounter(OPS, "Number of operations completed.", OPS, largerIsBetter), PerfStats.factory().createLongCounter(OP_TIME, "Total time spent doing operations.", "nanoseconds", !largerIsBetter)};
    }

    public static PerfStats getInstance() {
        PerfStats cps = (PerfStats)PerfStats.getInstance(PerfStats.class, (int)0);
        cps.incVMCount();
        return cps;
    }

    public static PerfStats getInstance(int scope) {
        PerfStats cps = (PerfStats)PerfStats.getInstance(PerfStats.class, (int)scope);
        cps.incVMCount();
        return cps;
    }

    public static PerfStats getInstance(String name) {
        PerfStats cps = (PerfStats)PerfStats.getInstance(PerfStats.class, (int)0, (String)name);
        cps.incVMCount();
        return cps;
    }

    public static PerfStats getInstance(String name, String trimspecName) {
        PerfStats cps = (PerfStats)PerfStats.getInstance(PerfStats.class, (int)0, (String)name, (String)trimspecName);
        cps.incVMCount();
        return cps;
    }

    public PerfStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public int getOps() {
        return this.statistics().getInt(OPS);
    }

    public long getOpTime() {
        return this.statistics().getLong(OP_TIME);
    }

    public void incHistogram(HistogramStats histogram, long amount) {
        if (histogram != null) {
            histogram.incBin(amount);
        }
    }

    private synchronized void incVMCount() {
        if (!VMCounted) {
            this.statistics().incInt(VM_COUNT, 1);
            VMCounted = true;
        }
    }

    protected void setOps(int amount) {
        this.statistics().setInt(OPS, amount);
    }

    protected void setOpTime(long amount) {
        this.statistics().setLong(OP_TIME, amount);
    }
}

