/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf;

import java.util.Random;

public class ZipfianGenerator
extends Random {
    private static final long serialVersionUID = 7216987094828263382L;
    public static final double ZIPFIAN_CONSTANT = 0.99;
    long items;
    long base;
    double zipfianconstant;
    double alpha;
    double zetan;
    double eta;
    double theta;
    double zeta2theta;
    long countforzeta;
    private ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    boolean allowitemcountdecrease = false;

    public ZipfianGenerator(long _items) {
        this(0L, _items - 1L);
    }

    public ZipfianGenerator(long _min, long _max) {
        this(_min, _max, 0.99);
    }

    public ZipfianGenerator(long _items, double _zipfianconstant) {
        this(0L, _items - 1L, _zipfianconstant);
    }

    public ZipfianGenerator(long min, long max, double _zipfianconstant) {
        this(min, max, _zipfianconstant, ZipfianGenerator.zetastatic(max - min + 1L, _zipfianconstant));
    }

    public ZipfianGenerator(long min, long max, double _zipfianconstant, double _zetan) {
        this.items = max - min + 1L;
        this.base = min;
        this.theta = this.zipfianconstant = _zipfianconstant;
        this.zeta2theta = this.zeta(2L, this.theta);
        this.alpha = 1.0 / (1.0 - this.theta);
        this.zetan = _zetan;
        this.countforzeta = this.items;
        this.eta = (1.0 - Math.pow(2.0 / (double)this.items, 1.0 - this.theta)) / (1.0 - this.zeta2theta / this.zetan);
        this.nextInt();
    }

    double zeta(long n, double theta) {
        this.countforzeta = n;
        return ZipfianGenerator.zetastatic(n, theta);
    }

    static double zetastatic(long n, double theta) {
        return ZipfianGenerator.zetastatic(0L, n, theta, 0.0);
    }

    double zeta(long st, long n, double theta, double initialsum) {
        this.countforzeta = n;
        return ZipfianGenerator.zetastatic(st, n, theta, initialsum);
    }

    static double zetastatic(long st, long n, double theta, double initialsum) {
        double sum = initialsum;
        for (long i = st; i < n; ++i) {
            sum += 1.0 / Math.pow(i + 1L, theta);
        }
        return sum;
    }

    @Override
    public int nextInt(int itemcount) {
        return (int)this.nextLong(itemcount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextLong(long itemcount) {
        double u;
        double uz;
        if (itemcount != this.countforzeta) {
            ZipfianGenerator zipfianGenerator = this;
            synchronized (zipfianGenerator) {
                if (itemcount > this.countforzeta) {
                    this.zetan = this.zeta(this.countforzeta, itemcount, this.theta, this.zetan);
                    this.eta = (1.0 - Math.pow(2.0 / (double)this.items, 1.0 - this.theta)) / (1.0 - this.zeta2theta / this.zetan);
                } else if (itemcount < this.countforzeta && this.allowitemcountdecrease) {
                    System.err.println("WARNING: Recomputing Zipfian distribtion. This is slow and should be avoided. (itemcount=" + itemcount + " countforzeta=" + this.countforzeta + ")");
                    this.zetan = this.zeta(itemcount, this.theta);
                    this.eta = (1.0 - Math.pow(2.0 / (double)this.items, 1.0 - this.theta)) / (1.0 - this.zeta2theta / this.zetan);
                }
            }
        }
        if ((uz = (u = this.random.get().nextDouble()) * this.zetan) < 1.0) {
            return 0L;
        }
        if (uz < 1.0 + Math.pow(0.5, this.theta)) {
            return 1L;
        }
        long ret = this.base + (long)((double)itemcount * Math.pow(this.eta * u - this.eta + 1.0, this.alpha));
        return ret;
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong(this.items);
    }

    @Override
    public long nextLong() {
        return this.nextLong(this.items);
    }
}

