/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.samples;

import gfxdperf.PerfClient;
import hydra.Log;

public class SampleClient
extends PerfClient {
    public static void sampleInitTask() {
        SampleClient client = new SampleClient();
        client.initialize();
        client.sampleInit();
    }

    private void sampleInit() {
        this.terminator.startBatch();
        while (!this.terminator.batchComplete()) {
            if (this.terminator.warmupComplete()) {
                this.sync();
                this.terminator.startWork();
            }
            if (this.terminator.workComplete()) {
                this.terminator.reportTrimInterval(this, "sampleinit", 0L);
                this.updateHydraThreadLocals();
                this.terminator.terminateTask();
            }
            int key = this.getNextKey();
            this.sample(key);
        }
        this.updateHydraThreadLocals();
        this.terminator.terminateBatch();
    }

    private void sampleInit(int key) {
        Log.getLogWriter().info("init key=" + key);
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            Log.getLogWriter().severe("Interrupted!");
            return;
        }
    }

    public static void sampleTask() {
        SampleClient client = new SampleClient();
        client.initialize();
        client.sample();
    }

    private void sample() {
        this.terminator.startBatch();
        while (!this.terminator.batchComplete()) {
            if (this.terminator.warmupComplete()) {
                this.sync();
                this.terminator.startWork();
            }
            if (this.terminator.workComplete()) {
                this.terminator.reportTrimInterval(this, "sample", 0L);
                this.updateHydraThreadLocals();
                this.terminator.terminateTask();
            }
            int key = this.getNextKey();
            this.sample(key);
        }
        this.updateHydraThreadLocals();
        this.terminator.terminateBatch();
    }

    private void sample(int key) {
        Log.getLogWriter().info("key=" + key);
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            Log.getLogWriter().severe("Interrupted!");
            return;
        }
    }
}

