/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.terminators;

import gfxdperf.PerfClient;
import gfxdperf.terminators.AbstractTerminator;
import gfxdperf.terminators.IterationTerminatorPrms;
import hydra.Log;

public class IterationTerminator
extends AbstractTerminator {
    int batchSeconds = IterationTerminatorPrms.getBatchSeconds();
    long warmupIterations = IterationTerminatorPrms.getWarmupIterations();
    long workIterations = IterationTerminatorPrms.getWorkIterations();
    long batchStartTime;
    long batchEndTime;
    long warmupStartCount = -1L;
    long warmupEndCount;
    long warmupStartTime = -1L;
    long warmupEndTime;
    long workStartCount;
    long workEndCount;
    long workStartTime;
    long workEndTime;
    boolean warmedUp = false;
    boolean reportedWarmup = false;
    long iterations = 0L;

    @Override
    public void startBatch() {
        this.batchStartTime = System.currentTimeMillis();
        this.batchEndTime = this.batchStartTime + (long)(this.batchSeconds * 1000);
        Log.getLogWriter().info("IterationTerminator starting batch with startTime=" + this.batchStartTime + " endTime=" + this.batchEndTime);
    }

    @Override
    public boolean batchComplete() {
        ++this.iterations;
        long now = System.currentTimeMillis();
        if (now > this.batchEndTime) {
            long elapsed = now - this.batchStartTime;
            Log.getLogWriter().info("IterationTerminator completed batch: " + this.batchSeconds + " seconds in " + elapsed + " ms");
            return true;
        }
        return false;
    }

    @Override
    public boolean warmupComplete() {
        if (this.reportedWarmup) {
            return false;
        }
        if (this.warmupIterations == 0L) {
            Log.getLogWriter().info("IterationTerminator skipping warmup");
            this.warmedUp = true;
            this.reportedWarmup = true;
            return true;
        }
        if (this.warmupStartCount == -1L) {
            long now;
            this.warmupStartTime = now = System.currentTimeMillis();
            this.warmupStartCount = 0L;
            this.warmupEndCount = this.warmupStartCount + this.warmupIterations;
            Log.getLogWriter().info("IterationTerminator starting warmup: " + this.warmupIterations + " iterations (start=" + this.warmupStartCount + " end=" + this.warmupEndCount + ") at startTime=" + this.warmupStartTime);
            return false;
        }
        if (this.iterations == this.warmupIterations) {
            long now = System.currentTimeMillis();
            long elapsed = now - this.warmupStartTime;
            Log.getLogWriter().info("IterationTerminator completed warmup: " + this.warmupIterations + " iterations in " + elapsed + " ms");
            this.warmedUp = true;
            this.reportedWarmup = true;
            return true;
        }
        return false;
    }

    @Override
    public void startWork() {
        long now;
        this.workStartTime = now = System.currentTimeMillis();
        this.workStartCount = this.iterations;
        this.workEndCount = this.workStartCount + this.workIterations;
        Log.getLogWriter().info("IterationTerminator starting work: " + this.workIterations + " iterations (start=" + this.workStartCount + " end=" + this.workEndCount + ") at startTime=" + this.workStartTime);
    }

    @Override
    public boolean workComplete() {
        if (this.warmedUp && this.iterations == this.workEndCount) {
            long now = System.currentTimeMillis();
            long elapsed = now - this.workStartTime;
            Log.getLogWriter().info("IterationTerminator completed work: " + this.workIterations + " iterations in " + elapsed + " ms");
            this.workEndTime = now;
            return true;
        }
        return false;
    }

    @Override
    public void reportTrimInterval(PerfClient client, String trimIntervalName, long timestamp) {
        boolean extended = false;
        if (timestamp > 0L) {
            this.workEndTime = timestamp;
            extended = true;
        }
        this.reportTrimInterval(client, trimIntervalName, this.workStartTime, this.workEndTime, extended);
    }
}

