/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.terminators;

import gfxdperf.PerfClient;
import gfxdperf.terminators.AbstractTerminator;
import gfxdperf.terminators.TimeTerminatorPrms;
import hydra.Log;

public class TimeTerminator
extends AbstractTerminator {
    int batchSeconds = TimeTerminatorPrms.getBatchSeconds();
    int warmupSeconds = TimeTerminatorPrms.getWarmupSeconds();
    int workSeconds = TimeTerminatorPrms.getWorkSeconds();
    long batchStartTime;
    long batchEndTime;
    long warmupStartTime = -1L;
    long warmupEndTime;
    long workStartTime;
    long workEndTime;
    boolean warmedUp = false;
    boolean reportedWarmup = false;

    @Override
    public void startBatch() {
        this.batchStartTime = System.currentTimeMillis();
        this.batchEndTime = this.batchStartTime + (long)(this.batchSeconds * 1000);
        Log.getLogWriter().info("TimeTerminator starting batch with start=" + this.batchStartTime + " end=" + this.batchEndTime);
    }

    @Override
    public boolean batchComplete() {
        long now = System.currentTimeMillis();
        if (now > this.batchEndTime) {
            long elapsed = now - this.batchStartTime;
            Log.getLogWriter().info("TimeTerminator completed batch: " + this.batchSeconds + " seconds in " + elapsed + " ms");
            return true;
        }
        return false;
    }

    @Override
    public boolean warmupComplete() {
        if (this.reportedWarmup) {
            return false;
        }
        if (this.warmupSeconds == 0) {
            Log.getLogWriter().info("TimeTerminator skipping warmup");
            this.warmedUp = true;
            this.reportedWarmup = true;
            return true;
        }
        if (this.warmupStartTime == -1L) {
            long now;
            this.warmupStartTime = now = System.currentTimeMillis();
            this.warmupEndTime = now + (long)(this.warmupSeconds * 1000);
            Log.getLogWriter().info("TimeTerminator starting warmup: " + this.warmupSeconds + " seconds (start=" + this.warmupStartTime + " end=" + this.warmupEndTime + ")");
            return false;
        }
        long now = System.currentTimeMillis();
        if (now > this.warmupEndTime) {
            long elapsed = now - this.warmupStartTime;
            Log.getLogWriter().info("TimeTerminator completed warmup: " + this.warmupSeconds + " seconds in " + elapsed + " ms");
            this.warmedUp = true;
            this.reportedWarmup = true;
            return true;
        }
        return false;
    }

    @Override
    public void startWork() {
        this.workStartTime = System.currentTimeMillis();
        this.workEndTime = this.workStartTime + (long)(this.workSeconds * 1000);
        Log.getLogWriter().info("TimeTerminator starting work: " + this.workSeconds + " seconds (start=" + this.workStartTime + " end=" + this.workEndTime + ")");
    }

    @Override
    public boolean workComplete() {
        long now;
        if (this.warmedUp && (now = System.currentTimeMillis()) > this.workEndTime) {
            long elapsed = now - this.workStartTime;
            Log.getLogWriter().info("TimeTerminator completed work: " + this.workSeconds + " seconds in " + elapsed + " ms");
            this.workEndTime = now;
            return true;
        }
        return false;
    }

    @Override
    public void reportTrimInterval(PerfClient client, String trimIntervalName, long timestamp) {
        boolean extended = false;
        if (timestamp > 0L) {
            this.workEndTime = timestamp;
            extended = true;
        }
        this.reportTrimInterval(client, trimIntervalName, this.workStartTime, this.workEndTime, extended);
    }
}

