/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import gfxdperf.tpch.Query;
import gfxdperf.tpch.ResultRow;
import hydra.Log;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractQ1
extends Query {
    public AbstractQ1() {
        this.queryName = "Q1";
    }

    @Override
    public String validateQuery() throws SQLException {
        int delta = 90;
        ResultSet rs = this.executeQuery(delta);
        return this.validateQuery(rs);
    }

    @Override
    public int executeQuery() throws SQLException {
        int delta = 60 + this.rng.nextInt(61);
        ResultSet rs = this.executeQuery(delta);
        return this.readResultSet(rs);
    }

    @Override
    public void executeQueryPlan() throws SQLException {
        int delta = 60 + this.rng.nextInt(61);
        this.executeQueryPlan(delta);
    }

    @Override
    public ResultRow createResultRow() {
        return new Result();
    }

    protected ResultSet executeQuery(int delta) throws SQLException {
        if (this.logDML) {
            Log.getLogWriter().info(this.queryName + ": " + this.query);
            Log.getLogWriter().info("Executing " + this.queryName + " with delta=" + delta);
        }
        if (this.preparedQueryStmt == null) {
            this.preparedQueryStmt = this.connection.prepareStatement(this.query);
        }
        this.preparedQueryStmt.setInt(1, delta);
        return this.preparedQueryStmt.executeQuery();
    }

    protected void executeQueryPlan(int delta) throws SQLException {
        Log.getLogWriter().info("Getting query plan for " + this.queryName + " with delta=" + delta);
        if (this.preparedQueryPlanStmt == null) {
            this.preparedQueryPlanStmt = this.connection.prepareStatement("explain " + this.query);
        }
        this.preparedQueryPlanStmt.setInt(1, delta);
        ResultSet rs = this.preparedQueryPlanStmt.executeQuery();
        this.logQueryPlan(rs);
    }

    public static class Result
    implements ResultRow {
        public String l_returnflag;
        public String l_linestatus;
        public BigDecimal sum_qty;
        public BigDecimal sum_base_price;
        public BigDecimal sum_disc_price;
        public BigDecimal sum_charge;
        public BigDecimal avg_qty;
        public BigDecimal avg_price;
        public BigDecimal avg_disc;
        public int count_order;

        @Override
        public void init(ResultSet rs) throws SQLException {
            this.l_returnflag = rs.getString(1);
            this.l_linestatus = rs.getString(2);
            this.sum_qty = rs.getBigDecimal(3);
            this.sum_base_price = rs.getBigDecimal(4);
            this.sum_disc_price = rs.getBigDecimal(5);
            this.sum_charge = rs.getBigDecimal(6);
            this.avg_qty = rs.getBigDecimal(7);
            this.avg_price = rs.getBigDecimal(8);
            this.avg_disc = rs.getBigDecimal(9);
            this.count_order = rs.getInt(10);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" l_returnflag=").append(this.l_returnflag).append(" l_linestatus=").append(this.l_linestatus).append(" sum_qty=").append(this.sum_qty).append(" sum_base_price=").append(this.sum_base_price).append(" sum_disc_price=").append(this.sum_disc_price).append(" sum_charge=").append(this.sum_charge).append(" avg_qty=").append(this.avg_qty).append(" avg_price=").append(this.avg_price).append(" avg_disc=").append(this.avg_disc).append(" count_order=" + this.count_order);
            return sb.toString();
        }

        @Override
        public String toAnswerLineFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.l_returnflag + "|").append(this.l_linestatus + "|").append(this.sum_qty.setScale(2, RoundingMode.HALF_UP) + "|").append(this.sum_base_price.setScale(2, RoundingMode.HALF_UP) + "|").append(this.sum_disc_price.setScale(2, RoundingMode.HALF_UP) + "|").append(this.sum_charge.setScale(2, RoundingMode.HALF_UP) + "|").append(this.avg_qty.setScale(2, RoundingMode.HALF_UP) + "|").append(this.avg_price.setScale(2, RoundingMode.HALF_UP) + "|").append(this.avg_disc.setScale(2, RoundingMode.HALF_UP) + "|").append(String.format("%22d", this.count_order));
            return sb.toString();
        }
    }
}

