/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import gfxdperf.tpch.Query;
import gfxdperf.tpch.ResultRow;
import hydra.Log;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractQ2
extends Query {
    public AbstractQ2() {
        this.queryName = "Q2";
        this.query = "select s_acctbal, s_name, n_name, p_partkey, p_mfgr, s_address, s_phone, s_comment from part, supplier, partsupp, nation, region where p_partkey = ps_partkey and s_suppkey = ps_suppkey and p_size = ? and p_type like ? and s_nationkey = n_nationkey and n_regionkey = r_regionkey and r_name = ? and ps_supplycost = ( select min(ps_supplycost) from partsupp, supplier, nation, region where p_partkey = ps_partkey and s_suppkey = ps_suppkey and s_nationkey = n_nationkey and n_regionkey = r_regionkey and r_name = ?) order by s_acctbal desc, n_name, s_name, p_partkey";
    }

    @Override
    public String validateQuery() throws SQLException {
        int size = 15;
        String type = "BRASS";
        String region = String.format("%-25s", "EUROPE");
        ResultSet rs = this.executeQuery(size, type, region);
        return this.validateQuery(rs);
    }

    @Override
    public int executeQuery() throws SQLException {
        Object[] args = this.getRandomArgs();
        int size = (Integer)args[0];
        String type = (String)args[1];
        String region = (String)args[2];
        ResultSet rs = this.executeQuery(size, type, region);
        return this.readResultSet(rs);
    }

    @Override
    public void executeQueryPlan() throws SQLException {
        Object[] args = this.getRandomArgs();
        int size = (Integer)args[0];
        String type = (String)args[1];
        String region = (String)args[2];
        this.executeQueryPlan(size, type, region);
    }

    protected Object[] getRandomArgs() {
        int size = 1 + this.rng.nextInt(50);
        String type = TYPE[this.rng.nextInt(TYPE.length - 1)];
        String region = String.format("%-25s", REGION[this.rng.nextInt(REGION.length - 1)]);
        return new Object[]{size, type, region};
    }

    @Override
    public ResultRow createResultRow() {
        return new Result();
    }

    protected ResultSet executeQuery(int size, String type, String region) throws SQLException {
        if (this.logDML) {
            Log.getLogWriter().info(this.queryName + ": " + this.query);
            Log.getLogWriter().info("Executing " + this.queryName + " with size=" + size + " type=" + type + " region=" + region);
        }
        if (this.preparedQueryStmt == null) {
            this.preparedQueryStmt = this.connection.prepareStatement(this.query);
        }
        this.preparedQueryStmt.setInt(1, size);
        this.preparedQueryStmt.setString(2, "%" + type);
        this.preparedQueryStmt.setString(3, region);
        this.preparedQueryStmt.setString(4, region);
        return this.preparedQueryStmt.executeQuery();
    }

    protected void executeQueryPlan(int size, String type, String region) throws SQLException {
        Log.getLogWriter().info("Getting query plan for " + this.queryName + " with size=" + size + " type=" + type + " region=" + region);
        if (this.preparedQueryPlanStmt == null) {
            this.preparedQueryPlanStmt = this.connection.prepareStatement("explain " + this.query);
        }
        this.preparedQueryPlanStmt.setInt(1, size);
        this.preparedQueryPlanStmt.setString(2, "%" + type);
        this.preparedQueryPlanStmt.setString(3, region);
        this.preparedQueryPlanStmt.setString(4, region);
        ResultSet rs = this.preparedQueryPlanStmt.executeQuery();
        this.logQueryPlan(rs);
    }

    public static class Result
    implements ResultRow {
        public BigDecimal s_acctbal;
        public String s_name;
        public String n_name;
        public int p_partkey;
        public String p_mfgr;
        public String s_address;
        public String s_phone;
        public String s_comment;

        @Override
        public void init(ResultSet rs) throws SQLException {
            this.s_acctbal = rs.getBigDecimal(1);
            this.s_name = rs.getString(2);
            this.n_name = rs.getString(3);
            this.p_partkey = rs.getInt(4);
            this.p_mfgr = rs.getString(5);
            this.s_address = rs.getString(6);
            this.s_phone = rs.getString(7);
            this.s_comment = rs.getString(8);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" s_acctbal=").append(this.s_acctbal).append(" s_name=").append(this.s_name).append(" n_name=").append(this.n_name).append(" p_partkey=").append(this.p_partkey).append(" p_mfgr=").append(this.p_mfgr).append(" s_address=").append(this.s_address).append(" s_phone=").append(this.s_phone).append(" s_comment=").append(this.s_comment);
            return sb.toString();
        }

        @Override
        public String toAnswerLineFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.s_acctbal.setScale(2, RoundingMode.HALF_UP) + "|").append(this.s_name + "|").append(this.n_name + "|").append(String.format("%20d", this.p_partkey) + "|").append(this.p_mfgr + "|").append(String.format("%-40s", this.s_address) + "|").append(this.s_phone + "|").append(String.format("%-101s", this.s_comment));
            return sb.toString();
        }
    }
}

