/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import gfxdperf.tpch.Query;
import gfxdperf.tpch.ResultRow;
import hydra.Log;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractQ3
extends Query {
    public static final String BASE_DATE_STR = "1995-03-";

    public AbstractQ3() {
        this.queryName = "Q3";
        this.query = "select l_orderkey, sum(l_extendedprice*(1-l_discount)) as revenue, o_orderdate, o_shippriority from customer, orders, lineitem where c_mktsegment = ? and c_custkey = o_custkey and l_orderkey = o_orderkey and o_orderdate < ? and l_shipdate > ? group by l_orderkey, o_orderdate, o_shippriority order by revenue desc, o_orderdate";
    }

    @Override
    public String validateQuery() throws SQLException {
        String segment = String.format("%-10s", "BUILDING");
        Date date = Date.valueOf("1995-03-15");
        ResultSet rs = this.executeQuery(segment, date);
        return this.validateQuery(rs);
    }

    @Override
    public int executeQuery() throws SQLException {
        Object[] args = this.getRandomArgs();
        String segment = (String)args[0];
        Date date = (Date)args[1];
        ResultSet rs = this.executeQuery(segment, date);
        return this.readResultSet(rs);
    }

    @Override
    public void executeQueryPlan() throws SQLException {
        Object[] args = this.getRandomArgs();
        String segment = (String)args[0];
        Date date = (Date)args[1];
        this.executeQueryPlan(segment, date);
    }

    protected Object[] getRandomArgs() {
        String segment = SEGMENT[this.rng.nextInt(SEGMENT.length - 1)];
        String dateStr = BASE_DATE_STR + (this.rng.nextInt(30) + 1);
        Date date = Date.valueOf(dateStr);
        return new Object[]{segment, date};
    }

    @Override
    public ResultRow createResultRow() {
        return new Result();
    }

    protected ResultSet executeQuery(String segment, Date date) throws SQLException {
        if (this.logDML) {
            Log.getLogWriter().info(this.queryName + ": " + this.query);
            Log.getLogWriter().info("Executing " + this.queryName + " with segment=" + segment + " date=" + date);
        }
        if (this.preparedQueryStmt == null) {
            this.preparedQueryStmt = this.connection.prepareStatement(this.query);
        }
        this.preparedQueryStmt.setString(1, segment);
        this.preparedQueryStmt.setDate(2, date);
        this.preparedQueryStmt.setDate(3, date);
        return this.preparedQueryStmt.executeQuery();
    }

    protected void executeQueryPlan(String segment, Date date) throws SQLException {
        Log.getLogWriter().info("Getting query plan for " + this.queryName + " with segment=" + segment + " date=" + date);
        if (this.preparedQueryPlanStmt == null) {
            this.preparedQueryPlanStmt = this.connection.prepareStatement("explain " + this.query);
        }
        this.preparedQueryPlanStmt.setString(1, segment);
        this.preparedQueryPlanStmt.setDate(2, date);
        this.preparedQueryPlanStmt.setDate(3, date);
        ResultSet rs = this.preparedQueryPlanStmt.executeQuery();
        this.logQueryPlan(rs);
    }

    public static class Result
    implements ResultRow {
        public int l_orderKey;
        public BigDecimal revenue;
        public Date o_orderDate;
        public int o_shipPriority;

        @Override
        public void init(ResultSet rs) throws SQLException {
            this.l_orderKey = rs.getInt(1);
            this.revenue = rs.getBigDecimal(2);
            this.o_orderDate = rs.getDate(3);
            this.o_shipPriority = rs.getInt(4);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" l_orderKey=").append(this.l_orderKey).append(" revenue=").append(this.revenue).append(" o_orderDate=").append(this.o_orderDate).append(" o_shipPriority=").append(this.o_shipPriority);
            return sb.toString();
        }

        @Override
        public String toAnswerLineFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%22d", this.l_orderKey) + "|").append(this.revenue.setScale(2, RoundingMode.HALF_UP) + "|").append(this.o_orderDate + "|").append(String.format("%20d", this.o_shipPriority));
            return sb.toString();
        }
    }
}

