/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import gfxdperf.tpch.Query;
import gfxdperf.tpch.ResultRow;
import hydra.Log;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public abstract class AbstractQ4
extends Query {
    public AbstractQ4() {
        this.queryName = "Q4";
    }

    @Override
    public String validateQuery() throws SQLException {
        String dateStr = "1993-07-01";
        Date date = Date.valueOf(dateStr);
        Timestamp timestamp = Timestamp.valueOf(dateStr + " 00:00:00.0");
        ResultSet rs = this.executeQuery(date, timestamp);
        return this.validateQuery(rs);
    }

    @Override
    public int executeQuery() throws SQLException {
        Object[] args = this.getRandomArgs();
        Date date = (Date)args[0];
        Timestamp timestamp = (Timestamp)args[1];
        ResultSet rs = this.executeQuery(date, timestamp);
        return this.readResultSet(rs);
    }

    @Override
    public void executeQueryPlan() throws SQLException {
        Object[] args = this.getRandomArgs();
        Date date = (Date)args[0];
        Timestamp timestamp = (Timestamp)args[1];
        this.executeQueryPlan(date, timestamp);
    }

    protected Object[] getRandomArgs() {
        String year = "199" + (this.rng.nextInt(4) + 3);
        String month = String.format("%02d", this.rng.nextInt(year.equals("1997") ? 9 : 11) + 1);
        String dateStr = year + "-" + month + "-01";
        Date date = Date.valueOf(dateStr);
        Timestamp timestamp = Timestamp.valueOf(date + " 00:00:00.0");
        return new Object[]{date, timestamp};
    }

    @Override
    public ResultRow createResultRow() {
        return new Result();
    }

    protected ResultSet executeQuery(Date date, Timestamp timestamp) throws SQLException {
        if (this.logDML) {
            Log.getLogWriter().info(this.queryName + ": " + this.query);
            Log.getLogWriter().info("Executing " + this.queryName + " with date=" + date);
        }
        if (this.preparedQueryStmt == null) {
            this.preparedQueryStmt = this.connection.prepareStatement(this.query);
        }
        this.preparedQueryStmt.setDate(1, date);
        this.preparedQueryStmt.setTimestamp(2, timestamp);
        return this.preparedQueryStmt.executeQuery();
    }

    protected void executeQueryPlan(Date date, Timestamp timestamp) throws SQLException {
        Log.getLogWriter().info("Getting query plan for " + this.queryName + " with date=" + date);
        if (this.preparedQueryPlanStmt == null) {
            this.preparedQueryPlanStmt = this.connection.prepareStatement("explain " + this.query);
        }
        this.preparedQueryPlanStmt.setDate(1, date);
        this.preparedQueryPlanStmt.setTimestamp(2, timestamp);
        ResultSet rs = this.preparedQueryPlanStmt.executeQuery();
        this.logQueryPlan(rs);
    }

    public static class Result
    implements ResultRow {
        String o_orderpriority = null;
        int ordercount = 0;

        @Override
        public void init(ResultSet rs) throws SQLException {
            this.o_orderpriority = rs.getString(1);
            this.ordercount = rs.getInt(2);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" o_orderpriority=").append(this.o_orderpriority).append(" ordercount=").append(this.ordercount);
            return sb.toString();
        }

        @Override
        public String toAnswerLineFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.o_orderpriority + "|").append(String.format("%22d", this.ordercount));
            return sb.toString();
        }
    }
}

