/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import gfxdperf.tpch.Query;
import gfxdperf.tpch.ResultRow;
import hydra.Log;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public abstract class AbstractQ5
extends Query {
    public AbstractQ5() {
        this.queryName = "Q5";
    }

    @Override
    public String validateQuery() throws SQLException {
        String region = "ASIA";
        String dateStr = "1994-01-01";
        Date date = Date.valueOf(dateStr);
        Timestamp timestamp = Timestamp.valueOf(dateStr + " 00:00:00.0");
        ResultSet rs = this.executeQuery(region, date, timestamp);
        return this.validateQuery(rs);
    }

    @Override
    public int executeQuery() throws SQLException {
        Object[] args = this.getRandomArgs();
        String region = (String)args[0];
        Date date = (Date)args[1];
        Timestamp timestamp = (Timestamp)args[2];
        ResultSet rs = this.executeQuery(region, date, timestamp);
        return this.readResultSet(rs);
    }

    @Override
    public void executeQueryPlan() throws SQLException {
        Object[] args = this.getRandomArgs();
        String region = (String)args[0];
        Date date = (Date)args[1];
        Timestamp timestamp = (Timestamp)args[2];
        this.executeQueryPlan(region, date, timestamp);
    }

    protected Object[] getRandomArgs() {
        String region = String.format("%-25s", REGION[this.rng.nextInt(REGION.length - 1)]);
        String dateStr = "199" + (this.rng.nextInt(4) + 3) + "-01-01";
        Date date = Date.valueOf(dateStr);
        Timestamp timestamp = Timestamp.valueOf(date + " 00:00:00.0");
        return new Object[]{region, date, timestamp};
    }

    @Override
    public ResultRow createResultRow() {
        return new Result();
    }

    protected ResultSet executeQuery(String region, Date date, Timestamp timestamp) throws SQLException {
        if (this.logDML) {
            Log.getLogWriter().info(this.queryName + ": " + this.query);
            Log.getLogWriter().info("Executing " + this.queryName + " with region=" + region + ", date=" + date + ", timestamp=" + timestamp);
        }
        if (this.preparedQueryStmt == null) {
            this.preparedQueryStmt = this.connection.prepareStatement(this.query);
        }
        this.preparedQueryStmt.setString(1, region);
        this.preparedQueryStmt.setDate(2, date);
        this.preparedQueryStmt.setTimestamp(3, timestamp);
        return this.preparedQueryStmt.executeQuery();
    }

    protected void executeQueryPlan(String region, Date date, Timestamp timestamp) throws SQLException {
        Log.getLogWriter().info("Getting query plan for " + this.queryName + " with region=" + region + ", date=" + date + ", timestamp=" + timestamp);
        if (this.preparedQueryPlanStmt == null) {
            this.preparedQueryPlanStmt = this.connection.prepareStatement("explain " + this.query);
        }
        this.preparedQueryPlanStmt.setString(1, region);
        this.preparedQueryPlanStmt.setDate(2, date);
        this.preparedQueryPlanStmt.setTimestamp(3, timestamp);
        ResultSet rs = this.preparedQueryPlanStmt.executeQuery();
        this.logQueryPlan(rs);
    }

    public static class Result
    implements ResultRow {
        String n_name;
        BigDecimal revenue;

        @Override
        public void init(ResultSet rs) throws SQLException {
            this.n_name = rs.getString(1);
            this.revenue = rs.getBigDecimal(2);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" n_name=").append(this.n_name).append(" revenue=").append(this.revenue);
            return sb.toString();
        }

        @Override
        public String toAnswerLineFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.n_name + "|").append(this.revenue.setScale(2, RoundingMode.HALF_UP));
            return sb.toString();
        }
    }
}

