/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import gfxdperf.tpch.Query;
import gfxdperf.tpch.ResultRow;
import hydra.Log;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public abstract class AbstractQ6
extends Query {
    public AbstractQ6() {
        this.queryName = "Q6";
    }

    @Override
    public String validateQuery() throws SQLException {
        String dateStr = "1994-01-01";
        Date date = Date.valueOf(dateStr);
        Timestamp timestamp = Timestamp.valueOf(dateStr + " 00:00:00.0");
        double discount = 0.06;
        int quantity = 24;
        ResultSet rs = this.executeQuery(date, timestamp, discount, quantity);
        return this.validateQuery(rs);
    }

    @Override
    public int executeQuery() throws SQLException {
        Object[] args = this.getRandomArgs();
        Date date = (Date)args[0];
        Timestamp timestamp = (Timestamp)args[1];
        double discount = (Double)args[2];
        int quantity = (Integer)args[3];
        ResultSet rs = this.executeQuery(date, timestamp, discount, quantity);
        return this.readResultSet(rs);
    }

    @Override
    public void executeQueryPlan() throws SQLException {
        Object[] args = this.getRandomArgs();
        Date date = (Date)args[0];
        Timestamp timestamp = (Timestamp)args[1];
        double discount = (Double)args[2];
        int quantity = (Integer)args[3];
        this.executeQueryPlan(date, timestamp, discount, quantity);
    }

    protected Object[] getRandomArgs() {
        String dateStr = "199" + (this.rng.nextInt(4) + 3) + "-01-01";
        Date date = Date.valueOf(dateStr);
        Timestamp timestamp = Timestamp.valueOf(date + " 00:00:00.0");
        double discount = (double)(this.rng.nextInt(8) + 2) * 0.01;
        int quantity = this.rng.nextInt(1) + 24;
        return new Object[]{date, timestamp, discount, quantity};
    }

    @Override
    public ResultRow createResultRow() {
        return new Result();
    }

    protected ResultSet executeQuery(Date date, Timestamp timestamp, double discount, int quantity) throws SQLException {
        if (this.logDML) {
            Log.getLogWriter().info(this.queryName + ": " + this.query);
            Log.getLogWriter().info("Executing " + this.queryName + " with date=" + date + ", timestamp=" + timestamp + ", discount=" + discount + ", quantity=" + quantity);
        }
        if (this.preparedQueryStmt == null) {
            this.preparedQueryStmt = this.connection.prepareStatement(this.query);
        }
        this.preparedQueryStmt.setDate(1, date);
        this.preparedQueryStmt.setTimestamp(2, timestamp);
        this.preparedQueryStmt.setDouble(3, discount);
        this.preparedQueryStmt.setDouble(4, discount);
        this.preparedQueryStmt.setInt(5, quantity);
        return this.preparedQueryStmt.executeQuery();
    }

    protected void executeQueryPlan(Date date, Timestamp timestamp, double discount, int quantity) throws SQLException {
        Log.getLogWriter().info("Getting query plan for " + this.queryName + " with date=" + date + ", timestamp=" + timestamp + ", discount=" + discount + ", quantity=" + quantity);
        if (this.preparedQueryPlanStmt == null) {
            this.preparedQueryPlanStmt = this.connection.prepareStatement("explain " + this.query);
        }
        this.preparedQueryPlanStmt.setDate(1, date);
        this.preparedQueryPlanStmt.setTimestamp(2, timestamp);
        this.preparedQueryPlanStmt.setDouble(3, discount);
        this.preparedQueryPlanStmt.setDouble(4, discount);
        this.preparedQueryPlanStmt.setInt(5, quantity);
        ResultSet rs = this.preparedQueryPlanStmt.executeQuery();
        this.logQueryPlan(rs);
    }

    public static class Result
    implements ResultRow {
        BigDecimal revenue;

        @Override
        public void init(ResultSet rs) throws SQLException {
            this.revenue = rs.getBigDecimal(1);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" revenue=").append(this.revenue);
            return sb.toString();
        }

        @Override
        public String toAnswerLineFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.revenue.setScale(2, RoundingMode.HALF_UP));
            return sb.toString();
        }
    }
}

