/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import gfxdperf.tpch.Query;
import gfxdperf.tpch.ResultRow;
import hydra.Log;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractQ7
extends Query {
    public AbstractQ7() {
        this.queryName = "Q7";
        this.query = "select supp_nation, cust_nation, l_year, sum(volume) as revenue from ( select n1.n_name as supp_nation, n2.n_name as cust_nation, year(l_shipdate) as l_year, l_extendedprice * (1 - l_discount) as volume from supplier, lineitem, orders, customer, nation n1, nation n2 where s_suppkey = l_suppkey and o_orderkey = l_orderkey and c_custkey = o_custkey and s_nationkey = n1.n_nationkey and c_nationkey = n2.n_nationkey and ( (n1.n_name = ? and n2.n_name = ?) or (n1.n_name = ? and n2.n_name = ?)) and l_shipdate between '1995-01-01' and '1996-12-31') as shipping group by supp_nation, cust_nation, l_year order by supp_nation, cust_nation, l_year";
    }

    @Override
    public String validateQuery() throws SQLException {
        String nation1 = "FRANCE";
        String nation2 = "GERMANY";
        ResultSet rs = this.executeQuery(nation1, nation2);
        return this.validateQuery(rs);
    }

    @Override
    public int executeQuery() throws SQLException {
        String[] args = this.getRandomArgs();
        String nation1 = args[0];
        String nation2 = args[1];
        ResultSet rs = this.executeQuery(nation1, nation2);
        return this.readResultSet(rs);
    }

    @Override
    public void executeQueryPlan() throws SQLException {
        String[] args = this.getRandomArgs();
        String nation1 = args[0];
        String nation2 = args[1];
        this.executeQueryPlan(nation1, nation2);
    }

    protected String[] getRandomArgs() {
        int index = this.rng.nextInt(NATION.length - 1);
        String nation1 = NATION[index];
        ArrayList<String> remainingNations = new ArrayList<String>(Arrays.asList(NATION));
        remainingNations.remove(index);
        String nation2 = (String)remainingNations.get(this.rng.nextInt(remainingNations.size() - 1));
        return new String[]{nation1, nation2};
    }

    @Override
    public ResultRow createResultRow() {
        return new Result();
    }

    protected ResultSet executeQuery(String nation1, String nation2) throws SQLException {
        if (this.logDML) {
            Log.getLogWriter().info(this.queryName + ": " + this.query);
            Log.getLogWriter().info("Executing " + this.queryName + " with nation1=" + nation1 + ", nation2=" + nation2);
        }
        if (this.preparedQueryStmt == null) {
            this.preparedQueryStmt = this.connection.prepareStatement(this.query);
        }
        this.preparedQueryStmt.setString(1, nation1);
        this.preparedQueryStmt.setString(2, nation2);
        this.preparedQueryStmt.setString(3, nation2);
        this.preparedQueryStmt.setString(4, nation1);
        return this.preparedQueryStmt.executeQuery();
    }

    protected void executeQueryPlan(String nation1, String nation2) throws SQLException {
        Log.getLogWriter().info("Getting query plan for " + this.queryName + " with nation1=" + nation1 + ", nation2=" + nation2);
        if (this.preparedQueryPlanStmt == null) {
            this.preparedQueryPlanStmt = this.connection.prepareStatement("explain " + this.query);
        }
        this.preparedQueryPlanStmt.setString(1, nation1);
        this.preparedQueryPlanStmt.setString(2, nation2);
        this.preparedQueryPlanStmt.setString(3, nation2);
        this.preparedQueryPlanStmt.setString(4, nation1);
        ResultSet rs = this.preparedQueryPlanStmt.executeQuery();
        this.logQueryPlan(rs);
    }

    public static class Result
    implements ResultRow {
        String suppNation;
        String custNation;
        String year;
        BigDecimal revenue;

        @Override
        public void init(ResultSet rs) throws SQLException {
            this.suppNation = rs.getString(1);
            this.custNation = rs.getString(2);
            this.year = rs.getString(3);
            this.revenue = rs.getBigDecimal(4);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" suppNation=").append(this.suppNation).append(" custNation=").append(this.custNation).append(" year=").append(this.year).append(" revenue=").append(this.revenue);
            return sb.toString();
        }

        @Override
        public String toAnswerLineFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%-25s", this.suppNation) + "|").append(String.format("%-25s", this.custNation) + "|").append(String.format("%20s", this.year) + "|").append(this.revenue.setScale(2, RoundingMode.HALF_UP));
            return sb.toString();
        }
    }
}

