/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import gfxdperf.tpch.Query;
import gfxdperf.tpch.ResultRow;
import hydra.Log;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractQ8
extends Query {
    public AbstractQ8() {
        this.queryName = "Q8";
        this.query = "select o_year, sum(case when nation = ? then volume else 0 end) / sum(volume) as mkt_share from ( select year(o_orderdate) as o_year, l_extendedprice * (1-l_discount) as volume, n2.n_name as nation from part, supplier, lineitem, orders, customer, nation n1, nation n2, region where p_partkey = l_partkey and s_suppkey = l_suppkey and l_orderkey = o_orderkey and o_custkey = c_custkey and c_nationkey = n1.n_nationkey and n1.n_regionkey = r_regionkey and r_name = ? and s_nationkey = n2.n_nationkey and o_orderdate between '1995-01-01' and '1996-12-31' and p_type = ? ) as all_nations group by o_year order by o_year";
    }

    @Override
    public String validateQuery() throws SQLException {
        String nation = "BRAZIL";
        String region = "AMERICA";
        String type = "ECONOMY ANODIZED STEEL";
        ResultSet rs = this.executeQuery(nation, region, type);
        return this.validateQuery(rs);
    }

    @Override
    public int executeQuery() throws SQLException {
        String[] args = this.getRandomArgs();
        String nation = args[0];
        String region = args[1];
        String type = args[2];
        ResultSet rs = this.executeQuery(nation, region, type);
        return this.readResultSet(rs);
    }

    @Override
    public void executeQueryPlan() throws SQLException {
        String[] args = this.getRandomArgs();
        String nation = args[0];
        String region = args[1];
        String type = args[2];
        this.executeQueryPlan(nation, region, type);
    }

    protected String[] getRandomArgs() {
        String nation = NATION[this.rng.nextInt(NATION.length - 1)];
        String region = (String)nationToRegionMap.get(nation);
        String type = SYLLABLE1[this.rng.nextInt(SYLLABLE1.length - 1)] + " " + SYLLABLE2[this.rng.nextInt(SYLLABLE2.length - 1)] + " " + SYLLABLE3[this.rng.nextInt(SYLLABLE3.length - 1)];
        return new String[]{nation, region, type};
    }

    @Override
    public ResultRow createResultRow() {
        return new Result();
    }

    protected ResultSet executeQuery(String nation, String region, String type) throws SQLException {
        if (this.logDML) {
            Log.getLogWriter().info(this.queryName + ": " + this.query);
            Log.getLogWriter().info("Executing " + this.queryName + " with nation=" + nation + ", region=" + region + ", type=" + type);
        }
        if (this.preparedQueryStmt == null) {
            this.preparedQueryStmt = this.connection.prepareStatement(this.query);
        }
        this.preparedQueryStmt.setString(1, nation);
        this.preparedQueryStmt.setString(2, region);
        this.preparedQueryStmt.setString(3, type);
        return this.preparedQueryStmt.executeQuery();
    }

    protected void executeQueryPlan(String nation, String region, String type) throws SQLException {
        Log.getLogWriter().info("Getting query plan for " + this.queryName + " with nation=" + nation + ", region=" + region + ", type=" + type);
        if (this.preparedQueryPlanStmt == null) {
            this.preparedQueryPlanStmt = this.connection.prepareStatement("explain " + this.query);
        }
        this.preparedQueryPlanStmt.setString(1, nation);
        this.preparedQueryPlanStmt.setString(2, region);
        this.preparedQueryPlanStmt.setString(3, type);
        ResultSet rs = this.preparedQueryPlanStmt.executeQuery();
        this.logQueryPlan(rs);
    }

    public static class Result
    implements ResultRow {
        String year;
        BigDecimal mktShare;

        @Override
        public void init(ResultSet rs) throws SQLException {
            this.year = rs.getString(1);
            this.mktShare = rs.getBigDecimal(2);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" year=").append(this.year).append(" mktShare=").append(this.mktShare);
            return sb.toString();
        }

        @Override
        public String toAnswerLineFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%20s", this.year) + "|").append(this.mktShare.setScale(2, RoundingMode.HALF_UP));
            return sb.toString();
        }
    }
}

