/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import gfxdperf.PerfTestException;
import gfxdperf.tpch.ResultRow;
import gfxdperf.tpch.TPCHPrms;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public abstract class Query {
    protected boolean logDML = TPCHPrms.logDML();
    protected boolean logDMLResults = TPCHPrms.logDMLResults();
    protected PreparedStatement preparedQueryStmt = null;
    protected PreparedStatement preparedQueryPlanStmt = null;
    protected Connection connection = null;
    protected Random rng = null;
    protected String queryName = null;
    protected String query = null;
    protected static final String[] REGION = new String[]{"AFRICA", "AMERICA", "ASIA", "EUROPE", "MIDDLE EAST"};
    protected static final String[] SEGMENT = new String[]{"AUTOMOBILE", "BUILDING", "FURNITURE", "MACHINERY", "HOUSEHOLD"};
    protected static final String[] TYPE = new String[]{"TIN", "NICKEL", "BRASS", "STEEL", "COPPER"};
    protected static final String[] NATION = new String[]{"ALGERIA", "ARGENTINA", "BRAZIL", "CANADA", "EGYPT", "ETHIOPIA", "FRANCE", "GERMANY", "INDIA", "INDONESIA", "IRAN", "IRAQ", "JAPAN", "JORDAN", "KENYA", "MOROCCO", "MOZAMBIQUE", "PERU", "CHINA", "ROMANIA", "SAUDI ARABIA", "VIETNAM", "RUSSIA", "UNITED KINGDOM", "UNITED STATES"};
    protected static final String[] SYLLABLE1 = new String[]{"STANDARD", "SMALL", "MEDIUM", "LARGE", "ECONOMY", "PROMO"};
    protected static final String[] SYLLABLE2 = new String[]{"ANODIZED", "BURNISHED", "PLATED", "POLISHED", "BRUSHED"};
    protected static final String[] SYLLABLE3 = new String[]{"TIN", "NICKEL", "BRASS", "STEEL", "COPPER"};
    protected static Map<String, String> nationToRegionMap = new HashMap<String, String>();
    protected static final int REGION_COL_LENGTH = 25;
    protected static final String REGION_FORMAT_STR = "%-25s";
    protected static final int SEGMENT_COL_LENGTH = 10;
    protected static final String SEGMENT_FORMAT_STR = "%-10s";

    public abstract String validateQuery() throws SQLException;

    public abstract int executeQuery() throws SQLException;

    public abstract void executeQueryPlan() throws SQLException;

    public abstract ResultRow createResultRow();

    protected String validateQuery(ResultSet rs) throws SQLException {
        return this.validateQuery(rs, false, true);
    }

    protected String validateQuery(ResultSet rs, boolean limitRowCount, boolean checkResultOrder) throws SQLException {
        String answerFile = EnvHelper.expandPath((String)("$JTESTS/gfxdperf/tpch/answers/" + this.queryName.toLowerCase() + ".out"));
        List<String> answerLines = new ArrayList();
        try {
            Log.getLogWriter().info("Reading query answers from " + answerFile);
            answerLines = FileUtil.getTextAsList((String)answerFile);
            answerLines.remove(0);
        }
        catch (FileNotFoundException e) {
            String s = "Unable to find answer file: " + answerFile;
            throw new PerfTestException(s);
        }
        catch (IOException e) {
            String s = "Unable to read answer file: " + answerFile;
            throw new PerfTestException(s);
        }
        int numExpectedRows = answerLines.size();
        StringBuilder sb = new StringBuilder();
        sb.append("Answer lines\n");
        for (String line : answerLines) {
            sb.append("Answer line:" + line + "\n");
        }
        Log.getLogWriter().info(sb.toString());
        ArrayList<String> qResults = new ArrayList<String>();
        int rowCount = 0;
        while (rs.next()) {
            ++rowCount;
            ResultRow result = this.createResultRow();
            result.init(rs);
            String answerLineFormat = result.toAnswerLineFormat();
            qResults.add(answerLineFormat);
            if (this.logDMLResults) {
                Log.getLogWriter().info("Result row " + rowCount + ": " + result + "\n" + "   Answer line format:" + answerLineFormat);
            }
            if (!limitRowCount || rowCount != numExpectedRows) continue;
            if (!rs.next()) break;
            Log.getLogWriter().info("Stopped reading rows at row count " + rowCount);
            break;
        }
        rs.close();
        rs = null;
        StringBuilder errStr = new StringBuilder();
        Log.getLogWriter().info("Expected number of rows is " + answerLines.size() + ", number of rows in result set is " + qResults.size());
        if (qResults.size() != answerLines.size()) {
            String s = "For " + this.queryName + " expected the query result size to be " + answerLines.size() + " but it is " + qResults.size() + "\n";
            errStr.append(s);
        }
        HashSet<String> extraResults = new HashSet<String>();
        extraResults.addAll(qResults);
        extraResults.removeAll(answerLines);
        HashSet<String> missingResults = new HashSet<String>();
        missingResults.addAll(answerLines);
        missingResults.removeAll(qResults);
        if (extraResults.size() != 0) {
            sb = new StringBuilder();
            for (String result : extraResults) {
                sb.append("Extra:" + result + "\n");
            }
            errStr.append("For " + this.queryName + " found " + extraResults.size() + " extra rows in query result:\n" + sb + "\n");
        }
        if (missingResults.size() != 0) {
            sb = new StringBuilder();
            for (String result : missingResults) {
                sb.append("Missing:" + result + "\n");
            }
            errStr.append("For " + this.queryName + " found " + missingResults.size() + " missing rows in query result:\n" + sb + "\n");
        }
        if (checkResultOrder) {
            Log.getLogWriter().info("Checking order of rows");
            for (int i = 0; i < Math.min(answerLines.size(), qResults.size()); ++i) {
                String answerLineRow = answerLines.get(i);
                String resultRow = (String)qResults.get(i);
                if (resultRow.equals(answerLineRow)) continue;
                int rowNumber = i + 1;
                errStr.append("Rows are not in the expected order starting at row " + rowNumber + ", " + " answerLine " + rowNumber + ": " + answerLineRow + ", " + " resultRow " + rowNumber + ": " + resultRow + "\n");
                break;
            }
        }
        if (errStr.length() > 0) {
            Log.getLogWriter().info(errStr.toString());
            String additionalLogStr = this.getKnownBugNumber(qResults, answerLines, missingResults, extraResults);
            return additionalLogStr + "Validation for " + this.queryName + " failed, see log for details\n";
        }
        Log.getLogWriter().info("Query " + this.queryName + " was successfully validated");
        return "";
    }

    protected String getKnownBugNumber(List<String> qResults, List<String> answerLines, Set<String> missingResults, Set<String> extraResults) {
        return "";
    }

    protected int readResultSet(ResultSet rs) throws SQLException {
        int resultSize = 0;
        ResultRow result = this.createResultRow();
        while (rs.next()) {
            result.init(rs);
            if (this.logDMLResults) {
                Log.getLogWriter().info("Result:" + result);
            }
            ++resultSize;
        }
        if (!TPCHPrms.allowEmptyResultSet() && resultSize == 0) {
            String s = "Unexpected empty result set for " + this.queryName;
            throw new PerfTestException(s);
        }
        rs.close();
        rs = null;
        if (this.logDML) {
            Log.getLogWriter().info("Completed execution of " + this.queryName + ", result set size is " + resultSize);
        }
        return resultSize;
    }

    protected void logQueryPlan(ResultSet rs) throws SQLException {
        StringBuilder sb = new StringBuilder();
        while (rs.next()) {
            Clob clob = rs.getClob(1);
            sb.append(clob.getSubString(1L, (int)clob.length()) + "\n");
        }
        Log.getLogWriter().info("Query plan for " + this.queryName + ":\n" + sb.toString());
        rs.close();
    }

    static {
        nationToRegionMap.put("ALGERIA", "AFRICA");
        nationToRegionMap.put("ARGENTINA", "AMERICA");
        nationToRegionMap.put("BRAZIL", "AMERICA");
        nationToRegionMap.put("CANADA", "AMERICA");
        nationToRegionMap.put("EGYPT", "MIDDLE EAST");
        nationToRegionMap.put("ETHIOPIA", "AFRICA");
        nationToRegionMap.put("FRANCE", "EUROPE");
        nationToRegionMap.put("GERMANY", "EUROPE");
        nationToRegionMap.put("INDIA", "ASIA");
        nationToRegionMap.put("INDONESIA", "ASIA");
        nationToRegionMap.put("IRAN", "MIDDLE EAST");
        nationToRegionMap.put("IRAQ", "MIDDLE EAST");
        nationToRegionMap.put("JAPAN", "ASIA");
        nationToRegionMap.put("JORDAN", "MIDDLE EAST");
        nationToRegionMap.put("KENYA", "AFRICA");
        nationToRegionMap.put("MOROCCO", "AFRICA");
        nationToRegionMap.put("MOZAMBIQUE", "AFRICA");
        nationToRegionMap.put("PERU", "AMERICA");
        nationToRegionMap.put("CHINA", "ASIA");
        nationToRegionMap.put("ROMANIA", "EUROPE");
        nationToRegionMap.put("SAUDI ARABIA", "MIDDLE EAST");
        nationToRegionMap.put("VIETNAM", "ASIA");
        nationToRegionMap.put("RUSSIA", "EUROPE");
        nationToRegionMap.put("UNITED KINGDOM", "EUROPE");
        nationToRegionMap.put("UNITED STATES", "AMERICA");
    }
}

