/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch;

import com.gemstone.gemfire.internal.NanoTimer;
import gfxdperf.PerfClient;
import gfxdperf.PerfTestException;
import gfxdperf.tpch.DB;
import gfxdperf.tpch.DBException;
import gfxdperf.tpch.TPCHPrms;
import hydra.HydraThreadLocal;

public class TPCHClient
extends PerfClient {
    private static HydraThreadLocal localdb = new HydraThreadLocal();
    private static HydraThreadLocal localrng = new HydraThreadLocal();
    private static HydraThreadLocal localQueryPlanFrequency = new HydraThreadLocal();
    private static HydraThreadLocal localLastQueryPlanTime = new HydraThreadLocal();
    protected DB db;
    protected int queryPlanFrequency = 0;
    protected long lastQueryPlanTime = 0L;

    @Override
    public void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.db = (DB)localdb.get();
        this.queryPlanFrequency = (Integer)localQueryPlanFrequency.get();
        this.lastQueryPlanTime = (Long)localLastQueryPlanTime.get();
    }

    @Override
    public void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        localdb.set((Object)this.db);
        localQueryPlanFrequency.set((Object)this.queryPlanFrequency);
        localLastQueryPlanTime.set((Object)this.lastQueryPlanTime);
    }

    @Override
    protected void initialize() {
        localQueryPlanFrequency.set((Object)this.queryPlanFrequency);
        localLastQueryPlanTime.set((Object)this.lastQueryPlanTime);
        super.initialize();
    }

    protected long completeTask(String trimIntervalName) {
        throw new UnsupportedOperationException();
    }

    protected void validateQueries() throws DBException {
        this.db.validateQueries();
    }

    protected void validateQuery() throws DBException {
        this.db.validateQuery(TPCHPrms.getQueryNumber());
    }

    protected void doWorkload() throws DBException, InterruptedException {
        String trimIntervalName = TPCHPrms.getTrimInterval();
        double throttledOpsPerSecond = TPCHPrms.getThrottledOpsPerSecond();
        boolean throttle = throttledOpsPerSecond > 0.0;
        int interval = (int)(1000.0 / throttledOpsPerSecond);
        this.terminator.startBatch();
        if (throttle) {
            Thread.sleep(this.rng.nextInt(interval));
        }
        while (!this.terminator.batchComplete()) {
            long elapsed;
            int remaining;
            if (this.terminator.warmupComplete()) {
                this.sync();
                if (throttle) {
                    Thread.sleep(this.rng.nextInt(interval));
                }
                this.terminator.startWork();
            }
            if (this.terminator.workComplete()) {
                long timestamp = this.completeTask(trimIntervalName);
                this.terminator.reportTrimInterval(this, trimIntervalName, timestamp);
                this.updateHydraThreadLocals();
                this.terminator.terminateTask();
            }
            long start = NanoTimer.getTime();
            if (this.queryPlanFrequency != 0 && this.timeToExecuteQueryPlan()) {
                this.db.executeQueryPlan(TPCHPrms.getQueryNumber());
            } else {
                this.db.executeQuery(TPCHPrms.getQueryNumber());
            }
            if (!throttle || (remaining = interval - (int)((elapsed = NanoTimer.getTime() - start) / 1000000L)) <= 0) continue;
            Thread.sleep(remaining);
        }
        this.updateHydraThreadLocals();
        this.terminator.terminateBatch();
    }

    private boolean timeToExecuteQueryPlan() {
        if (this.queryPlanFrequency == 0) {
            return false;
        }
        if (this.queryPlanFrequency == -1) {
            return true;
        }
        if (this.queryPlanFrequency > 0) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastQueryPlanTime >= (long)(this.queryPlanFrequency * 1000)) {
                this.lastQueryPlanTime = currentTime;
                return true;
            }
            return false;
        }
        throw new PerfTestException("Unknown value of queryPlanFrequency: " + this.queryPlanFrequency);
    }
}

