/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch.gfxd;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class GFXDPrms
extends BasePrms {
    public static final String ALL = "ALL";
    public static final int TRANSACTION_NONE = 0;
    private static final String DEFAULT_HDFS_CLIENT_CONFIG_FILE = "$JTESTS/gfxdperf/tpch/gfxd/gfxd-client-config.xml";
    public static Long autocommit;
    public static Long bucketCount;
    public static Long connectionType;
    public static Long enableStats;
    public static Long enableTimeStats;
    public static Long failOnLoadImbalance;
    public static Long hdfsClientConfigFile;
    public static Long hdfsFlushQueues;
    public static Long hdfsForceCompaction;
    public static Long hdfsTables;
    public static Long indexes;
    public static Long isHA;
    public static Long offHeapTables;
    public static Long partitionRedundancy;
    public static Long persistentTables;
    public static Long queryHDFS;
    public static Long queryPlanFrequency;
    public static Long queryPlanners;
    public static Long skipConstraintChecks;
    public static Long skipListeners;
    public static Long txIsolation;
    public static Long useHDFS;
    public static Long useHDFSWriteOnly;

    public static boolean getAutoCommit() {
        Long key = autocommit;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static int getBucketCount() {
        Long key = bucketCount;
        int val = GFXDPrms.tasktab().intAt(key, GFXDPrms.tab().intAt(key, -1));
        if (val < 0) {
            String s = "Illegal value for " + GFXDPrms.nameForKey((Long)key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static ConnectionType getConnectionType() {
        Long key = connectionType;
        String val = GFXDPrms.tasktab().stringAt(key, GFXDPrms.tab().stringAt(key, null));
        if (val == null) {
            String s = GFXDPrms.nameForKey((Long)key) + " is a required parameter";
            throw new HydraConfigException(s);
        }
        for (ConnectionType c : ConnectionType.values()) {
            if (!val.equalsIgnoreCase(c.toString())) continue;
            return c;
        }
        String s = "Illegal value for " + GFXDPrms.nameForKey((Long)key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static boolean enableStats() {
        Long key = enableStats;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static boolean enableTimeStats() {
        Long key = enableTimeStats;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static boolean getFailOnLoadImbalance() {
        Long key = failOnLoadImbalance;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, true));
    }

    public static String getHDFSClientConfigFile() {
        Long key = hdfsClientConfigFile;
        return GFXDPrms.tasktab().stringAt(key, GFXDPrms.tab().stringAt(key, DEFAULT_HDFS_CLIENT_CONFIG_FILE));
    }

    public static boolean hdfsFlushQueues() {
        Long key = hdfsFlushQueues;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static boolean hdfsForceCompaction() {
        Long key = hdfsForceCompaction;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static List<String> getHDFSTables() {
        Long key = hdfsTables;
        return GFXDPrms.asTablesList((Vector)GFXDPrms.tab().vecAt(key, null));
    }

    public static List<String> getIndexes() {
        Long key = indexes;
        HydraVector v = GFXDPrms.tab().vecAt(key, null);
        ArrayList<String> l = new ArrayList<String>();
        if (v != null) {
            l.addAll((Collection<String>)v);
        }
        return l;
    }

    public static boolean isHA() {
        Long key = isHA;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static List<String> getOffHeapTables() {
        Long key = offHeapTables;
        return GFXDPrms.asTablesList((Vector)GFXDPrms.tab().vecAt(key, null));
    }

    public static int getPartitionRedundancy() {
        Long key = partitionRedundancy;
        return GFXDPrms.tasktab().intAt(key, GFXDPrms.tab().intAt(key, 1));
    }

    public static List<String> getPersistentTables() {
        Long key = persistentTables;
        return GFXDPrms.asTablesList((Vector)GFXDPrms.tab().vecAt(key, null));
    }

    public static boolean queryHDFS() {
        Long key = queryHDFS;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static int getQueryPlanFrequency() {
        Long key = queryPlanFrequency;
        return GFXDPrms.tasktab().intAt(key, GFXDPrms.tab().intAt(key, 0));
    }

    public static int getQueryPlanners() {
        Long key = queryPlanners;
        return GFXDPrms.tasktab().intAt(key, GFXDPrms.tab().intAt(key, 1));
    }

    public static boolean skipConstraintChecks() {
        Long key = skipConstraintChecks;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static boolean skipListeners() {
        Long key = skipListeners;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static int getTxIsolation() {
        Long key = txIsolation;
        String val = GFXDPrms.tasktab().stringAt(key, GFXDPrms.tab().stringAt(key, "none"));
        return GFXDPrms.getTxIsolation(key, val);
    }

    private static int getTxIsolation(Long key, String val) {
        if (val.equalsIgnoreCase("none")) {
            return 0;
        }
        if (val.equalsIgnoreCase("read_uncommitted") || val.equalsIgnoreCase("readUncommitted")) {
            return 1;
        }
        if (val.equalsIgnoreCase("read_committed") || val.equalsIgnoreCase("readCommitted")) {
            return 2;
        }
        if (val.equalsIgnoreCase("repeatable_read") || val.equalsIgnoreCase("repeatableRead")) {
            return 4;
        }
        if (val.equalsIgnoreCase("serializable")) {
            return 8;
        }
        String s = "Illegal value for " + GFXDPrms.nameForKey((Long)key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static String getTxIsolation(int n) {
        switch (n) {
            case 0: {
                return "none";
            }
            case 1: {
                return "read_uncommitted";
            }
            case 2: {
                return "read_committed";
            }
            case 4: {
                return "repeatable_read";
            }
            case 8: {
                return "serializable";
            }
        }
        String s = "Unknown transaction isolation level: " + n;
        throw new HydraConfigException(s);
    }

    public static boolean useHDFS() {
        Long key = useHDFS;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    public static boolean useHDFSWriteOnly() {
        Long key = useHDFSWriteOnly;
        return GFXDPrms.tasktab().booleanAt(key, GFXDPrms.tab().booleanAt(key, false));
    }

    private static List<String> asTablesList(Vector v) {
        ArrayList<String> tables = new ArrayList<String>();
        if (v != null) {
            tables.addAll(v);
        }
        for (String table : tables) {
            if (!table.equalsIgnoreCase(ALL)) continue;
            tables = new ArrayList();
            tables.add(ALL);
            return tables;
        }
        return tables;
    }

    static {
        GFXDPrms.setValues(GFXDPrms.class);
    }

    public static enum ConnectionType {
        peer,
        thin;

    }
}

