/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch.gfxd;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class GFXDStats
extends PerformanceStatistics {
    protected static final String HDFS_FLUSH_QUEUES = "hdfsFlushQueues";
    protected static final String HDFS_FLUSH_QUEUE_TIME = "hdfsFlushQueueTime";
    protected static final String HDFS_FORCE_COMPACTIONS = "hdfsForceCompactions";
    protected static final String HDFS_FORCE_COMPACTION_TIME = "hdfsForceCompactionTime";
    protected static final String IMPORT_TABLE_ROWS = "importTableRows";
    protected static final String IMPORT_TABLE_TIME = "importTableTime";
    protected static final String CREATE_INDEX = "createIndex";
    protected static final String CREATE_INDEX_TIME = "createIndexTime";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{GFXDStats.factory().createIntCounter(HDFS_FLUSH_QUEUES, "Number of HDFS flush queue stored procedures executed.", "operations", largerIsBetter), GFXDStats.factory().createLongCounter(HDFS_FLUSH_QUEUE_TIME, "Total time spent executing HDFS flush queue stored procedures.", "nanoseconds", !largerIsBetter), GFXDStats.factory().createIntCounter(HDFS_FORCE_COMPACTIONS, "Number of HDFS force compaction stored procedures executed.", "operations", largerIsBetter), GFXDStats.factory().createLongCounter(HDFS_FORCE_COMPACTION_TIME, "Total time spent executing HDFS force compaction stored procedures.", "nanoseconds", !largerIsBetter), GFXDStats.factory().createIntCounter(IMPORT_TABLE_ROWS, "Number of rows imported in this table.", "rows", largerIsBetter), GFXDStats.factory().createLongCounter(IMPORT_TABLE_TIME, "Total time spent importing rows into this table.", "nanoseconds", !largerIsBetter), GFXDStats.factory().createIntCounter(CREATE_INDEX, "Number of indexes created.", "rows", largerIsBetter), GFXDStats.factory().createLongCounter(CREATE_INDEX_TIME, "Total time spent creating indexes.", "nanoseconds", !largerIsBetter)};
    }

    public static GFXDStats getInstance() {
        return (GFXDStats)GFXDStats.getInstance(GFXDStats.class, (int)0);
    }

    public GFXDStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public long startHDFSFlushQueues() {
        return NanoTimer.getTime();
    }

    public void endHDFSFlushQueues(long start) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(HDFS_FLUSH_QUEUES, 1);
        this.statistics().incLong(HDFS_FLUSH_QUEUE_TIME, elapsed);
    }

    public long startHDFSForceCompaction() {
        return NanoTimer.getTime();
    }

    public void endHDFSForceCompaction(long start) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(HDFS_FORCE_COMPACTIONS, 1);
        this.statistics().incLong(HDFS_FORCE_COMPACTION_TIME, elapsed);
    }

    public long startImportTable() {
        return NanoTimer.getTime();
    }

    public void endImportTable(long start, int rows) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(IMPORT_TABLE_ROWS, rows);
        this.statistics().incLong(IMPORT_TABLE_TIME, elapsed);
    }

    public long startCreateIndex() {
        return NanoTimer.getTime();
    }

    public void endCreateIndex(long start) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(CREATE_INDEX, 1);
        this.statistics().incLong(CREATE_INDEX_TIME, elapsed);
    }
}

