/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch.oracle;

import gfxdperf.PerfTestException;
import gfxdperf.terminators.TrimReporter;
import gfxdperf.tpch.DBException;
import gfxdperf.tpch.TPCHClient;
import gfxdperf.tpch.TPCHPrms;
import gfxdperf.tpch.oracle.OracleDB;
import gfxdperf.tpch.oracle.OracleStats;
import hydra.FileUtil;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.gemfirexd.LonerHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import resultsUtil.FileLineReader;

public class OracleClient
extends TPCHClient {
    public static String COLUMN_PREFIX = "field";
    public static final String IN_DDL_FILE = System.getProperty("JTESTS") + "/gfxdperf/tpch/oracle/ddl.sql";
    public static final String OUT_DDL_FILE = System.getProperty("user.dir") + "/ddl.sql";
    public static final String PRIMARY_KEY = "TPCH_KEY";
    public static final String LIST_INDEXES_QUERY = "SELECT index_name, column_name FROM all_ind_columns WHERE index_owner = 'SYSTEM' and table_name = ";
    protected static HydraThreadLocal localoraclestats = new HydraThreadLocal();
    protected OracleStats oraclestats;

    @Override
    public void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.oraclestats = (OracleStats)((Object)localoraclestats.get());
    }

    @Override
    public void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        localoraclestats.set((Object)this.oraclestats);
    }

    public static void startLonerTask() {
        LonerHelper.connect();
    }

    public static void generateDDLTask() throws IOException {
        OracleClient client = new OracleClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.generateDDL();
        }
    }

    private void generateDDL() throws IOException {
        String ddl = this.generateTableDDL();
        FileUtil.writeToFile((String)OUT_DDL_FILE, (String)ddl);
    }

    private String generateTableDDL() throws FileNotFoundException, IOException {
        StringBuilder sql = new StringBuilder();
        List<String> ddls = this.getDDLStatements(IN_DDL_FILE);
        for (String ddl : ddls) {
            sql.append(ddl);
            sql.append(";\n");
        }
        return sql.toString();
    }

    private List<String> getDDLStatements(String fn) throws FileNotFoundException, IOException {
        String[] tokens;
        String text = FileUtil.getText((String)fn).trim();
        ArrayList<String> stmts = new ArrayList<String>();
        for (String token : tokens = text.split(";")) {
            String stmt = token.trim();
            stmts.add(stmt);
        }
        return stmts;
    }

    public static void executeDDLTask() throws IOException, SQLException {
        OracleClient client = new OracleClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.executeDDL();
        }
    }

    private void executeDDL() throws IOException, SQLException {
        Connection conn = ((OracleDB)this.db).getConnection();
        Statement stmt = conn.createStatement();
        List<String> ddls = this.getDDLStatements(OUT_DDL_FILE);
        for (String ddl : ddls) {
            if (ddl.length() <= 0) continue;
            Log.getLogWriter().info("Executing DDL: " + ddl);
            boolean result = stmt.execute(ddl);
            Log.getLogWriter().info("Executed DDL: " + ddl + " with result " + result);
        }
        stmt.close();
        conn.commit();
    }

    public static void createIndexesTask() throws DBException {
        OracleClient client = new OracleClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.createIndexes();
        }
    }

    protected void createIndexes() throws DBException {
        List<String> indexes = TPCHPrms.getIndexes();
        Log.getLogWriter().info("Creating indexes: " + indexes);
        for (String indexStmt : indexes) {
            try {
                Log.getLogWriter().info("Executing " + indexStmt);
                long startTime = this.oraclestats.startCreateIndex();
                this.db.createIndex(indexStmt);
                this.oraclestats.endCreateIndex(startTime);
                Log.getLogWriter().info("Done executing " + indexStmt);
            }
            catch (DBException e) {
                Throwable cause = e.getCause();
                if (cause.getMessage().contains("ORA-01408: such column list already indexed")) {
                    Log.getLogWriter().info("Already an index for " + indexStmt + "; " + cause.getMessage());
                    continue;
                }
                throw e;
            }
        }
        Log.getLogWriter().info("Created indexes: " + indexes);
    }

    public static void listIndexes() throws DBException, FileNotFoundException, IOException {
        OracleClient client = new OracleClient();
        client.initialize();
        List<String> ddls = client.getDDLStatements(IN_DDL_FILE);
        block2: for (String createStmt : ddls) {
            String[] tokens = createStmt.split("[\\s]+");
            for (int i = 0; i < tokens.length; ++i) {
                if (i + 2 >= tokens.length || !tokens[i].toLowerCase().endsWith("create") || !tokens[i + 1].toLowerCase().equals("table")) continue;
                String tableName = tokens[i + 2];
                String sql = "SELECT index_name, column_name FROM all_ind_columns WHERE index_owner = 'SYSTEM' and table_name = '" + tableName + "'";
                ResultSet rs = (ResultSet)client.db.executeSql(sql);
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Indexes on table " + tableName + ":\n");
                    while (rs.next()) {
                        sb.append("   index " + rs.getString(1) + " on column " + rs.getString(2) + "\n");
                    }
                    rs.close();
                    Log.getLogWriter().info(sb.toString());
                    continue block2;
                }
                catch (SQLException e) {
                    String s = "Unable to process output of " + sql;
                    throw new DBException(s);
                }
            }
        }
    }

    public static void dropIndexes() throws DBException {
        Log.getLogWriter().info("Removing indexes....");
        OracleClient client = new OracleClient();
        client.initialize();
        Map<String, List<String>> indexMap = OracleClient.getIndexMap();
        for (String tableName : indexMap.keySet()) {
            List<String> indexList = indexMap.get(tableName);
            for (String indexName : indexList) {
                String sql = "DROP INDEX " + indexName;
                Log.getLogWriter().info("Executing " + sql);
                try {
                    client.db.executeSql(sql);
                }
                catch (DBException e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause.getMessage().contains("specified index does not exist")) {
                        Log.getLogWriter().info(cause.getMessage());
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    protected static Map<String, List<String>> getIndexMap() {
        String[] dirContents;
        String INDEX_FILE_SUFFIX = "_index.inc";
        HashMap<String, List<String>> indexMap = new HashMap<String, List<String>>();
        String dirPath = System.getProperty("JTESTS") + File.separator + "gfxdperf" + File.separator + "tpch";
        File dir = new File(dirPath);
        for (String fileName : dirContents = dir.list()) {
            FileLineReader flr;
            if (!fileName.endsWith("_index.inc")) continue;
            try {
                flr = new FileLineReader(dir.getAbsoluteFile() + File.separator + fileName);
            }
            catch (FileNotFoundException e) {
                String s = "Not able to find " + fileName;
                throw new PerfTestException(s);
            }
            String line = flr.readNextLine();
            while (line != null) {
                String[] tokens = line.split("[\\s]+");
                for (int i = 0; i < tokens.length; ++i) {
                    if (i + 4 >= tokens.length || !tokens[i].toLowerCase().endsWith("create") || !tokens[i + 1].toLowerCase().equals("index") || !tokens[i + 3].toLowerCase().equals("on")) continue;
                    String indexName = tokens[i + 2];
                    String tableName = tokens[i + 4];
                    ArrayList<String> indexList = (ArrayList<String>)indexMap.get(tableName);
                    if (indexList == null) {
                        indexList = new ArrayList<String>();
                    }
                    indexList.add(indexName);
                    indexMap.put(tableName, indexList);
                    break;
                }
                line = flr.readNextLine();
            }
        }
        return indexMap;
    }

    public static void initDBTask() throws DBException {
        OracleClient client = new OracleClient();
        client.initialize();
        client.initDB();
        client.updateHydraThreadLocals();
    }

    protected void initDB() throws DBException {
        this.db = new OracleDB();
        this.db.init((Random)this.rng);
        this.oraclestats = OracleStats.getInstance();
    }

    public static void cleanupDBTask() throws DBException, InterruptedException {
        OracleClient client = new OracleClient();
        client.initialize();
        client.cleanupDB();
        client.updateHydraThreadLocals();
    }

    protected void cleanupDB() throws DBException, InterruptedException {
        if (this.oraclestats != null) {
            Thread.sleep(2000L);
            this.oraclestats.close();
            this.oraclestats = null;
        }
        this.db.cleanup();
    }

    public static void dropTableTask() throws DBException {
        OracleClient client = new OracleClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.dropTable();
        }
    }

    protected void dropTable() throws DBException {
        TPCHPrms.TableName tableName = TPCHPrms.getTableName();
        this.db.dropTable(tableName);
    }

    public static void importTableTask() throws DBException {
        OracleClient client = new OracleClient();
        client.initialize();
        if (client.ttgid == 0) {
            client.importTable();
        }
    }

    protected void importTable() throws DBException {
        String trimIntervalName = TPCHPrms.getTrimInterval();
        TPCHPrms.TableName tableName = TPCHPrms.getTableName();
        String fn = TPCHPrms.getDataPath() + "/" + tableName.toString().toLowerCase() + ".tbl";
        int rows = this.getRowCount(fn);
        long startTime = this.oraclestats.startImportTable();
        this.db.importTable(fn, tableName);
        long endTime = this.completeTask(trimIntervalName);
        this.oraclestats.endImportTable(endTime, rows);
        TrimReporter.reportTrimInterval(this, trimIntervalName, startTime, endTime, true);
    }

    protected int getRowCount(String fn) {
        int rows;
        String output = ProcessMgr.fgexec((String)("wc " + fn), (int)300);
        String[] tokens = output.split(" ");
        try {
            rows = Integer.parseInt(tokens[0]);
        }
        catch (NumberFormatException e) {
            String s = "Unable to process output of wc";
            throw new PerfTestException(s);
        }
        Log.getLogWriter().info(fn + " contains " + rows + " rows");
        return rows;
    }

    @Override
    protected long completeTask(String trimIntervalName) {
        return System.currentTimeMillis();
    }

    public static void validateQueriesTask() throws DBException, InterruptedException {
        OracleClient client = new OracleClient();
        client.initialize();
        client.validateQueries();
    }

    public static void validateQueryTask() throws DBException, InterruptedException {
        OracleClient client = new OracleClient();
        client.initialize();
        client.validateQuery();
    }

    public static void doWorkloadTask() throws DBException, InterruptedException {
        OracleClient client = new OracleClient();
        client.initialize();
        client.doWorkload();
    }
}

