/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch.oracle;

import com.gemstone.gemfire.distributed.DistributedSystem;
import gfxdperf.tpch.DB;
import gfxdperf.tpch.DBException;
import gfxdperf.tpch.Query;
import gfxdperf.tpch.TPCHPrms;
import gfxdperf.tpch.TPCHStats;
import gfxdperf.tpch.oracle.OraclePrms;
import gfxdperf.tpch.oracle.OracleUtil;
import gfxdperf.tpch.oracle.Q1;
import gfxdperf.tpch.oracle.Q10;
import gfxdperf.tpch.oracle.Q11;
import gfxdperf.tpch.oracle.Q12;
import gfxdperf.tpch.oracle.Q13;
import gfxdperf.tpch.oracle.Q14;
import gfxdperf.tpch.oracle.Q15;
import gfxdperf.tpch.oracle.Q16;
import gfxdperf.tpch.oracle.Q17;
import gfxdperf.tpch.oracle.Q18;
import gfxdperf.tpch.oracle.Q19;
import gfxdperf.tpch.oracle.Q2;
import gfxdperf.tpch.oracle.Q20;
import gfxdperf.tpch.oracle.Q21;
import gfxdperf.tpch.oracle.Q22;
import gfxdperf.tpch.oracle.Q3;
import gfxdperf.tpch.oracle.Q4;
import gfxdperf.tpch.oracle.Q5;
import gfxdperf.tpch.oracle.Q6;
import gfxdperf.tpch.oracle.Q7;
import gfxdperf.tpch.oracle.Q8;
import gfxdperf.tpch.oracle.Q9;
import hydra.FileUtil;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.gemfirexd.LonerHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.Random;
import util.TestHelper;

public class OracleDB
extends DB {
    public static final boolean logDML = TPCHPrms.logDML();
    public static final boolean logDMLResults = TPCHPrms.logDMLResults();
    protected Connection connection;
    private DistributedSystem distributedSystem;
    private TPCHStats statistics;
    protected Query q1;
    protected Query q2;
    protected Query q3;
    protected Query q4;
    protected Query q5;
    protected Query q6;
    protected Query q7;
    protected Query q8;
    protected Query q9;
    protected Query q10;
    protected Query q11;
    protected Query q12;
    protected Query q13;
    protected Query q14;
    protected Query q15;
    protected Query q16;
    protected Query q17;
    protected Query q18;
    protected Query q19;
    protected Query q20;
    protected Query q21;
    protected Query q22;

    @Override
    public void init(Random random) throws DBException {
        super.init(random);
        this.connection = this.initConnection();
        this.distributedSystem = LonerHelper.connect();
        this.statistics = TPCHStats.getInstance();
    }

    private Connection initConnection() throws DBException {
        try {
            return OracleUtil.openConnection();
        }
        catch (SQLException e) {
            String s = "Unable to create client connection";
            throw new DBException(s, e);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void cleanup() throws DBException {
        Log.getLogWriter().info("Closing connection " + this.connection);
        if (this.connection == null) {
            Log.getLogWriter().info("Connection already closed");
        } else {
            try {
                this.connection.close();
                this.connection = null;
                Log.getLogWriter().info("Closed connection");
            }
            catch (SQLException e) {
                throw new DBException("Problem closing connection", e);
            }
        }
        if (this.statistics != null) {
            this.statistics.close();
            this.statistics = null;
        }
        if (this.distributedSystem != null) {
            this.distributedSystem.disconnect();
            this.distributedSystem = null;
        }
    }

    @Override
    public void dropTable(TPCHPrms.TableName tableName) throws DBException {
        Log.getLogWriter().info("Dropping table " + (Object)((Object)tableName));
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            stmt.execute("drop table " + (Object)((Object)tableName));
            stmt.close();
        }
        catch (SQLSyntaxErrorException e) {
            if (e.getMessage().contains("ORA-00942: table or view does not exist")) {
                Log.getLogWriter().info("Table " + (Object)((Object)tableName) + " does not exist");
            }
            String s = "Problem dropping table: " + (Object)((Object)tableName);
            throw new DBException(s, e);
        }
        catch (SQLException e) {
            String s = "Problem dropping table: " + (Object)((Object)tableName);
            throw new DBException(s, e);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new DBException("Failed to commit", e);
        }
        Log.getLogWriter().info("Dropped table " + (Object)((Object)tableName));
    }

    @Override
    public void importTable(String fn, TPCHPrms.TableName tableName) throws DBException {
        Log.getLogWriter().info("Importing table from " + fn);
        String colfn = System.getProperty("JTESTS") + "/gfxdperf/tpch/oracle/cols/" + tableName.toString().toLowerCase() + ".col";
        String ctlfn = tableName.toString().toLowerCase() + ".ctl";
        String logfn = tableName.toString().toLowerCase() + ".log";
        this.createControlFile(colfn, ctlfn, tableName);
        String home = OraclePrms.getHome();
        String[] envp = new String[]{"ORACLE_HOME=" + home, "PATH=" + home + "/bin", "ORACLE_SID=" + OraclePrms.getDatabaseName().toUpperCase()};
        String cmd = home + "/bin/sqlldr" + " " + OraclePrms.getUser() + "/" + OraclePrms.getPassword() + " DATA=" + fn + " CONTROL=" + ctlfn + " LOG=" + logfn;
        String host = OraclePrms.getDatabaseServerHost();
        int waitSec = TestConfig.tab().intAt(Prms.maxResultWaitSec);
        String result = ProcessMgr.fgexec((String)host, (String)cmd, (String[])envp, (int)waitSec);
        Log.getLogWriter().info("Result of import table for " + (Object)((Object)tableName) + ":\n" + result);
        Log.getLogWriter().info("Imported table from " + fn);
    }

    private void createControlFile(String colfn, String ctlfn, TPCHPrms.TableName tableName) throws DBException {
        String tbl;
        try {
            tbl = FileUtil.getText((String)colfn);
        }
        catch (FileNotFoundException e) {
            String s = "File not found: " + colfn;
            throw new DBException(s, e);
        }
        catch (IOException e) {
            String s = "Problem reading file: " + colfn;
            throw new DBException(s, e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("LOAD DATA\n").append("INFILE ").append("'").append(colfn).append("'").append("\n").append("REPLACE\n").append("INTO TABLE \"").append((Object)tableName).append("\"\n").append("FIELDS TERMINATED BY '|'\n").append("TRAILING NULLCOLS (\n").append(tbl).append(")\n");
        FileUtil.writeToFile((String)ctlfn, (String)sb.toString());
    }

    @Override
    public void createIndex(String index) throws DBException {
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            stmt.executeUpdate(index);
            stmt.close();
        }
        catch (SQLException e) {
            String s = "Problem creating index: " + index;
            throw new DBException(s, e);
        }
    }

    @Override
    public void validateQueries() throws DBException {
        StringBuilder errStr = new StringBuilder();
        try {
            errStr.append(this.getQ1().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q1: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ2().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q2: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ3().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q3: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ4().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q4: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ5().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q5: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ6().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q6: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ7().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q7: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ8().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q8: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ9().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q9: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ10().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q10: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ11().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q11: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ12().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q12: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ13().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q13: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ14().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q14: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ15().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q15: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ16().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q16: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ17().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q17: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ18().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q18: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ19().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q19: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ20().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q20: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ21().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q21: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        try {
            errStr.append(this.getQ22().validateQuery());
        }
        catch (Exception e) {
            errStr.append("For Q22: " + TestHelper.getStackTrace((Throwable)e) + "\n");
        }
        if (errStr.length() > 0) {
            throw new DBException(errStr.toString());
        }
    }

    @Override
    public void executeQuery(int queryNum) throws DBException {
        long start = this.statistics.startQuery();
        int results = 0;
        try {
            switch (queryNum) {
                case 1: {
                    results = this.getQ1().executeQuery();
                    break;
                }
                case 2: {
                    results = this.getQ2().executeQuery();
                    break;
                }
                case 3: {
                    results = this.getQ3().executeQuery();
                    break;
                }
                case 4: {
                    results = this.getQ4().executeQuery();
                    break;
                }
                case 5: {
                    results = this.getQ5().executeQuery();
                    break;
                }
                case 6: {
                    results = this.getQ6().executeQuery();
                    break;
                }
                case 7: {
                    results = this.getQ7().executeQuery();
                    break;
                }
                case 8: {
                    results = this.getQ8().executeQuery();
                    break;
                }
                case 9: {
                    results = this.getQ9().executeQuery();
                    break;
                }
                case 10: {
                    results = this.getQ10().executeQuery();
                    break;
                }
                case 11: {
                    results = this.getQ11().executeQuery();
                    break;
                }
                case 12: {
                    results = this.getQ12().executeQuery();
                    break;
                }
                case 13: {
                    results = this.getQ13().executeQuery();
                    break;
                }
                case 14: {
                    results = this.getQ14().executeQuery();
                    break;
                }
                case 15: {
                    results = this.getQ15().executeQuery();
                    break;
                }
                case 16: {
                    results = this.getQ16().executeQuery();
                    break;
                }
                case 17: {
                    results = this.getQ17().executeQuery();
                    break;
                }
                case 18: {
                    results = this.getQ18().executeQuery();
                    break;
                }
                case 19: {
                    results = this.getQ19().executeQuery();
                    break;
                }
                case 20: {
                    results = this.getQ20().executeQuery();
                    break;
                }
                case 21: {
                    results = this.getQ21().executeQuery();
                    break;
                }
                case 22: {
                    results = this.getQ22().executeQuery();
                    break;
                }
                default: {
                    String s = "Unsupported query number: " + queryNum;
                    throw new UnsupportedOperationException(s);
                }
            }
        }
        catch (SQLException e) {
            String s = "Problem executing query number:" + queryNum;
            throw new DBException(s, e);
        }
        this.statistics.endQuery(queryNum, start, results);
    }

    protected Query getQ1() {
        if (this.q1 == null) {
            this.q1 = new Q1(this.connection, this.rng);
        }
        return this.q1;
    }

    protected Query getQ2() {
        if (this.q2 == null) {
            this.q2 = new Q2(this.connection, this.rng);
        }
        return this.q2;
    }

    protected Query getQ3() {
        if (this.q3 == null) {
            this.q3 = new Q3(this.connection, this.rng);
        }
        return this.q3;
    }

    protected Query getQ4() {
        if (this.q4 == null) {
            this.q4 = new Q4(this.connection, this.rng);
        }
        return this.q4;
    }

    protected Query getQ5() {
        if (this.q5 == null) {
            this.q5 = new Q5(this.connection, this.rng);
        }
        return this.q5;
    }

    protected Query getQ6() {
        if (this.q6 == null) {
            this.q6 = new Q6(this.connection, this.rng);
        }
        return this.q6;
    }

    protected Query getQ7() {
        if (this.q7 == null) {
            this.q7 = new Q7(this.connection, this.rng);
        }
        return this.q7;
    }

    protected Query getQ8() {
        if (this.q8 == null) {
            this.q8 = new Q8(this.connection, this.rng);
        }
        return this.q8;
    }

    protected Query getQ9() {
        if (this.q9 == null) {
            this.q9 = new Q9(this.connection, this.rng);
        }
        return this.q9;
    }

    protected Query getQ10() {
        if (this.q10 == null) {
            this.q10 = new Q10(this.connection, this.rng);
        }
        return this.q10;
    }

    protected Query getQ11() {
        if (this.q11 == null) {
            this.q11 = new Q11(this.connection, this.rng);
        }
        return this.q11;
    }

    protected Query getQ12() {
        if (this.q12 == null) {
            this.q12 = new Q12(this.connection, this.rng);
        }
        return this.q12;
    }

    protected Query getQ13() {
        if (this.q13 == null) {
            this.q13 = new Q13(this.connection, this.rng);
        }
        return this.q13;
    }

    protected Query getQ14() {
        if (this.q14 == null) {
            this.q14 = new Q14(this.connection, this.rng);
        }
        return this.q14;
    }

    protected Query getQ15() {
        if (this.q15 == null) {
            this.q15 = new Q15(this.connection, this.rng);
        }
        return this.q15;
    }

    protected Query getQ16() {
        if (this.q16 == null) {
            this.q16 = new Q16(this.connection, this.rng);
        }
        return this.q16;
    }

    protected Query getQ17() {
        if (this.q17 == null) {
            this.q17 = new Q17(this.connection, this.rng);
        }
        return this.q17;
    }

    protected Query getQ18() {
        if (this.q18 == null) {
            this.q18 = new Q18(this.connection, this.rng);
        }
        return this.q18;
    }

    protected Query getQ19() {
        if (this.q19 == null) {
            this.q19 = new Q19(this.connection, this.rng);
        }
        return this.q19;
    }

    protected Query getQ20() {
        if (this.q20 == null) {
            this.q20 = new Q20(this.connection, this.rng);
        }
        return this.q20;
    }

    protected Query getQ21() {
        if (this.q21 == null) {
            this.q21 = new Q21(this.connection, this.rng);
        }
        return this.q21;
    }

    protected Query getQ22() {
        if (this.q22 == null) {
            this.q22 = new Q22(this.connection, this.rng);
        }
        return this.q22;
    }
}

