/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch.oracle;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class OracleStats
extends PerformanceStatistics {
    protected static final String IMPORT_TABLE_ROWS = "importTableRows";
    protected static final String IMPORT_TABLE_TIME = "importTableTime";
    protected static final String CREATE_INDEX = "createIndex";
    protected static final String CREATE_INDEX_TIME = "createIndexTime";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{OracleStats.factory().createIntCounter(IMPORT_TABLE_ROWS, "Number of rows imported in this table.", "rows", largerIsBetter), OracleStats.factory().createLongCounter(IMPORT_TABLE_TIME, "Total time spent importing rows into this table.", "nanoseconds", !largerIsBetter), OracleStats.factory().createIntCounter(CREATE_INDEX, "Number of indexes created.", "rows", largerIsBetter), OracleStats.factory().createLongCounter(CREATE_INDEX_TIME, "Total time spent creating indexes.", "nanoseconds", !largerIsBetter)};
    }

    public static OracleStats getInstance() {
        return (OracleStats)OracleStats.getInstance(OracleStats.class, (int)0);
    }

    public OracleStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public long startImportTable() {
        return NanoTimer.getTime();
    }

    public void endImportTable(long start, int rows) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(IMPORT_TABLE_ROWS, rows);
        this.statistics().incLong(IMPORT_TABLE_TIME, elapsed);
    }

    public long startCreateIndex() {
        return NanoTimer.getTime();
    }

    public void endCreateIndex(long start) {
        long elapsed = NanoTimer.getTime() - start;
        this.statistics().incInt(CREATE_INDEX, 1);
        this.statistics().incLong(CREATE_INDEX_TIME, elapsed);
    }
}

