/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.tpch.oracle;

import gfxdperf.PerfTestException;
import gfxdperf.tpch.oracle.OraclePrms;
import hydra.HostHelper;
import hydra.Log;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class OracleUtil {
    public static final String THIN_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String PROTOCOL = "jdbc:oracle:thin:";

    public static Connection openConnection() throws SQLException {
        String databaseServerHost = OraclePrms.getDatabaseServerHost();
        if (HostHelper.isLocalHost((String)databaseServerHost)) {
            databaseServerHost = "localhost";
        }
        String url = PROTOCOL + OraclePrms.getUser() + "/" + OraclePrms.getPassword() + "@" + databaseServerHost + ":" + OraclePrms.getDatabaseServerPort() + ":" + OraclePrms.getDatabaseName();
        Log.getLogWriter().info("Creating connection using oracle.jdbc.OracleDriver with " + url);
        System.setProperty("java.security.egd", "file:///dev/urandom");
        OracleUtil.loadDriver(THIN_DRIVER);
        Connection conn = DriverManager.getConnection(url);
        conn.setAutoCommit(OraclePrms.getAutoCommit());
        conn.setTransactionIsolation(OraclePrms.getTxIsolation());
        Log.getLogWriter().info("Created connection for " + url + " using transaction isolation: " + OraclePrms.getTxIsolation(conn.getTransactionIsolation()) + " autocommit: " + OraclePrms.getAutoCommit());
        return conn;
    }

    private static void loadDriver(String driver) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            String s = "Problem loading JDBC driver: " + driver;
            throw new PerfTestException(s, e);
        }
    }
}

