/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb;

import com.gemstone.gemfire.internal.NanoTimer;
import gfxdperf.PerfClient;
import gfxdperf.ycsb.YCSBPrms;
import gfxdperf.ycsb.core.DB;
import gfxdperf.ycsb.core.Workload;
import hydra.HydraThreadLocal;
import java.util.Random;

public class YCSBClient
extends PerfClient {
    private static HydraThreadLocal localdb = new HydraThreadLocal();
    private static HydraThreadLocal localworkload = new HydraThreadLocal();
    private static HydraThreadLocal localworkloadstate = new HydraThreadLocal();
    protected DB db;
    protected Workload workload;
    protected Object workloadstate;

    @Override
    public void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.db = (DB)localdb.get();
        this.workload = (Workload)localworkload.get();
        this.workloadstate = localworkloadstate.get();
    }

    @Override
    public void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        localdb.set((Object)this.db);
        localworkload.set((Object)this.workload);
        localworkloadstate.set(this.workloadstate);
    }

    protected void loadData() {
        String trimIntervalName = YCSBPrms.getTrimInterval();
        this.terminator.startBatch();
        while (!this.terminator.batchComplete()) {
            if (this.terminator.warmupComplete()) {
                this.sync();
                this.terminator.startWork();
            }
            if (this.terminator.workComplete()) {
                long timestamp = this.completeTask(trimIntervalName);
                this.terminator.reportTrimInterval(this, trimIntervalName, timestamp);
                this.updateHydraThreadLocals();
                this.terminator.terminateTask();
            }
            this.workload.doInsert(this.db, this.workloadstate);
        }
        this.updateHydraThreadLocals();
        this.terminator.terminateBatch();
    }

    protected long completeTask(String trimIntervalName) {
        throw new UnsupportedOperationException();
    }

    protected void doWorkload() throws InterruptedException {
        String trimIntervalName = YCSBPrms.getTrimInterval();
        double throttledOpsPerSecond = YCSBPrms.getThrottledOpsPerSecond();
        boolean throttle = throttledOpsPerSecond > 0.0;
        int interval = (int)(1000.0 / throttledOpsPerSecond);
        Random rng = new Random(this.ttgid);
        this.terminator.startBatch();
        if (throttle) {
            Thread.sleep(rng.nextInt(interval));
        }
        while (!this.terminator.batchComplete()) {
            int remaining;
            if (this.terminator.warmupComplete()) {
                this.sync();
                if (throttle) {
                    Thread.sleep(rng.nextInt(interval));
                }
                this.terminator.startWork();
            }
            if (this.terminator.workComplete()) {
                long timestamp = this.completeTask(trimIntervalName);
                this.terminator.reportTrimInterval(this, trimIntervalName, timestamp);
                this.updateHydraThreadLocals();
                this.terminator.terminateTask();
            }
            long start = NanoTimer.getTime();
            this.workload.doTransaction(this.db, this.workloadstate);
            long elapsed = NanoTimer.getTime() - start;
            if (!throttle || (remaining = interval - (int)(elapsed / 1000000L)) <= 0) continue;
            Thread.sleep(remaining);
        }
        this.updateHydraThreadLocals();
        this.terminator.terminateBatch();
    }
}

