/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb.core;

import gfxdperf.ycsb.core.ByteIterator;
import gfxdperf.ycsb.core.Utils;

public class RandomByteIterator
extends ByteIterator {
    private long len;
    private long off;
    private int bufOff;
    private byte[] buf;

    @Override
    public boolean hasNext() {
        return this.off + (long)this.bufOff < this.len;
    }

    private void fillBytesImpl(byte[] buffer, int base) {
        int bytes = Utils.random().nextInt();
        try {
            buffer[base + 0] = (byte)((bytes & 0x1F) + 32);
            buffer[base + 1] = (byte)((bytes >> 5 & 0x1F) + 32);
            buffer[base + 2] = (byte)((bytes >> 10 & 0x1F) + 32);
            buffer[base + 3] = (byte)((bytes >> 15 & 0x1F) + 32);
            buffer[base + 4] = (byte)((bytes >> 20 & 0x1F) + 32);
            buffer[base + 5] = (byte)((bytes >> 25 & 0x1F) + 32);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void fillBytes() {
        if (this.bufOff == this.buf.length) {
            this.fillBytesImpl(this.buf, 0);
            this.bufOff = 0;
            this.off += (long)this.buf.length;
        }
    }

    public RandomByteIterator(long len) {
        this.len = len;
        this.buf = new byte[6];
        this.bufOff = this.buf.length;
        this.fillBytes();
        this.off = 0L;
    }

    @Override
    public byte nextByte() {
        this.fillBytes();
        ++this.bufOff;
        return this.buf[this.bufOff - 1];
    }

    @Override
    public int nextBuf(byte[] buffer, int bufferOffset) {
        int ret = this.len - this.off < (long)(buffer.length - bufferOffset) ? (int)(this.len - this.off) : buffer.length - bufferOffset;
        for (int i = 0; i < ret; i += 6) {
            this.fillBytesImpl(buffer, i + bufferOffset);
        }
        this.off += (long)ret;
        return ret + bufferOffset;
    }

    @Override
    public long bytesLeft() {
        return this.len - this.off - (long)this.bufOff;
    }
}

