/*
 * Decompiled with CFR 0.152.
 */
package gfxdperf.ycsb.core.generator;

import gfxdperf.PerfTestException;
import gfxdperf.ycsb.core.Utils;
import gfxdperf.ycsb.core.WorkloadException;
import gfxdperf.ycsb.core.generator.Generator;
import java.util.Vector;

public class DiscreteGenerator
extends Generator {
    Vector<Pair> _values = new Vector();
    String _lastvalue = null;

    @Override
    public String nextString() {
        double sum = 0.0;
        for (Pair p : this._values) {
            sum += p._weight;
        }
        double val = Utils.random().nextDouble();
        for (Pair p : this._values) {
            if (val < p._weight / sum) {
                return p._value;
            }
            val -= p._weight / sum;
        }
        String s = "Unable to process " + this._values;
        throw new PerfTestException(s);
    }

    public int nextInt() throws WorkloadException {
        throw new WorkloadException("DiscreteGenerator does not support nextInt()");
    }

    @Override
    public String lastString() {
        if (this._lastvalue == null) {
            this._lastvalue = this.nextString();
        }
        return this._lastvalue;
    }

    public void addValue(double weight, String value) {
        this._values.add(new Pair(weight, value));
    }

    class Pair {
        public double _weight;
        public String _value;

        Pair(double weight, String value) {
            this._weight = weight;
            this._value = value;
        }
    }
}

